/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DlgSelectPlan;
import com.sas.ssn.GetPlans;
import com.sas.ssn.Globals;
import com.sas.ssn.KitBrowseButton;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.OrderData;
import com.sas.ssn.Plan;
import com.sas.ssn.SSNResource;
import com.sas.ssn.StandardDeploymentPlan;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardCallbackIface;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PanelSelectPlan
implements WizardPanelIface,
WizardCallbackIface,
ActionListener {
    private final String RESPONSE_CUSTOMIZED = "customized";
    private final String RESPONSE_STANDARD = "standard";
    private SSNResource bundle = new SSNResource(PanelSelectPlan.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JRadioButton m_customOption = null;
    private KitTextField m_planDir = null;
    private KitBrowseButton m_browseButton = null;
    private JRadioButton m_standardOption = null;
    private JEditorPane m_planInfo = null;
    private JTextArea m_listDesc = null;
    private JScrollPane m_scrollPane = null;
    private boolean m_panelLoaded = false;
    private String m_lastOrder = "";
    private String m_loadedPlan = "";
    private String m_selectedPlan = null;
    private JButton advSearchButton = null;
    private Map<String, StandardDeploymentPlan> stdPlansMap = new TreeMap<String, StandardDeploymentPlan>();
    private SortedSet<String> machineCounts = new TreeSet<String>();
    private StandardPlanComboBox m_combo = null;

    public PanelSelectPlan() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSelectPlan.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSelectPlan.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        String quietMsg = null;
        String errorMsg = null;
        boolean samplePlan = false;
        String planPath = "";
        try {
            if (this.m_standardOption.isSelected()) {
                samplePlan = true;
                StandardDeploymentPlan planInfo = this.m_combo.getSelectedItem();
                planPath = planInfo.getPathOnDisk();
            } else {
                planPath = this.m_planDir.getText().trim();
                this.m_planDir.setText(planPath);
            }
            if (!Utils.pathContainsValidChars(planPath)) {
                valid = false;
                if (Globals.g_quietMode) {
                    quietMsg = Utils.getOS() == 1 ? "The following characters are invalid: / : * ? \" < > |" : (Utils.getOS() == 9 ? "The following characters are invalid: \\ :" : "The following characters are invalid: <space> % * \" & ? : < > \\ | ( )");
                } else {
                    errorMsg = Utils.getOS() == 1 ? this.bundle.messageString("Common.Error.InvalidChars.Windows.txt", this.bundle.getString("PanelSelectPlan.FieldName.txt")) : (Utils.getOS() == 9 ? this.bundle.messageString("Common.Error.InvalidChars.Mac.txt", this.bundle.getString("PanelSelectPlan.FieldName.txt")) : this.bundle.messageString("Common.Error.InvalidChars.UNIX.txt", this.bundle.getString("PanelSelectPlan.FieldName.txt")));
                }
            }
            if (valid) {
                Plan plan = new Plan(planPath);
                String version = null;
                OrderData orderData = Globals.g_deploymentData.getOrder(Globals.g_order);
                String[] setnumids = orderData.getSetnumids();
                for (int i = 0; version == null && i < setnumids.length; ++i) {
                    String sidType = orderData.getSidType(setnumids[i]);
                    if (!"".equals(sidType) && !"SAS".equals(sidType)) continue;
                    version = orderData.getSidVersion(setnumids[i]);
                }
                String planver = plan.getProperty("SasVersion");
                if (planver == null) {
                    planver = "9.2";
                }
                if (version != null && !version.equalsIgnoreCase(planver)) {
                    if (!Globals.g_quietMode) {
                        errorMsg = this.bundle.messageString("PanelSelectPlan.mismatchPlan.txt", planver, version);
                    } else {
                        quietMsg = "The specified deployment plan is intended for use with a version " + planver + " order, but the current order is version " + version + " Please use a deployment plan created for version " + version + ".";
                    }
                    valid = false;
                }
                if (valid) {
                    Globals.g_plan = plan;
                }
            }
        }
        catch (Exception e) {
            if (!Globals.g_quietMode) {
                errorMsg = this.bundle.getString("PanelSelectPlan.BadPlan.txt");
            }
            valid = false;
        }
        if (valid) {
            if (!Globals.g_quietMode) {
                Globals.g_wizardData.setPreference("LastProjDir", this.m_planDir.getText());
                Globals.g_wizardData.setPreference("SampleSelectedPlan", samplePlan);
            }
        } else if (Globals.g_quietMode) {
            String field = null;
            String value = null;
            if (samplePlan) {
                field = "STANDARD_PLAN_NAME";
                value = this.m_combo.getSelectedItem().getName();
            } else {
                field = "CUSTOMIZED_PLAN_PATH";
                value = planPath;
            }
            Wizard.logResponseInvalid(this.getHeader(), field, value, quietMsg);
        } else if (errorMsg != null) {
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errorMsg, this.bundle.getString("Common.Warning.txt"), 2);
        }
        this.logPlanInfo("validateData");
        return valid;
    }

    private void logPlanInfo(String method) {
        String globalPlan = Globals.g_plan != null ? Globals.g_plan.getName() : null;
        Logging.log.info("After " + method + " select standard plan is " + this.m_selectedPlan + "; custom plan path is  Globals.g_plan is " + globalPlan);
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = Globals.g_mode == 3 ? "execute" : "machine";
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_lastOrder.equalsIgnoreCase(Globals.g_order)) {
            if (!this.m_panelLoaded) {
                File plan_files;
                this.loadResponseData();
                if (this.m_planDir.getText().length() == 0) {
                    this.m_planDir.setText(Globals.g_wizardData.getPreference("LastProjDir", ""));
                }
                if (this.m_planDir.getText().length() == 0 && (plan_files = new File(Globals.g_startupLocation, "plan_files")).isDirectory()) {
                    this.m_planDir.setText(plan_files.getAbsolutePath());
                }
                this.m_panelLoaded = true;
            }
            this.loadComboBox();
            this.setRadioState();
            this.m_panel.validate();
            this.m_lastOrder = Globals.g_order;
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        JRadioButton focus = null;
        focus = this.m_customOption.isSelected() ? this.m_customOption : this.m_standardOption;
        return focus;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            this.loadComboBox();
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        if (Globals.g_quietMode && Globals.g_recordMode) {
            return null;
        }
        String[] data = new String[]{"#PLAN_TYPE=customized/standard", " PLAN_TYPE=customized", "#CUSTOMIZED_PLAN_PATH=<full path - only if PLAN_TYPE=customized>", " CUSTOMIZED_PLAN_PATH=", "#STANDARD_PLAN_NAME=<standard plan name - only if PLAN_TYPE=standard>", " STANDARD_PLAN_NAME="};
        if (this.m_panelLoaded) {
            if (this.m_standardOption.isSelected()) {
                data[1] = " PLAN_TYPE=standard";
                data[5] = " STANDARD_PLAN_NAME=" + this.m_combo.getSelectedItem().getName();
            } else {
                data[3] = " CUSTOMIZED_PLAN_PATH=" + this.m_planDir.getText();
            }
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
        Globals.g_plan = null;
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_customOption, this.m_standardOption};
        int returnCode = ConsoleMode.promptRadioButtons(options, null);
        if (returnCode > -1) {
            this.setRadioState();
            if (this.m_customOption.isSelected()) {
                returnCode = ConsoleMode.promptText(this.bundle.getString("PanelSelectPlan.CustomLabel.txt"), this.m_planDir);
            } else if (this.m_standardOption.isSelected()) {
                returnCode = ConsoleMode.promptComboBox(this.m_combo);
            }
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String responseType = Wizard.getResponse("PLAN_TYPE", null);
        if (responseType != null) {
            if (responseType.equalsIgnoreCase("customized")) {
                valid = true;
                this.m_customOption.setSelected(true);
            } else if (responseType.equalsIgnoreCase("standard")) {
                valid = true;
                this.m_standardOption.setSelected(true);
            } else if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "PLAN_TYPE", responseType, null);
            }
        } else if (Globals.g_quietMode) {
            Logging.log.fine("Missing PLAN_TYPE. Set default PLAN_TYPE to custom.");
            valid = true;
            this.m_standardOption.setSelected(true);
        }
        String responsePath = Wizard.getResponse("CUSTOMIZED_PLAN_PATH", null);
        if (responsePath != null && responsePath.length() != 0) {
            this.m_planDir.setText(responsePath);
        } else if (Globals.g_quietMode && this.m_customOption.isSelected()) {
            valid = false;
            String planpath = Globals.g_wizardData.getPreference("LastProjDir", "");
            if (Utils.validatePath(planpath)) {
                valid = true;
                this.m_planDir.setText(planpath);
            } else {
                planpath = Utils.joinPath(Globals.g_startupLocation, "plan_files");
                if (Utils.validatePath(planpath)) {
                    valid = true;
                    this.m_planDir.setText(planpath);
                } else {
                    Wizard.logResponseMissing(this.getHeader(), "CUSTOMIZED_PLAN_PATH");
                }
            }
        }
        String responseName = Wizard.getResponse("STANDARD_PLAN_NAME", null);
        if (responseName != null) {
            this.m_selectedPlan = responseName;
        } else if (Globals.g_quietMode && this.m_standardOption.isSelected()) {
            this.m_combo.setSelectedIndex(0);
            this.m_selectedPlan = this.m_combo.getSelectedItem().getName();
            valid = true;
        }
        this.logPlanInfo("loadResponseData");
        return valid;
    }

    private void initialize() {
        this.m_planInfo = new JEditorPane();
        this.m_scrollPane = new JScrollPane(this.m_planInfo);
        this.m_combo = new StandardPlanComboBox();
        this.m_planDir = new KitTextField();
        this.m_planDir.getDocument().addDocumentListener(new TextChangeListener());
        this.m_listDesc = new JTextArea(this.bundle.getString("PanelSelectPlan.ListDesc.txt"));
        this.m_listDesc.setEditable(false);
        this.m_listDesc.setFocusable(false);
        this.m_listDesc.setLineWrap(false);
        this.m_listDesc.setOpaque(false);
        String mtxt = this.bundle.getString("Common.Browse2.txt");
        this.m_browseButton = new KitBrowseButton(Util.getLabelWithoutMnemonic(mtxt), "", 0, this.m_planDir);
        this.m_browseButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_browseButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_browseButton.setCallbackPanel(this);
        mtxt = this.bundle.getString("PanelSelectPlan.AdvSearchButton.txt");
        this.advSearchButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.advSearchButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.advSearchButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.advSearchButton.setActionCommand("launchAdvancedPlanSelectionDialog");
        this.advSearchButton.addActionListener(this);
        this.m_planInfo.setOpaque(false);
        this.m_planInfo.setEditable(false);
        this.m_planInfo.setContentType("text/html");
        mtxt = this.bundle.getString("PanelSelectPlan.CustomOption.txt");
        this.m_customOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_customOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_customOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_customOption.getFont();
        this.m_customOption.setFont(optionFont.deriveFont(1));
        this.m_customOption.setSelected(Globals.g_wizardData.getPreference("CustomPlan", true));
        mtxt = this.bundle.getString("PanelSelectPlan.TemplateOption.txt");
        this.m_standardOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_standardOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_standardOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_standardOption.getFont();
        this.m_standardOption.setFont(optionFont.deriveFont(1));
        this.m_standardOption.setSelected(!Globals.g_wizardData.getPreference("CustomPlan", true));
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_customOption);
        group.add(this.m_standardOption);
        this.m_combo.addActionListener(this);
        this.m_customOption.addActionListener(this);
        this.m_standardOption.addActionListener(this);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_customOption, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 20, 5, 0);
        this.m_panel.add((Component)this.m_planDir, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        c.fill = 0;
        c.insets = new Insets(0, 5, 5, 0);
        this.m_panel.add((Component)this.m_browseButton, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_standardOption, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = Utils.getJREVersion() >= DlgSelectPlan.MIN_SWING_JAVA_VERSION ? 1 : 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 20, 5, 0);
        this.m_panel.add((Component)this.m_combo, c);
        if (Utils.getJREVersion() >= DlgSelectPlan.MIN_SWING_JAVA_VERSION) {
            c.gridx = 1;
            c.gridy = 3;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.anchor = 13;
            c.fill = 2;
            c.insets = new Insets(0, 5, 5, 0);
            this.m_panel.add((Component)this.advSearchButton, c);
        }
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_listDesc, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_scrollPane, c);
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        Object obj = actionEvent.getSource();
        if (obj.equals(this.m_combo)) {
            this.updateTextArea();
        } else if (obj.equals(this.m_standardOption) || obj.equals(this.m_customOption)) {
            Globals.g_wizardData.setPreference("CustomPlan", this.m_customOption.isSelected());
            this.setRadioState();
        } else if (obj.equals(this.advSearchButton)) {
            new DlgSelectPlan(Globals.g_wizard.getFrame(), this.m_combo, this.stdPlansMap, this.machineCounts);
        }
    }

    private void loadStandardPlanData() {
        String samplePlans = Globals.g_deploymentData.getProductDir(Globals.g_order, "sampleplans", false, false);
        File samplePlansDir = new File(samplePlans);
        GetPlans planDesc = null;
        if (samplePlansDir.isDirectory()) {
            planDesc = new GetPlans(samplePlans);
            this.stdPlansMap = planDesc.getPlanMap();
            this.machineCounts = planDesc.getMachineCounts();
            if (this.machineCounts.isEmpty()) {
                this.advSearchButton.setVisible(false);
            }
        }
    }

    private void loadComboBox() {
        this.m_combo.removeAllItems();
        this.loadStandardPlanData();
        int i = 0;
        int pos = 0;
        if (!this.stdPlansMap.isEmpty()) {
            TreeSet<StandardDeploymentPlan> planSet = new TreeSet<StandardDeploymentPlan>(this.stdPlansMap.values());
            for (StandardDeploymentPlan currPlan : planSet) {
                if (currPlan == null) continue;
                this.m_combo.addItem(currPlan);
                if (currPlan.getName().equalsIgnoreCase(this.m_selectedPlan)) {
                    pos = i;
                    continue;
                }
                ++i;
            }
        }
        if (this.m_combo.getItemCount() > 0) {
            this.m_combo.setSelectedIndex(pos);
        }
    }

    private void setRadioState() {
        this.m_combo.setEnabled(this.m_standardOption.isSelected());
        this.m_browseButton.setEnabled(this.m_customOption.isSelected());
        this.m_planDir.setEnabled(this.m_customOption.isSelected());
        this.advSearchButton.setEnabled(this.m_standardOption.isSelected());
        this.updateTextArea();
    }

    @Override
    public void updateTextArea() {
        String planPath = "";
        Vector<String> boldedProducts = new Vector<String>();
        if (this.m_standardOption.isSelected()) {
            if (this.stdPlansMap != null && this.m_combo.getSelectedIndex() > -1) {
                StandardDeploymentPlan planInfo = this.m_combo.getSelectedItem();
                planPath = planInfo.getPathOnDisk();
            }
        } else {
            planPath = this.m_planDir.getText();
        }
        if (!planPath.equals(this.m_loadedPlan)) {
            if (Globals.g_wizard != null && Globals.g_wizard.getFrame() != null) {
                Globals.g_wizard.getFrame().setCursor(Cursor.getPredefinedCursor(3));
            }
            File filePlanPath = new File(planPath);
            this.m_loadedPlan = planPath;
            boolean showBoldNote = false;
            String detailText = "<html>";
            String listText = "";
            if (!Utils.pathContainsValidChars(planPath)) {
                detailText = Utils.getOS() == 1 ? detailText + this.bundle.messageString("Common.Error.InvalidChars.Windows.txt", this.bundle.getString("PanelSelectPlan.FieldName.txt")) : (Utils.getOS() == 9 ? detailText + this.bundle.messageString("Common.Error.InvalidChars.Mac.txt", this.bundle.getString("PanelSelectPlan.FieldName.txt")) : detailText + this.bundle.messageString("Common.Error.InvalidChars.UNIX.txt", this.bundle.getString("PanelSelectPlan.FieldName.txt")));
            } else if (filePlanPath.exists()) {
                try {
                    Plan plan = new Plan(planPath);
                    String planDesc = plan.getDescription();
                    if (planDesc != null && planDesc.length() > 0) {
                        detailText = detailText + planDesc + "<br><br>";
                    }
                    Plan.Machine[] machines = plan.getMachines();
                    for (int i = 0; i < machines.length; ++i) {
                        int j;
                        String promptedList = null;
                        String installList = null;
                        String configList = null;
                        Plan.Machine machine = machines[i];
                        listText = listText + "<u>" + machine.getNamePossiblyOptional() + "</u><ul>";
                        Plan.Machine.Component[] deployedComponents = machine.getDeployedComponents();
                        Plan.Machine.Component[] configuredComponents = machine.getConfiguredComponents();
                        String name = null;
                        for (j = 0; j < deployedComponents.length; ++j) {
                            name = deployedComponents[j].getName();
                            if (!deployedComponents[j].isSupported()) {
                                boldedProducts.add(name);
                                name = "<b>" + name + "</b>";
                                showBoldNote = true;
                            }
                            if (deployedComponents[j].isPrompted()) {
                                if (promptedList == null) {
                                    promptedList = this.bundle.getString("PanelSelectPlan.List3.txt") + "<ol>";
                                }
                                promptedList = promptedList + "<li>" + name;
                                continue;
                            }
                            if (installList == null) {
                                installList = Utils.getOS() == 8 ? "<br><u>" + this.bundle.getString("PanelSelectPlan.List1.txt") + "</u><ol>" : this.bundle.getString("PanelSelectPlan.List1.txt") + "<ol>";
                            }
                            installList = installList + "<li>" + name;
                        }
                        for (j = 0; j < configuredComponents.length; ++j) {
                            name = configuredComponents[j].getName();
                            if (!configuredComponents[j].isSupported()) {
                                boldedProducts.add(name);
                                name = "<b>" + name + "</b>";
                                showBoldNote = true;
                            }
                            if (configList == null) {
                                configList = Utils.getOS() == 8 ? "<br><u>" + this.bundle.getString("PanelSelectPlan.List2.txt") + "</u><ol>" : this.bundle.getString("PanelSelectPlan.List2.txt") + "<ol>";
                            }
                            configList = configList + "<li>" + name;
                        }
                        if (promptedList != null) {
                            listText = listText + promptedList + "</ol>";
                        }
                        if (installList != null) {
                            listText = listText + installList + "</ol>";
                        }
                        if (configList != null) {
                            listText = listText + configList + "</ol>";
                        }
                        listText = listText + "</ul>";
                    }
                    if (showBoldNote) {
                        detailText = detailText + this.bundle.getString("PanelSelectPlan.BoldNote.txt") + "<br><br>";
                    }
                    detailText = detailText + listText;
                }
                catch (Exception e) {
                    detailText = detailText + this.bundle.getString("PanelSelectPlan.BadPlan.txt");
                }
            } else if (planPath != null && "".equals(planPath)) {
                detailText = detailText + this.bundle.getString("PanelSelectPlan.BadPlan.txt");
            }
            detailText = detailText + "</html>";
            this.m_planInfo.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.m_planInfo.setText(detailText);
            this.m_planInfo.setCaretPosition(0);
            this.m_planInfo.revalidate();
            if (Globals.g_wizard != null && Globals.g_wizard.getFrame() != null) {
                Globals.g_wizard.getFrame().setCursor(Cursor.getDefaultCursor());
            }
        }
        if (!boldedProducts.isEmpty()) {
            Logging.log.info("This plan contains products that are not available or not supported " + planPath + Globals.g_eol + "     Unavailable products: " + boldedProducts);
        }
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    class StandardPlanComboBox
    extends JComboBox {
        private static final long serialVersionUID = 4691616729618452653L;

        @Override
        public StandardDeploymentPlan getSelectedItem() {
            return (StandardDeploymentPlan)super.getSelectedItem();
        }
    }

    class TextChangeListener
    implements DocumentListener {
        TextChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PanelSelectPlan.this.updateTextArea();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PanelSelectPlan.this.updateTextArea();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PanelSelectPlan.this.updateTextArea();
        }
    }
}

