/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.JREData;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class PanelSelectMode
implements WizardPanelIface {
    private final String RESPONSE_64BIT = "64-bit";
    private final String RESPONSE_32BIT = "32-bit";
    private SSNResource bundle = new SSNResource(PanelSelectMode.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_instructions = null;
    private JRadioButton m_platPrimary = null;
    private JTextArea m_descPrimary = null;
    private JRadioButton m_platAlternate = null;
    private JTextArea m_descAlternate = null;
    private boolean m_panelLoaded = false;
    private String m_altPlatCode = null;
    private String m_location32Bit = null;
    private String m_location64Bit = null;
    private boolean sdm_no_saslicense = false;

    public PanelSelectMode() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        String header = null;
        header = Globals.g_createSSD ? this.bundle.getString("PanelSelectMode.HeaderSAW.txt") : this.bundle.getString("PanelSelectMode.Header.txt");
        return header;
    }

    @Override
    public String getHeaderDesc() {
        String headerDesc = null;
        headerDesc = Globals.g_createSSD ? this.bundle.getString("PanelSelectMode.HeaderDescSAW.txt") : (Globals.g_cmtTask == 41 ? this.bundle.getString("PanelSelectMode.HeaderDescRenew.txt") : (Globals.g_cmtTask == 40 ? this.bundle.getString("PanelSelectMode.HeaderDescRepair.txt") : (Globals.g_configure && !Globals.g_install ? this.bundle.getString("PanelSelectMode.HeaderDescConfig.txt") : this.bundle.getString("PanelSelectMode.HeaderDesc.txt"))));
        return headerDesc;
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        if (valid) {
            if (this.m_platAlternate.isSelected()) {
                Globals.g_sasinstallPlat = this.m_altPlatCode;
                Globals.g_bitnessSASLocation = this.m_location32Bit;
            } else {
                Globals.g_sasinstallPlat = null;
                Globals.g_bitnessSASLocation = this.m_location64Bit;
            }
            if (Globals.g_cmtTask == 3 || Globals.g_cmtTask == 40) {
                Globals.g_bitnessSASLocation = Globals.g_sasinstallPlat == null ? this.m_location64Bit : this.m_location32Bit;
                if (Globals.g_sdm_saslicense_required && Utils.isSASLicenseValidated(Globals.g_bitnessSASLocation) == 528) {
                    if (Globals.g_quietMode) {
                        Logging.log.severe("The Base SAS Software product is either not licensed for your system or the product license has expired. Please contact your SAS installation representative.");
                    } else {
                        Logging.log.severe("The Base SAS Software product is either not licensed for your system or the product license has expired. Please contact your SAS installation representative.");
                        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelSelectSASFoundationTask.InvalidSASLicenseMsg.txt"), this.bundle.getString("Common.Warning.txt"), 2);
                    }
                }
            }
            if (Globals.g_selectedInstalls != null) {
                ProductData productData = null;
                boolean foundSAS = false;
                boolean foundStatstudio = false;
                boolean foundWebedtr = false;
                for (int i = 0; !(i >= Globals.g_selectedInstalls.length || foundSAS && foundStatstudio); ++i) {
                    if (Globals.g_selectedInstalls[i].getProdCode().equalsIgnoreCase("sasinstall") && !foundSAS) {
                        productData = Globals.g_sasinstallPlat == null ? Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", false) : Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", Globals.g_sasinstallPlat, false);
                        if (productData != null) {
                            Globals.g_selectedInstalls[i] = productData;
                        }
                        foundSAS = true;
                        continue;
                    }
                    if (Globals.g_selectedInstalls[i].getProdCode().equalsIgnoreCase("statstudio") && Globals.g_sasinstallPlat != null && !foundStatstudio) {
                        productData = Globals.g_deploymentData.getProduct(Globals.g_order, "statstudio", Globals.g_sasinstallPlat, false);
                        if (productData != null) {
                            Globals.g_selectedInstalls[i] = productData;
                        }
                        foundStatstudio = true;
                        continue;
                    }
                    if (!Globals.g_selectedInstalls[i].getProdCode().equalsIgnoreCase("webedtr") || Globals.g_sasinstallPlat == null || foundWebedtr) continue;
                    productData = Globals.g_deploymentData.getProduct(Globals.g_order, "webedtr", Globals.g_sasinstallPlat, false);
                    if (productData != null) {
                        Globals.g_selectedInstalls[i] = productData;
                    }
                    foundWebedtr = true;
                }
            }
        }
        JREData.setJREData(Globals.g_sasinstallPlat, JREData.isPrivateJreNeeded());
        return valid;
    }

    @Override
    public boolean displayPanel() {
        boolean display = false;
        this.sdm_no_saslicense = false;
        if (Globals.g_createSSD) {
            if (Utils.getOS_Suffix().equals("wx6") && Globals.g_deploymentData.getProduct(Globals.g_order, "adminwizard", "win", false) != null && Globals.g_deploymentData.getProduct(Globals.g_order, "adminwizard", "wx6", false) != null) {
                display = true;
            }
        } else if (Globals.g_srwOnly) {
            display = false;
        } else if (Globals.g_cmtTask == 41 || Globals.g_cmtTask == 40) {
            RegistryAccess registryAccess = null;
            String osSuffix = Utils.getOS_Suffix();
            this.m_location32Bit = null;
            this.m_location64Bit = null;
            try {
                registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (registryAccess != null && registryAccess.open()) {
                this.m_location64Bit = registryAccess.getInstallLoc("base", Globals.g_majorReleaseVersion);
                if (this.m_location64Bit == null) {
                    this.m_location64Bit = registryAccess.getInstallLoc("base", "default");
                }
                if (Utils.getOS_Suffix().equals("wx6")) {
                    this.m_location32Bit = registryAccess.getInstallLoc("base", Globals.g_majorReleaseVersion, "win");
                    if (this.m_location32Bit == null) {
                        this.m_location32Bit = registryAccess.getInstallLoc("base", "default", "win");
                    }
                } else if (Utils.getOS_Suffix().equals("lax")) {
                    this.m_location32Bit = registryAccess.getInstallLoc("base", Globals.g_majorReleaseVersion, "lnx");
                    if (this.m_location32Bit == null) {
                        this.m_location32Bit = registryAccess.getInstallLoc("base", "default", "lnx");
                    }
                } else {
                    this.m_location32Bit = registryAccess.getInstallLoc("base", Globals.g_majorReleaseVersion, "mvs");
                    if (this.m_location32Bit == null) {
                        this.m_location32Bit = registryAccess.getInstallLoc("base", "default", "mvs");
                    }
                }
                registryAccess.close();
            }
            if (this.m_location32Bit != null && this.m_location64Bit != null) {
                display = true;
            } else if (this.m_location32Bit != null) {
                Globals.g_bitnessSASLocation = this.m_location32Bit;
                if (osSuffix.equals("wx6")) {
                    Globals.g_sasinstallPlat = "win";
                } else if (osSuffix.equals("lax")) {
                    Globals.g_sasinstallPlat = "lnx";
                }
            } else if (this.m_location64Bit != null) {
                Globals.g_bitnessSASLocation = this.m_location64Bit;
            }
        } else if (Globals.g_configure && !Globals.g_install) {
            Globals.g_sasinstallPlat = null;
            String osSuffix = Utils.getOS_Suffix();
            if (osSuffix.equals("wx6") || osSuffix.equals("lax") || osSuffix.equals("mvs")) {
                ProductData prodData32Bit = null;
                ProductData prodData64Bit = null;
                if (osSuffix.equals("wx6")) {
                    prodData32Bit = Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "win", false);
                    prodData64Bit = Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "wx6", false);
                } else if (osSuffix.equals("lax")) {
                    prodData32Bit = Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "lnx", false);
                    prodData64Bit = Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "lax", false);
                } else {
                    prodData32Bit = Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "mvs", false);
                    prodData64Bit = Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "z64", false);
                }
                if (prodData32Bit != null && prodData64Bit != null) {
                    RegistryAccess registryAccess = null;
                    try {
                        registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String location32Bit = null;
                    String location64Bit = null;
                    if (registryAccess != null && registryAccess.open()) {
                        location64Bit = registryAccess.getInstallLoc("sasinstall", prodData64Bit.getProdVersion());
                        if (location64Bit == null) {
                            location64Bit = registryAccess.getInstallLoc("sasinstall", "default");
                        }
                        if (osSuffix.equals("wx6")) {
                            location32Bit = registryAccess.getInstallLoc("sasinstall", prodData32Bit.getProdVersion(), "win");
                            if (location32Bit == null) {
                                location32Bit = registryAccess.getInstallLoc("sasinstall", "default", "win");
                            }
                        } else if (osSuffix.equals("lax")) {
                            location32Bit = registryAccess.getInstallLoc("sasinstall", prodData32Bit.getProdVersion(), "lnx");
                            if (location32Bit == null) {
                                location32Bit = registryAccess.getInstallLoc("sasinstall", "default", "lnx");
                            }
                        } else {
                            location32Bit = registryAccess.getInstallLoc("sasinstall", prodData32Bit.getProdVersion(), "mvs");
                            if (location32Bit == null) {
                                location32Bit = registryAccess.getInstallLoc("sasinstall", "default", "mvs");
                            }
                        }
                        registryAccess.close();
                    }
                    if (location32Bit != null && location64Bit != null) {
                        display = true;
                    } else if (location32Bit != null) {
                        Globals.g_sasinstallPlat = osSuffix.equals("wx6") ? "win" : (osSuffix.equals("lax") ? "lnx" : "mvs");
                    }
                } else if (prodData32Bit != null) {
                    Globals.g_sasinstallPlat = osSuffix.equals("wx6") ? "win" : (osSuffix.equals("lax") ? "lnx" : "mvs");
                }
            }
        } else {
            String osSuffix = Utils.getOS_Suffix();
            if (osSuffix.equals("wx6") || osSuffix.equals("lax") || osSuffix.equals("z64")) {
                boolean installingSAS = false;
                if (Globals.g_selectedInstalls != null) {
                    for (int i = 0; !installingSAS && i < Globals.g_selectedInstalls.length; ++i) {
                        if (!Globals.g_selectedInstalls[i].getProdCode().equalsIgnoreCase("sasinstall")) continue;
                        installingSAS = true;
                    }
                }
                if (installingSAS) {
                    if (osSuffix.equals("wx6")) {
                        if (Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "win", false) != null && Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "wx6", false) != null) {
                            display = true;
                        }
                    } else if (osSuffix.equals("lax")) {
                        if (Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "lnx", false) != null && Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "lax", false) != null) {
                            display = true;
                        }
                    } else if (Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "mvs", false) != null && Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "z64", false) != null) {
                        display = true;
                    }
                }
            }
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        if (Globals.g_cmtTask == 41) {
            return "selectsid";
        }
        if (Globals.g_cmtTask == 40) {
            if (this.sdm_no_saslicense) {
                return "selectsasfoundationtask";
            }
            return "execute";
        }
        return "selectmodeeg";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            if (!this.loadResponseData()) {
                this.m_platPrimary.setSelected(true);
            }
            this.m_panelLoaded = true;
        }
        if (Globals.g_createSSD) {
            this.m_instructions.setText(this.bundle.getString("PanelSelectMode.InstructionsSAW.txt"));
            this.m_descPrimary.setText(this.bundle.getString("PanelSelectMode.Desc64BitSAW.txt"));
            this.m_descAlternate.setText(this.bundle.getString("PanelSelectMode.Desc32BitSAW.txt"));
        } else if (Globals.g_cmtTask == 41) {
            this.m_instructions.setText(this.bundle.getString("PanelSelectMode.InstructionsRenew.txt"));
            this.m_descPrimary.setText(this.bundle.getString("PanelSelectMode.Desc64BitRenew.txt"));
            this.m_descAlternate.setText(this.bundle.getString("PanelSelectMode.Desc32BitRenew.txt"));
        } else if (Globals.g_cmtTask == 40) {
            this.m_instructions.setText(this.bundle.getString("PanelSelectMode.InstructionsRepair.txt"));
            this.m_descPrimary.setText(this.bundle.getString("PanelSelectMode.Desc64BitRepair.txt"));
            this.m_descAlternate.setText(this.bundle.getString("PanelSelectMode.Desc32BitRepair.txt"));
        } else if (Globals.g_configure && !Globals.g_install) {
            this.m_instructions.setText(this.bundle.getString("PanelSelectMode.InstructionsConfig.txt"));
            this.m_descPrimary.setText(this.bundle.getString("PanelSelectMode.Desc64BitConfig.txt"));
            this.m_descAlternate.setText(this.bundle.getString("PanelSelectMode.Desc32BitConfig.txt"));
        } else {
            this.m_instructions.setText(this.bundle.getString("PanelSelectMode.Instructions.txt"));
            this.m_descPrimary.setText(this.bundle.getString("PanelSelectMode.Desc64Bit.txt"));
            this.m_descAlternate.setText(this.bundle.getString("PanelSelectMode.Desc32Bit.txt"));
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        if (this.m_platPrimary.isSelected()) {
            return this.m_platPrimary;
        }
        return this.m_platAlternate;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        ArrayList<String> data = new ArrayList<String>();
        String osSuffix = Utils.getOS_Suffix();
        if (osSuffix.equals("wx6") || osSuffix.equals("lax") || osSuffix.equals("z64")) {
            data.add("#SAS_FOUNDATION_MODE=64-bit/32-bit");
            if (this.m_panelLoaded) {
                if (this.m_platPrimary.isSelected()) {
                    data.add(" SAS_FOUNDATION_MODE=64-bit");
                } else {
                    data.add(" SAS_FOUNDATION_MODE=32-bit");
                }
            } else {
                data.add(" SAS_FOUNDATION_MODE=");
            }
        } else {
            return null;
        }
        return data.toArray(new String[0]);
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_platPrimary, this.m_platAlternate};
        JTextArea[] infos = new JTextArea[]{this.m_descPrimary, this.m_descAlternate};
        return ConsoleMode.promptRadioButtons(options, infos);
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String osSuffix = Utils.getOS_Suffix();
        if (osSuffix.equals("wx6") || osSuffix.equals("lax") || osSuffix.equals("z64")) {
            String response = Wizard.getResponse("SAS_FOUNDATION_MODE", null);
            if (response != null) {
                if (response.equalsIgnoreCase("64-bit")) {
                    valid = true;
                    this.m_platPrimary.setSelected(true);
                } else if (response.equalsIgnoreCase("32-bit")) {
                    valid = true;
                    this.m_platAlternate.setSelected(true);
                }
                if (Globals.g_quietMode && !valid) {
                    Wizard.logResponseInvalid(this.getHeader(), "SAS_FOUNDATION_MODE", response, null);
                }
            } else if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "SAS_FOUNDATION_MODE");
            }
        }
        return valid;
    }

    private void initialize() {
        this.m_altPlatCode = Utils.getOS_Suffix().equals("wx6") ? "win" : (Utils.getOS_Suffix().equals("lax") ? "lnx" : "mvs");
        this.m_instructions = new JTextArea();
        this.m_instructions.setEditable(false);
        this.m_instructions.setFocusable(false);
        this.m_instructions.setLineWrap(true);
        this.m_instructions.setWrapStyleWord(true);
        this.m_instructions.setOpaque(false);
        String mtxt = this.bundle.getString("PanelSelectMode.Name64Bit.txt");
        this.m_platPrimary = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_platPrimary.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_platPrimary.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_platPrimary.getFont();
        this.m_platPrimary.setFont(optionFont.deriveFont(1));
        this.m_descPrimary = new JTextArea();
        this.m_descPrimary.setEditable(false);
        this.m_descPrimary.setFocusable(false);
        this.m_descPrimary.setLineWrap(true);
        this.m_descPrimary.setWrapStyleWord(true);
        this.m_descPrimary.setOpaque(false);
        mtxt = this.bundle.getString("PanelSelectMode.Name32Bit.txt");
        this.m_platAlternate = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_platAlternate.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_platAlternate.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_platAlternate.getFont();
        this.m_platAlternate.setFont(optionFont.deriveFont(1));
        this.m_descAlternate = new JTextArea();
        this.m_descAlternate.setEditable(false);
        this.m_descAlternate.setFocusable(false);
        this.m_descAlternate.setLineWrap(true);
        this.m_descAlternate.setWrapStyleWord(true);
        this.m_descAlternate.setOpaque(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_platPrimary);
        group.add(this.m_platAlternate);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_instructions, c);
        c.gridy = 1;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_platPrimary, c);
        c.gridy = 2;
        c.insets = new Insets(5, 20, 5, 0);
        this.m_panel.add((Component)this.m_descPrimary, c);
        c.gridy = 3;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_platAlternate, c);
        c.gridy = 4;
        c.insets = new Insets(5, 20, 0, 0);
        this.m_panel.add((Component)this.m_descAlternate, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

