/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.BatchFile;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class PanelSelectMVAProducts
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelSelectMVAProducts.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_info = null;
    private JTable m_prodList = null;
    private JScrollPane m_listScrollPane = null;
    private ProductTableModel m_prodListModel = null;
    private ActionListener m_prodActionListener = null;
    private JPanel m_buttonPanel = new JPanel(new GridBagLayout());
    private JButton m_selectAllButton = null;
    private JButton m_clearAllButton = null;
    private boolean m_panelLoaded = false;
    private String m_previousSasinstallPlat = null;
    private ArrayList<String> m_productIds = new ArrayList();
    private ArrayList<String> m_hiddenProductIds = new ArrayList();
    private HashMap<String, MVAProductData> m_products = new HashMap();
    private HashMap<String, MVAProductData> m_hiddenProducts = new HashMap();

    public PanelSelectMVAProducts() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public void backEvent(String backPanelID) {
        MVAProductData productData = null;
        Globals.g_selectedMVAProdsCmdOp = "";
        Globals.g_selectedMVAAltSkus = null;
        Globals.g_selectedMVAProducts.clear();
        for (String id : this.m_productIds) {
            productData = this.m_products.get(id);
            if (productData == null || !productData.getInstall()) continue;
            Globals.g_selectedMVAProducts.add(id.toLowerCase(Locale.ENGLISH));
        }
    }

    @Override
    public boolean displayPanel() {
        boolean display = true;
        ProductData data = Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", this.getOS_Suffix_Considering_x64("sasinstall"), false);
        if (data != null && ("9.2".equals(data.getProdSASRelease()) || "9.2".equals(data.getProdVersion())) && data.getChainingCmd(false).indexOf("!CMPLIST") < 0) {
            display = false;
        }
        if (display && Globals.g_installAllMVAProds) {
            display = false;
        }
        if (display && Globals.g_createSSD) {
            display = false;
        }
        if (display && !this.isSasinstallSelected()) {
            display = false;
        }
        if (Utils.isDeploywizWebOrder()) {
            display = false;
        }
        if (display && Globals.g_plannedInstall) {
            display = false;
        }
        if (display && (Utils.getOS() == 9 || Utils.getOS() == 8 || Utils.getOS() == 6)) {
            display = false;
        }
        if (display && (Utils.getOS_Suffix() == "win" || Utils.getOS_Suffix() == "wx6") && Globals.g_depotManager != null && Globals.g_depotManager.getDepotType() == 1) {
            display = false;
        }
        return display;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSelectMVAProducts.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSelectMVAProducts.HeaderDesc.txt");
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    @Override
    public String getNextPanelID() {
        return "selectsid";
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        boolean bSasinstallPlatChanged = false;
        this.loadProdInfo();
        if (this.m_panelLoaded) {
            bSasinstallPlatChanged = this.m_previousSasinstallPlat != null && Globals.g_sasinstallPlat != null ? false : this.m_previousSasinstallPlat != null || Globals.g_sasinstallPlat != null;
        }
        if (this.m_panelLoaded || !this.loadResponseData()) {
            String id = null;
            MVAProductData prodData = null;
            for (int i = 0; i < this.m_productIds.size(); ++i) {
                id = this.m_productIds.get(i);
                prodData = this.m_products.get(id);
                if (prodData == null) continue;
                if (bSasinstallPlatChanged || !this.m_panelLoaded || Globals.g_selectedMVAProducts.contains(id.toLowerCase(Locale.ENGLISH))) {
                    if (Globals.g_plannedInstall || prodData.getSelectable()) {
                        prodData.setInstall(true);
                        continue;
                    }
                    prodData.setInstall(false);
                    continue;
                }
                prodData.setInstall(false);
            }
        }
        if (!this.m_panelLoaded) {
            this.m_panelLoaded = true;
        }
        this.m_previousSasinstallPlat = Globals.g_sasinstallPlat;
    }

    @Override
    public int consoleEvent() {
        ConsoleMode.SelectionItem[] options = new ConsoleMode.SelectionItem[this.m_productIds.size()];
        String id = null;
        MVAProductData data = null;
        for (int i = 0; i < options.length; ++i) {
            id = this.m_productIds.get(i);
            data = this.m_products.get(id);
            options[i] = new ConsoleMode.SelectionItem(data.getName(), data.getInstall(), !data.getSelectable());
        }
        int returnCode = ConsoleMode.promptMultiChoice(options, null);
        if (returnCode > -1) {
            for (int i = 0; i < options.length; ++i) {
                id = this.m_productIds.get(i);
                data = this.m_products.get(id);
                data.setInstall(options[i].getSelected());
            }
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String id = null;
        String response = Wizard.getResponse("SASFOUNDATION_SELECTION", null);
        if (response != null) {
            Vector<String> prodCodes = new Vector<String>(Arrays.asList(response.split(",")));
            MVAProductData prodData = null;
            for (int i = 0; i < this.m_productIds.size(); ++i) {
                id = this.m_productIds.get(i);
                if (!prodCodes.contains(Globals.g_deploymentData.getSpsSku(id).getProdCode().toLowerCase(Locale.ENGLISH)) || (prodData = this.m_products.get(id)) == null) continue;
                valid = true;
                if (!prodData.getSelectable()) continue;
                prodData.setInstall(true);
            }
        }
        if (Globals.g_quietMode && !valid) {
            Wizard.logResponseMissing(this.getHeader(), "SASFOUNDATION_SELECTION");
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#SASFOUNDATION_SELECTION=<comma delimited SAS Foundation (MVA) product codes>", " SASFOUNDATION_SELECTION="};
        if (this.m_panelLoaded) {
            String response = "";
            String id = null;
            MVAProductData prodData = null;
            for (int i = 0; i < this.m_productIds.size(); ++i) {
                id = this.m_productIds.get(i);
                prodData = this.m_products.get(id);
                if (prodData == null || !prodData.getInstall()) continue;
                if (response.length() > 0) {
                    response = response + ",";
                }
                response = response + Globals.g_deploymentData.getSpsSku(id).getProdCode().toLowerCase(Locale.ENGLISH);
            }
            data[1] = " SASFOUNDATION_SELECTION=" + response;
        }
        return data;
    }

    @Override
    public boolean silentEvent() {
        this.loadProdInfo();
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validateData() {
        boolean valid = false;
        MVAProductData productData = null;
        int index = 1;
        File mvaCompList = null;
        Globals.g_selectedMVAProducts.clear();
        Globals.g_selectedMVAAltSkus = null;
        ArrayList<String> altskusForMaint = new ArrayList<String>();
        BufferedWriter bw = null;
        File tmpDir = new File(Globals.g_tempLocation);
        try {
            mvaCompList = File.createTempFile("mvacomplist", ".ini", tmpDir);
        }
        catch (Exception e) {
            Logging.log.severe("Error creating temporary mvacomplist file at " + tmpDir);
            if (!Globals.g_quietMode) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelSelectMVAProducts.ErrorWritingFile.txt"), this.bundle.getString("Common.Error.txt"), 0);
            }
            return valid;
        }
        try {
            bw = new BufferedWriter(new FileWriter(mvaCompList));
            bw.append("[CommandLineComponents]");
            bw.newLine();
            for (String id : this.m_productIds) {
                productData = this.m_products.get(id);
                if (productData == null || !productData.getInstall()) continue;
                valid = true;
                bw.append("Comp" + index + "=" + id);
                bw.newLine();
                Globals.g_selectedMVAProducts.add(id.toLowerCase(Locale.ENGLISH));
                altskusForMaint.add(id);
                ++index;
            }
            for (String id : this.m_hiddenProductIds) {
                productData = this.m_hiddenProducts.get(id);
                if (productData == null || !productData.getInstall()) continue;
                valid = true;
                bw.append("Comp" + index + "=" + id);
                bw.newLine();
                ++index;
            }
        }
        catch (Exception e) {
            valid = false;
            Logging.log.severe("Error writing to temporary mvacomplist file: " + mvaCompList.getAbsolutePath());
            if (!Globals.g_quietMode) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelSelectMVAProducts.ErrorWritingFile.txt"), this.bundle.getString("Common.Error.txt"), 0);
            }
        }
        finally {
            block29: {
                try {
                    if (bw != null) {
                        bw.flush();
                        bw.close();
                    }
                }
                catch (IOException e) {
                    valid = false;
                    Logging.log.severe("Error closing temporary mvacomplist file: " + mvaCompList.getAbsolutePath());
                    if (Globals.g_quietMode) break block29;
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelSelectMVAProducts.ErrorWritingFile.txt"), this.bundle.getString("Common.Error.txt"), 0);
                }
            }
        }
        if (valid) {
            Globals.g_selectedMVAProdsCmdOp = Utils.getOS() == 1 ? "-cmplist=\"" + mvaCompList.getAbsolutePath() + "\"" : "-cmplist " + mvaCompList.getAbsolutePath();
            for (String id : this.m_hiddenProductIds) {
                productData = this.m_hiddenProducts.get(id);
                if (productData == null || !productData.getInstall()) continue;
                altskusForMaint.add(id);
            }
            Globals.g_selectedMVAAltSkus = altskusForMaint.toArray(new String[0]);
            BatchFile bf = BatchFile.getInstance();
            if (Globals.g_createBatch) {
                try {
                    bf.createBatchFile();
                }
                catch (IOException ioe) {
                    Logging.log.severe("No system requisite batch file could be created: " + ioe.getMessage());
                }
                catch (SecurityException se) {
                    Logging.log.severe("System requisite batch file could not be deleted: " + se.getMessage());
                }
            } else if (Globals.g_srwOnly) {
                bf.close();
            }
        } else if (!Globals.g_quietMode) {
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelSelectMVAProducts.RequiredField.txt"), this.bundle.getString("Common.Warning.txt"), 2);
            this.m_prodList.requestFocus();
        }
        return valid;
    }

    private void initialize() {
        this.m_info = new JTextArea(this.bundle.getString("PanelSelectMVAProducts.Info.txt"));
        this.m_info.setEditable(false);
        this.m_info.setFocusable(false);
        this.m_info.setLineWrap(true);
        this.m_info.setWrapStyleWord(true);
        this.m_info.setOpaque(false);
        this.m_prodListModel = new ProductTableModel();
        this.m_prodList = new JTable(this.m_prodListModel);
        this.m_prodList.setCellSelectionEnabled(true);
        this.m_prodList.setSelectionMode(0);
        this.m_prodList.setTableHeader(null);
        this.m_prodList.setShowGrid(false);
        this.m_prodList.setOpaque(true);
        this.m_prodList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelSelectMVAProducts.this.m_prodList.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.m_listScrollPane = new JScrollPane(this.m_prodList);
        this.m_listScrollPane.getViewport().setBackground(this.m_prodList.getBackground());
        String mtxt = this.bundle.getString("Common.SelectAll.txt");
        String txt = Util.getLabelWithoutMnemonic(mtxt);
        int mkey = Util.getDisplayedMnemonic(mtxt);
        this.m_selectAllButton = new JButton(txt);
        this.m_selectAllButton.setMnemonic(mkey);
        mtxt = this.bundle.getString("Common.ClearAll.txt");
        txt = Util.getLabelWithoutMnemonic(mtxt);
        mkey = Util.getDisplayedMnemonic(mtxt);
        this.m_clearAllButton = new JButton(txt);
        this.m_clearAllButton.setMnemonic(mkey);
        this.m_prodActionListener = new SelectClearActionListener();
        this.m_selectAllButton.addActionListener(this.m_prodActionListener);
        this.m_clearAllButton.addActionListener(this.m_prodActionListener);
        this.installRenderers();
    }

    private void installRenderers() {
        this.m_prodList.getColumnModel().getColumn(0).setCellRenderer(new ProductCellRenderer());
        this.m_prodList.getColumnModel().getColumn(0).setCellEditor(new ProductCellEditor(new JCheckBox()));
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 18;
        c.gridy = 0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_info, c);
        c.gridy = 1;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_listScrollPane, c);
        this.initButtonPanel();
        c.gridy = 2;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_panel.add((Component)this.m_buttonPanel, c);
    }

    private void initButtonPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.gridx = 0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 5);
        this.m_buttonPanel.add((Component)this.m_selectAllButton, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_buttonPanel.add((Component)this.m_clearAllButton, c);
        if (this.m_selectAllButton.getPreferredSize().getWidth() < this.m_clearAllButton.getPreferredSize().getWidth()) {
            this.m_selectAllButton.setPreferredSize(this.m_clearAllButton.getPreferredSize());
        } else if (this.m_clearAllButton.getPreferredSize().getWidth() < this.m_selectAllButton.getPreferredSize().getWidth()) {
            this.m_clearAllButton.setPreferredSize(this.m_selectAllButton.getPreferredSize());
        }
    }

    private void loadProdInfo() {
        this.m_prodListModel.load();
        int rowHeight = Utils.getPreferredRowHeight(this.m_prodList);
        if (rowHeight > 0) {
            this.m_prodList.setRowHeight(rowHeight);
        }
    }

    private boolean isSasinstallSelected() {
        boolean selected = false;
        if (Globals.g_selectedInstalls == null) {
            selected = true;
        } else {
            for (int i = 0; i < Globals.g_selectedInstalls.length; ++i) {
                if (!"sasinstall".equalsIgnoreCase(Globals.g_selectedInstalls[i].getProdCode())) continue;
                selected = true;
            }
        }
        return selected;
    }

    private String getOS_Suffix_Considering_x64(String productCode) {
        if (productCode.equalsIgnoreCase("sasinstall") && Globals.g_sasinstallPlat != null) {
            return Globals.g_sasinstallPlat;
        }
        return Utils.getOS_Suffix();
    }

    class ProductTableModel
    extends AbstractTableModel {
        public static final int LANGUAGE_COLUMN = 0;

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int index) {
            return null;
        }

        public Class getColumnClass(int index) {
            return Boolean.class;
        }

        @Override
        public int getRowCount() {
            return PanelSelectMVAProducts.this.m_products.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String id = (String)PanelSelectMVAProducts.this.m_productIds.get(rowIndex);
            boolean selected = false;
            if (id != null) {
                MVAProductData prodData = (MVAProductData)PanelSelectMVAProducts.this.m_products.get(id);
                selected = prodData.getInstall();
            }
            return selected;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            String id = (String)PanelSelectMVAProducts.this.m_productIds.get(rowIndex);
            if (id != null && value instanceof Boolean) {
                MVAProductData prodData = (MVAProductData)PanelSelectMVAProducts.this.m_products.get(id);
                prodData.setInstall((Boolean)value);
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }

        public void load() {
            PanelSelectMVAProducts.this.m_products.clear();
            PanelSelectMVAProducts.this.m_productIds.clear();
            PanelSelectMVAProducts.this.m_hiddenProducts.clear();
            PanelSelectMVAProducts.this.m_hiddenProductIds.clear();
            MVAProductData prodData = null;
            String[] mvaAltSkus = null;
            ProductData sasinstallData = Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", PanelSelectMVAProducts.this.getOS_Suffix_Considering_x64("sasinstall"), false);
            if (sasinstallData != null) {
                mvaAltSkus = Globals.g_deploymentData.getOrder(Globals.g_order).getMVAAltSkus(sasinstallData.getSpsSku());
            }
            if (mvaAltSkus == null) {
                mvaAltSkus = Globals.g_deploymentData.getOrder(Globals.g_order).getMVAAltSkus(PanelSelectMVAProducts.this.getOS_Suffix_Considering_x64("sasinstall"));
            }
            for (int i = 0; i < mvaAltSkus.length; ++i) {
                if (!Globals.g_deploymentData.getSpsSku(mvaAltSkus[i]).getLanguage().equalsIgnoreCase("en") && !Globals.g_deploymentData.getSpsSku(mvaAltSkus[i]).getLanguage().equalsIgnoreCase("ne")) continue;
                prodData = new MVAProductData(Globals.g_deploymentData.getSpsSku(mvaAltSkus[i]).getProdCode(), Globals.g_deploymentData.getSpsSku(mvaAltSkus[i]).getDisplayName("en"), !this.isRequired(mvaAltSkus[i]));
                if (!this.isHidden(mvaAltSkus[i])) {
                    PanelSelectMVAProducts.this.m_productIds.add(mvaAltSkus[i]);
                    prodData.setInstall(false);
                    PanelSelectMVAProducts.this.m_products.put(mvaAltSkus[i], prodData);
                    continue;
                }
                PanelSelectMVAProducts.this.m_hiddenProductIds.add(mvaAltSkus[i]);
                prodData.setInstall(Globals.g_plannedInstall);
                PanelSelectMVAProducts.this.m_hiddenProducts.put(mvaAltSkus[i], prodData);
            }
            String tempProdId = null;
            for (int i = PanelSelectMVAProducts.this.m_productIds.size() - 1; i > 0; --i) {
                for (int j = 0; j < i; ++j) {
                    if (((MVAProductData)PanelSelectMVAProducts.this.m_products.get(PanelSelectMVAProducts.this.m_productIds.get(j))).getName().compareTo(((MVAProductData)PanelSelectMVAProducts.this.m_products.get(PanelSelectMVAProducts.this.m_productIds.get(j + 1))).getName()) <= 0) continue;
                    tempProdId = (String)PanelSelectMVAProducts.this.m_productIds.get(j);
                    PanelSelectMVAProducts.this.m_productIds.set(j, (String)PanelSelectMVAProducts.this.m_productIds.get(j + 1));
                    PanelSelectMVAProducts.this.m_productIds.set(j + 1, tempProdId);
                }
            }
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelSelectMVAProducts.this.installRenderers();
            PanelSelectMVAProducts.this.m_selectAllButton.setEnabled(PanelSelectMVAProducts.this.m_products.size() > 0);
            PanelSelectMVAProducts.this.m_clearAllButton.setEnabled(PanelSelectMVAProducts.this.m_products.size() > 0);
        }

        protected boolean isRequired(String sku) {
            boolean required = false;
            if (Globals.g_deploymentData.getSpsSku(sku).getProdCode().equalsIgnoreCase("base")) {
                required = true;
            }
            return required;
        }

        protected boolean isHidden(String sku) {
            boolean hidden = false;
            SpsSkuData skuData = Globals.g_deploymentData.getSpsSku(sku);
            if (skuData.getLanguage().equals("xx")) {
                hidden = true;
            } else {
                ProductData prodData = Globals.g_deploymentData.getProduct(Globals.g_order, skuData.getProdCode(), PanelSelectMVAProducts.this.getOS_Suffix_Considering_x64("sasinstall"), false);
                if (prodData.getSelectableType() == 2) {
                    hidden = true;
                }
            }
            return hidden;
        }

        public void selectAll(boolean value) {
            String id = null;
            MVAProductData prodData = null;
            for (int i = 0; i < PanelSelectMVAProducts.this.m_productIds.size(); ++i) {
                id = (String)PanelSelectMVAProducts.this.m_productIds.get(i);
                prodData = (MVAProductData)PanelSelectMVAProducts.this.m_products.get(id);
                if (prodData == null || !prodData.getSelectable()) continue;
                prodData.setInstall(value);
            }
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelSelectMVAProducts.this.installRenderers();
        }

        public void clear() {
            PanelSelectMVAProducts.this.m_products.clear();
            PanelSelectMVAProducts.this.m_productIds.clear();
            PanelSelectMVAProducts.this.m_hiddenProducts.clear();
            PanelSelectMVAProducts.this.m_hiddenProductIds.clear();
            this.fireTableDataChanged();
        }
    }

    class MVAProductData {
        private String m_name = null;
        private boolean m_install = false;
        private boolean m_selectable = false;

        public MVAProductData(String altsku, String name, boolean selectable) {
            this.m_name = name;
            this.m_selectable = selectable;
            if (!this.m_selectable) {
                this.m_install = true;
            }
        }

        public String getName() {
            return this.m_name;
        }

        public boolean getInstall() {
            return this.m_install;
        }

        public boolean getSelectable() {
            return this.m_selectable;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public void setInstall(boolean install) {
            if (this.m_selectable) {
                this.m_install = install;
            }
        }

        public void setSelectable(boolean selectable) {
            this.m_selectable = selectable;
            if (!this.m_selectable) {
                this.m_install = true;
            }
        }
    }

    class SelectClearActionListener
    implements ActionListener {
        SelectClearActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PanelSelectMVAProducts.this.m_selectAllButton) {
                PanelSelectMVAProducts.this.m_prodListModel.selectAll(true);
            } else if (e.getSource() == PanelSelectMVAProducts.this.m_clearAllButton) {
                PanelSelectMVAProducts.this.m_prodListModel.selectAll(false);
            }
        }
    }

    private class ProductCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
                this.setSelected(false);
                this.setEnabled(false);
            } else {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = (String)PanelSelectMVAProducts.this.m_productIds.get(row);
                    MVAProductData prodData = (MVAProductData)PanelSelectMVAProducts.this.m_products.get(id);
                    this.setText(prodData.getName());
                    this.setSelected(prodData.getInstall());
                    this.setEnabled(prodData.getSelectable());
                }
            }
            return this;
        }
    }

    private class ProductCellEditor
    extends DefaultCellEditor {
        private JCheckBox m_checkBox;

        public ProductCellEditor(JCheckBox checkBox) {
            super(checkBox);
            this.m_checkBox = checkBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                this.m_checkBox.setText("");
                this.m_checkBox.setSelected(false);
                this.m_checkBox.setEnabled(false);
            } else {
                if (isSelected) {
                    this.m_checkBox.setForeground(table.getSelectionForeground());
                    this.m_checkBox.setBackground(table.getSelectionBackground());
                } else {
                    this.m_checkBox.setForeground(table.getForeground());
                    this.m_checkBox.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = (String)PanelSelectMVAProducts.this.m_productIds.get(row);
                    MVAProductData prodData = (MVAProductData)PanelSelectMVAProducts.this.m_products.get(id);
                    this.m_checkBox.setText(prodData.getName());
                    this.m_checkBox.setSelected(prodData.getInstall());
                    this.m_checkBox.setEnabled(prodData.getSelectable());
                }
            }
            return this.m_checkBox;
        }
    }
}

