/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.Kit;
import com.sas.ssn.Logging;
import com.sas.ssn.OrderData;
import com.sas.ssn.SASLocale;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import com.sas.tools.installs.it.DeploymentXMLReader;
import com.sas.tools.installs.schema.ittasks.LocaleType;
import com.sas.tools.installs.schema.ittasks.LocalesForHostType;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class PanelSelectLocale
implements WizardPanelIface {
    private static SASLocale m_fallbackSASLocaleForMVS = null;
    private static SASLocale m_fallbackSASLocaleForWIN = null;
    private static SASLocale m_fallbackSASLocaleForUNX = null;
    private final SSNResource bundle = new SSNResource(PanelSelectLocale.class);
    private final JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_locale_info = null;
    private JComboBox m_locale = null;
    private JLabel m_localeLabel = null;
    private JTextArea m_unicode_info = null;
    private JCheckBox m_unicode = null;
    private boolean m_panelLoaded = false;
    private boolean m_showUnicode = false;
    private String m_platformFamily = null;
    private String m_loadedForOrder = null;

    public PanelSelectLocale() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSelectLocale.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSelectLocale.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        if (this.m_locale.getSelectedIndex() < 0) {
            if (!Globals.g_quietMode) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelSelectLocale.ErrorMsg.txt"), this.bundle.getString("Common.Warning.txt"), 2);
                this.m_locale.requestFocus();
            }
            return false;
        }
        SASLocale selectedLocale = this.m_locale.getSelectedIndex() > -1 ? (SASLocale)this.m_locale.getSelectedItem() : this.getFallbackSASLocale();
        Globals.g_sasDefaultLocale = selectedLocale.clone();
        if (this.m_showUnicode && this.m_unicode.isSelected()) {
            Globals.g_sasDefaultLocale.setAsUnicode();
        }
        if (Globals.g_debug) {
            String encodingTwoByte;
            String encodingType;
            Logging.log.info("SAS Default Locale MVA Posix Name=" + Globals.g_sasDefaultLocale.getMVAPosixName());
            Logging.log.info("SAS Default SAS Encoding=" + Globals.g_sasDefaultLocale.getSASEncoding());
            Logging.log.info("SAS Default Java Encoding=" + Globals.g_sasDefaultLocale.getJavaEncoding());
            String ibmEncoding = Globals.g_sasDefaultLocale.getIbmEncoding();
            if (ibmEncoding != null) {
                Logging.log.info("SAS Default IBM Encoding=" + ibmEncoding);
            }
            if ((encodingType = Globals.g_sasDefaultLocale.getEncodingType()) != null) {
                Logging.log.info("SAS Default Encoding Type=" + encodingType);
            }
            if ((encodingTwoByte = Globals.g_sasDefaultLocale.getEncodingTwoByte()) != null) {
                Logging.log.info("SAS Default Encoding Two Byte=" + encodingTwoByte);
            }
        }
        return true;
    }

    @Override
    public boolean displayPanel() {
        if (Globals.g_skipLocalePrompt) {
            return false;
        }
        SASLocale sasLocaleFromDeploymentReg = SASLocale.getSASLocaleFromDeploymentReg();
        if (sasLocaleFromDeploymentReg == null) {
            if (Globals.g_selectedInstalls != null && Globals.g_selectedInstalls.length > 0) {
                return true;
            }
        } else {
            Globals.g_sasDefaultLocale = sasLocaleFromDeploymentReg;
        }
        return Globals.g_recordMode && Globals.g_recordOnly;
    }

    @Override
    public String getNextPanelID() {
        return "selectdefaultproductforfiletypes";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        this.ensurePanelDataIsLoaded();
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
        this.m_unicode_info.setEnabled(this.m_showUnicode);
        this.m_unicode_info.setVisible(this.m_showUnicode);
        this.m_unicode.setEnabled(this.m_showUnicode);
        this.m_unicode.setVisible(this.m_showUnicode);
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_locale;
    }

    @Override
    public boolean silentEvent() {
        this.ensurePanelDataIsLoaded();
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        if (this.m_showUnicode) {
            String[] data = new String[]{"#REGION_SETTING=<region setting code>", " REGION_SETTING=", "#UNICODE_SERVER=yes/no", " UNICODE_SERVER="};
            if (this.m_panelLoaded) {
                data[1] = " REGION_SETTING=" + ((SASLocale)this.m_locale.getSelectedItem()).getMVAPosixName();
                data[3] = this.m_unicode.isSelected() ? " UNICODE_SERVER=yes" : " UNICODE_SERVER=no";
            }
            return data;
        }
        String[] data = new String[]{"#REGION_SETTING=<locale setting code>", " REGION_SETTING="};
        if (this.m_panelLoaded) {
            data[1] = " REGION_SETTING=" + ((SASLocale)this.m_locale.getSelectedItem()).getMVAPosixName();
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int returnCode = ConsoleMode.promptComboBox(this.m_locale);
        if (returnCode > -1 && this.m_showUnicode) {
            returnCode = ConsoleMode.promptBoolean(this.m_unicode);
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String responseRegion = Wizard.getResponse("REGION_SETTING", null);
        if (responseRegion != null) {
            for (int i = 0; i < this.m_locale.getItemCount() && !valid; ++i) {
                SASLocale sasLocale = (SASLocale)this.m_locale.getItemAt(i);
                if (!responseRegion.equals(sasLocale.getMVAPosixName())) continue;
                this.m_locale.setSelectedItem(sasLocale);
                valid = true;
            }
            if (!valid) {
                Wizard.logResponseInvalid(this.getHeader(), "REGION_SETTING", responseRegion, null);
            }
        } else {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "REGION_SETTING");
            }
        }
        if (valid && this.m_showUnicode) {
            String responseUnicode = Wizard.getResponse("UNICODE_SERVER", null);
            if (responseUnicode != null) {
                if (responseUnicode.equalsIgnoreCase("yes")) {
                    this.m_unicode.setSelected(true);
                } else if (responseUnicode.equalsIgnoreCase("no")) {
                    this.m_unicode.setSelected(false);
                } else {
                    valid = false;
                    Wizard.logResponseInvalid(this.getHeader(), "UNICODE_SERVER", responseUnicode, null);
                }
            } else {
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseMissing(this.getHeader(), "UNICODE_SERVER");
                }
            }
        }
        return valid;
    }

    private void initialize() {
        this.m_locale_info = new JTextArea(this.bundle.getString("PanelSelectLocale.LocaleInfo.txt"));
        this.m_locale_info.setEditable(false);
        this.m_locale_info.setFocusable(false);
        this.m_locale_info.setLineWrap(true);
        this.m_locale_info.setWrapStyleWord(true);
        this.m_locale_info.setOpaque(false);
        this.m_locale = new JComboBox();
        this.m_locale.setEnabled(true);
        this.m_locale.setMaximumRowCount(22);
        this.m_locale.setToolTipText(this.bundle.getString("PanelSelectLocale.Tooltip.txt"));
        String mtxt = this.bundle.getString("PanelSelectLocale.LocaleLabel.txt");
        this.m_localeLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_localeLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_localeLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_localeLabel.setLabelFor(this.m_locale);
        this.m_unicode_info = new JTextArea(this.bundle.getString("PanelSelectLocale.UnicodeInfo.txt"));
        this.m_unicode_info.setEditable(false);
        this.m_unicode_info.setFocusable(false);
        this.m_unicode_info.setLineWrap(true);
        this.m_unicode_info.setWrapStyleWord(true);
        this.m_unicode_info.setOpaque(false);
        mtxt = this.bundle.getString("PanelSelectLocale.UnicodeLabel.txt");
        this.m_unicode = new JCheckBox(Util.getLabelWithoutMnemonic(mtxt));
        this.m_unicode.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_unicode.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridwidth = 3;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_locale_info, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.gridwidth = 2;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 20, 5, 0);
        this.m_panel.add((Component)this.m_localeLabel, c);
        c.gridx = 2;
        c.gridy = 1;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 10, 5, 5);
        this.m_panel.add((Component)this.m_locale, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.gridwidth = 3;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(20, 0, 5, 0);
        this.m_panel.add((Component)this.m_unicode_info, c);
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 0.0;
        c.gridwidth = 3;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 15, 5, 0);
        this.m_panel.add((Component)this.m_unicode, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    private void ensurePanelDataIsLoaded() {
        OrderData orderData;
        this.m_platformFamily = Utils.getOS() == 8 ? "mvs" : (Utils.getOS() == 1 ? "win" : "unx");
        this.m_showUnicode = false;
        if (!"mvs".equals(this.m_platformFamily) && (orderData = Globals.g_deploymentData.getOrder(Globals.g_order)) != null) {
            this.m_showUnicode = orderData.isPlanning();
        }
        if (!Globals.g_order.equals(this.m_loadedForOrder)) {
            this.loadComboData();
            this.m_loadedForOrder = Globals.g_order;
        }
    }

    private void loadComboData() {
        String prevSelPosixName;
        SASLocale prevSelLocale = (SASLocale)this.m_locale.getSelectedItem();
        this.m_locale.removeAllItems();
        TreeSet<SASLocale> sasLocales = new TreeSet<SASLocale>(this.loadLocaleData().values());
        boolean matchingDefaultSet = false;
        Locale localeDefault = Locale.getDefault();
        String fallbackMVAPosixName = this.getFallbackSASLocale().getMVAPosixName();
        for (SASLocale sasLocale : sasLocales) {
            this.m_locale.addItem(sasLocale);
            if (matchingDefaultSet) continue;
            if ("mvs".equals(this.m_platformFamily)) {
                if (!sasLocale.isDefaultSelection()) continue;
                this.m_locale.setSelectedItem(sasLocale);
                matchingDefaultSet = true;
                continue;
            }
            if (sasLocale.isMatchForJavaLocale(localeDefault)) {
                this.m_locale.setSelectedItem(sasLocale);
                matchingDefaultSet = true;
                continue;
            }
            if (!fallbackMVAPosixName.equals(sasLocale.getMVAPosixName())) continue;
            this.m_locale.setSelectedItem(sasLocale);
        }
        if (prevSelLocale != null && (prevSelPosixName = prevSelLocale.getMVAPosixName()) != null) {
            boolean keepLooking = true;
            for (int i = 0; i < this.m_locale.getItemCount() && keepLooking; ++i) {
                SASLocale sasLocale = (SASLocale)this.m_locale.getItemAt(i);
                if (!prevSelPosixName.equals(sasLocale.getMVAPosixName())) continue;
                this.m_locale.setSelectedItem(sasLocale);
                keepLooking = false;
            }
        }
        if (this.m_locale.getSelectedIndex() < 0 && this.m_locale.getItemCount() > 0) {
            this.m_locale.setSelectedIndex(0);
        }
    }

    private Hashtable<String, SASLocale> loadLocaleData() {
        Hashtable<String, SASLocale> sasLocaleMap = new Hashtable<String, SASLocale>();
        DeploymentXMLReader m_reader = Kit.getDeploymentXMLReader();
        try {
            if (m_reader != null) {
                String[] processPlatforms;
                String encodingTwoByte = null;
                if ("mvs".equals(this.m_platformFamily)) {
                    encodingTwoByte = Globals.g_deploymentData.getOrder(Globals.g_order).getEncoding();
                }
                for (String processPlatform : processPlatforms = new String[]{this.m_platformFamily, Utils.getOS_Suffix()}) {
                    List<LocaleType> localeTypes;
                    LocalesForHostType localesForHostType = m_reader.getLocalesForHost(processPlatform, encodingTwoByte);
                    if (localesForHostType == null || (localeTypes = localesForHostType.getLocale()) == null) continue;
                    for (LocaleType localeType : localeTypes) {
                        SASLocale sasLocale = new SASLocale(localeType, encodingTwoByte);
                        sasLocaleMap.put(sasLocale.getMVAPosixName(), sasLocale);
                    }
                }
            } else {
                Logging.log.warning("Locale Processing was unable to find the deployment.xml that contains locale/languae data");
            }
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
        if (sasLocaleMap.isEmpty()) {
            SASLocale fallbackLocale = this.getFallbackSASLocale();
            sasLocaleMap.put(fallbackLocale.getMVAPosixName(), fallbackLocale);
        }
        return sasLocaleMap;
    }

    private SASLocale getFallbackSASLocale() {
        SASLocale fallbackLocale;
        if ("mvs".equals(this.m_platformFamily)) {
            if (m_fallbackSASLocaleForMVS == null) {
                m_fallbackSASLocaleForMVS = new SASLocale("en_US", "open_ed-1047", "Cp1047", "ibm-1047", "SBCS", "w0");
                m_fallbackSASLocaleForMVS.setDefaultSelection(true);
            }
            fallbackLocale = m_fallbackSASLocaleForMVS;
        } else if ("win".equals(this.m_platformFamily)) {
            if (m_fallbackSASLocaleForWIN == null) {
                m_fallbackSASLocaleForWIN = new SASLocale("en_US", "wlatin1", "Cp1252");
            }
            fallbackLocale = m_fallbackSASLocaleForWIN;
        } else {
            if (m_fallbackSASLocaleForUNX == null) {
                m_fallbackSASLocaleForUNX = new SASLocale("en_US", "latin1", "ISO8859-1");
            }
            fallbackLocale = m_fallbackSASLocaleForUNX;
        }
        return fallbackLocale;
    }
}

