/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.PanelSystemRequisitesRequired;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class PanelSelectLicensesToRenew
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelSystemRequisitesRequired.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTable m_componentTable = null;
    private ComponentTableModel m_componentTableModel = null;
    private ActionListener m_installColumnActionListener = null;
    private JPanel m_buttonPanel = new JPanel(new GridBagLayout());
    private JButton m_selectAllButton = null;
    private JButton m_clearAllButton = null;
    private ArrayList<ProductData> installComponents = null;
    private HashMap<String, ?> m_responseProducts = null;
    private boolean m_isBaseInstalled = false;
    private boolean m_isTklasrInstalled = false;

    public PanelSelectLicensesToRenew() {
        this.m_componentTableModel = new ComponentTableModel();
        this.initialize();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSelectLicensesToRenew.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSelectLicensesToRenew.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        ArrayList<String> componentIds = this.m_componentTableModel.getComponentIds();
        HashMap<String, RenewalProduct> components = this.m_componentTableModel.getComponents();
        this.installComponents = new ArrayList();
        for (int i = 0; i < componentIds.size(); ++i) {
            String id = componentIds.get(i);
            RenewalProduct renewalProduct = components.get(id);
            if (!renewalProduct.doInstall()) continue;
            this.installComponents.add(renewalProduct.getRenewalProduct());
        }
        Globals.g_renewalProducts = this.installComponents;
        if (this.m_componentTableModel.noProductsForRenewal()) {
            return false;
        }
        if (!this.m_isBaseInstalled && this.m_isTklasrInstalled) {
            if (Globals.g_quietMode) {
                Logging.log.severe("The SAS Deployment Manager cannot renew the SAS LASR Analytic Server license file because Base SAS has been removed from this machine. The SAS LASR Analytic Server requires a Base SAS installation.");
            } else {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelSelectLicensesToRenew.NoBaseTklasrError.txt"), this.bundle.getString("Common.Warning.txt"), 2);
                this.m_componentTable.requestFocus();
            }
            return false;
        }
        if (this.installComponents.size() == 0) {
            if (Globals.g_quietMode) {
                Logging.log.severe("No products are selected for license renewal. You must select at least one product.");
            } else {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelSelectLicensesToRenew.NoInstallError.txt"), this.bundle.getString("Common.Warning.txt"), 2);
                this.m_componentTable.requestFocus();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        return "selectmode";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        this.m_buttonPanel.setVisible(true);
        this.loadResponseData();
        this.populate();
        int rowHeight = Utils.getPreferredRowHeight(this.m_componentTable);
        if (rowHeight > 0) {
            this.m_componentTable.setRowHeight(rowHeight);
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            this.populate();
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        ArrayList<String> data = new ArrayList<String>();
        if (Globals.g_quietMode && Globals.g_recordMode) {
            data.add(" RENEWAL_SELECTION1=");
        } else {
            ArrayList<String> componentIds = this.m_componentTableModel.getComponentIds();
            HashMap<String, RenewalProduct> components = this.m_componentTableModel.getComponents();
            int index = 1;
            for (int i = 0; i < componentIds.size(); ++i) {
                String id = componentIds.get(i);
                RenewalProduct renewalProduct = components.get(id);
                if (!renewalProduct.doInstall()) continue;
                data.add(" RENEWAL_SELECTION" + Integer.toString(index++) + "=" + renewalProduct.getRenewalCode());
            }
        }
        return data.toArray(new String[0]);
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        ConsoleMode.SelectionItem[] options = new ConsoleMode.SelectionItem[this.m_componentTableModel.getComponentIds().size()];
        String id = null;
        RenewalProduct renewalProduct = null;
        for (int i = 0; i < options.length; ++i) {
            id = this.m_componentTableModel.getComponentIds().get(i);
            renewalProduct = this.m_componentTableModel.getComponents().get(id);
            options[i] = new ConsoleMode.SelectionItem(renewalProduct.getRenewalProduct().getProdName(), renewalProduct.doInstall(), false);
        }
        int returnCode = ConsoleMode.promptMultiChoice(options, null);
        if (returnCode > -1) {
            for (int i = 0; i < options.length; ++i) {
                id = this.m_componentTableModel.getComponentIds().get(i);
                renewalProduct = this.m_componentTableModel.getComponents().get(id);
                renewalProduct.setInstall(options[i].getSelected());
            }
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        if (valid) {
            this.m_responseProducts = null;
            boolean found = true;
            int productCount = 1;
            String responseProduct = null;
            while (found) {
                responseProduct = Wizard.getResponse("RENEWAL_SELECTION" + Integer.toString(productCount), null);
                if (responseProduct != null) {
                    if (productCount == 1) {
                        this.m_responseProducts = new HashMap();
                    }
                    this.m_responseProducts.put(responseProduct.toLowerCase(Locale.ENGLISH), null);
                } else {
                    if (productCount == 1) {
                        valid = false;
                        if (Globals.g_quietMode) {
                            Wizard.logResponseMissing(this.getHeader(), "RENEWAL_SELECTION" + Integer.toString(productCount));
                        }
                    }
                    found = false;
                }
                ++productCount;
            }
        }
        return valid;
    }

    private void initialize() {
        this.m_componentTable = new JTable(this.m_componentTableModel);
        this.m_componentTable.setCellSelectionEnabled(true);
        this.m_componentTable.setSelectionMode(0);
        this.m_componentTable.setTableHeader(null);
        this.m_componentTable.setShowGrid(false);
        this.m_componentTable.setFillsViewportHeight(true);
        JScrollPane tablePane = new JScrollPane(this.m_componentTable);
        tablePane.setPreferredSize(new Dimension(450, 350));
        String mtxt = this.bundle.getString("Common.SelectAll.txt");
        this.m_selectAllButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_selectAllButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_selectAllButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        mtxt = this.bundle.getString("Common.ClearAll.txt");
        this.m_clearAllButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_clearAllButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_clearAllButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_installColumnActionListener = new InstallColumnActionListener();
        this.m_selectAllButton.addActionListener(this.m_installColumnActionListener);
        this.m_clearAllButton.addActionListener(this.m_installColumnActionListener);
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)tablePane, c);
        this.initButtonPanel();
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_panel.add((Component)this.m_buttonPanel, c);
    }

    private void initButtonPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 5);
        this.m_buttonPanel.add((Component)this.m_selectAllButton, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_buttonPanel.add((Component)this.m_clearAllButton, c);
        if (this.m_selectAllButton.getPreferredSize().getWidth() < this.m_clearAllButton.getPreferredSize().getWidth()) {
            this.m_selectAllButton.setPreferredSize(this.m_clearAllButton.getPreferredSize());
        } else if (this.m_clearAllButton.getPreferredSize().getWidth() < this.m_selectAllButton.getPreferredSize().getWidth()) {
            this.m_clearAllButton.setPreferredSize(this.m_selectAllButton.getPreferredSize());
        }
    }

    private void installRenderers() {
        this.m_componentTable.getColumnModel().getColumn(0).setCellRenderer(new ComponentDataCellRenderer());
        this.m_componentTable.getColumnModel().getColumn(0).setCellEditor(new ComponentDataCellEditor(new JCheckBox()));
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void focusGained(FocusEvent e) {
        Globals.g_wizard.getFrame().getRootPane().setDefaultButton(Globals.g_wizard.getNextButton());
    }

    public void focusLost(FocusEvent e) {
        Globals.g_wizard.getFrame().getRootPane().setDefaultButton(Globals.g_wizard.getNextButton());
    }

    private void populate() {
        this.m_componentTableModel.load();
    }

    class ComponentTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 8283934554498211136L;
        public static final int COMPONENT_NAME_COLUMN = 0;
        protected HashMap<String, RenewalProduct> m_components = new HashMap();
        protected ArrayList<String> m_componentIds = new ArrayList();

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int index) {
            return null;
        }

        public Class<Boolean> getColumnClass(int index) {
            return Boolean.class;
        }

        @Override
        public int getRowCount() {
            return this.m_components.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int colIndex) {
            String id = this.m_componentIds.get(rowIndex);
            boolean selected = false;
            if (id != null) {
                RenewalProduct renewalProduct = this.m_components.get(id);
                selected = renewalProduct.doInstall();
            }
            return selected;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int colIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int colIndex) {
            String id = this.m_componentIds.get(rowIndex);
            if (id != null && value instanceof Boolean && colIndex == 0) {
                RenewalProduct renewalProduct = this.m_components.get(id);
                renewalProduct.setInstall((Boolean)value);
                this.fireTableCellUpdated(rowIndex, colIndex);
            }
        }

        public void load() {
            this.m_components.clear();
            this.m_componentIds.clear();
            Globals.g_renewalProducts = this.getProdsInstalledForRenewal();
            Collections.sort(this.m_componentIds, new Comparator<String>(){

                @Override
                public int compare(String pd1, String pd2) {
                    return pd1.compareTo(pd2);
                }
            });
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelSelectLicensesToRenew.this.installRenderers();
            PanelSelectLicensesToRenew.this.m_selectAllButton.setEnabled(this.m_components.size() > 0);
            PanelSelectLicensesToRenew.this.m_clearAllButton.setEnabled(this.m_components.size() > 0);
            if (this.noProductsForRenewal()) {
                return;
            }
        }

        private boolean hasSelected(ProductData productData) {
            if (PanelSelectLicensesToRenew.this.installComponents != null) {
                return PanelSelectLicensesToRenew.this.installComponents.contains(productData);
            }
            return true;
        }

        public void selectAllInstall(boolean value) {
            String id = null;
            RenewalProduct renewalProduct = null;
            for (int i = 0; i < this.m_componentIds.size(); ++i) {
                id = this.m_componentIds.get(i);
                renewalProduct = this.m_components.get(id);
                if (renewalProduct == null) continue;
                renewalProduct.setInstall(value);
            }
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelSelectLicensesToRenew.this.installRenderers();
        }

        public void clear() {
            this.m_components.clear();
            this.m_componentIds.clear();
            this.fireTableDataChanged();
        }

        public ArrayList<String> getComponentIds() {
            return this.m_componentIds;
        }

        public HashMap<String, RenewalProduct> getComponents() {
            return this.m_components;
        }

        public boolean noProductsForRenewal() {
            if (this.m_componentIds.size() == 0) {
                if (Globals.g_quietMode) {
                    Logging.log.severe("No products are available for renewal on this machine.");
                } else {
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), PanelSelectLicensesToRenew.this.bundle.getString("PanelSelectLicensesToRenew.NoProductRenewalMsg.txt"), PanelSelectLicensesToRenew.this.bundle.getString("Common.Warning.txt"), 2);
                    PanelSelectLicensesToRenew.this.m_componentTable.requestFocus();
                }
                return true;
            }
            return false;
        }

        private ArrayList<ProductData> getProdsInstalledForRenewal() {
            ArrayList<ProductData> products = new ArrayList<ProductData>();
            File deploymntRegJar = new File(Globals.g_wizardData.getPreference("SASHome", "") + File.separator + "deploymntreg", "sas.tools.deploymntreg.jar");
            String taskName = null;
            if (deploymntRegJar.exists()) {
                RegistryAccess registryAccess = null;
                try {
                    RegistryData.setRegistry(Globals.g_wizardData.getPreference("SASHome", ""));
                    registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                    registryAccess.open();
                    for (ProductData product : Globals.g_cmtDeploymentData.getAllProducts("000000", true)) {
                        String prodCode = product.getProdCode().split("_")[0];
                        if (!product.getProdCode().endsWith("renewal") || !this.isProductInstalled(registryAccess, prodCode)) continue;
                        RenewalProduct data = new RenewalProduct(product, product.getProdCode());
                        if (PanelSelectLicensesToRenew.this.m_responseProducts != null) {
                            if (PanelSelectLicensesToRenew.this.m_responseProducts.containsKey(product.getProdCode().toLowerCase(Locale.ENGLISH))) {
                                data.setInstall(true);
                            } else {
                                data.setInstall(false);
                            }
                            if (product.getProdCode().equalsIgnoreCase("tklasr_renewal")) {
                                data.setInstallable(false);
                            } else {
                                data.setInstallable(true);
                            }
                            this.m_components.put(product.getProdCode(), data);
                            this.m_componentIds.add(product.getProdCode());
                        } else {
                            data.setInstall(this.hasSelected(product));
                            if (product.getProdCode().equalsIgnoreCase("tklasr_renewal")) {
                                data.setInstallable(false);
                            } else {
                                data.setInstallable(true);
                            }
                            this.m_components.put(product.getProdCode(), data);
                            this.m_componentIds.add(product.getProdCode());
                        }
                        taskName = PanelSelectLicensesToRenew.this.bundle.getString("PanelSelectLicensesToRenew." + product.getProdCode() + ".label.txt");
                        product.setProdName(taskName);
                        products.add(product);
                    }
                }
                catch (FileNotFoundException e) {
                    Logging.logStackTrace(e);
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
                registryAccess.close();
            }
            return products;
        }

        private boolean isProductInstalled(RegistryAccess registryAccess, String code) {
            String[] hosts = registryAccess.getInstallHosts();
            for (int h = 0; hosts != null && hosts.length > 0 && h < hosts.length; ++h) {
                String[] versions = registryAccess.getInstallVersions(code, hosts[h]);
                for (int i = 0; versions != null && versions.length > 0 && i < versions.length; ++i) {
                    File installDir;
                    String installLoc = registryAccess.getInstallLoc(code, versions[i], hosts[h]);
                    if (installLoc == null || !(installDir = new File(installLoc)).exists()) continue;
                    if (code.equals("base")) {
                        PanelSelectLicensesToRenew.this.m_isBaseInstalled = true;
                    }
                    if (code.equals("tklasr")) {
                        PanelSelectLicensesToRenew.this.m_isTklasrInstalled = true;
                    }
                    return true;
                }
            }
            return false;
        }
    }

    class RenewalProduct {
        protected ProductData m_renewalProduct = null;
        protected String m_renewalCode = null;
        protected boolean m_install = true;
        protected boolean m_installable = true;

        public RenewalProduct(ProductData renewalProduct, String renewalCode) {
            this.m_renewalProduct = renewalProduct;
            this.m_renewalCode = renewalCode;
        }

        public ProductData getRenewalProduct() {
            return this.m_renewalProduct;
        }

        public String getRenewalCode() {
            return this.m_renewalCode;
        }

        public boolean doInstall() {
            return this.m_install;
        }

        public void setInstall(boolean install) {
            this.m_install = install;
        }

        public boolean isInstallable() {
            return this.m_installable;
        }

        public void setInstallable(boolean installable) {
            this.m_installable = installable;
        }
    }

    class InstallColumnActionListener
    implements ActionListener {
        InstallColumnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PanelSelectLicensesToRenew.this.m_selectAllButton) {
                PanelSelectLicensesToRenew.this.m_componentTableModel.selectAllInstall(true);
            } else if (e.getSource() == PanelSelectLicensesToRenew.this.m_clearAllButton) {
                PanelSelectLicensesToRenew.this.m_componentTableModel.selectAllInstall(false);
            }
        }
    }

    private class ComponentDataCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -2422980246659985705L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
                this.setSelected(false);
                this.setEnabled(false);
            } else {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = PanelSelectLicensesToRenew.this.m_componentTableModel.getComponentIds().get(row);
                    RenewalProduct renewalProduct = PanelSelectLicensesToRenew.this.m_componentTableModel.getComponents().get(id);
                    this.setText(renewalProduct.getRenewalProduct().getProdName());
                    this.setSelected(renewalProduct.doInstall());
                    this.setEnabled(renewalProduct.isInstallable());
                }
            }
            return this;
        }
    }

    private class ComponentDataCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -1039755031254835968L;
        private JCheckBox m_checkBox;
        private RenewalProduct renewalProduct;

        public ComponentDataCellEditor(JCheckBox checkBox) {
            super(checkBox);
            this.m_checkBox = checkBox;
            this.m_checkBox.addItemListener(new CheckBoxListener());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                this.m_checkBox.setText("");
                this.m_checkBox.setSelected(false);
                this.m_checkBox.setEnabled(false);
            } else {
                if (isSelected) {
                    this.m_checkBox.setForeground(table.getSelectionForeground());
                    this.m_checkBox.setBackground(table.getSelectionBackground());
                } else {
                    this.m_checkBox.setForeground(table.getForeground());
                    this.m_checkBox.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = PanelSelectLicensesToRenew.this.m_componentTableModel.getComponentIds().get(row);
                    this.renewalProduct = PanelSelectLicensesToRenew.this.m_componentTableModel.getComponents().get(id);
                    this.m_checkBox.setText(this.renewalProduct.getRenewalProduct().getProdName());
                    this.m_checkBox.setSelected(this.renewalProduct.doInstall());
                    this.m_checkBox.setEnabled(this.renewalProduct.isInstallable());
                }
            }
            return this.m_checkBox;
        }

        class CheckBoxListener
        implements ItemListener {
            CheckBoxListener() {
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getSource() == ComponentDataCellEditor.this.m_checkBox) {
                    if (ComponentDataCellEditor.this.m_checkBox.isSelected() && ComponentDataCellEditor.this.renewalProduct.getRenewalProduct().getProdCode().equalsIgnoreCase("base_renewal")) {
                        if (PanelSelectLicensesToRenew.this.m_componentTableModel.getComponents().containsKey("tklasr_renewal")) {
                            PanelSelectLicensesToRenew.this.m_componentTableModel.getComponents().get("tklasr_renewal").setInstall(true);
                        }
                    } else if (!ComponentDataCellEditor.this.m_checkBox.isSelected() && ComponentDataCellEditor.this.renewalProduct.getRenewalProduct().getProdCode().equalsIgnoreCase("base_renewal") && PanelSelectLicensesToRenew.this.m_componentTableModel.getComponents().containsKey("tklasr_renewal")) {
                        PanelSelectLicensesToRenew.this.m_componentTableModel.getComponents().get("tklasr_renewal").setInstall(false);
                    }
                }
                PanelSelectLicensesToRenew.this.m_componentTableModel.fireTableDataChanged();
            }
        }
    }
}

