/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class PanelSelectLang
implements WizardPanelIface {
    private final SSNResource bundle = new SSNResource(PanelSelectLang.class);
    private final JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_info = null;
    private JTable m_langList = null;
    private JScrollPane m_listScrollPane = null;
    private LanguageTableModel m_langListModel = null;
    private ActionListener m_langActionListener = null;
    private final JPanel m_buttonPanel = new JPanel(new GridBagLayout());
    private JButton m_selectAllButton = null;
    private JButton m_clearAllButton = null;
    private boolean m_panelLoaded = false;
    private String m_previousProducts = "";
    private String m_previousSasinstallPlat = null;
    private final ArrayList<String> m_languageIds = new ArrayList();
    private final HashMap<String, LanguageData> m_languages = new HashMap();

    public PanelSelectLang() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSelectLang.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSelectLang.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = false;
        String selectedLangs = "";
        String id = null;
        LanguageData langData = null;
        for (int i = 0; i < this.m_languageIds.size(); ++i) {
            id = this.m_languageIds.get(i);
            langData = this.m_languages.get(id);
            if (langData == null || !langData.getInstall()) continue;
            valid = true;
            if (selectedLangs.length() > 0) {
                selectedLangs = selectedLangs + ",";
            }
            selectedLangs = selectedLangs + langData.getTwoByteCode();
            if (!langData.getTwoByteCode().equals("zt")) continue;
            selectedLangs = selectedLangs + ",zx";
        }
        if (valid) {
            Globals.g_selectedLanguages = selectedLangs;
        } else if (!Globals.g_quietMode) {
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelSelectLang.RequiredField.txt"), this.bundle.getString("Common.Warning.txt"), 2);
            this.m_langList.requestFocus();
        }
        return valid;
    }

    private boolean languagesToSelect() {
        if (Globals.g_selectedInstalls != null && !"mvs".equalsIgnoreCase(Utils.getOS_Suffix())) {
            for (int i = 0; i < Globals.g_selectedInstalls.length; ++i) {
                String OS_Suffix = Globals.g_selectedInstalls[i].getPlatform();
                SpsSkuData spsSkuData = Globals.g_deploymentData.getSpsSku(Globals.g_selectedInstalls[i].getSpsSku());
                ProductData[] productDataArray = Globals.g_deploymentData.getProductArray(Globals.g_order, spsSkuData.getProdCode(), OS_Suffix, false);
                if (!(productDataArray.length == 1 ? spsSkuData.getLanguages(OS_Suffix).length > 0 : productDataArray.length > 1)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean displayPanel() {
        boolean display = this.languagesToSelect();
        if (display && Globals.g_defaultLanguageSet) {
            this.loadLangInfo();
            String id = null;
            LanguageData langData = null;
            for (int i = 0; i < this.m_languageIds.size(); ++i) {
                id = this.m_languageIds.get(i);
                langData = this.m_languages.get(id);
                if (langData == null) continue;
                langData.setInstall(true);
            }
            display = !this.validateData();
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        return "selectlocale";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        String currentProducts = "";
        boolean bSasinstallPlatChanged = false;
        String m_productsWithLangSel = this.bundle.getString("PanelSelectLang.Info.txt");
        if (Globals.g_selectedInstalls != null && !"mvs".equalsIgnoreCase(Utils.getOS_Suffix())) {
            for (int i = 0; i < Globals.g_selectedInstalls.length; ++i) {
                String OS_Suffix = Globals.g_selectedInstalls[i].getPlatform();
                SpsSkuData spsSkuData = Globals.g_deploymentData.getSpsSku(Globals.g_selectedInstalls[i].getSpsSku());
                ProductData[] productDataArray = Globals.g_deploymentData.getProductArray(Globals.g_order, spsSkuData.getProdCode(), OS_Suffix, false);
                if (productDataArray.length == 1) {
                    if (spsSkuData.getLanguages(OS_Suffix).length <= 0) continue;
                    m_productsWithLangSel = m_productsWithLangSel + "\n\t" + Globals.g_selectedInstalls[i].getProdName();
                    if (currentProducts.length() > 0) {
                        currentProducts = currentProducts + ",";
                    }
                    currentProducts = currentProducts + Globals.g_selectedInstalls[i].getProdCode();
                    continue;
                }
                if (productDataArray.length <= 1) continue;
                m_productsWithLangSel = m_productsWithLangSel + "\n\t" + Globals.g_selectedInstalls[i].getProdName();
                if (currentProducts.length() > 0) {
                    currentProducts = currentProducts + ",";
                }
                currentProducts = currentProducts + Globals.g_selectedInstalls[i].getProdCode();
            }
        }
        if (this.m_panelLoaded) {
            bSasinstallPlatChanged = this.m_previousSasinstallPlat != null && Globals.g_sasinstallPlat != null ? false : this.m_previousSasinstallPlat != null || Globals.g_sasinstallPlat != null;
        }
        if (!currentProducts.equalsIgnoreCase(this.m_previousProducts) || bSasinstallPlatChanged) {
            this.loadLangInfo();
            if (!this.loadResponseData()) {
                String id = null;
                LanguageData langData = null;
                for (int i = 0; i < this.m_languageIds.size(); ++i) {
                    id = this.m_languageIds.get(i);
                    langData = this.m_languages.get(id);
                    if (langData == null) continue;
                    langData.setInstall(true);
                }
            }
            this.m_previousProducts = currentProducts;
            this.m_previousSasinstallPlat = Globals.g_sasinstallPlat;
        }
        if (!this.m_panelLoaded) {
            this.m_panelLoaded = true;
        }
        this.m_info.setText(m_productsWithLangSel);
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        this.loadLangInfo();
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#LANGUAGE_SELECTION=<comma delimited language codes>", " LANGUAGE_SELECTION="};
        if (this.m_panelLoaded) {
            String response = "";
            String id = null;
            LanguageData langData = null;
            for (int i = 0; i < this.m_languageIds.size(); ++i) {
                id = this.m_languageIds.get(i);
                langData = this.m_languages.get(id);
                if (langData == null || !langData.getInstall()) continue;
                if (response.length() > 0) {
                    response = response + ",";
                }
                response = response + langData.getTwoByteCode();
            }
            data[1] = " LANGUAGE_SELECTION=" + response;
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        ConsoleMode.SelectionItem[] options = new ConsoleMode.SelectionItem[this.m_languageIds.size()];
        String id = null;
        LanguageData data = null;
        for (int i = 0; i < options.length; ++i) {
            id = this.m_languageIds.get(i);
            data = this.m_languages.get(id);
            options[i] = new ConsoleMode.SelectionItem(data.getName(), data.getInstall(), !data.getSelectable());
        }
        int returnCode = ConsoleMode.promptMultiChoice(options, null);
        if (returnCode > -1) {
            for (int i = 0; i < options.length; ++i) {
                id = this.m_languageIds.get(i);
                data = this.m_languages.get(id);
                data.setInstall(options[i].getSelected());
            }
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("LANGUAGE_SELECTION", null);
        if (response != null) {
            String[] langCodes = response.split(",");
            LanguageData langData = null;
            for (int i = 0; i < langCodes.length; ++i) {
                langData = this.m_languages.get(langCodes[i]);
                if (langData == null) continue;
                valid = true;
                langData.setInstall(true);
            }
        }
        if (Globals.g_quietMode && !valid) {
            Wizard.logResponseMissing(this.getHeader(), "LANGUAGE_SELECTION");
        }
        return valid;
    }

    private void initialize() {
        this.m_info = new JTextArea(this.bundle.getString("PanelSelectLang.Info.txt"));
        this.m_info.setEditable(false);
        this.m_info.setFocusable(false);
        this.m_info.setLineWrap(true);
        this.m_info.setWrapStyleWord(true);
        this.m_info.setOpaque(false);
        this.m_langListModel = new LanguageTableModel();
        this.m_langList = new JTable(this.m_langListModel);
        this.m_langList.setCellSelectionEnabled(true);
        this.m_langList.setSelectionMode(0);
        this.m_langList.setTableHeader(null);
        this.m_langList.setShowGrid(false);
        this.m_langList.setOpaque(true);
        this.m_langList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelSelectLang.this.m_langList.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.m_listScrollPane = new JScrollPane(this.m_langList);
        this.m_listScrollPane.getViewport().setBackground(this.m_langList.getBackground());
        String mtxt = this.bundle.getString("Common.SelectAll.txt");
        String txt = Util.getLabelWithoutMnemonic(mtxt);
        int mkey = Util.getDisplayedMnemonic(mtxt);
        this.m_selectAllButton = new JButton(txt);
        this.m_selectAllButton.setMnemonic(mkey);
        mtxt = this.bundle.getString("Common.ClearAll.txt");
        txt = Util.getLabelWithoutMnemonic(mtxt);
        mkey = Util.getDisplayedMnemonic(mtxt);
        this.m_clearAllButton = new JButton(txt);
        this.m_clearAllButton.setMnemonic(mkey);
        this.m_langActionListener = new SelectClearActionListener();
        this.m_selectAllButton.addActionListener(this.m_langActionListener);
        this.m_clearAllButton.addActionListener(this.m_langActionListener);
        this.installRenderers();
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 18;
        c.gridy = 0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_info, c);
        c.gridy = 1;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_listScrollPane, c);
        this.initButtonPanel();
        c.gridy = 2;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_panel.add((Component)this.m_buttonPanel, c);
    }

    private void initButtonPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.gridx = 0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 5);
        this.m_buttonPanel.add((Component)this.m_selectAllButton, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_buttonPanel.add((Component)this.m_clearAllButton, c);
        if (this.m_selectAllButton.getPreferredSize().getWidth() < this.m_clearAllButton.getPreferredSize().getWidth()) {
            this.m_selectAllButton.setPreferredSize(this.m_clearAllButton.getPreferredSize());
        } else if (this.m_clearAllButton.getPreferredSize().getWidth() < this.m_selectAllButton.getPreferredSize().getWidth()) {
            this.m_clearAllButton.setPreferredSize(this.m_selectAllButton.getPreferredSize());
        }
    }

    private void loadLangInfo() {
        this.m_langListModel.load();
        int rowHeight = Utils.getPreferredRowHeight(this.m_langList);
        if (rowHeight > 0) {
            this.m_langList.setRowHeight(rowHeight);
        }
    }

    private void installRenderers() {
        this.m_langList.getColumnModel().getColumn(0).setCellRenderer(new LanguageCellRenderer());
        this.m_langList.getColumnModel().getColumn(0).setCellEditor(new LanguageCellEditor(new JCheckBox()));
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    class LanguageTableModel
    extends AbstractTableModel {
        public static final int LANGUAGE_COLUMN = 0;

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int index) {
            return null;
        }

        public Class getColumnClass(int index) {
            return Boolean.class;
        }

        @Override
        public int getRowCount() {
            return PanelSelectLang.this.m_languages.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String id = (String)PanelSelectLang.this.m_languageIds.get(rowIndex);
            boolean selected = false;
            if (id != null) {
                LanguageData langData = (LanguageData)PanelSelectLang.this.m_languages.get(id);
                selected = langData.getInstall();
            }
            return selected;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            String id = (String)PanelSelectLang.this.m_languageIds.get(rowIndex);
            if (id != null && value instanceof Boolean) {
                LanguageData langData = (LanguageData)PanelSelectLang.this.m_languages.get(id);
                langData.setInstall((Boolean)value);
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }

        public void load() {
            PanelSelectLang.this.m_languages.clear();
            PanelSelectLang.this.m_languageIds.clear();
            boolean selectable = false;
            SpsSkuData spsSkuData = null;
            SpsSkuData maintSkuData = null;
            ProductData[] maintData = null;
            String OS_Suffix = null;
            LanguageData tempLangData = null;
            HashSet<String> languagesForProduct = new HashSet<String>();
            block0: for (int i = 0; i < Globals.g_selectedInstalls.length; ++i) {
                languagesForProduct.clear();
                OS_Suffix = Globals.g_selectedInstalls[i].getPlatform();
                spsSkuData = Globals.g_deploymentData.getSpsSku(Globals.g_selectedInstalls[i].getSpsSku());
                ProductData[] productDataArray = Globals.g_deploymentData.getProductArray(Globals.g_order, spsSkuData.getProdCode(), OS_Suffix, false);
                if (productDataArray.length == 1) {
                    languagesForProduct.addAll(Arrays.asList(spsSkuData.getLanguages(OS_Suffix)));
                } else {
                    int j;
                    for (j = 0; j < productDataArray.length; ++j) {
                        spsSkuData = Globals.g_deploymentData.getSpsSku(productDataArray[j].getSpsSku());
                        languagesForProduct.add(spsSkuData.getLanguage());
                    }
                    spsSkuData = Globals.g_deploymentData.getSpsSku(Globals.g_selectedInstalls[i].getSpsSku());
                    maintData = Globals.g_deploymentData.getMaintenance(Globals.g_order, spsSkuData.getProdCode(), spsSkuData.getPlatform(), false);
                    for (j = 0; j < maintData.length; ++j) {
                        maintSkuData = Globals.g_deploymentData.getSpsSku(maintData[j].getSpsSku());
                        if (maintSkuData == null) continue;
                        languagesForProduct.add(maintSkuData.getLanguage());
                    }
                }
                for (String language : languagesForProduct) {
                    Vector<String> products;
                    selectable = true;
                    if ("en".equals(language) || "u8".equals(language) || "07".equals(language)) {
                        selectable = false;
                    } else if (spsSkuData != null) {
                        selectable = spsSkuData.isLanguageSelectable(OS_Suffix, language);
                    }
                    tempLangData = (LanguageData)PanelSelectLang.this.m_languages.get(language);
                    if (tempLangData != null) {
                        products = tempLangData.getProducts();
                        if (!products.contains(Globals.g_selectedInstalls[i].getProdCode())) {
                            products.add(Globals.g_selectedInstalls[i].getProdCode());
                        }
                        if (selectable) continue;
                        tempLangData.setSelectable(selectable);
                        continue;
                    }
                    products = new Vector();
                    products.add(Globals.g_selectedInstalls[i].getProdCode());
                    if (language.equals("zx")) continue block0;
                    PanelSelectLang.this.m_languageIds.add(language);
                    LanguageData langData = new LanguageData(language, "", PanelSelectLang.this.bundle.getString("Common.LangCode" + language.toUpperCase(Locale.ENGLISH) + ".txt"), products, selectable);
                    PanelSelectLang.this.m_languages.put(language, langData);
                }
            }
            String tempLangId = null;
            for (int i = PanelSelectLang.this.m_languageIds.size() - 1; i > 0; --i) {
                for (int j = 0; j < i; ++j) {
                    if (((LanguageData)PanelSelectLang.this.m_languages.get(PanelSelectLang.this.m_languageIds.get(j))).getName().compareTo(((LanguageData)PanelSelectLang.this.m_languages.get(PanelSelectLang.this.m_languageIds.get(j + 1))).getName()) <= 0) continue;
                    tempLangId = (String)PanelSelectLang.this.m_languageIds.get(j);
                    PanelSelectLang.this.m_languageIds.set(j, (String)PanelSelectLang.this.m_languageIds.get(j + 1));
                    PanelSelectLang.this.m_languageIds.set(j + 1, tempLangId);
                }
            }
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelSelectLang.this.installRenderers();
            PanelSelectLang.this.m_selectAllButton.setEnabled(PanelSelectLang.this.m_languages.size() > 0);
            PanelSelectLang.this.m_clearAllButton.setEnabled(PanelSelectLang.this.m_languages.size() > 0);
        }

        public void selectAll(boolean value) {
            String id = null;
            LanguageData langData = null;
            for (int i = 0; i < PanelSelectLang.this.m_languageIds.size(); ++i) {
                id = (String)PanelSelectLang.this.m_languageIds.get(i);
                langData = (LanguageData)PanelSelectLang.this.m_languages.get(id);
                if (langData == null || !langData.getSelectable()) continue;
                langData.setInstall(value);
            }
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelSelectLang.this.installRenderers();
        }

        public void clear() {
            PanelSelectLang.this.m_languages.clear();
            PanelSelectLang.this.m_languageIds.clear();
            this.fireTableDataChanged();
        }
    }

    class LanguageData {
        private String m_twoByteCode = null;
        private String m_threeByteCode = null;
        private String m_name = null;
        private Vector<String> m_products = new Vector();
        private boolean m_install = false;
        private boolean m_selectable = true;

        public LanguageData(String twoByteCode, String threeByteCode, String name, Vector<String> products, boolean selectable) {
            this.m_twoByteCode = twoByteCode;
            this.m_threeByteCode = threeByteCode;
            this.m_name = name;
            this.m_products = products;
            this.m_selectable = selectable;
        }

        public String getName() {
            return this.m_name;
        }

        public boolean getInstall() {
            return this.m_install;
        }

        public String getTwoByteCode() {
            return this.m_twoByteCode;
        }

        public String getThreeByteCode() {
            return this.m_threeByteCode;
        }

        public Vector<String> getProducts() {
            return this.m_products;
        }

        public boolean getSelectable() {
            return this.m_selectable;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public void setInstall(boolean install) {
            this.m_install = install;
        }

        public void setSelectable(boolean selectable) {
            this.m_selectable = selectable;
        }
    }

    class SelectClearActionListener
    implements ActionListener {
        SelectClearActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PanelSelectLang.this.m_selectAllButton) {
                PanelSelectLang.this.m_langListModel.selectAll(true);
            } else if (e.getSource() == PanelSelectLang.this.m_clearAllButton) {
                PanelSelectLang.this.m_langListModel.selectAll(false);
            }
        }
    }

    private class LanguageCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
                this.setSelected(false);
                this.setEnabled(false);
            } else {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = (String)PanelSelectLang.this.m_languageIds.get(row);
                    LanguageData langData = (LanguageData)PanelSelectLang.this.m_languages.get(id);
                    this.setText(langData.getName());
                    this.setSelected(langData.getInstall());
                    this.setEnabled(langData.getSelectable());
                }
            }
            return this;
        }
    }

    private class LanguageCellEditor
    extends DefaultCellEditor {
        private final JCheckBox m_checkBox;

        public LanguageCellEditor(JCheckBox checkBox) {
            super(checkBox);
            this.m_checkBox = checkBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                this.m_checkBox.setText("");
                this.m_checkBox.setSelected(false);
                this.m_checkBox.setEnabled(false);
            } else {
                if (isSelected) {
                    this.m_checkBox.setForeground(table.getSelectionForeground());
                    this.m_checkBox.setBackground(table.getSelectionBackground());
                } else {
                    this.m_checkBox.setForeground(table.getForeground());
                    this.m_checkBox.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = (String)PanelSelectLang.this.m_languageIds.get(row);
                    LanguageData langData = (LanguageData)PanelSelectLang.this.m_languages.get(id);
                    this.m_checkBox.setText(langData.getName());
                    this.m_checkBox.setSelected(langData.getInstall());
                    this.m_checkBox.setEnabled(langData.getSelectable());
                }
            }
            return this.m_checkBox;
        }
    }
}

