/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConfigureDefaults;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DynamicDialogs;
import com.sas.ssn.Globals;
import com.sas.ssn.InstanceData;
import com.sas.ssn.Language;
import com.sas.ssn.Logging;
import com.sas.ssn.MetadataAccess;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public abstract class PanelSelectInstances
implements WizardPanelIface {
    protected SSNResource bundle = new SSNResource(PanelSelectInstances.class);
    protected JPanel m_panel = new JPanel(new GridBagLayout());
    protected JLabel m_warningImage = null;
    protected JTextArea m_warningMessage = null;
    protected JTable m_instanceTable = null;
    protected InstanceTableModel m_instanceTableModel = null;
    protected ActionListener m_allColumnListener = null;
    protected JPanel m_buttonPanel = new JPanel(new GridBagLayout());
    protected JButton m_selectAllButton = null;
    protected JButton m_clearAllButton = null;
    protected boolean m_panelLoaded = false;
    protected int m_previousTask = -1;
    protected String m_previousConfigDir = "";
    protected String m_previousHost = "";
    protected String m_previousPort = "";
    protected String m_previousUser = "";
    protected HashMap m_responseInstances = null;
    protected InstanceData m_globalrootInstance = null;
    protected boolean m_oneSelected = false;
    protected boolean m_allSelected = true;
    public static final String COLUMN_ID_INSTANCE = "Instance";
    public static final String COLUMN_ID_TYPE = "Type";
    public static final String COLUMN_ID_CURRHOTFIX = "CurrHotFix";
    public static final String COLUMN_ID_FQID = "ID";
    public static final String COLUMN_ID_PRODCODE = "ProductCode";
    protected String[] m_columnNames = null;
    protected String m_consoleHeader = null;
    protected String[] m_implicitInstanceNames = null;
    protected Set<ProductData> m_implicitProductData = new HashSet<ProductData>();
    protected String m_configTargetList = null;

    public PanelSelectInstances() {
        String[] columns = this.getColumns();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 0; i < columns.length; ++i) {
            columnNames.add(this.getColumnName(columns[i]));
        }
        this.m_columnNames = columnNames.toArray(new String[0]);
        this.initialize();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    protected abstract String getSubClassName();

    protected abstract String[] getColumns();

    protected abstract String getConfigTargetListPropertyName();

    protected boolean includeProductsWithNoFQID() {
        return false;
    }

    protected boolean doSortNameAlphabetically() {
        return true;
    }

    protected boolean doShowDisabledRowsAtBottom() {
        return true;
    }

    protected String getConfigTargetList() {
        if (this.m_configTargetList == null) {
            this.m_configTargetList = Globals.g_configDefaults.getDefault(this.getConfigTargetListPropertyName(), "");
        }
        return this.m_configTargetList;
    }

    protected boolean isAvailTargetSupported(String prodCode) {
        return this.isAvailTargetSupported(prodCode, this.getConfigTargetList());
    }

    protected boolean isAvailTargetSupported(String prodCode, String configTargetList) {
        boolean supported = false;
        StringTokenizer configTargets = new StringTokenizer(configTargetList);
        while (configTargets.hasMoreTokens() && !supported) {
            String target = configTargets.nextToken();
            supported = Globals.g_configDefaults.getDefault(prodCode + "." + target + ".target.is_called", "FALSE").equalsIgnoreCase("TRUE");
        }
        return supported;
    }

    protected String getColumnID(int columnNum) {
        return this.getColumns()[columnNum];
    }

    protected Class<?> getColumnClassFromID(String columnID) {
        if (columnID.equalsIgnoreCase(COLUMN_ID_INSTANCE)) {
            return Boolean.class;
        }
        return String.class;
    }

    protected int getColumnNum(String columnID) {
        int ret = 0;
        String[] columns = this.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].equalsIgnoreCase(columnID)) continue;
            ret = i;
            break;
        }
        return ret;
    }

    protected String getColumnName(String columnID) {
        String ret = this.bundle.getRawStringNoWarning(this.getSubClassName() + ".Table." + columnID + "Column.Title.txt");
        if (ret == null) {
            ret = this.bundle.getString("PanelSelectInstances.Table." + columnID + "Column.Title.txt");
        }
        return ret;
    }

    @Override
    public String getHeader() {
        String header = this.bundle.getString(this.getSubClassName() + ".Header.txt");
        return header;
    }

    @Override
    public String getHeaderDesc() {
        String headerDesc = this.bundle.getString(this.getSubClassName() + ".HeaderDesc.txt");
        return headerDesc;
    }

    protected boolean isMandatoryOneSelected() {
        return true;
    }

    protected boolean isOneSelected() {
        return this.m_oneSelected;
    }

    protected void setOneSelected(boolean m_oneSelected) {
        this.m_oneSelected = m_oneSelected;
    }

    protected boolean isAllSelected() {
        return this.m_allSelected;
    }

    protected void setAllSelected(boolean m_allSelected) {
        this.m_allSelected = m_allSelected;
    }

    protected boolean validateTableData(TableData data) {
        return true;
    }

    protected String[] getImplicitInstanceNames() {
        if (this.m_implicitInstanceNames == null) {
            this.m_implicitInstanceNames = new String[]{"cfgwizard"};
        }
        return this.m_implicitInstanceNames;
    }

    protected boolean isImplicitInstance(String prodCode) {
        boolean ret = false;
        String[] implicitInstances = this.getImplicitInstanceNames();
        if (implicitInstances != null) {
            for (int i = 0; i < implicitInstances.length; ++i) {
                if (!implicitInstances[i].equalsIgnoreCase(prodCode)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        String[] ids = this.m_instanceTableModel.getIds();
        HashMap<String, TableData> instances = this.m_instanceTableModel.getInstances();
        TreeSet<ProductData> prodData = new TreeSet<ProductData>();
        String id = null;
        Object prodName = null;
        Object prodList = null;
        TableData data = null;
        for (int i = 0; i < ids.length && valid; ++i) {
            id = ids[i];
            data = instances.get(id);
            valid = this.validateTableData(data);
            if (!valid || !data.getSelected()) continue;
            prodData.add(data.getData());
        }
        this.setAllSelected(prodData.size() == ids.length);
        this.setOneSelected(prodData.size() > 0);
        if (valid && this.isMandatoryOneSelected() && !this.m_oneSelected) {
            valid = false;
            if (Globals.g_quietMode) {
                Logging.log.severe("At least one Product Configuration must be selected.\n   Panel: " + this.getHeader() + "\n   Field: " + "CONFIGURATION" + "#");
            } else {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelSelectInstances.NoProductsError.txt"), this.bundle.getString("Common.Warning.txt"), 2);
                this.m_instanceTable.requestFocus();
            }
        }
        if (valid) {
            DynamicDialogs.loadDialogDefaults(null, 0);
            prodData.addAll(this.m_implicitProductData);
            this.setSelectedInstances(prodData.toArray(new ProductData[0]));
        }
        return valid;
    }

    protected void setSelectedInstances(ProductData[] selectedInstances) {
        Globals.g_cmtTaskTargetList = this.getConfigTargetList();
        Globals.g_instances = selectedInstances;
    }

    public ProductData[] getSelectedInstances() {
        return Globals.g_instances;
    }

    @Override
    public boolean displayPanel() {
        boolean ret = true;
        if (this.loadData() && !this.displayIfNoInstances() && this.m_instanceTableModel.getIds().length < 1) {
            ret = false;
        }
        return ret;
    }

    @Override
    public String getNextPanelID() {
        return "execute";
    }

    protected boolean displayIfNoInstances() {
        return true;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        this.loadData();
    }

    protected boolean doPopulateData() {
        boolean ret = false;
        if (!(this.m_previousTask == Globals.g_cmtTask && this.m_previousConfigDir.equals(Globals.g_cmtConfigDir) && this.m_previousHost.equals(Globals.g_cmtConnectHost) && this.m_previousPort.equals(Globals.g_cmtConnectPort) && this.m_previousUser.equals(Globals.g_cmtConnectUser))) {
            this.m_previousTask = Globals.g_cmtTask;
            this.m_previousConfigDir = Globals.g_cmtConfigDir;
            this.m_previousHost = Globals.g_cmtConnectHost;
            this.m_previousPort = Globals.g_cmtConnectPort;
            this.m_previousUser = Globals.g_cmtConnectUser;
            ret = true;
        }
        return ret;
    }

    protected boolean loadData() {
        boolean valid = true;
        if (!this.m_panelLoaded) {
            valid = this.loadResponseData();
            this.m_panelLoaded = true;
        }
        if (valid) {
            boolean bl = valid = Globals.g_cmtConfigDir != null && Globals.g_cmtConnectHost != null && Globals.g_cmtConnectPort != null && Globals.g_cmtConnectUser != null;
            if (valid && this.doPopulateData()) {
                this.populate();
            }
        }
        return valid;
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_instanceTable;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            this.populate();
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        ArrayList<String> data = new ArrayList<String>();
        if (this.m_panelLoaded) {
            String[] ids = this.m_instanceTableModel.getIds();
            HashMap<String, TableData> instances = this.m_instanceTableModel.getInstances();
            TableData instanceData = null;
            int count = 0;
            for (int i = 0; i < ids.length; ++i) {
                instanceData = instances.get(ids[i]);
                if (!instanceData.getSelected()) continue;
                data.add(" CONFIGURATION" + Integer.toString(++count) + "=" + instanceData.getValue(COLUMN_ID_FQID));
            }
        }
        return data.toArray(new String[0]);
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    protected String getConsoleTableDataText(TableData tableData) {
        String[] columns = this.getColumns();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                sb.append("~");
            }
            sb.append(tableData.getValue(columns[i]));
        }
        return sb.toString();
    }

    protected String getConsoleHeader() {
        if (this.m_consoleHeader == null) {
            String[] columns = this.getColumns();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < columns.length; ++i) {
                if (i > 0) {
                    sb.append("~");
                }
                sb.append(this.getColumnName(columns[i]));
            }
            this.m_consoleHeader = sb.toString();
        }
        return this.m_consoleHeader;
    }

    @Override
    public int consoleEvent() {
        int returnCode;
        String[] ids = this.m_instanceTableModel.getIds();
        HashMap<String, TableData> instances = this.m_instanceTableModel.getInstances();
        TableData instanceData = null;
        String header = null;
        ConsoleMode.SelectionItem[] options = new ConsoleMode.SelectionItem[ids.length];
        for (int i = 0; i < options.length; ++i) {
            instanceData = instances.get(ids[i]);
            options[i] = new ConsoleMode.SelectionItem(this.getConsoleTableDataText(instanceData), instanceData.getSelected());
        }
        header = this.getConsoleHeader();
        if (this.m_warningMessage.isVisible()) {
            ConsoleMode.printInfoText(this.m_warningMessage.getText());
        }
        if ((returnCode = ConsoleMode.promptMultiChoice(options, header)) > -1) {
            for (int i = 0; i < options.length; ++i) {
                instanceData = instances.get(ids[i]);
                instanceData.setSelected(options[i].getSelected());
            }
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        this.m_responseInstances = null;
        boolean found = true;
        int productCount = 1;
        String responseInstance = null;
        while (found) {
            responseInstance = Wizard.getResponse("CONFIGURATION" + Integer.toString(productCount), null);
            if (responseInstance == null) {
                found = false;
            } else {
                if (this.m_responseInstances == null) {
                    this.m_responseInstances = new HashMap();
                }
                this.m_responseInstances.put(responseInstance.toLowerCase(Locale.ENGLISH), null);
            }
            ++productCount;
        }
        return valid;
    }

    private void initialize() {
        this.m_warningImage = new JLabel();
        this.m_warningImage.setIcon(this.bundle.getImageIcon("Common.warning_small.image"));
        this.m_warningMessage = new JTextArea();
        this.m_warningMessage.setEditable(false);
        this.m_warningMessage.setFocusable(false);
        this.m_warningMessage.setLineWrap(true);
        this.m_warningMessage.setWrapStyleWord(true);
        this.m_warningMessage.setOpaque(false);
        this.m_instanceTableModel = new InstanceTableModel();
        this.m_instanceTable = new JTable(this.m_instanceTableModel);
        this.m_instanceTable.setCellSelectionEnabled(true);
        this.m_instanceTable.setSelectionMode(0);
        this.m_instanceTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelSelectInstances.this.m_instanceTable.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        JScrollPane tablePane = new JScrollPane(this.m_instanceTable);
        String mtxt = this.bundle.getString("Common.SelectAll.txt");
        this.m_selectAllButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_selectAllButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_selectAllButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        mtxt = this.bundle.getString("Common.ClearAll.txt");
        this.m_clearAllButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_clearAllButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_clearAllButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_allColumnListener = new AllColumnActionListener();
        this.m_selectAllButton.addActionListener(this.m_allColumnListener);
        this.m_clearAllButton.addActionListener(this.m_allColumnListener);
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_warningImage, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(10, 5, 0, 0);
        this.m_panel.add((Component)this.m_warningMessage, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)tablePane, c);
        this.initButtonPanel();
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_panel.add((Component)this.m_buttonPanel, c);
    }

    private void initButtonPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.gridx = 0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 5);
        this.m_buttonPanel.add((Component)this.m_selectAllButton, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_buttonPanel.add((Component)this.m_clearAllButton, c);
        if (this.m_selectAllButton.getPreferredSize().getWidth() < this.m_clearAllButton.getPreferredSize().getWidth()) {
            this.m_selectAllButton.setPreferredSize(this.m_clearAllButton.getPreferredSize());
        } else if (this.m_clearAllButton.getPreferredSize().getWidth() < this.m_selectAllButton.getPreferredSize().getWidth()) {
            this.m_clearAllButton.setPreferredSize(this.m_selectAllButton.getPreferredSize());
        }
    }

    protected void installStringColumnRenderer(int columnIndex) {
        this.m_instanceTable.getColumnModel().getColumn(columnIndex).setCellRenderer(new StringCellRenderer());
        TableColumn column = this.m_instanceTable.getColumnModel().getColumn(columnIndex);
        int minWidth = Utils.getMinColumnWidth(this.m_instanceTable, columnIndex);
        int width = Utils.getPreferredColumnWidth(this.m_instanceTable, columnIndex);
        column.setMinWidth(minWidth);
        column.setPreferredWidth(width);
        column.setMaxWidth(width * 2);
    }

    protected void installRenderers() {
        this.m_instanceTable.getColumnModel().getColumn(this.getColumnNum(COLUMN_ID_INSTANCE)).setCellRenderer(new InstanceDataCellRenderer());
        this.m_instanceTable.getColumnModel().getColumn(this.getColumnNum(COLUMN_ID_INSTANCE)).setCellEditor(new InstanceDataCellEditor(new JCheckBox()));
        this.m_instanceTable.getTableHeader().setResizingAllowed(true);
        this.m_instanceTable.getTableHeader().setReorderingAllowed(false);
        for (int i = 1; i < this.m_instanceTable.getColumnCount(); ++i) {
            this.installStringColumnRenderer(i);
        }
    }

    @Override
    public String getHelpTopic() {
        return this.getSubClassName();
    }

    protected String[] getDependencies(String fqid) {
        ArrayList<String> dependencies = new ArrayList<String>();
        String[] dependents = MetadataAccess.getDependentComponents(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, fqid);
        TableData data = null;
        for (int i = 0; i < dependents.length; ++i) {
            data = this.m_instanceTableModel.getInstances().get(dependents[i]);
            if (data != null && data.getSelected()) continue;
            dependencies.add(dependents[i]);
        }
        return dependencies.toArray(new String[0]);
    }

    protected void populate() {
        this.m_instanceTableModel.load();
        int rowHeight = Utils.getPreferredRowHeight(this.m_instanceTable);
        if (rowHeight > 0) {
            this.m_instanceTable.setRowHeight(rowHeight);
        }
        if (this.displayIfNoInstances() && this.m_instanceTableModel.getEnabledIds().length < 1) {
            this.m_warningMessage.setText(this.bundle.getString(this.getSubClassName() + ".WarningMessage.txt"));
            this.m_warningImage.setVisible(true);
            this.m_warningMessage.setVisible(true);
        } else {
            this.m_warningImage.setVisible(false);
            this.m_warningMessage.setVisible(false);
        }
    }

    protected String loadNameForInstance(InstanceData data, String currentName) {
        return currentName;
    }

    protected TableData loadTableData(String name, InstanceData instanceData, ProductData productData) {
        return new TableData(instanceData.getFQID(), instanceData.getCode(), name, productData.getProdName(), instanceData.getHotFix(), productData);
    }

    class InstanceTableModel
    extends AbstractTableModel {
        private String[] m_ids = null;
        private String[] m_enabled_ids = null;
        private String[] m_disabled_ids = null;
        private HashMap<String, TableData> m_instances = new HashMap();

        @Override
        public int getColumnCount() {
            return PanelSelectInstances.this.m_columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return PanelSelectInstances.this.m_columnNames[index];
        }

        @Override
        public Class<?> getColumnClass(int index) {
            return PanelSelectInstances.this.getColumnClassFromID(PanelSelectInstances.this.getColumnID(index));
        }

        @Override
        public int getRowCount() {
            return this.m_instances.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int colIndex) {
            Object value = null;
            String id = null;
            if (rowIndex < this.m_ids.length) {
                id = this.m_ids[rowIndex];
            }
            if (id != null) {
                TableData data = this.m_instances.get(id);
                String columnID = PanelSelectInstances.this.getColumnID(colIndex);
                value = columnID.equalsIgnoreCase(PanelSelectInstances.COLUMN_ID_INSTANCE) ? Boolean.valueOf(data.getSelected()) : data.getValue(columnID);
            }
            return value;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int colIndex) {
            boolean editable = false;
            if (rowIndex < this.m_ids.length) {
                String columnID = PanelSelectInstances.this.getColumnID(colIndex);
                editable = columnID.equalsIgnoreCase(PanelSelectInstances.COLUMN_ID_INSTANCE);
            }
            if (editable) {
                String id = null;
                if (rowIndex < this.m_ids.length) {
                    id = this.m_ids[rowIndex];
                }
                if (id != null) {
                    TableData data = this.m_instances.get(id);
                    editable = data.getEnabled();
                }
            }
            return editable;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int colIndex) {
            String id = null;
            if (rowIndex < this.m_ids.length) {
                id = this.m_ids[rowIndex];
            }
            String columnID = PanelSelectInstances.this.getColumnID(colIndex);
            if (id != null && value instanceof Boolean && columnID.equalsIgnoreCase(PanelSelectInstances.COLUMN_ID_INSTANCE)) {
                TableData data = this.m_instances.get(id);
                data.setSelected((Boolean)value);
                this.fireTableCellUpdated(rowIndex, colIndex);
            }
        }

        public void load() {
            int i;
            this.m_instances.clear();
            PanelSelectInstances.this.m_implicitProductData.clear();
            Globals.g_levdirrootFQID = null;
            File statusFile = new File(Utils.joinPath(Globals.g_cmtConfigDir, "ConfigData", "status.xml"));
            InstanceData[] instanceData = MetadataAccess.getInstanceData(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, statusFile, PanelSelectInstances.this.includeProductsWithNoFQID());
            if (Globals.g_configDefaults == null) {
                Globals.g_configDefaults = new ConfigureDefaults();
            }
            DynamicDialogs.loadProductDefaults("cfgwizard", null, Language.gs_SelectedLanguage, 0);
            boolean supported = false;
            Object target = null;
            String fqid = null;
            String code = null;
            String order = null;
            String hotfix = null;
            String hotfixdate = null;
            String ucCode = null;
            String name = null;
            String type = null;
            ProductData[] prodData = null;
            String[] codeList = new String[1];
            TableData data = null;
            TreeSet<TableData> sortedTableData = new TreeSet<TableData>();
            ArrayList<String> prodList = new ArrayList<String>();
            ArrayList<ProductData> defaultSelection = new ArrayList<ProductData>();
            String deprecatedProductList = Globals.g_configDefaults.getDefault("cfgwizard.deprecated.12byte.list", "");
            Logging.log.info("The following will be excluded from product selection table because they have been marked as deprecated by the cfgwizard.deprecated.12byte.list property: " + deprecatedProductList);
            StringTokenizer deprecatedProductTokenizer = new StringTokenizer(deprecatedProductList);
            ArrayList<String> deprecatedProductArrayList = new ArrayList<String>();
            while (deprecatedProductTokenizer.hasMoreTokens()) {
                String deprecatedProduct = deprecatedProductTokenizer.nextToken();
                Logging.log.finer("Adding product " + deprecatedProduct + " to list of deprecated products");
                deprecatedProductArrayList.add(deprecatedProduct.toLowerCase());
            }
            for (i = 0; i < instanceData.length; ++i) {
                code = instanceData[i].getCode();
                order = instanceData[i].getOrder();
                hotfix = instanceData[i].getHotFix();
                hotfixdate = instanceData[i].getHotFixDate();
                DynamicDialogs.loadProductDefaults(order, code, null, Language.gs_SelectedLanguage, 0);
                if (code.equalsIgnoreCase("weblogic")) {
                    Globals.g_configDefaults.setDefault("weblogic.buildUnifiedPolicy.target.is_called", "FALSE");
                }
                supported = deprecatedProductArrayList.contains(code.toLowerCase()) && Globals.g_cmtTask != 2 ? false : PanelSelectInstances.this.isAvailTargetSupported(code);
                if (!code.equalsIgnoreCase("levconfig") && !code.equalsIgnoreCase("cfgwizard")) {
                    fqid = instanceData[i].getFQID();
                    name = MetadataAccess.getObjectName(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, fqid);
                    if (code.equalsIgnoreCase("globalroot")) {
                        PanelSelectInstances.this.m_globalrootInstance = instanceData[i];
                    } else if (code.equalsIgnoreCase("levdirroot")) {
                        Globals.g_levdirrootFQID = fqid;
                        Globals.g_levdirrootProps = instanceData[i].getProperties();
                    }
                    name = PanelSelectInstances.this.loadNameForInstance(instanceData[i], name);
                    codeList[0] = code;
                    if (PanelSelectInstances.this.isImplicitInstance(code)) {
                        prodData = Globals.g_deploymentData.getConfigured(order, codeList, true);
                        if (prodData != null && prodData.length == 1) {
                            prodData[0].setInstanceData(instanceData[i]);
                            PanelSelectInstances.this.m_implicitProductData.add(prodData[0]);
                        }
                    } else if (supported && (prodData = Globals.g_deploymentData.getConfigured(order, codeList, true)) != null && prodData.length == 1) {
                        prodData[0].setInstanceData(instanceData[i]);
                        prodData[0].setOrder(order);
                        type = prodData[0].getProdName();
                        data = PanelSelectInstances.this.loadTableData(name, instanceData[i], prodData[0]);
                        if (data != null) {
                            if (PanelSelectInstances.this.m_responseInstances != null && PanelSelectInstances.this.m_responseInstances.containsKey(fqid.toLowerCase(Locale.ENGLISH))) {
                                data.setSelected(true);
                            }
                            sortedTableData.add(data);
                            this.m_instances.put(fqid, data);
                            if (data.getSelected()) {
                                defaultSelection.add(data.getData());
                            }
                        }
                    }
                }
                if (prodList.contains(ucCode = code.toUpperCase(Locale.ENGLISH))) continue;
                prodList.add(ucCode);
            }
            if (PanelSelectInstances.this.isImplicitInstance("cfgwizard")) {
                codeList[0] = "cfgwizard";
                prodData = Globals.g_deploymentData.getConfigured(Globals.g_order, codeList, true);
                if (prodData != null && prodData.length == 1) {
                    prodData[0].setInstanceData(PanelSelectInstances.this.m_globalrootInstance);
                    PanelSelectInstances.this.m_implicitProductData.add(prodData[0]);
                }
            }
            Globals.g_cmtMachineAll = "";
            for (i = 0; i < prodList.size(); ++i) {
                if (i > 0) {
                    Globals.g_cmtMachineAll = Globals.g_cmtMachineAll + " ";
                }
                Globals.g_cmtMachineAll = Globals.g_cmtMachineAll + prodList.get(i);
            }
            this.m_ids = new String[sortedTableData.size()];
            int count = 0;
            for (TableData tableData : sortedTableData) {
                this.m_ids[count++] = tableData.getValue(PanelSelectInstances.COLUMN_ID_FQID);
            }
            if (PanelSelectInstances.this.doSortNameAlphabetically()) {
                int swapPos = 0;
                String swapFQID = null;
                String swapName = null;
                TableData swapData = null;
                for (int i2 = 0; i2 < this.m_ids.length; ++i2) {
                    swapPos = i2;
                    fqid = this.m_ids[i2];
                    data = this.m_instances.get(fqid);
                    name = data.getName().toLowerCase(Locale.ENGLISH);
                    for (int j = i2 + 1; j < this.m_ids.length; ++j) {
                        swapFQID = this.m_ids[j];
                        swapData = this.m_instances.get(swapFQID);
                        swapName = swapData.getName().toLowerCase(Locale.ENGLISH);
                        if (swapName.compareTo(name) >= 0) continue;
                        name = swapName;
                        swapPos = j;
                    }
                    if (i2 == swapPos) continue;
                    this.m_ids[i2] = this.m_ids[swapPos];
                    this.m_ids[swapPos] = fqid;
                }
            }
            ArrayList<String> enabledFQIDs = new ArrayList<String>();
            ArrayList<String> disabledFQIDs = new ArrayList<String>();
            for (int i3 = 0; i3 < this.m_ids.length; ++i3) {
                fqid = this.m_ids[i3];
                TableData tableData = this.m_instances.get(fqid);
                if (tableData.getEnabled()) {
                    enabledFQIDs.add(fqid);
                    continue;
                }
                disabledFQIDs.add(fqid);
            }
            this.m_enabled_ids = new String[enabledFQIDs.size()];
            this.m_enabled_ids = enabledFQIDs.toArray(this.m_enabled_ids);
            this.m_disabled_ids = new String[disabledFQIDs.size()];
            this.m_disabled_ids = disabledFQIDs.toArray(this.m_disabled_ids);
            if (PanelSelectInstances.this.doShowDisabledRowsAtBottom()) {
                ArrayList<String> tempFQIDs = new ArrayList<String>();
                tempFQIDs.addAll(enabledFQIDs);
                tempFQIDs.addAll(disabledFQIDs);
                this.m_ids = tempFQIDs.toArray(this.m_ids);
            }
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelSelectInstances.this.installRenderers();
            PanelSelectInstances.this.m_selectAllButton.setEnabled(this.m_enabled_ids.length > 0);
            PanelSelectInstances.this.m_clearAllButton.setEnabled(this.m_enabled_ids.length > 0);
            defaultSelection.addAll(PanelSelectInstances.this.m_implicitProductData);
            PanelSelectInstances.this.setSelectedInstances(defaultSelection.toArray(new ProductData[0]));
        }

        public void selectAll(boolean value) {
            String id = null;
            TableData data = null;
            for (int i = 0; i < this.m_enabled_ids.length; ++i) {
                id = this.m_enabled_ids[i];
                data = this.m_instances.get(id);
                if (data == null || !data.getEnabled()) continue;
                data.setSelected(value);
            }
            this.fireTableDataChanged();
        }

        public String[] getIds() {
            return this.m_ids;
        }

        public String[] getEnabledIds() {
            return this.m_enabled_ids;
        }

        public String[] getDisabledIds() {
            return this.m_disabled_ids;
        }

        public HashMap<String, TableData> getInstances() {
            return this.m_instances;
        }
    }

    class TableData
    implements Comparable<TableData> {
        private boolean m_enabled = true;
        private boolean m_selected = false;
        private HashMap<String, String> values = new HashMap();
        private ProductData m_data = null;

        public TableData(String id, String code, String name, String type, String currhotfix, ProductData data) {
            this.m_data = data;
            if (name != null && name.length() > 0) {
                this.values.put(PanelSelectInstances.COLUMN_ID_INSTANCE, name);
            } else {
                this.values.put(PanelSelectInstances.COLUMN_ID_INSTANCE, type);
            }
            this.values.put(PanelSelectInstances.COLUMN_ID_FQID, id);
            this.values.put(PanelSelectInstances.COLUMN_ID_PRODCODE, code);
            this.values.put(PanelSelectInstances.COLUMN_ID_TYPE, type);
            if (currhotfix == null || currhotfix.isEmpty()) {
                String noneConfiguredTxt = PanelSelectInstances.this.bundle.getString("PanelSelectInstances.NoneConfigured.txt");
                this.values.put(PanelSelectInstances.COLUMN_ID_CURRHOTFIX, noneConfiguredTxt);
            } else {
                this.values.put(PanelSelectInstances.COLUMN_ID_CURRHOTFIX, currhotfix);
            }
        }

        public void setValue(String columnID, String value) {
            this.values.put(columnID, value);
        }

        public String getValue(String columnID) {
            return this.values.get(columnID);
        }

        public String getName() {
            return this.getValue(PanelSelectInstances.COLUMN_ID_INSTANCE);
        }

        public ProductData getData() {
            return this.m_data;
        }

        public boolean getSelected() {
            return this.m_selected;
        }

        public void setSelected(boolean selected) {
            this.m_selected = selected;
        }

        public boolean getEnabled() {
            return this.m_enabled;
        }

        public void setEnabled(boolean enabled) {
            this.m_enabled = enabled;
        }

        @Override
        public int compareTo(TableData o) {
            int ret = 0;
            if (o != null) {
                ProductData thisData = this.getData();
                ProductData otherData = o.getData();
                if (thisData != null && otherData != null) {
                    ret = thisData.compareTo(otherData);
                } else {
                    String thisName = this.getName();
                    String otherName = o.getName();
                    ret = thisName.compareTo(otherName);
                }
            }
            return ret;
        }
    }

    class AllColumnActionListener
    implements ActionListener {
        AllColumnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PanelSelectInstances.this.m_selectAllButton) {
                PanelSelectInstances.this.m_instanceTableModel.selectAll(true);
            } else if (e.getSource() == PanelSelectInstances.this.m_clearAllButton) {
                PanelSelectInstances.this.m_instanceTableModel.selectAll(false);
            }
        }
    }

    private class StringCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 3127519601877967486L;

        private StringCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
            } else {
                this.setText(value.toString());
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                String id = PanelSelectInstances.this.m_instanceTableModel.getIds()[row];
                TableData data = PanelSelectInstances.this.m_instanceTableModel.getInstances().get(id);
                this.setEnabled(data.getEnabled());
            }
            return this;
        }
    }

    private class InstanceDataCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -2527480163730862531L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
                this.setSelected(false);
                this.setEnabled(false);
            } else {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = PanelSelectInstances.this.m_instanceTableModel.getIds()[row];
                    TableData data = PanelSelectInstances.this.m_instanceTableModel.getInstances().get(id);
                    this.setText(data.getName());
                    this.setSelected(data.getSelected());
                    this.setEnabled(data.getEnabled());
                }
            }
            return this;
        }
    }

    private class InstanceDataCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 7239401213575970316L;
        private JCheckBox m_checkBox;

        public InstanceDataCellEditor(JCheckBox checkBox) {
            super(checkBox);
            this.m_checkBox = null;
            this.m_checkBox = checkBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                this.m_checkBox.setText("");
                this.m_checkBox.setSelected(false);
                this.m_checkBox.setEnabled(false);
            } else {
                if (isSelected) {
                    this.m_checkBox.setForeground(table.getSelectionForeground());
                    this.m_checkBox.setBackground(table.getSelectionBackground());
                } else {
                    this.m_checkBox.setForeground(table.getForeground());
                    this.m_checkBox.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = PanelSelectInstances.this.m_instanceTableModel.getIds()[row];
                    TableData data = PanelSelectInstances.this.m_instanceTableModel.getInstances().get(id);
                    this.m_checkBox.setText(data.getName());
                    this.m_checkBox.setSelected(data.getSelected());
                    this.m_checkBox.setEnabled(data.getEnabled());
                }
            }
            return this.m_checkBox;
        }
    }
}

