/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConfigStatus;
import com.sas.ssn.DynamicDialogs;
import com.sas.ssn.Globals;
import com.sas.ssn.HotFixesWithConfiguration;
import com.sas.ssn.InstanceData;
import com.sas.ssn.Language;
import com.sas.ssn.Logging;
import com.sas.ssn.PanelSelectInstances;
import com.sas.ssn.ProductData;
import java.util.ArrayList;
import java.util.Map;

public class PanelSelectHotFixInstances
extends PanelSelectInstances {
    public static final String COLUMN_ID_NEWHOTFIX = "NewHotFix";
    public static final String COLUMN_ID_STATUS = "Status";
    protected String[] m_columns = null;
    protected String m_previousPackageDir = "";
    protected HotFixesWithConfiguration m_hfwithconfig = null;

    @Override
    protected String getSubClassName() {
        return PanelSelectHotFixInstances.class.getSimpleName();
    }

    @Override
    public boolean displayPanel() {
        boolean ret = super.displayPanel();
        return ret;
    }

    @Override
    protected String[] getColumns() {
        if (this.m_columns == null) {
            this.m_columns = Globals.g_debug ? new String[]{"Instance", "Type", "CurrHotFix", COLUMN_ID_NEWHOTFIX, COLUMN_ID_STATUS, "ID"} : new String[]{"Instance", "Type", "CurrHotFix", COLUMN_ID_NEWHOTFIX, COLUMN_ID_STATUS};
        }
        return this.m_columns;
    }

    @Override
    protected String getConfigTargetListPropertyName() {
        return "cfgwizard.hotFixConfigure.target.list";
    }

    protected void setHotFixesWithConfiguration(HotFixesWithConfiguration hfwithconfig) {
        this.m_hfwithconfig = hfwithconfig;
        Map<String, String> configurableHotFixes = this.m_hfwithconfig.getNewestHotFixIds();
        if (configurableHotFixes.isEmpty()) {
            Logging.log.info("There are no hot fixes available for configuration");
        } else {
            StringBuffer hotFixLogEntries = new StringBuffer();
            hotFixLogEntries.append("Below is a list of hot fixes that are available for configuration:\n");
            for (String product : configurableHotFixes.keySet()) {
                hotFixLogEntries.append("* Hot fix ");
                hotFixLogEntries.append(configurableHotFixes.get(product));
                hotFixLogEntries.append(" for ");
                hotFixLogEntries.append(product);
                hotFixLogEntries.append("\n");
            }
            Logging.log.info(hotFixLogEntries.toString());
        }
    }

    protected HotFixesWithConfiguration getHotFixesWithConfiguration() {
        return this.m_hfwithconfig;
    }

    @Override
    protected boolean doPopulateData() {
        boolean ret = super.doPopulateData();
        if (!ret) {
            if (Globals.g_cmtRunInstall) {
                if (this.m_previousPackageDir.equals("") || !this.m_previousPackageDir.equals(Globals.g_hotFixPackageDir)) {
                    this.m_previousPackageDir = Globals.g_hotFixPackageDir;
                    ret = true;
                }
            } else if (this.m_previousPackageDir.length() > 0) {
                this.m_previousPackageDir = "";
                ret = true;
            }
        }
        if (ret) {
            this.setHotFixesWithConfiguration(new HotFixesWithConfiguration());
        }
        return ret;
    }

    @Override
    public boolean validateData() {
        boolean ret = super.validateData();
        if (ret && Globals.g_configStatus == null) {
            try {
                Globals.g_configStatus = ConfigStatus.loadDefaultConfigStatus();
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
        return ret;
    }

    @Override
    protected boolean isAvailTargetSupported(String prodCode) {
        return true;
    }

    @Override
    protected PanelSelectInstances.TableData loadTableData(String name, InstanceData instanceData, ProductData productData) {
        PanelSelectInstances.TableData ret = super.loadTableData(name, instanceData, productData);
        if (ret != null) {
            String currHotFix = ret.getValue("CurrHotFix");
            String latestHotFix = this.getHotFixesWithConfiguration().getNewestHotFixId(productData.getProdCode());
            if (latestHotFix == null) {
                String notApplicableTxt = this.bundle.getString("PanelSelectHotFixInstances.NotApplicable.txt");
                ret.setValue("CurrHotFix", notApplicableTxt);
                ret.setValue(COLUMN_ID_NEWHOTFIX, notApplicableTxt);
                ret.setValue(COLUMN_ID_STATUS, notApplicableTxt);
                ret.setSelected(false);
                ret.setEnabled(false);
            } else {
                instanceData.setNewerHotFix(latestHotFix);
                productData.setType(5);
                if (!latestHotFix.equalsIgnoreCase(currHotFix)) {
                    ret.setValue(COLUMN_ID_NEWHOTFIX, latestHotFix);
                    ret.setValue(COLUMN_ID_STATUS, this.bundle.getString("PanelSelectHotFixInstances.ReadyToConfigure.txt"));
                    ret.setSelected(true);
                } else {
                    ret.setValue(COLUMN_ID_NEWHOTFIX, this.bundle.getString("PanelSelectHotFixInstances.NotApplicable.txt"));
                    ret.setValue(COLUMN_ID_STATUS, this.bundle.getString("PanelSelectHotFixInstances.UpToDate.txt"));
                    ret.setSelected(false);
                }
            }
        }
        return ret;
    }

    @Override
    protected void setSelectedInstances(ProductData[] selectedInstances) {
        Globals.g_selectedHotFixesToConfig = selectedInstances;
        String configTargetList = Globals.g_configDefaults.getDefault("cfgwizard.buildWebapps.target.list", "");
        if (configTargetList.length() == 0) {
            DynamicDialogs.loadProductDefaults("cfgwizard", null, Language.gs_SelectedLanguage, 0);
            configTargetList = Globals.g_configDefaults.getDefault("cfgwizard.buildWebapps.target.list", "");
        }
        ArrayList<ProductData> selectedWebApps = new ArrayList<ProductData>();
        for (int i = 0; i < selectedInstances.length; ++i) {
            ProductData productData = selectedInstances[i];
            productData.setType(5);
            String prodCode = productData.getProdCode();
            if (!this.isAvailTargetSupported(prodCode, configTargetList)) continue;
            selectedWebApps.add(productData);
        }
        Globals.g_selectedHotFixesWithWebApps = selectedWebApps.toArray(new ProductData[0]);
    }

    @Override
    public ProductData[] getSelectedInstances() {
        return Globals.g_selectedHotFixesToConfig;
    }

    @Override
    public String getNextPanelID() {
        if (Globals.g_cmtRunInstall || Globals.g_selectedHotFixesToConfig != null && Globals.g_selectedHotFixesToConfig.length > 0) {
            if (Globals.g_selectedHotFixesWithWebApps != null && Globals.g_selectedHotFixesWithWebApps.length > 0) {
                return "selecthotfixdeploywebappinstances";
            }
            return "execute";
        }
        return "finish";
    }

    @Override
    protected String[] getImplicitInstanceNames() {
        return null;
    }

    @Override
    protected boolean isMandatoryOneSelected() {
        return false;
    }

    @Override
    protected boolean doSortNameAlphabetically() {
        return false;
    }

    @Override
    public void backEvent(String backPanelID) {
        this.m_previousPackageDir = "";
    }
}

