/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DynamicDialogs;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.UnicodeInputStream;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PanelSelectHost
implements WizardPanelIface,
ActionListener {
    private SSNResource bundle = new SSNResource(PanelSelectHost.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JLabel m_hostLabel = null;
    private JComboBox m_hostCombo = null;
    private JLabel m_infoLabel = null;
    private JEditorPane m_hostInfo = null;
    private JScrollPane m_scrollPane = null;
    private boolean m_panelLoaded = false;
    private String m_selectedMachine = null;

    public PanelSelectHost() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSelectHost.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSelectHost.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        String smuMachine;
        boolean valid = true;
        String errMsg = null;
        Globals.g_smuMachine = smuMachine = (String)this.m_hostCombo.getSelectedItem();
        Globals.g_configData.setProperty("config.migration.package.tier.dir", Utils.joinPath(Globals.g_configData.getProperty("config.migration.smu.file", ""), smuMachine));
        valid = Utils.validateSMUTierExecution(Globals.g_configData.getProperty("config.migration.package.tier.dir", null));
        if (!valid) {
            errMsg = this.bundle.messageString("PanelMigrate.SMUTierIsAnalyzeOnly.txt", Globals.g_smuMachine);
        }
        if (!valid && !Globals.g_quietMode) {
            if (errMsg != null) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
            }
            this.m_hostCombo.requestFocus();
        }
        if (valid && Globals.g_migrationSchema.hasNewTiers()) {
            Globals.g_migrationSchema.deleteNewTiers();
        }
        Globals.g_migrationSchema.addNewTier(Globals.g_smuMachine);
        if (!Globals.g_migrationSchema.originalTierHasPorts(Globals.g_smuMachine)) {
            DynamicDialogs.loadConfigDialogs();
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = Globals.g_smuMachine != null && Globals.g_migrationSchema.originalTierHasPorts(Globals.g_smuMachine) ? "portremap" : (Globals.g_dynamicConfigDialogs != null && Globals.g_dynamicConfigDialogs.length > 0 ? Globals.g_dynamicConfigDialogs[0] : "execute");
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
        this.loadComboBox();
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.loadComboBox();
        }
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        if (Globals.g_quietMode && Globals.g_recordMode) {
            return null;
        }
        String[] data = new String[]{"#MIGRATION_MACHINE=<machine name>", " MIGRATION_MACHINE="};
        if (this.m_panelLoaded) {
            data[1] = " MIGRATION_MACHINE=" + (String)this.m_hostCombo.getSelectedItem();
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int returnCode = ConsoleMode.promptComboBox(this.m_hostCombo);
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        String response = Wizard.getResponse("MIGRATION_MACHINE", null);
        if (response != null) {
            this.m_selectedMachine = response;
        } else if (Globals.g_quietMode) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "PERFORM_MIGRATION");
        }
        return valid;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_hostCombo) {
            this.updateTextArea();
        }
    }

    private void initialize() {
        this.m_hostCombo = new JComboBox();
        String mtxt = this.bundle.getString("PanelSelectHost.Machine.txt");
        this.m_hostLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_hostLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_hostLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_hostLabel.setLabelFor(this.m_hostCombo);
        this.m_hostInfo = new JEditorPane();
        this.m_hostInfo.setOpaque(false);
        this.m_hostInfo.setEditable(false);
        this.m_hostInfo.setContentType("text/html");
        this.m_scrollPane = new JScrollPane(this.m_hostInfo);
        mtxt = this.bundle.getString("PanelSelectHost.Info.txt");
        this.m_infoLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_infoLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_infoLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_infoLabel.setLabelFor(this.m_hostInfo);
        this.m_hostCombo.addActionListener(this);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 17;
        c.gridy = 0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_hostLabel, c);
        c.gridy = 1;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_hostCombo, c);
        c.gridy = 2;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_infoLabel, c);
        c.gridy = 3;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_scrollPane, c);
    }

    private boolean loadComboBox() {
        boolean found = false;
        int selectedIndex = 0;
        if (this.m_hostCombo.getItemCount() > 0) {
            this.m_selectedMachine = (String)this.m_hostCombo.getSelectedItem();
        }
        this.m_hostCombo.removeAllItems();
        if (Globals.g_smuMachines != null) {
            for (int i = 0; i < Globals.g_smuMachines.length; ++i) {
                if (this.m_selectedMachine != null && Globals.g_smuMachines[i].equalsIgnoreCase(this.m_selectedMachine)) {
                    found = true;
                    selectedIndex = i;
                }
                this.m_hostCombo.addItem(Globals.g_smuMachines[i]);
            }
        }
        if (this.m_hostCombo.getItemCount() > 0) {
            this.m_hostCombo.setSelectedIndex(selectedIndex);
        }
        return found;
    }

    private void updateTextArea() {
        File schema;
        String detailText = "<html><ol>";
        String smuMachine = (String)this.m_hostCombo.getSelectedItem();
        if (smuMachine != null && (schema = new File(Utils.joinPath(Globals.g_configData.getProperty("config.migration.smu.file", ""), "migration-schemas"), "template.xml")).isFile()) {
            try {
                int i;
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(schema));
                Element root = doc.getDocumentElement();
                Element nodeElement = null;
                String prodCode = null;
                ProductData prodData = null;
                NodeList tiers = root.getElementsByTagName("tier");
                NodeList products = null;
                for (i = 0; i < tiers.getLength(); ++i) {
                    Element node = (Element)tiers.item(i);
                    if (!node.getAttribute("name").equalsIgnoreCase(smuMachine)) continue;
                    products = node.getElementsByTagName("product");
                }
                for (i = 0; i < products.getLength(); ++i) {
                    nodeElement = (Element)products.item(i);
                    prodCode = nodeElement.getAttribute("id");
                    if (prodCode == null) continue;
                    prodData = Globals.g_deploymentData.getProduct(Globals.g_order, prodCode.toLowerCase(Locale.ENGLISH), true);
                    detailText = prodData != null ? detailText + "<li>" + prodData.getProdName() : detailText + "<li>" + Globals.g_migrationSchema.getProductName(smuMachine, prodCode);
                }
            }
            catch (Exception e) {
                Logging.log.warning("Unable to parse the migration schema in: " + schema.toString());
                Logging.logStackTrace(e);
            }
        }
        detailText = detailText + "</ol></html>";
        this.m_hostInfo.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.m_hostInfo.setText(detailText);
        this.m_hostInfo.setCaretPosition(0);
        this.m_hostInfo.revalidate();
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

