/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConfigStatus;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.KitBrowseButton;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.OrderData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class PanelSelectConfigDir
implements WizardPanelIface,
ActionListener {
    private SSNResource bundle = new SSNResource(PanelSelectConfigDir.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JRadioButton m_knownOption = null;
    private JTable m_configDirList = null;
    private JScrollPane m_listScrollPane = null;
    private JRadioButton m_browseOption = null;
    private JLabel m_configDirLabel = null;
    private KitTextField m_configDir = null;
    private KitBrowseButton m_browseButton = null;
    private JLabel m_configLevLabel = null;
    private JComboBox m_configLev = null;
    private boolean m_panelLoaded = false;
    private String m_prevConfigDir = "";
    private ListTableModel m_listTableModel = null;
    private ArrayList<ListData> m_listData = new ArrayList();

    public PanelSelectConfigDir() {
        this.loadConfigDirs();
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSelectConfigDir.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSelectConfigDir.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        String errMsg = null;
        String configDir = null;
        String configLev = null;
        JComponent focusObj = null;
        Globals.g_cmtNewConfigDir = false;
        if (this.m_knownOption.isSelected()) {
            int selectedRow = this.m_configDirList.getSelectedRow();
            if (selectedRow > -1) {
                ListData listData = this.m_listData.get(selectedRow);
                configDir = listData.getConfigDir();
                configLev = listData.getConfigLev();
            } else {
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseMissing(this.getHeader(), "CONFIGURATION_DIRECTORY");
                } else {
                    errMsg = this.bundle.getString("PanelSelectConfigDir.NoConfigSelectedError.txt");
                    focusObj = this.m_configDirList;
                }
            }
        } else {
            configDir = Utils.trimTrailingSlashes(this.m_configDir.getText());
            configLev = "";
            this.m_configDir.setText(configDir);
            if (configDir.length() == 0) {
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseMissing(this.getHeader(), "CONFIGURATION_DIRECTORY");
                } else {
                    errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelSelectConfigDir.DirFieldName.txt"));
                    focusObj = this.m_configDir;
                }
            }
            if (valid) {
                if (this.m_configLev.getSelectedIndex() < 0) {
                    valid = false;
                    if (Globals.g_quietMode) {
                        Wizard.logResponseMissing(this.getHeader(), "CONFIGURATION_LEVEL");
                    } else {
                        errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelSelectConfigDir.LevFieldName.txt"));
                        focusObj = this.m_configLev;
                    }
                } else {
                    configLev = Globals.g_configLevels[this.m_configLev.getSelectedIndex()];
                }
            }
            if (valid) {
                if (Utils.getOS() == 6) {
                    configDir = Utils.VMSToUnixPath(configDir);
                }
                if (Utils.pathContainsValidChars(configDir)) {
                    valid = Utils.validatePath(configDir);
                    if (!valid) {
                        if (Globals.g_quietMode) {
                            Wizard.logResponseInvalid(this.getHeader(), "CONFIGURATION_DIRECTORY", configDir, null);
                        } else {
                            errMsg = this.bundle.messageString("Common.Error.InvalidField.txt", this.bundle.getString("PanelSelectConfigDir.DirFieldName.txt"));
                            focusObj = this.m_configDir;
                        }
                    }
                } else {
                    valid = false;
                    if (Globals.g_quietMode) {
                        String quietMsg = null;
                        quietMsg = Utils.getOS() == 1 ? "The following characters are invalid: / : * ? \" < > |" : (Utils.getOS() == 9 ? "The following characters are invalid: \\ :" : "The following characters are invalid: <space> % * \" & ? : < > \\ | ( )");
                        Wizard.logResponseInvalid(this.getHeader(), "CONFIGURATION_DIRECTORY", configDir, quietMsg);
                    } else {
                        errMsg = Utils.getOS() == 1 ? this.bundle.messageString("Common.Error.InvalidChars.Windows.txt", this.bundle.getString("PanelSelectConfigDir.DirFieldName.txt")) : (Utils.getOS() == 9 ? this.bundle.messageString("Common.Error.InvalidChars.Mac.txt", this.bundle.getString("PanelSelectConfigDir.DirFieldName.txt")) : this.bundle.messageString("Common.Error.InvalidChars.UNIX.txt", this.bundle.getString("PanelSelectConfigDir.DirFieldName.txt")));
                        focusObj = this.m_configDir;
                    }
                }
            }
            if (valid) {
                File statusFile = new File(Utils.joinPath(Utils.joinPath(configDir, configLev), "ConfigData", "status.xml"));
                valid = statusFile.isFile();
                if (!valid) {
                    statusFile = new File(Utils.joinPath(Utils.joinPath(configDir, configLev), "Utilities", "status.xml"));
                    valid = statusFile.isFile();
                }
                if (!valid) {
                    if (Globals.g_cmtTask == 26) {
                        valid = true;
                        Globals.g_cmtNewConfigDir = true;
                    } else if (Globals.g_quietMode) {
                        Wizard.logResponseInvalid(this.getHeader(), "CONFIGURATION_DIRECTORY", configDir, null);
                    } else {
                        errMsg = this.bundle.messageString("Common.Error.InvalidField.txt", this.bundle.getString("PanelSelectConfigDir.DirFieldName.txt"));
                        focusObj = this.m_configDir;
                    }
                } else if (!Globals.g_skipVerCheck) {
                    OrderData[] orderData = Globals.g_deploymentData.getOrders();
                    ConfigStatus configStatus = null;
                    try {
                        configStatus = new ConfigStatus(statusFile);
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                    if (configStatus != null) {
                        ConfigStatus.StatusEntry[] entries = configStatus.getStatusEntries();
                        ArrayList<String> missingOrders = new ArrayList<String>();
                        boolean found = false;
                        String order = null;
                        for (int i = 0; i < entries.length; ++i) {
                            order = entries[i].getOrder();
                            if (order == null || Utils.locInArrayList(missingOrders, order) != -1) continue;
                            found = false;
                            for (int j = 0; j < orderData.length && !found; ++j) {
                                if (!order.equalsIgnoreCase(orderData[j].getOrder())) continue;
                                found = true;
                            }
                            if (found) continue;
                            valid = false;
                            missingOrders.add(order);
                        }
                        if (!valid) {
                            String orderList = "";
                            for (int i = 0; i < missingOrders.size(); ++i) {
                                if (orderList.length() > 0) {
                                    orderList = Globals.g_quietMode ? orderList + ", " : orderList + "\n";
                                }
                                orderList = orderList + missingOrders.get(i);
                            }
                            if (Globals.g_quietMode) {
                                Wizard.logResponseInvalid(this.getHeader(), "CONFIGURATION_DIRECTORY", configDir, "The specified configuration directory contains products configured from the following orders that were not added to this instance of the SAS Deployment Manager: " + orderList);
                            } else {
                                errMsg = this.bundle.messageString("PanelSelectConfigDir.OrdersMissing.txt", orderList);
                                focusObj = this.m_configDir;
                            }
                        }
                    }
                }
            }
            if (valid && !(valid = Utils.canWriteToPath(configDir))) {
                if (Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), "CONFIGURATION_DIRECTORY", configDir, "Insufficient permission to write to the Configuration Directory specified.");
                } else {
                    errMsg = this.bundle.messageString("Common.Error.NoPermissions.txt", this.bundle.getString("PanelSelectConfigDir.DirFieldName.txt"));
                    focusObj = this.m_configDir;
                }
            }
            if (valid && !(valid = Utils.canWriteToPath(Utils.joinPath(configDir, configLev)))) {
                if (Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), "CONFIGURATION_LEVEL", configLev, "Insufficient permission to write to the Configuration Level specified.");
                } else {
                    errMsg = this.bundle.messageString("Common.Error.NoPermissions.txt", this.bundle.getString("PanelSelectConfigDir.LevFieldName.txt"));
                    focusObj = this.m_configLev;
                }
            }
        }
        if (valid && !this.isValidUserID(Utils.joinPath(configDir, configLev))) {
            valid = false;
        }
        if (valid) {
            Globals.g_cmtConfigDir = Utils.joinPath(configDir, configLev);
            if (!this.m_prevConfigDir.equals(Globals.g_cmtConfigDir)) {
                Globals.g_configData.clear();
                if (Globals.g_cmtTask == 26) {
                    try {
                        File statusFile = new File(Globals.g_cmtConfigDir, Utils.joinPath("ConfigData", "status.xml"));
                        Globals.g_configStatus = new ConfigStatus(statusFile);
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                }
                this.m_prevConfigDir = Globals.g_cmtConfigDir;
            }
            if (Globals.g_cmtNewConfigDir) {
                String configDirName = new File(configDir).getName();
                String levNum = Integer.toString((this.m_configLev.getSelectedIndex() + 1) % 10);
                Globals.g_configData.setProperty("config.dir.name", configDirName);
                Globals.g_configData.setProperty("config.home.dir", configDir);
                Globals.g_configData.setProperty("config.level.name", configLev);
                Globals.g_configData.setProperty("config.level.num", levNum);
            }
            Globals.g_configData.setProperty("config.lev.utilities.dir", Utils.joinPath(configDir, configLev, "Utilities"));
        } else if (!Globals.g_quietMode) {
            if (errMsg != null) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
            }
            if (focusObj != null) {
                focusObj.requestFocus();
            }
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return !Globals.g_cmtConfigDirSet;
    }

    @Override
    public String getNextPanelID() {
        return "connection";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            if (!this.loadResponseData()) {
                this.m_knownOption.setSelected(true);
            }
            if (this.m_configLev.getSelectedIndex() < 0) {
                this.m_configLev.setSelectedIndex(0);
            }
            this.setRadioState();
            if (this.m_configDirList.getSelectedRow() < 0 && this.m_configDirList.getRowCount() > 0) {
                this.m_configDirList.setRowSelectionInterval(0, 0);
            }
            this.m_panelLoaded = true;
        }
        TableColumn column = this.m_configDirList.getColumnModel().getColumn(1);
        int minWidth = Utils.getMinColumnWidth(this.m_configDirList, 1);
        int width = Utils.getPreferredColumnWidth(this.m_configDirList, 1);
        column.setMinWidth(minWidth);
        column.setPreferredWidth(width);
        column.setMaxWidth(width * 2);
        int rowHeight = Utils.getPreferredRowHeight(this.m_configDirList);
        if (rowHeight > 0) {
            this.m_configDirList.setRowHeight(rowHeight);
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_knownOption;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#CONFIGURATION_DIRECTORY=<full path>", " CONFIGURATION_DIRECTORY=", "#CONFIGURATION_LEVEL=<subdirectory>", " CONFIGURATION_LEVEL="};
        if (this.m_panelLoaded) {
            if (this.m_browseOption.isSelected()) {
                data[1] = " CONFIGURATION_DIRECTORY=" + this.m_configDir.getText();
                data[3] = " CONFIGURATION_LEVEL=" + Globals.g_configLevels[this.m_configLev.getSelectedIndex()];
            } else {
                int selectedRow = this.m_configDirList.getSelectedRow();
                if (selectedRow > -1) {
                    ListData listData = this.m_listData.get(selectedRow);
                    data[1] = " CONFIGURATION_DIRECTORY=" + listData.getConfigDir();
                    data[3] = " CONFIGURATION_LEVEL=" + listData.getConfigLev();
                }
            }
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_knownOption, this.m_browseOption};
        int returnCode = ConsoleMode.promptRadioButtons(options, null);
        if (returnCode > -1) {
            this.setRadioState();
            if (this.m_knownOption.isSelected()) {
                String[] cfgDirs = new String[this.m_listData.size()];
                for (int i = 0; i < this.m_listData.size(); ++i) {
                    cfgDirs[i] = this.m_listData.get(i).getConfigDir() + "~" + this.m_listData.get(i).getConfigLev();
                }
                String header = this.bundle.getString("PanelSelectConfigDir.DirFieldName.txt") + "~" + this.bundle.getString("PanelSelectConfigDir.LevFieldName.txt");
                returnCode = ConsoleMode.promptSingleChoice(cfgDirs, null, header, this.m_configDirList.getSelectedRow());
                if (returnCode > -1) {
                    this.m_configDirList.setRowSelectionInterval(returnCode, returnCode);
                }
            } else if (this.m_browseOption.isSelected()) {
                returnCode = ConsoleMode.promptText(this.m_configDirLabel.getText(), this.m_configDir);
            }
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String responseConfigDir = Wizard.getResponse("CONFIGURATION_DIRECTORY", null);
        if (responseConfigDir != null) {
            valid = true;
            this.m_configDir.setText(responseConfigDir);
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), "CONFIGURATION_DIRECTORY");
        }
        String responseConfigLev = Wizard.getResponse("CONFIGURATION_LEVEL", null);
        if (responseConfigLev != null) {
            boolean found = false;
            for (int i = 0; i < Globals.g_configLevels.length && !found; ++i) {
                if (!responseConfigLev.equalsIgnoreCase(Globals.g_configLevels[i])) continue;
                found = true;
                this.m_configLev.setSelectedIndex(i);
            }
            if (!found) {
                Wizard.logResponseInvalid(this.getHeader(), "CONFIGURATION_LEVEL", responseConfigLev, null);
            }
        } else if (Globals.g_quietMode) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "CONFIGURATION_LEVEL");
        }
        if (valid) {
            this.m_browseOption.setSelected(true);
        }
        return valid;
    }

    private void initialize() {
        String mtxt = this.bundle.getString("PanelSelectConfigDir.KnownConfigDir.txt");
        this.m_knownOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_knownOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_knownOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_knownOption.getFont();
        this.m_knownOption.setFont(optionFont.deriveFont(1));
        this.m_listTableModel = new ListTableModel();
        this.m_configDirList = new JTable(this.m_listTableModel);
        this.m_configDirList.setRowSelectionAllowed(true);
        this.m_configDirList.setColumnSelectionAllowed(false);
        this.m_configDirList.setSelectionMode(0);
        this.m_configDirList.getTableHeader().setResizingAllowed(true);
        this.m_configDirList.getTableHeader().setReorderingAllowed(false);
        this.m_configDirList.getColumnModel().getColumn(0).setCellRenderer(new StringCellRenderer());
        this.m_configDirList.getColumnModel().getColumn(1).setCellRenderer(new StringCellRenderer());
        this.m_configDirList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelSelectConfigDir.this.m_configDirList.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.m_listScrollPane = new JScrollPane(this.m_configDirList);
        mtxt = this.bundle.getString("PanelSelectConfigDir.BrowseConfigDir.txt");
        this.m_browseOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_browseOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_browseOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_browseOption.getFont();
        this.m_browseOption.setFont(optionFont.deriveFont(1));
        this.m_configDir = new KitTextField();
        mtxt = this.bundle.getString("PanelSelectConfigDir.ConfigDirLabel.txt");
        this.m_configDirLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_configDirLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_configDirLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_configDirLabel.setLabelFor(this.m_configDir);
        mtxt = this.bundle.getString("Common.Browse1.txt");
        this.m_browseButton = new KitBrowseButton(Util.getLabelWithoutMnemonic(mtxt), "", 0, this.m_configDir);
        this.m_browseButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_browseButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_browseButton.setFileSelectionMode(1);
        this.m_configLev = new JComboBox();
        this.loadComboBox();
        this.m_configLev.setPrototypeDisplayValue("Lev0 ");
        mtxt = this.bundle.getString("PanelSelectConfigDir.ConfigLevLabel.txt");
        this.m_configLevLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_configLevLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_configLevLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_configLevLabel.setLabelFor(this.m_configLev);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_knownOption);
        group.add(this.m_browseOption);
        this.m_knownOption.addActionListener(this);
        this.m_browseOption.addActionListener(this);
    }

    private void loadComboBox() {
        this.m_configLev.removeAllItems();
        for (int i = 0; i < Globals.g_configLevels.length; ++i) {
            this.m_configLev.addItem(Globals.g_configLevels[i]);
        }
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_knownOption, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 20, 5, 0);
        this.m_panel.add((Component)this.m_listScrollPane, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_browseOption, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 20, 5, 0);
        this.m_panel.add((Component)this.m_configDirLabel, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 20, 0, 0);
        this.m_panel.add((Component)this.m_configDir, c);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_panel.add((Component)this.m_browseButton, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 20, 5, 0);
        this.m_panel.add((Component)this.m_configLevLabel, c);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 20, 0, 0);
        this.m_panel.add((Component)this.m_configLev, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_knownOption || obj == this.m_browseOption) {
            this.setRadioState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigDirs() {
        this.m_listData.clear();
        try (RegistryAccess regAccess = null;){
            String[] configDirs;
            File deployRegJar = new File(Utils.joinPath(Globals.g_cmtSASHome, "deploymntreg"), "sas.tools.deploymntreg.jar");
            regAccess = new RegistryAccess(deployRegJar.getAbsolutePath());
            if (regAccess != null && regAccess.open() && (configDirs = regAccess.getConfigLocs()) != null && configDirs.length > 0) {
                for (int i = 0; i < configDirs.length; ++i) {
                    for (int j = 0; j < Globals.g_configLevels.length; ++j) {
                        File statusFile;
                        File fullDir = new File(configDirs[i], Globals.g_configLevels[j]);
                        if (!fullDir.isDirectory() || !(statusFile = new File(Utils.joinPath(fullDir.toString(), "ConfigData"), "status.xml")).isFile()) continue;
                        this.m_listData.add(new ListData(configDirs[i], Globals.g_configLevels[j]));
                    }
                }
            }
        }
    }

    private void setRadioState() {
        this.m_configDirList.setEnabled(this.m_knownOption.isSelected());
        this.m_configDirLabel.setEnabled(this.m_browseOption.isSelected());
        this.m_configDir.setEnabled(this.m_browseOption.isSelected());
        this.m_browseButton.setEnabled(this.m_browseOption.isSelected());
        this.m_configLevLabel.setEnabled(this.m_browseOption.isSelected());
        this.m_configLev.setEnabled(this.m_browseOption.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidUserID(String configDir) {
        boolean valid = true;
        if (!Globals.g_recordMode || !Globals.g_recordOnly) {
            String user = null;
            user = Utils.getOS() == 1 ? Utils.getUserDomain() + "\\" + System.getProperty("user.name") : System.getProperty("user.name");
            String lastUser = null;
            RegistryAccess registryAccess = null;
            try {
                File deployRegJar = new File(Utils.joinPath(Globals.g_cmtSASHome, "deploymntreg"), "sas.tools.deploymntreg.jar");
                registryAccess = new RegistryAccess(deployRegJar.getAbsolutePath());
                if (registryAccess != null && registryAccess.open()) {
                    lastUser = registryAccess.getInstallUser();
                }
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
            finally {
                if (registryAccess != null) {
                    registryAccess.close();
                    registryAccess = null;
                }
            }
            if (user != null && lastUser != null && !user.equals(lastUser)) {
                Logging.log.warning("The current user (" + user + ") is not the same user that last deployed to the SAS Home location associated with the specified configuration directory: " + lastUser);
                if (!Globals.g_skipAdminCheck && Utils.getOS() != 1 && Utils.getOS() != 6) {
                    valid = false;
                    if (Globals.g_quietMode) {
                        Wizard.logResponseInvalid(this.getHeader(), "CONFIGURATION_DIRECTORY", configDir, "The current user (" + user + ") is not the same user that last deployed to the SAS Home location associated with the specified configuration directory: " + lastUser);
                    } else {
                        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelSelectConfigDir.SASUserMsg.txt", user, lastUser), this.bundle.getString("Common.Warning.txt"), 2);
                    }
                }
            }
        }
        return valid;
    }

    private class ListTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1378567483163982244L;
        public static final int TABLE_COLUMN_DIR = 0;
        public static final int TABLE_COLUMN_LEV = 1;
        private String[] m_columnNames;

        public ListTableModel() {
            this.m_columnNames = new String[]{PanelSelectConfigDir.this.bundle.getString("PanelSelectConfigDir.DirFieldName.txt"), PanelSelectConfigDir.this.bundle.getString("PanelSelectConfigDir.LevFieldName.txt")};
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.m_columnNames[index];
        }

        public Class getColumnClass(int index) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            int count = 0;
            if (PanelSelectConfigDir.this.m_listData != null) {
                count = PanelSelectConfigDir.this.m_listData.size();
            }
            return count;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String value = null;
            ListData data = (ListData)PanelSelectConfigDir.this.m_listData.get(rowIndex);
            if (data != null) {
                if (columnIndex == 0) {
                    value = data.getConfigDir();
                } else if (columnIndex == 1) {
                    value = data.getConfigLev();
                }
            }
            return value;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
        }
    }

    private class ListData {
        private String m_configDir = null;
        private String m_configLev = null;

        public ListData(String configDir, String configLev) {
            this.m_configDir = configDir;
            this.m_configLev = configLev;
        }

        public String getConfigDir() {
            return this.m_configDir;
        }

        public String getConfigLev() {
            return this.m_configLev;
        }
    }

    private class StringCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -1403337703273209259L;

        private StringCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
            } else {
                this.setText(value.toString());
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
            }
            return this;
        }
    }
}

