/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConfigStatus;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.JREData;
import com.sas.ssn.KitBrowseButton;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.OsLevelConfirm;
import com.sas.ssn.PanelThirdParty;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SASHomeStatus;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class PanelSASHome
implements WizardPanelIface,
ActionListener {
    private SSNResource bundle = new SSNResource(PanelSASHome.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JLabel m_warningImage = null;
    private JTextArea m_sasHomeInfo = null;
    private JRadioButton m_oldSASHomeOption = null;
    private JList m_list = null;
    private JScrollPane m_listScrollPane = null;
    private JRadioButton m_newSASHomeOption = null;
    private JLabel m_sasHomeLabel = null;
    private KitTextField m_sasHomeDir = null;
    private KitBrowseButton m_browseButton = null;
    private boolean m_lastUpgradeSAS = false;
    private ProductData[] m_lastSelectedInstalls = null;
    private boolean m_panelLoaded = false;
    private boolean m_multipleSASHomes = false;
    private ArrayList m_sasHomes = new ArrayList();
    public static String sasHomeDir = null;
    public static String handledSasHome = null;
    public static String handledOrder = null;

    public PanelSASHome() {
        this.loadSASHomes();
        this.m_multipleSASHomes = Utils.getOS() != 1 && this.m_sasHomes.size() > 0;
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSASHome.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSASHome.HeaderDesc.txt");
    }

    private boolean equals(String s1, String s2) {
        boolean equals;
        boolean bl = equals = s1 == null && s2 == null;
        if (!equals && s1 != null && s2 != null) {
            equals = s1.equals(s2);
        }
        return equals;
    }

    private boolean shouldProcessSasHomeStatus(String sasHomeDir) {
        boolean ret = false;
        boolean bl = ret = !this.equals(sasHomeDir, handledSasHome);
        if (ret) {
            Logging.log.finer("PanelSASHome::shouldProcessSasHomeStatus(\"" + sasHomeDir + "\") detected unhandled SASHome");
        } else {
            boolean bl2 = ret = !this.equals(Globals.g_order, handledOrder);
            if (ret) {
                Logging.log.finer("PanelSASHome::shouldProcessSasHomeStatus(\"" + sasHomeDir + "\") detected unhandled order " + Globals.g_order);
            }
        }
        return ret;
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        boolean newDir = false;
        String errMsg = null;
        if (this.m_multipleSASHomes && this.m_oldSASHomeOption.isSelected()) {
            sasHomeDir = (String)this.m_sasHomes.get(this.m_list.getSelectedIndex());
        } else {
            newDir = true;
            sasHomeDir = Utils.trimTrailingSlashes(this.m_sasHomeDir.getText());
            this.m_sasHomeDir.setText(sasHomeDir);
            if (sasHomeDir.length() == 0) {
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseMissing(this.getHeader(), "SAS_HOME");
                } else {
                    errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelSASHome.FieldName.txt"));
                }
            }
            if (valid && Globals.g_deploymentData.getOrder(Globals.g_order).isStandAlone() && !OsLevelConfirm.checkOsVersion()) {
                valid = false;
                if (!Globals.g_quietMode) {
                    errMsg = OsLevelConfirm.getErrorMessage();
                }
            }
            if (valid && (Utils.getOS() == 8 || Utils.getOS() == 10) && sasHomeDir.length() > 54) {
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), "SAS_HOME", sasHomeDir, "The SAS Home location may not be longer than 54 characters on z/OS.");
                } else {
                    errMsg = this.bundle.messageString("PanelSASHome.MVSLength.txt", this.bundle.getString("PanelSASHome.FieldName.txt"));
                }
            }
            if (valid) {
                if (Utils.getOS() == 6) {
                    sasHomeDir = Utils.VMSToUnixPath(sasHomeDir);
                }
                if (Utils.pathContainsValidChars(sasHomeDir)) {
                    valid = Utils.validatePath(sasHomeDir);
                    if (!valid) {
                        if (Globals.g_quietMode) {
                            Wizard.logResponseInvalid(this.getHeader(), "SAS_HOME", sasHomeDir, null);
                        } else {
                            errMsg = this.bundle.messageString("Common.Error.InvalidField.txt", this.bundle.getString("PanelSASHome.FieldName.txt"));
                        }
                    }
                } else {
                    valid = false;
                    if (Globals.g_quietMode) {
                        String quietMsg = null;
                        quietMsg = Utils.getOS() == 1 ? "The following characters are invalid: / : * ? \" < > |" : (Utils.getOS() == 9 ? "The following characters are invalid: \\ :" : "The following characters are invalid: <space> % * \" & ? : < > \\ | ( )");
                        Wizard.logResponseInvalid(this.getHeader(), "SAS_HOME", sasHomeDir, quietMsg);
                    } else {
                        errMsg = Utils.getOS() == 1 ? this.bundle.messageString("Common.Error.InvalidChars.Windows.txt", this.bundle.getString("PanelSASHome.FieldName.txt")) : (Utils.getOS() == 9 ? this.bundle.messageString("Common.Error.InvalidChars.Mac.txt", this.bundle.getString("PanelSASHome.FieldName.txt")) : this.bundle.messageString("Common.Error.InvalidChars.UNIX.txt", this.bundle.getString("PanelSASHome.FieldName.txt")));
                    }
                }
            }
            if (valid) {
                try {
                    String source = new File(Globals.g_startupLocation).getCanonicalPath() + File.separator;
                    String target = new File(sasHomeDir).getCanonicalPath() + File.separator;
                    if (target.startsWith(source)) {
                        valid = false;
                    }
                }
                catch (IOException source) {
                    // empty catch block
                }
                if (!valid) {
                    if (Globals.g_quietMode) {
                        Wizard.logResponseInvalid(this.getHeader(), "SAS_HOME", sasHomeDir, "The SAS Home location may not be specified within the source directory tree.");
                    } else {
                        errMsg = this.bundle.getString("PanelSASHome.SourceSubdirMsg.txt");
                    }
                }
            }
        }
        if (this.shouldProcessSasHomeStatus(sasHomeDir)) {
            Globals.g_sasHomeStatus = new SASHomeStatus(sasHomeDir);
            handledSasHome = sasHomeDir;
            handledOrder = Globals.g_order;
        }
        if (Globals.g_sasHomeStatus.isNewerSASHome()) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "SAS_HOME", sasHomeDir, "The SAS Home location specified contains software, which is newer than what is included in the order you are attempting to deploy.");
            } else {
                errMsg = this.bundle.getString("PanelSASHome.NewerSoftwarePresent.txt");
                SASHomeStatus.UpdateEntity[] products = Globals.g_sasHomeStatus.getNewerInstalledProducts();
                for (int i = 0; i < products.length; ++i) {
                    errMsg = errMsg + "\n     " + products[i].getExistingProductName() + " " + products[i].getExistingCustomerVersion();
                    if (!Globals.g_debug || products[i].getBaseProductData() == null) continue;
                    errMsg = errMsg + " (" + products[i].getBaseProductData().getProdCode() + ")";
                }
            }
        }
        if (valid && !this.isSupportedMajorRelease(sasHomeDir, Globals.g_majorReleaseVersion)) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "SAS_HOME", sasHomeDir, "This order cannot be installed to a SAS Home containing SAS Software from a release other than " + Globals.g_majorReleaseVersion);
            } else {
                errMsg = this.bundle.messageString("PanelSASHome.WrongMajorRelease.txt", Globals.g_majorReleaseVersion);
            }
        }
        if (valid && !this.isValidUserID(sasHomeDir)) {
            valid = false;
        }
        if (!(!valid || Globals.g_recordMode && Globals.g_recordOnly || Utils.canWriteToPath(sasHomeDir))) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "SAS_HOME", sasHomeDir, "Insufficient permission to write to the SAS Home location specified.");
            } else {
                errMsg = this.bundle.messageString("Common.Error.NoPermissions.txt", this.bundle.getString("PanelSASHome.FieldName.txt"));
            }
        }
        if (valid && this.isUIPWebDownloadOrStandalone() && !Globals.g_sasHomeStatus.checkForM9(sasHomeDir)) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "SAS_HOME", sasHomeDir, "This order must install to a SAS Home containing SAS Software from a release at 9.4 M9 or greater. The current order is either a web download or stand alone.");
            } else {
                errMsg = this.bundle.messageString("PanelSASHome.WrongMajorRelease.txt", "9.4 M9");
                if (errMsg != null) {
                    CustMsgBox.showMessageDialog(null, errMsg, this.bundle.getString("Common.Error.txt"), 2);
                }
            }
        }
        if (newDir && valid && (!Globals.g_recordMode || !Globals.g_recordOnly)) {
            File sasHomeFile = new File(sasHomeDir);
            if (Utils.pathContainsFiles(sasHomeFile)) {
                boolean isDepo = false;
                String fileNameToSearch = "SASDepotCheck.";
                String directoryPath = Utils.joinPath("utilities", "depotchecker");
                try {
                    List sasDepotPaths = Files.walk(Paths.get(sasHomeDir, new String[0]), new FileVisitOption[0]).filter(path -> path.getFileName().toString().startsWith(fileNameToSearch) && path.toString().contains(directoryPath)).collect(Collectors.toList());
                    if (!sasDepotPaths.isEmpty()) {
                        valid = false;
                        isDepo = true;
                        if (Globals.g_quietMode) {
                            Wizard.logResponseMissing(this.getHeader(), "SAS_HOME");
                        } else {
                            errMsg = this.bundle.getString("PanelSASHome.ExistingDepotInSASHome.txt");
                        }
                    }
                }
                catch (IOException ex) {
                    Logging.log.severe(ex.getMessage());
                }
                catch (RuntimeException re) {
                    Logging.log.severe(re.getMessage());
                }
                if (!Globals.g_DocUpdate && !isDepo) {
                    valid = this.confirmPrompt(this.bundle.getString("PanelSASHome.ExistingFilesMsg.txt"));
                }
            } else if (Globals.g_DocUpdate) {
                String msg = this.bundle.getString("PanelSASHome.NonExistingSASHome.txt");
                Logging.log.warning("-docupdate expects existing SASHome: " + msg);
                if (!Globals.g_quietMode) {
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), msg, this.bundle.getString("Common.Warning.txt"), 2);
                }
                valid = false;
            }
        }
        if (valid) {
            Globals.g_wizardData.setPreference("SASHome", sasHomeDir);
            Globals.g_wizardData.setPreference("SASVersion", Globals.g_majorReleaseVersion);
            RegistryData.setRegistry(sasHomeDir);
            Globals.g_installData.load(sasHomeDir);
            Globals.g_installDataLoc = sasHomeDir;
            JREData.setJREData(Globals.g_sasinstallPlat, JREData.isPrivateJreNeeded());
            String sasRootDir = Utils.joinPath(sasHomeDir, "SASFoundation", Globals.g_majorReleaseVersion);
            Globals.g_installData.setProperty("sas.root", sasRootDir);
            Logging.log.info("sasRootDir is: " + sasRootDir);
            if (Globals.g_zosJobSubmit) {
                if (Globals.g_z64) {
                    Globals.g_installData.setProperty("z64.job.submit", "TRUE");
                    Globals.g_installData.setProperty("z64.job.chain", "FALSE");
                } else {
                    Globals.g_installData.setProperty("zos.job.submit", "TRUE");
                    Globals.g_installData.setProperty("zos.job.chain", "FALSE");
                }
                if (Globals.g_zosUseFtp) {
                    if (Globals.g_z64) {
                        Globals.g_installData.setProperty("z64.use.ftp", "TRUE");
                    } else {
                        Globals.g_installData.setProperty("zos.use.ftp", "TRUE");
                    }
                } else if (Globals.g_z64) {
                    Globals.g_installData.setProperty("z64.use.ftp", "FALSE");
                } else {
                    Globals.g_installData.setProperty("zos.use.ftp", "FALSE");
                }
            } else if (Globals.g_z64) {
                Globals.g_installData.setProperty("z64.job.submit", "FALSE");
                if (Globals.g_zosJobChain) {
                    Globals.g_installData.setProperty("z64.job.chain", "TRUE");
                } else {
                    Globals.g_installData.setProperty("z64.job.chain", "FALSE");
                }
            } else {
                Globals.g_installData.setProperty("zos.job.submit", "FALSE");
                if (Globals.g_zosJobChain) {
                    Globals.g_installData.setProperty("zos.job.chain", "TRUE");
                } else {
                    Globals.g_installData.setProperty("zos.job.chain", "FALSE");
                }
            }
            if (newDir && !this.m_sasHomes.contains(sasHomeDir)) {
                Globals.g_wizardData.setSharedPreference("SASHome" + (this.m_sasHomes.size() + 1), sasHomeDir);
                Globals.g_wizardData.setPreference("SASVersion" + (this.m_sasHomes.size() + 1), Globals.g_majorReleaseVersion);
            }
            Globals.g_installData.setProperty("deployagent.config.is_skip", Boolean.toString(Globals.g_skipagentcfg));
            Globals.g_installData.setProperty("deployagent.config.is_force", Boolean.toString(Globals.g_forceagentcfg));
        } else if (!Globals.g_quietMode) {
            if (errMsg != null) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
            }
            this.m_sasHomeDir.requestFocus();
        }
        if (valid) {
            Globals.g_installData.setProperty("deployment.is.uip", Boolean.toString(false));
            Globals.g_installData.setProperty("deployment.is.metadatasrv.tier", Boolean.toString(false));
            Globals.g_installData.setProperty("deployment.is.addon", Boolean.toString(false));
            if (this.hasMetadataSrvTier()) {
                Globals.g_installData.setProperty("deployment.is.metadatasrv.tier", Boolean.toString(true));
            }
            if (Globals.g_sasHomeStatus != null && !Globals.g_sasHomeStatus.updatesRequired() && !Globals.g_sasHomeStatus.isEmptySASHome()) {
                Globals.g_installData.setProperty("deployment.is.addon", Boolean.toString(true));
            }
            if (Globals.g_sasHomeStatus.updatesRequired()) {
                Globals.g_install = true;
                Globals.g_configure = false;
                Globals.g_plan = null;
                Globals.g_machine = null;
                Globals.g_installData.setProperty("deployment.is.uip", Boolean.toString(true));
                if (!Utils.isExistingSASPlannedDeployment()) {
                    Globals.g_plannedInstall = false;
                }
                ArrayList<String> promptedList = new ArrayList<String>();
                Globals.g_promptedData = Globals.g_sasHomeStatus.getPromptedInstallSteps();
                for (int i = 0; i < Globals.g_promptedData.length; ++i) {
                    if (Globals.g_promptedData[i] == null) continue;
                    String prodCode = Globals.g_promptedData[i].getProdCode();
                    String prodVersion = Globals.g_promptedData[i].getProdVersion();
                    String prodName = Globals.g_promptedData[i].getProdName();
                    String panelID = "promptfor".concat(prodCode);
                    Globals.g_wizard.addPanel(panelID, new PanelThirdParty(i, prodCode, prodVersion, prodName));
                    promptedList.add(panelID);
                }
                Globals.g_promptedInstalls = promptedList.toArray(new String[0]);
                if (Utils.getOS() == 8) {
                    if (Globals.g_sasHomeStatus.isSASUpgrade()) {
                        if (!this.m_lastUpgradeSAS) {
                            this.m_lastUpgradeSAS = true;
                            this.m_lastSelectedInstalls = Globals.g_selectedInstalls;
                            Globals.g_selectedInstalls = new ProductData[]{Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", false)};
                            Globals.g_fullInstalls = new ProductData[]{Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", false)};
                            if (Globals.g_z64) {
                                Globals.g_installData.setProperty("z64.install.action", "B - Add products to existing SAS libraries");
                            } else {
                                Globals.g_installData.setProperty("zos.install.action", "C - Install products to staging prefix");
                            }
                        }
                    } else if (this.m_lastUpgradeSAS) {
                        this.m_lastUpgradeSAS = false;
                        Globals.g_selectedInstalls = this.m_lastSelectedInstalls;
                        Globals.g_fullInstalls = null;
                        this.m_lastSelectedInstalls = null;
                    }
                }
            } else if (Utils.getOS() == 8 && this.m_lastUpgradeSAS) {
                this.m_lastUpgradeSAS = false;
                Globals.g_selectedInstalls = this.m_lastSelectedInstalls;
                Globals.g_fullInstalls = null;
                this.m_lastSelectedInstalls = null;
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMetadataSrvTier() {
        String[] configDirs = null;
        RegistryAccess registryAccess = null;
        try {
            registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
            if (registryAccess != null && registryAccess.open()) {
                configDirs = registryAccess.getConfigLocs();
            }
        }
        catch (Exception e) {
            Logging.log.info("Unable to get config locations from deployment registry");
            Logging.log.info(e.getMessage());
        }
        finally {
            if (registryAccess != null) {
                registryAccess.close();
                registryAccess = null;
            }
        }
        if (configDirs != null && configDirs.length > 0) {
            for (String configDir : configDirs) {
                File[] files;
                File configDirFile = new File(configDir);
                if (!configDirFile.isDirectory()) continue;
                for (File file : files = configDirFile.listFiles()) {
                    File statusXml;
                    if (!file.isDirectory() || !file.getName().startsWith("Lev") || !(statusXml = new File(Utils.joinPaths(configDir, file.getName(), "ConfigData", "status.xml"))).exists()) continue;
                    try {
                        ConfigStatus configStatus = new ConfigStatus(statusXml);
                        return configStatus.checkStatusFileForProductCode("metadatasrv");
                    }
                    catch (Exception e) {
                        Logging.log.info("Unable to check status.xml");
                        Logging.log.info(e.getMessage());
                    }
                }
            }
        }
        return false;
    }

    private boolean isUIPWebDownloadOrStandalone() {
        if (Globals.g_sasHomeStatus == null || !Globals.g_sasHomeStatus.updatesRequired()) {
            return false;
        }
        return Globals.g_deploymentData.getOrder(Globals.g_order).isStandAlone() || Globals.g_deploymentData.getOrder(Globals.g_order).isWeb();
    }

    @Override
    public boolean displayPanel() {
        boolean display = false;
        if (Globals.g_zos) {
            if (!Globals.g_installData.isTemporary()) {
                Globals.g_installData.makeTemporary();
            }
            Globals.g_installData.loadTemporary(Utils.getSDWDataPath(false));
        } else {
            String sasHomeDir = Globals.g_srwOnly ? Utils.getSDWDataPath(false) : Globals.g_wizardData.getPreference("SASHome", "");
            if ((Globals.g_changeSASHome || this.m_multipleSASHomes || this.m_panelLoaded && Utils.getOS() != 1 || Globals.g_recordMode && Globals.g_recordOnly || sasHomeDir.length() == 0) && !Globals.g_srwOnly) {
                display = true;
            } else {
                File sasHome = new File(sasHomeDir);
                if (sasHome.isDirectory()) {
                    if (this.shouldProcessSasHomeStatus(sasHomeDir)) {
                        Globals.g_sasHomeStatus = new SASHomeStatus(sasHomeDir);
                        handledSasHome = sasHomeDir;
                        handledOrder = Globals.g_order;
                    }
                    if (Globals.g_sasHomeStatus.isNewerSASHome()) {
                        display = true;
                    }
                    if (!this.isSupportedMajorRelease(sasHomeDir, Globals.g_majorReleaseVersion)) {
                        display = true;
                    }
                    if (!this.isValidUserID(sasHomeDir)) {
                        display = true;
                    }
                    if (!Utils.canWriteToPath(sasHome)) {
                        display = true;
                    }
                    if (Globals.g_srwOnly) {
                        display = false;
                    }
                } else {
                    display = true;
                }
            }
            if (!display) {
                RegistryData.setRegistry(sasHomeDir);
                Globals.g_installData.load(sasHomeDir);
                Globals.g_installDataLoc = sasHomeDir;
                PanelSASHome.sasHomeDir = sasHomeDir;
                if (Globals.g_srwOnly) {
                    Globals.g_wizardData.setPreference("SASHome", sasHomeDir);
                    Globals.g_wizardData.setPreference("SASVersion", Globals.g_majorReleaseVersion);
                }
                if (this.isUIPWebDownloadOrStandalone() && !Globals.g_sasHomeStatus.checkForM9(sasHomeDir)) {
                    if (Globals.g_quietMode) {
                        Wizard.logResponseInvalid(this.getHeader(), "SAS_HOME", sasHomeDir, "This order must install to a SAS Home containing SAS Software from a release at 9.4 M9 or greater. The current order is either a web download or stand alone.");
                    } else {
                        String errMsg = "";
                        errMsg = Utils.getOS() == 1 ? this.bundle.messageString("PanelSASHome.WrongMajorReleaseWindows.txt", "9.4 M9") : this.bundle.messageString("PanelSASHome.WrongMajorRelease.txt", "9.4 M9");
                        if (errMsg != null) {
                            CustMsgBox.showMessageDialog(null, errMsg, this.bundle.getString("Common.Error.txt"), 0);
                        }
                    }
                    Logging.log.info("This order must install to a SAS Home containing SAS Software from a release at 9.4 M9 or greater. The current order is either a web download or stand alone.");
                    Globals.g_kit.exitKit(-1);
                }
                Globals.g_installData.setProperty("deployment.is.uip", Boolean.toString(false));
                Globals.g_installData.setProperty("deployment.is.metadatasrv.tier", Boolean.toString(false));
                Globals.g_installData.setProperty("deployment.is.addon", Boolean.toString(false));
                if (this.hasMetadataSrvTier()) {
                    Globals.g_installData.setProperty("deployment.is.metadatasrv.tier", Boolean.toString(true));
                }
                if (Globals.g_sasHomeStatus != null && !Globals.g_sasHomeStatus.updatesRequired() && !Globals.g_sasHomeStatus.isEmptySASHome()) {
                    Globals.g_installData.setProperty("deployment.is.addon", Boolean.toString(true));
                }
                if (Globals.g_wizard != null && Globals.g_sasHomeStatus.updatesRequired()) {
                    Globals.g_install = true;
                    Globals.g_configure = false;
                    Globals.g_plan = null;
                    Globals.g_machine = null;
                    Globals.g_installData.setProperty("deployment.is.uip", Boolean.toString(true));
                    if (Globals.g_order != null && (Globals.g_plannedInstall = Globals.g_deploymentData.getOrder(Globals.g_order).isPlanning()) && Utils.getOS() == 1 && Utils.isExistingSASPlannedDeployment()) {
                        Globals.g_checkDeploymentAgentUp = true;
                    }
                    ArrayList<String> promptedList = new ArrayList<String>();
                    Globals.g_promptedData = Globals.g_sasHomeStatus.getPromptedInstallSteps();
                    for (int i = 0; i < Globals.g_promptedData.length; ++i) {
                        if (Globals.g_promptedData[i] == null) continue;
                        String prodCode = Globals.g_promptedData[i].getProdCode();
                        String prodVersion = Globals.g_promptedData[i].getProdVersion();
                        String prodName = Globals.g_promptedData[i].getProdName();
                        String panelID = "promptfor".concat(prodCode);
                        Globals.g_wizard.addPanel(panelID, new PanelThirdParty(i, prodCode, prodVersion, prodName));
                        promptedList.add(panelID);
                    }
                    Globals.g_promptedInstalls = promptedList.toArray(new String[0]);
                }
                String sasRootDir = Utils.joinPath(sasHomeDir, "SASFoundation", Globals.g_majorReleaseVersion);
                Globals.g_installData.setProperty("sas.root", sasRootDir);
                Logging.log.info("sasRootDir is: " + sasRootDir);
                Globals.g_installData.setProperty("deployagent.config.is_skip", Boolean.toString(Globals.g_skipagentcfg));
                Globals.g_installData.setProperty("deployagent.config.is_force", Boolean.toString(Globals.g_forceagentcfg));
            }
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = Globals.g_mode == 3 ? (Globals.g_personalPlan != null ? "execute" : "selectplan") : (Globals.g_forceConfigMaint ? "configmaint" : (Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired() ? (!Globals.g_DocUpdate ? "updatesummary" : (Globals.g_sasHomeStatus.getRequiredInstallSteps().length == 0 ? "finish" : "updatesummary")) : (Globals.g_sasHomeStatus != null && !Globals.g_sasHomeStatus.updatesRequired() && Globals.g_DocUpdate ? "finish" : ((Globals.g_forcePlanning || Globals.g_order != null && Globals.g_deploymentData.getOrder(Globals.g_order).isPlanning()) && !Globals.g_skipPlanning ? "installtype" : "machine"))));
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            if (this.m_multipleSASHomes) {
                this.setRadioState();
            } else if (this.m_sasHomeDir.getText().length() == 0) {
                this.m_sasHomeDir.setText(Globals.g_wizardData.getPreference("SASHome", Utils.getSASHomeDefault()));
                if (Utils.getOS() == 1) {
                    String sasHome = null;
                    if (sasHome == null && (sasHome = Globals.g_wizardData.getPreference("SASHome", null)) != null && !this.isSupportedMajorRelease(sasHome, Globals.g_majorReleaseVersion)) {
                        sasHome = null;
                    }
                    if (sasHome == null && (sasHome = Utils.getSASHomeDefault()) != null && !this.isSupportedMajorRelease(sasHome, Globals.g_majorReleaseVersion)) {
                        sasHome = null;
                    }
                    if (sasHome != null) {
                        this.m_sasHomeDir.setText(sasHome);
                    }
                }
            }
            if (Utils.getOS() == 1 && !Globals.g_changeSASHome && Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.isNewerSASHome()) {
                this.m_sasHomeDir.setEnabled(false);
                this.m_browseButton.setEnabled(false);
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return !this.m_multipleSASHomes;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        JComponent focus = null;
        focus = this.m_list != null && this.m_list.isEnabled() ? this.m_list : this.m_sasHomeDir;
        return focus;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#SAS_HOME=<full path>", " SAS_HOME="};
        if (this.m_panelLoaded) {
            data[1] = this.m_multipleSASHomes && this.m_oldSASHomeOption.isSelected() ? " SAS_HOME=" + (String)this.m_sasHomes.get(this.m_list.getSelectedIndex()) : " SAS_HOME=" + this.m_sasHomeDir.getText();
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int returnCode = 0;
        boolean newSASHome = false;
        if (this.m_multipleSASHomes) {
            JRadioButton[] options = new JRadioButton[]{this.m_oldSASHomeOption, this.m_newSASHomeOption};
            returnCode = ConsoleMode.promptRadioButtons(options, null);
            if (returnCode > -1) {
                this.setRadioState();
                if (this.m_oldSASHomeOption.isSelected()) {
                    returnCode = ConsoleMode.promptSingleChoice(this.m_sasHomes.toArray(new String[0]), null, null, this.m_list.getSelectedIndex());
                    if (returnCode > -1) {
                        this.m_list.setSelectedIndex(returnCode);
                    }
                } else if (this.m_newSASHomeOption.isSelected()) {
                    newSASHome = true;
                }
            }
        } else {
            newSASHome = true;
        }
        if (returnCode > -1 && newSASHome) {
            returnCode = ConsoleMode.promptText(this.m_sasHomeLabel.getText(), this.m_sasHomeDir);
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("SAS_HOME", null);
        if (response != null) {
            if (this.m_multipleSASHomes) {
                for (int i = 0; i < this.m_sasHomes.size(); ++i) {
                    if (!((String)this.m_sasHomes.get(i)).equals(response)) continue;
                    valid = true;
                    this.m_oldSASHomeOption.setSelected(true);
                    this.m_list.setSelectedIndex(i);
                }
            }
            if (!valid) {
                valid = true;
                if (this.m_newSASHomeOption != null) {
                    this.m_newSASHomeOption.setSelected(true);
                }
                this.m_sasHomeDir.setText(response);
            }
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), "SAS_HOME");
        }
        return valid;
    }

    private void initialize() {
        String mtxt = null;
        if (this.m_multipleSASHomes) {
            mtxt = this.bundle.getString("PanelSASHome.ExistingSASHome.txt");
            this.m_oldSASHomeOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
            this.m_oldSASHomeOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
            this.m_oldSASHomeOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            Font optionFont = this.m_oldSASHomeOption.getFont();
            this.m_oldSASHomeOption.setFont(optionFont.deriveFont(1));
            this.m_oldSASHomeOption.setSelected(true);
            String[] sasHomes = new String[]{};
            sasHomes = this.m_sasHomes.toArray(sasHomes);
            this.m_list = new JList<String>(sasHomes);
            this.m_list.setOpaque(true);
            if (this.m_list.getModel().getSize() > 0) {
                this.m_list.setSelectedIndex(0);
            }
            this.m_listScrollPane = new JScrollPane();
            this.m_listScrollPane.getViewport().setView(this.m_list);
            mtxt = this.bundle.getString("PanelSASHome.NewSASHome.txt");
            this.m_newSASHomeOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
            this.m_newSASHomeOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
            this.m_newSASHomeOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            optionFont = this.m_newSASHomeOption.getFont();
            this.m_newSASHomeOption.setFont(optionFont.deriveFont(1));
            ButtonGroup group = new ButtonGroup();
            group.add(this.m_oldSASHomeOption);
            group.add(this.m_newSASHomeOption);
            this.m_oldSASHomeOption.addActionListener(this);
            this.m_newSASHomeOption.addActionListener(this);
        } else if (Utils.getOS() == 1) {
            this.m_warningImage = new JLabel();
            this.m_warningImage.setIcon(this.bundle.getImageIcon("Common.info_small.image"));
            this.m_sasHomeInfo = new JTextArea(this.bundle.getString("PanelSASHome.SASHomeInfo.txt"));
            this.m_sasHomeInfo.setEditable(false);
            this.m_sasHomeInfo.setFocusable(false);
            this.m_sasHomeInfo.setLineWrap(true);
            this.m_sasHomeInfo.setWrapStyleWord(true);
            this.m_sasHomeInfo.setOpaque(false);
        }
        this.m_sasHomeDir = new KitTextField();
        if (Utils.getOS() == 8) {
            this.m_sasHomeDir.setDocument(new MaxLengthDocument(63));
        }
        mtxt = this.bundle.getString("PanelSASHome.SASHomeLabel.txt");
        this.m_sasHomeLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_sasHomeLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_sasHomeLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_sasHomeLabel.setLabelFor(this.m_sasHomeDir);
        mtxt = this.bundle.getString("Common.Browse1.txt");
        this.m_browseButton = new KitBrowseButton(Util.getLabelWithoutMnemonic(mtxt), "", 0, this.m_sasHomeDir);
        this.m_browseButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_browseButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_browseButton.setFileSelectionMode(1);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.anchor = 17;
        if (this.m_multipleSASHomes) {
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 4;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 2;
            c.insets = new Insets(0, 0, 5, 0);
            this.m_panel.add((Component)this.m_oldSASHomeOption, c);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 4;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            c.insets = new Insets(5, 20, 5, 0);
            this.m_panel.add((Component)this.m_listScrollPane, c);
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 4;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 2;
            c.insets = new Insets(5, 0, 5, 0);
            this.m_panel.add((Component)this.m_newSASHomeOption, c);
        } else if (!(Utils.getOS() != 1 || Globals.g_recordMode && Globals.g_recordOnly)) {
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            c.insets = new Insets(0, 0, 5, 0);
            this.m_panel.add((Component)this.m_warningImage, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 3;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 2;
            c.insets = new Insets(0, 5, 5, 0);
            this.m_panel.add((Component)this.m_sasHomeInfo, c);
        }
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = this.m_multipleSASHomes ? new Insets(5, 20, 0, 5) : new Insets(5, 0, 0, 5);
        this.m_panel.add((Component)this.m_sasHomeLabel, c);
        c.gridx = 2;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_sasHomeDir, c);
        c.gridx = 3;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_panel.add((Component)this.m_browseButton, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setRadioState();
    }

    private void setRadioState() {
        this.m_sasHomeLabel.setEnabled(this.m_newSASHomeOption.isSelected());
        this.m_sasHomeDir.setEnabled(this.m_newSASHomeOption.isSelected());
        this.m_browseButton.setEnabled(this.m_newSASHomeOption.isSelected());
        this.m_list.setEnabled(this.m_oldSASHomeOption.isSelected());
    }

    private boolean confirmPrompt(String message) {
        boolean valid = true;
        if (!Globals.g_quietMode && CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), message, Globals.g_wizard.getWizardTitle(), 0, 3, 0) == 1) {
            valid = false;
        }
        return valid;
    }

    private void loadSASHomes() {
        boolean more = true;
        int count = 1;
        String sasHome = null;
        while (more) {
            sasHome = Globals.g_wizardData.getSharedPreference("SASHome" + count, "");
            if (sasHome.length() > 0) {
                this.m_sasHomes.add(sasHome);
                ++count;
                continue;
            }
            more = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSupportedMajorRelease(String sasHome, String testVersion) {
        boolean valid = true;
        if (!(Globals.g_recordMode && Globals.g_recordOnly || sasHome == null || sasHome.length() <= 0)) {
            try (RegistryAccess registryAccess = null;){
                RegistryData.setRegistry(sasHome);
                registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                if (registryAccess != null && registryAccess.open()) {
                    valid = false;
                    if (registryAccess.containsMethod("getMajorReleases", new Class[0])) {
                        String[] versions = registryAccess.getMajorReleases();
                        for (int i = 0; !valid && i < versions.length; ++i) {
                            if (!testVersion.equals(versions[i])) continue;
                            valid = true;
                        }
                    }
                }
            }
        }
        return valid;
    }

    private boolean isValidUserID(String sasHome) {
        boolean valid = true;
        if (!(Globals.g_recordMode && Globals.g_recordOnly || sasHome == null || sasHome.length() <= 0)) {
            String lastUser;
            String user;
            block8: {
                user = null;
                user = Utils.getOS() == 1 ? Utils.getUserDomain() + "\\" + System.getProperty("user.name") : System.getProperty("user.name");
                lastUser = null;
                RegistryAccess registryAccess = null;
                try {
                    RegistryData.setRegistry(sasHome);
                    registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                    if (registryAccess != null && registryAccess.open()) {
                        lastUser = registryAccess.getInstallUser();
                        registryAccess.close();
                    }
                }
                catch (Exception e) {
                    if (registryAccess == null) break block8;
                    registryAccess.close();
                }
            }
            if (user != null && lastUser != null && !user.equals(lastUser)) {
                Logging.log.warning("The current user (" + user + ") is not the same user that last installed to this SAS Home location: " + lastUser);
                if (!Globals.g_skipAdminCheck && Utils.getOS() != 1 && Utils.getOS() != 6) {
                    valid = false;
                    if (Globals.g_quietMode) {
                        Wizard.logResponseInvalid(this.getHeader(), "SAS_HOME", sasHome, "The current user (" + user + ") is not the same user that last installed to the SAS Home location specified: " + lastUser);
                    } else {
                        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelSASHome.SASUserMsg.txt", user, lastUser), this.bundle.getString("Common.Warning.txt"), 2);
                    }
                }
            }
        }
        return valid;
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    class MaxLengthDocument
    extends PlainDocument {
        private int m_maxLength = 0;

        public MaxLengthDocument(int maxLength) {
            this.m_maxLength = maxLength;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (super.getLength() + str.length() <= this.m_maxLength) {
                super.insertString(offs, str, a);
            } else {
                super.insertString(offs, str.substring(0, this.m_maxLength - super.getLength()), a);
            }
        }
    }
}

