/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class PanelRemoveContent
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelRemoveContent.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_infoText = null;
    private JCheckBox m_removeContent = null;
    private boolean m_panelLoaded = false;

    public PanelRemoveContent() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelRemoveContent.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelRemoveContent.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        if (this.m_removeContent.isSelected()) {
            Globals.g_cmtRemoveFSContent = "true";
            if (Globals.g_quietMode) {
                Logging.log.info("User content will be unregistered for SAS Forecast Server.");
            }
        } else {
            Globals.g_cmtRemoveFSContent = "false";
        }
        return true;
    }

    @Override
    public boolean displayPanel() {
        boolean display = false;
        if (Globals.g_cmtTask == 2 && Globals.g_instances != null) {
            for (int i = 0; i < Globals.g_instances.length && !display; ++i) {
                if (!Globals.g_instances[i].getProdCode().equalsIgnoreCase("forecastsrvr")) continue;
                display = true;
            }
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        return "execute";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#REMOVE_FS_CONTENT=yes/no", " REMOVE_FS_CONTENT=no"};
        if (this.m_panelLoaded && this.m_removeContent.isSelected()) {
            data[1] = " REMOVE_FS_CONTENT=yes";
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int returnCode = ConsoleMode.promptBoolean(this.m_removeContent);
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("REMOVE_FS_CONTENT", null);
        if (response != null) {
            if (response.equalsIgnoreCase("yes")) {
                valid = true;
                this.m_removeContent.setSelected(true);
            } else if (response.equalsIgnoreCase("no")) {
                valid = true;
                this.m_removeContent.setSelected(false);
            } else if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "REMOVE_FS_CONTENT", response, null);
            }
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), "REMOVE_FS_CONTENT");
        }
        return valid;
    }

    private void initialize() {
        this.m_infoText = new JTextArea(this.bundle.getString("PanelRemoveContent.RemoveInfo.txt"));
        this.m_infoText.setEditable(false);
        this.m_infoText.setFocusable(false);
        this.m_infoText.setLineWrap(true);
        this.m_infoText.setWrapStyleWord(true);
        this.m_infoText.setOpaque(false);
        String mtxt = this.bundle.getString("PanelRemoveContent.RemoveContentOption.txt");
        this.m_removeContent = new JCheckBox(Util.getLabelWithoutMnemonic(mtxt));
        this.m_removeContent.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_removeContent.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_infoText, c);
        c.gridy = 1;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_removeContent, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

