/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.FindProxy;
import com.sas.ssn.Globals;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import com.sas.util.SasPasswordString;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;

public class PanelProxy
implements WizardPanelIface,
ActionListener {
    private SSNResource bundle = new SSNResource(PanelProxy.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_instructions = null;
    private JLabel m_serverLabel = null;
    private KitTextField m_server = null;
    private JLabel m_portLabel = null;
    private KitTextField m_port = null;
    private JCheckBox m_loginOption = null;
    private JLabel m_userNameLabel = null;
    private KitTextField m_userName = null;
    private JLabel m_passwordLabel = null;
    private JPasswordField m_password = null;
    private boolean m_panelLoaded = false;
    private boolean m_logSent = false;
    private boolean m_authRequired;

    public PanelProxy() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelProxy.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelProxy.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        this.m_server.setText(this.m_server.getText().trim().replaceFirst("http://", ""));
        this.m_server.setText(this.m_server.getText().trim().replaceFirst("https://", ""));
        this.m_port.setText(this.m_port.getText().trim());
        this.m_userName.setText(this.m_userName.getText().trim());
        if (!Globals.g_recordMode || !Globals.g_recordOnly) {
            if (!this.m_logSent) {
                if (!Globals.g_quietMode) {
                    Globals.g_wizardData.setPreference("UseProxyServer", true);
                    Globals.g_wizardData.setPreference("ProxyServer", this.m_server.getText());
                    Globals.g_wizardData.setPreference("ProxyPort", this.m_port.getText());
                    Globals.g_wizardData.setPreference("LoginProxyServer", this.m_loginOption.isSelected());
                    Globals.g_wizardData.setPreference("ProxyUser", this.m_userName.getText());
                }
                System.setProperty("http.proxySet", "true");
                System.setProperty("http.proxyHost", this.m_server.getText());
                System.setProperty("http.proxyPort", this.m_port.getText());
                System.setProperty("http.proxyType", "4");
                System.setProperty("http.proxyUser", this.m_loginOption.isSelected() ? this.m_userName.getText() : "");
                System.setProperty("http.proxyPassword", this.m_loginOption.isSelected() ? String.valueOf(this.m_password.getPassword()) : "");
                int proxyResults = FindProxy.findProxy();
                if (proxyResults == 0) {
                    if (Globals.g_mode == 1 || Globals.g_checkForHotFix) {
                        valid = true;
                    }
                } else if (proxyResults == 1) {
                    Logging.log.warning("Attempted to contact proxy, but received an AUTH required response");
                    if (!Globals.g_quietMode) {
                        String errorMsg = null;
                        errorMsg = Globals.g_kerberosproxy ? this.bundle.getString("PanelProxy.AuthErrorKerberos.txt") : (FindProxy.authSchemeNTLM() ? this.bundle.getString("PanelProxy.AuthErrorNTLM.txt") : this.bundle.getString("PanelProxy.AuthError.txt"));
                        CustMsgBox.showMessageDialog(null, errorMsg, this.bundle.getString("PanelProxy.ProxyErrorTitle.txt"), 0);
                    }
                    valid = false;
                } else if (proxyResults == 5) {
                    Logging.log.warning("Attempted to contact proxy, but received a certificate problem response.");
                    if (!Globals.g_quietMode) {
                        CustMsgBox.showMessageDialog(null, this.bundle.getString("PanelProxy.CertError.txt"), this.bundle.getString("PanelProxy.ProxyErrorTitle.txt"), 2);
                    }
                    valid = false;
                } else if (proxyResults == 2) {
                    Logging.log.warning("Attempted to contact proxy, but received an ERROR response");
                    if (!Globals.g_quietMode) {
                        CustMsgBox.showMessageDialog(null, this.bundle.getString("PanelProxy.Error.txt"), this.bundle.getString("PanelProxy.ProxyErrorTitle.txt"), 0);
                    }
                    valid = false;
                }
            }
            if (!valid && Globals.g_mode != 1) {
                if (Globals.g_quietMode) {
                    Logging.log.warning("Response data warning for:\n   Panel: " + this.getHeader() + "\n     Msg: A connection to the Internet could not be established.");
                } else if (CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelProxy.ErrorMsg.txt"), this.bundle.getString("Common.Warning.txt"), 0, 2, 0) == 0) {
                    valid = true;
                }
            }
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        boolean display = false;
        if (Globals.g_forceProxy || this.m_panelLoaded) {
            display = true;
        } else if (Globals.g_recordMode && Globals.g_recordOnly) {
            display = FindProxy.findProxy() != 0;
        } else {
            int proxyResults = FindProxy.findProxy();
            if (proxyResults == 0) {
                display = false;
            } else if (proxyResults == 1) {
                Logging.log.warning("Attempted to contact proxy, but received an AUTH required response");
                if (!Globals.g_quietMode) {
                    CustMsgBox.showMessageDialog(null, this.bundle.getString("PanelProxy.AuthError.txt"), this.bundle.getString("PanelProxy.ProxyErrorTitle.txt"), 2);
                }
                display = true;
                Globals.g_wizardData.setPreference("UseProxyServer", true);
                Globals.g_wizardData.setPreference("ProxyServer", FindProxy.getHost());
                Globals.g_wizardData.setPreference("ProxyPort", FindProxy.getPort());
                this.m_authRequired = true;
            } else if (proxyResults == 5) {
                if (!Globals.g_quietMode) {
                    CustMsgBox.showMessageDialog(null, this.bundle.getString("PanelProxy.CertError.txt"), this.bundle.getString("PanelProxy.ProxyErrorTitle.txt"), 2);
                }
                display = true;
            } else if (proxyResults == 2) {
                display = true;
            }
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = Globals.g_checkForHotFix ? "selectorder" : (Globals.g_mode == 1 ? (Globals.g_resumeESD ? "progress" : "orderinfo") : (Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired() ? "configmaint" : "finish"));
        return panelID;
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            if (this.m_server.getText().length() == 0) {
                this.m_server.setText(Globals.g_wizardData.getPreference("ProxyServer", ""));
            }
            if (this.m_port.getText().length() == 0) {
                this.m_port.setText(Globals.g_wizardData.getPreference("ProxyPort", ""));
            }
            if (this.m_authRequired) {
                this.m_loginOption.setSelected(true);
                this.m_authRequired = false;
            } else if (Wizard.getResponse("LOG_IN_TO_PROXY_SERVER", null) == null) {
                this.m_loginOption.setSelected(Globals.g_wizardData.getPreference("LoginProxyServer", false));
            }
            if (this.m_userName.getText().length() == 0) {
                this.m_userName.setText(Globals.g_wizardData.getPreference("ProxyUser", System.getProperty("user.name")));
            }
            this.setCheckState();
            if (wizardFramework.getFrame() != null && !wizardFramework.getFrame().isVisible()) {
                wizardFramework.getFrame().pack();
            }
            this.m_server.setPreferredSize(new Dimension(200, this.m_server.getPreferredSize().height));
            this.m_port.setPreferredSize(new Dimension(200, this.m_port.getPreferredSize().height));
            this.m_userName.setPreferredSize(new Dimension(200, this.m_userName.getPreferredSize().height));
            this.m_password.setPreferredSize(new Dimension(200, this.m_password.getPreferredSize().height));
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        if (!valid) {
            Logging.log.info("Error in finding proxy data -- but problem not severe enough to report silent install as failed");
        }
        return true;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#PROXY_HTTP_SERVER=<HTTP server>", " PROXY_HTTP_SERVER=", "#PROXY_PORT=<port number>", " PROXY_PORT=", "#LOG_IN_TO_PROXY_SERVER=yes/no", " LOG_IN_TO_PROXY_SERVER=no", "#PROXY_USER_NAME=<user name>", " PROXY_USER_NAME=", "#PROXY_PASSWORD=<password value>", " PROXY_PASSWORD="};
        if (this.m_panelLoaded) {
            data[1] = " PROXY_HTTP_SERVER=" + this.m_server.getText();
            data[3] = " PROXY_PORT=" + this.m_port.getText();
            if (this.m_loginOption.isSelected()) {
                data[5] = " LOG_IN_TO_PROXY_SERVER=yes";
            }
            data[7] = " PROXY_USER_NAME=" + this.m_userName.getText();
            String pwd = String.valueOf(this.m_password.getPassword());
            if (!SasPasswordString.isEncoded(pwd)) {
                try {
                    pwd = SasPasswordString.encode("sas002", pwd);
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
            }
            data[9] = " PROXY_PASSWORD=" + pwd;
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        ConsoleMode.printInfoText(this.m_instructions.getText());
        int returnCode = ConsoleMode.promptText(this.m_serverLabel.getText(), this.m_server);
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptText(this.m_portLabel.getText(), this.m_port);
        }
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptBoolean(this.m_loginOption);
        }
        if (returnCode > -1 && this.m_loginOption.isSelected()) {
            this.setCheckState();
            returnCode = ConsoleMode.promptText(this.m_userNameLabel.getText(), this.m_userName);
            if (returnCode > -1) {
                returnCode = ConsoleMode.promptPassword(this.m_passwordLabel.getText(), this.m_password);
            }
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("PROXY_HTTP_SERVER", null);
        if (response != null) {
            valid = true;
            this.m_server.setText(response);
        } else if (Globals.g_quietMode) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "PROXY_HTTP_SERVER");
        }
        response = Wizard.getResponse("PROXY_PORT", null);
        if (response != null) {
            this.m_port.setText(response);
        } else if (Globals.g_quietMode) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "PROXY_PORT");
        }
        response = Wizard.getResponse("LOG_IN_TO_PROXY_SERVER", null);
        if (response != null) {
            if (response.equalsIgnoreCase("yes")) {
                this.m_loginOption.setSelected(true);
            } else if (response.equalsIgnoreCase("no")) {
                this.m_loginOption.setSelected(false);
            } else if (Globals.g_quietMode) {
                valid = false;
                Wizard.logResponseInvalid(this.getHeader(), "LOG_IN_TO_PROXY_SERVER", response, null);
            }
        } else if (Globals.g_quietMode) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "LOG_IN_TO_PROXY_SERVER");
        }
        response = Wizard.getResponse("PROXY_USER_NAME", null);
        if (response != null) {
            this.m_userName.setText(response);
        } else if (Globals.g_quietMode) {
            if (this.m_loginOption.isSelected()) {
                valid = false;
            }
            Wizard.logResponseMissing(this.getHeader(), "PROXY_USER_NAME");
        }
        response = Wizard.getResponse("PROXY_PASSWORD", null);
        if (response != null) {
            if (SasPasswordString.isEncoded(response)) {
                try {
                    response = SasPasswordString.decode(response);
                }
                catch (Exception e) {
                    Logging.log.warning("Unable to decode the password for: " + response);
                    Logging.logStackTrace(e);
                }
            }
            this.m_password.setText(response);
        } else if (Globals.g_quietMode) {
            if (this.m_loginOption.isSelected()) {
                valid = false;
            }
            Wizard.logResponseMissing(this.getHeader(), "PROXY_PASSWORD");
        }
        return valid;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_loginOption) {
            this.setCheckState();
        }
    }

    private void initialize() {
        System.setProperty("http.proxySet", Globals.g_wizardData.getPreference("UseProxyServer", false) ? "true" : "false");
        System.setProperty("http.proxyHost", Globals.g_wizardData.getPreference("ProxyServer", ""));
        System.setProperty("http.proxyPort", Globals.g_wizardData.getPreference("ProxyPort", ""));
        System.setProperty("http.proxyType", "4");
        Logging.log.finer("Set Default proxy: " + Globals.g_wizardData.getPreference("ProxyServer", "") + ":" + Globals.g_wizardData.getPreference("ProxyPort", ""));
        if (Globals.g_wizardData.getPreference("LoginProxyServer", false)) {
            System.setProperty("http.proxyUser", Globals.g_wizardData.getPreference("ProxyUser", ""));
        }
        this.m_instructions = new JTextArea();
        if (Globals.g_mode == 1) {
            this.m_instructions.setText(this.bundle.getString("PanelProxy.InstructionsESD.txt"));
        } else {
            this.m_instructions.setText(this.bundle.getString("PanelProxy.Instructions.txt"));
        }
        this.m_instructions.setEditable(false);
        this.m_instructions.setFocusable(false);
        this.m_instructions.setLineWrap(true);
        this.m_instructions.setWrapStyleWord(true);
        this.m_instructions.setOpaque(false);
        this.m_server = new KitTextField();
        this.m_serverLabel = new JLabel(this.bundle.getString("PanelProxy.Server.txt"));
        this.m_serverLabel.setLabelFor(this.m_server);
        this.m_port = new KitTextField();
        this.m_portLabel = new JLabel(this.bundle.getString("PanelProxy.Port.txt"));
        this.m_portLabel.setLabelFor(this.m_port);
        String mtxt = this.bundle.getString("PanelProxy.LoginProxyServer.txt");
        this.m_loginOption = new JCheckBox(Util.getLabelWithoutMnemonic(mtxt));
        this.m_loginOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_loginOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_loginOption.getFont();
        this.m_loginOption.setFont(optionFont.deriveFont(1));
        this.m_userName = new KitTextField();
        this.m_userNameLabel = new JLabel(this.bundle.getString("PanelProxy.Userid.txt"));
        this.m_userNameLabel.setLabelFor(this.m_userName);
        this.m_password = new JPasswordField();
        this.m_passwordLabel = new JLabel(this.bundle.getString("PanelProxy.Password.txt"));
        this.m_passwordLabel.setLabelFor(this.m_password);
        this.m_loginOption.addActionListener(this);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.weighty = 1.0;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 10, 0);
        this.m_panel.add((Component)this.m_instructions, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_serverLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 0;
        c.insets = new Insets(10, 5, 5, 0);
        this.m_panel.add((Component)this.m_server, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_portLabel, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 0);
        this.m_panel.add((Component)this.m_port, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_loginOption, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_userNameLabel, c);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 0);
        this.m_panel.add((Component)this.m_userName, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_passwordLabel, c);
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 0);
        this.m_panel.add((Component)this.m_password, c);
    }

    private void initProxyInfo() {
        String server = "";
        String port = "80";
        String servers = WinRegAPI.getWindowsRegistryValue(4, "software\\microsoft\\windows\\currentversion\\internet settings", "proxyserver");
        if (servers != null && servers.length() > 0) {
            StringTokenizer sections = new StringTokenizer(servers, ";", false);
            while (sections != null && sections.hasMoreTokens()) {
                StringTokenizer tokens = new StringTokenizer(sections.nextToken(), "=", false);
                if (tokens.countTokens() != 2 || !tokens.nextToken().equalsIgnoreCase("http")) continue;
                if ((tokens = new StringTokenizer(tokens.nextToken(), ":", false)).countTokens() == 2) {
                    server = tokens.nextToken();
                    port = tokens.nextToken();
                }
                sections = null;
            }
        }
        this.m_server.setText(Globals.g_wizardData.getPreference("ProxyServer", server));
        this.m_port.setText(Globals.g_wizardData.getPreference("ProxyPort", port));
    }

    private void setCheckState() {
        this.m_userNameLabel.setEnabled(this.m_loginOption.isSelected());
        this.m_userName.setEnabled(this.m_loginOption.isSelected());
        this.m_passwordLabel.setEnabled(this.m_loginOption.isSelected());
        this.m_password.setEnabled(this.m_loginOption.isSelected());
    }
}

