/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.ConsoleModeEventDriven;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DeploymentData;
import com.sas.ssn.DepotManager;
import com.sas.ssn.DownloadLogger;
import com.sas.ssn.EsdControl;
import com.sas.ssn.EsdDownloadController;
import com.sas.ssn.EsdDownloadStats;
import com.sas.ssn.Globals;
import com.sas.ssn.HotfixData;
import com.sas.ssn.Logging;
import com.sas.ssn.ProgressBar;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SubsetData;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;

public class PanelProgress
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelProgress.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_headerText = null;
    private ProgressBar m_progressBar = null;
    private JLabel m_downloadImage = null;
    private JPanel m_downloadPanel = new JPanel(new GridBagLayout());
    private JLabel m_downloadStatusLabel = null;
    private JLabel m_downloadStatus = null;
    private JLabel m_downloadRateLabel = null;
    private JLabel m_downloadRate = null;
    private JLabel m_extractImage = null;
    private JPanel m_extractPanel = new JPanel(new GridBagLayout());
    private JLabel m_extractStatusLabel = null;
    private JLabel m_extractStatus = null;
    private JLabel m_extractRateLabel = null;
    private JLabel m_extractRate = null;
    private JEditorPane m_details = null;
    private JScrollPane m_scrollPane = null;
    private Timer m_timer = null;
    private ActionListener m_timerAction = null;
    private EsdDownloadController m_esdDC = null;
    private boolean m_panelLoaded = false;
    private boolean m_processing = true;
    private boolean m_downloadActive = false;
    private boolean m_extractActive = false;
    private int m_consoleValue = 0;
    private NumberFormat m_numberFormat = new DecimalFormat("#,##0.0");
    private int m_displayStatsInterval = 0;
    private boolean m_displayNotes = false;
    private AtomicInteger m_displayMsgs = new AtomicInteger();
    private boolean m_hotfixDownloadStopped = false;

    public PanelProgress() {
        Globals.g_panelProgress = this;
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        String header = null;
        header = Globals.g_mode == 1 ? (this.m_processing ? this.bundle.getString("PanelProgress.HeaderESD.txt") : this.bundle.getString("PanelProgress.FinishHeaderESD.txt")) : (this.m_processing ? this.bundle.getString("PanelProgress.Header.txt") : this.bundle.getString("PanelProgress.FinishHeader.txt"));
        return header;
    }

    @Override
    public String getHeaderDesc() {
        String headerDesc = null;
        headerDesc = Globals.g_mode == 1 ? (this.m_processing ? this.bundle.getString("PanelProgress.HeaderDescESD.txt") : this.bundle.getString("PanelProgress.FinishHeaderDescESD.txt")) : (this.m_processing ? this.bundle.getString("PanelProgress.HeaderDesc.txt") : this.bundle.getString("PanelProgress.FinishHeaderDesc.txt"));
        return headerDesc;
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        if (Globals.g_recordMode && Globals.g_recordOnly) {
            File downloadhfDirFile;
            this.m_timer.stop();
            this.m_processing = false;
            File downloadDirFile = new File(Globals.g_downloadDir);
            if (downloadDirFile.exists()) {
                Utils.deleteFolder(downloadDirFile);
            }
            if ((downloadhfDirFile = new File(Globals.g_downloadDir + "hf")).exists()) {
                Utils.deleteFolder(downloadhfDirFile);
            }
        }
        if (this.m_processing) {
            if (Globals.g_mode == 1) {
                if (CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelProgress.InterruptMsgESD.txt", this.bundle.getString("Common.ESDTitle.txt")), Globals.g_wizard.getWizardTitle(), 0, 3, 1) == 0) {
                    this.m_esdDC.stopDownload("userQuit");
                    Globals.g_hotfixData.deleteHotfixStagingDir();
                    this.m_timer.stop();
                    this.m_processing = false;
                    this.m_hotfixDownloadStopped = true;
                } else {
                    valid = false;
                }
            } else if (CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelProgress.InterruptMsg.txt"), Globals.g_wizard.getWizardTitle(), 0, 3, 1) == 0) {
                Globals.g_job.interrupt();
                if (Globals.g_ssdType != 0) {
                    Globals.g_depotManager.setLock(false);
                    Utils.deleteFolder(new File(Globals.g_ssdDestDir));
                }
                this.m_timer.stop();
                this.m_processing = false;
            } else {
                valid = false;
            }
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        if (!this.m_processing && Globals.g_job.getStatus() == 4 && Globals.g_depotCompressionStatus) {
            panelID = "finishssd";
        }
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            wizardFramework.clearWizardChain(true);
            String mtxt = null;
            mtxt = Globals.g_mode == 1 ? (Globals.g_recordMode && Globals.g_recordOnly ? this.bundle.getString("PanelProgress.FinishButton.txt") : this.bundle.getString("PanelProgress.StopButtonESD.txt")) : this.bundle.getString("PanelProgress.StopButton.txt");
            wizardFramework.getNextButton().setText(Util.getLabelWithoutMnemonic(mtxt));
            wizardFramework.getNextButton().setMnemonic(Util.getDisplayedMnemonic(mtxt));
            wizardFramework.getNextButton().setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            wizardFramework.getBackButton().setEnabled(false);
            wizardFramework.getCancelButton().setEnabled(false);
            if (Globals.g_consoleMode && Globals.g_mode != 1) {
                this.m_consoleValue = this.m_progressBar.getValue();
                ConsoleMode.busyMsgStart(Integer.toString(this.m_consoleValue) + "%");
            }
            this.startAction();
            this.m_timer.start();
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return Globals.g_mode != 1;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = false;
        this.startAction();
        if (Globals.g_job.getStatus() == 4) {
            if (((DepotManager.AddJob)Globals.g_job).getMode() == 1) {
                ((DepotManager.AddJob)Globals.g_job).setMode(2);
                Globals.g_job.run();
            }
            if (Globals.g_job.getStatus() == 4) {
                valid = true;
                Globals.g_depotManager.setDescription(Globals.g_order, Globals.g_orderDesc);
                Globals.g_depotManager.setNote(Globals.g_order, Globals.g_orderNotes);
            }
        } else if (Globals.g_mode == 1) {
            Logging.log.severe("Quiet mode failure during download.");
        } else {
            Logging.log.severe("Quiet mode failure when creating a SAS Software Depot.");
        }
        Globals.g_depotManager.setLock(false);
        return valid;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        if (Globals.g_mode == 1) {
            return this.consoleEventESD();
        }
        try {
            Globals.g_job.join();
        }
        catch (InterruptedException e) {
            Logging.logStackTrace(e);
        }
        this.m_processing = false;
        ConsoleMode.busyMsgStop();
        if (Globals.g_job.getStatus() == 4) {
            if (Globals.g_mode == 1) {
                ConsoleMode.printInfoText(this.bundle.getString("PanelProgress.FinishHeaderDescESD.txt"));
            } else {
                ConsoleMode.printInfoText(this.bundle.getString("PanelProgress.FinishHeaderDesc.txt"));
            }
        } else if (Globals.g_mode == 1) {
            ConsoleMode.printInfoText(this.bundle.getString("PanelProgress.ErrorHeaderDescESD.txt"));
        } else {
            ConsoleMode.printInfoText(this.bundle.getString("PanelProgress.ErrorHeaderDesc.txt"));
        }
        return ConsoleMode.promptPause();
    }

    public int consoleEventESD() {
        boolean redisplay = false;
        boolean finished = false;
        ConsoleMode.println(this.bundle.messageString("PanelProgress.ConsoleStart.txt"));
        ConsoleModeEventDriven.setDefaultTimeout(20);
        ConsoleModeEventDriven.start();
        while (this.m_processing && !finished) {
            if (!redisplay) {
                ConsoleModeEventDriven.readLine(0);
            } else {
                redisplay = false;
            }
            if (!this.m_processing) break;
            this.pauseMsgs();
            String[] options = new String[]{Util.getLabelWithoutMnemonic(this.bundle.getString("PanelProgress.ConsoleMenu.Resume.txt")), Util.getLabelWithoutMnemonic(this.bundle.getString("PanelProgress.ConsoleMenu.DisplayDownloadMsgs.txt")), Util.getLabelWithoutMnemonic(this.bundle.getString("PanelProgress.StopButtonESD.txt"))};
            String title = Util.getLabelWithoutMnemonic(this.bundle.getString("PanelProgress.ConsoleMenu.Title.txt"));
            ConsoleMode.println();
            ConsoleMode.printDivider();
            ConsoleMode.println();
            switch (ConsoleModeEventDriven.promptSingleChoice(options, null, title, 0, true)) {
                case 0: {
                    ConsoleModeEventDriven.println(Util.getLabelWithoutMnemonic(this.bundle.getString("PanelProgress.ConsoleMenu.Resuming.txt")));
                    break;
                }
                case 1: {
                    if (!this.m_displayNotes) {
                        ConsoleModeEventDriven.println(Util.getLabelWithoutMnemonic(this.bundle.getString("PanelProgress.ConsoleMenu.TurningNotesOn.txt")));
                        this.m_displayNotes = true;
                        break;
                    }
                    ConsoleModeEventDriven.println(Util.getLabelWithoutMnemonic(this.bundle.getString("PanelProgress.ConsoleMenu.TurningNotesOff.txt")));
                    this.m_displayNotes = false;
                    break;
                }
                case 2: {
                    ConsoleModeEventDriven.println(Util.getLabelWithoutMnemonic(this.bundle.getString("PanelProgress.ConsoleMenu.CancelDownload.txt")));
                    finished = true;
                    break;
                }
                default: {
                    redisplay = true;
                }
            }
            this.unpauseMsgs();
        }
        this.m_processing = false;
        if (Globals.g_job.getStatus() == 4) {
            if (Globals.g_mode == 1) {
                ConsoleMode.printInfoText(this.bundle.getString("PanelProgress.FinishHeaderDescESD.txt"));
            } else {
                ConsoleMode.printInfoText(this.bundle.getString("PanelProgress.FinishHeaderDesc.txt"));
            }
        } else if (Globals.g_mode == 1) {
            ConsoleMode.printInfoText(this.bundle.getString("PanelProgress.ErrorHeaderDescESD.txt"));
        } else {
            ConsoleMode.printInfoText(this.bundle.getString("PanelProgress.ErrorHeaderDesc.txt"));
        }
        ConsoleModeEventDriven.println(this.bundle.getString("ConsoleMode.PausePrompt.txt"));
        ConsoleModeEventDriven.readLineFinal();
        return 0;
    }

    private void initialize() {
        this.m_headerText = new JTextArea();
        if (Globals.g_mode == 1) {
            this.m_headerText.setText(this.bundle.messageString("PanelProgress.InfoLabelESD.txt", this.bundle.getString("Common.ESDTitle.txt")));
        } else {
            this.m_headerText.setText(this.bundle.getString("PanelProgress.InfoLabel.txt"));
        }
        this.m_headerText.setEditable(false);
        this.m_headerText.setFocusable(false);
        this.m_headerText.setLineWrap(true);
        this.m_headerText.setWrapStyleWord(true);
        this.m_headerText.setOpaque(false);
        this.m_progressBar = new ProgressBar(100.0, Globals.g_mode != 1, Globals.g_mode == 1);
        if (Globals.g_mode == 1) {
            this.m_downloadImage = new JLabel();
            this.m_downloadImage.setIcon(this.bundle.getImageIcon("Common.download_stop.image"));
            this.m_downloadPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.bundle.getString("PanelProgress.DownloadTitle.txt")));
            this.m_downloadStatusLabel = new JLabel(this.bundle.getString("PanelProgress.DownloadStatusLabel.txt"));
            this.m_downloadStatus = new JLabel();
            this.m_downloadRateLabel = new JLabel(this.bundle.getString("PanelProgress.DownloadRateLabel.txt"));
            this.m_downloadRate = new JLabel();
            this.m_extractImage = new JLabel();
            this.m_extractImage.setIcon(this.bundle.getImageIcon("Common.extract_stop.image"));
            this.m_extractPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.bundle.getString("PanelProgress.ExtractionTitle.txt")));
            this.m_extractStatusLabel = new JLabel(this.bundle.getString("PanelProgress.ExtractionStatusLabel.txt"));
            this.m_extractStatus = new JLabel();
            this.m_extractRateLabel = new JLabel(this.bundle.getString("PanelProgress.ExtractionRateLabel.txt"));
            this.m_extractRate = new JLabel();
            this.m_details = new JEditorPane();
            this.m_details.setOpaque(false);
            this.m_details.setEditable(false);
            this.m_details.setContentType("text/html");
            this.m_scrollPane = new JScrollPane(this.m_details);
        }
        this.m_timerAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelProgress.this.timerEvent();
            }
        };
        this.m_timer = Globals.g_mode == 1 ? new Timer(1000, this.m_timerAction) : new Timer(250, this.m_timerAction);
    }

    private void timerEvent() {
        if (Globals.g_mode == 1) {
            if (this.m_esdDC.isCanceled()) {
                Globals.g_wizard.exitWizard(-1);
            } else if (!this.m_esdDC.isAlive()) {
                this.updateStats();
                if (Globals.g_job.getStatus() == 4 && (Globals.g_hotfixData == null || Globals.g_hotfixData.getDownloadComplete()) && Globals.g_depotCompressionStatus) {
                    Globals.g_depotManager.setDescription(Globals.g_order, Globals.g_orderDesc);
                    Globals.g_depotManager.setNote(Globals.g_order, Globals.g_orderNotes);
                    this.m_progressBar.finished();
                    Globals.g_wizard.getHeader().setText(this.bundle.getString("PanelProgress.FinishHeaderESD.txt"));
                    Globals.g_wizard.getHeaderDesc().setText(this.bundle.getString("PanelProgress.FinishHeaderDescESD.txt"));
                    this.m_headerText.setText(this.bundle.getString("PanelProgress.FinishInfoLabelESD.txt"));
                } else {
                    this.m_progressBar.failed();
                    Globals.g_wizard.getHeader().setText(this.bundle.getString("PanelProgress.ErrorHeaderESD.txt"));
                    Globals.g_wizard.getHeaderDesc().setText(this.bundle.getString("PanelProgress.ErrorHeaderDescESD.txt"));
                    this.m_headerText.setText(this.bundle.getString("PanelProgress.ErrorInfoLabelESD.txt"));
                }
                String mtxt = this.bundle.getString("PanelProgress.FinishButton.txt");
                Globals.g_wizard.getNextButton().setText(Util.getLabelWithoutMnemonic(mtxt));
                Globals.g_wizard.getNextButton().setMnemonic(Util.getDisplayedMnemonic(mtxt));
                Globals.g_wizard.getNextButton().setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
                this.m_processing = false;
            } else {
                if (Globals.g_esdStats.resetProgressBarHappened()) {
                    this.m_progressBar.setStartValue(Globals.g_esdStats.getStartingCount());
                    this.m_progressBar.setMaxValue(Globals.g_esdStats.getTotalCount());
                    this.m_progressBar.reset();
                }
                this.m_progressBar.setCurrentValue(Globals.g_esdStats.getCurrCount());
                this.updateStats();
            }
        } else if (!Globals.g_job.isAlive()) {
            if (Globals.g_job.getStatus() == 4) {
                if (((DepotManager.AddJob)Globals.g_job).getMode() == 1) {
                    ((DepotManager.AddJob)Globals.g_job).setMode(2);
                    Globals.g_job.start();
                    return;
                }
            } else if (Globals.g_ssdType != 0) {
                Globals.g_depotManager.setLock(false);
                Utils.deleteFolder(new File(Globals.g_ssdDestDir));
            }
            if (Globals.g_job.getStatus() == 4) {
                Globals.g_depotManager.setDescription(Globals.g_order, Globals.g_orderDesc);
                Globals.g_depotManager.setNote(Globals.g_order, Globals.g_orderNotes);
                HotfixData hfdata = new HotfixData(Globals.g_order, HotfixData.HFMode.COPY, Globals.g_ssdDestDir);
                hfdata.copyHotfixes(Globals.g_deploymentData.getMediaRoot(), Globals.g_ssdDestDir);
                this.m_progressBar.finished();
                Globals.g_wizard.getHeader().setText(this.bundle.getString("PanelProgress.FinishHeader.txt"));
                Globals.g_wizard.getHeaderDesc().setText(this.bundle.getString("PanelProgress.FinishHeaderDesc.txt"));
                this.m_headerText.setText(this.bundle.getString("PanelProgress.FinishInfoLabel.txt"));
            } else if (Globals.g_recordMode && !Globals.g_recordOnly) {
                this.m_progressBar.failed();
                Globals.g_wizard.getHeader().setText(this.bundle.getString("PanelProgress.ErrorHeader.txt"));
                Globals.g_wizard.getHeaderDesc().setText(this.bundle.getString("PanelProgress.ErrorHeaderDesc.txt"));
                this.m_headerText.setText(this.bundle.getString("PanelProgress.ErrorInfoLabel.txt"));
            }
            String mtxt = this.bundle.getString("PanelProgress.FinishButton.txt");
            Globals.g_wizard.getNextButton().setText(Util.getLabelWithoutMnemonic(mtxt));
            Globals.g_wizard.getNextButton().setMnemonic(Util.getDisplayedMnemonic(mtxt));
            Globals.g_wizard.getNextButton().setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            Globals.g_depotManager.setLock(false);
            this.m_processing = false;
        } else {
            if (!this.m_progressBar.isPaused()) {
                this.m_progressBar.setCurrentValue(Globals.g_bytesMoved);
            }
            if (Globals.g_job.getStatus() == 2) {
                this.m_progressBar.pause();
            } else if (this.m_progressBar.isPaused()) {
                this.m_progressBar.resume();
            }
        }
        if (this.m_processing) {
            if (Globals.g_consoleMode && Globals.g_mode != 1 && this.m_consoleValue != this.m_progressBar.getValue()) {
                this.m_consoleValue = this.m_progressBar.getValue();
                ConsoleMode.busyMsgAddMsg(Integer.toString(this.m_consoleValue) + "%");
            }
        } else {
            this.m_timer.stop();
            Globals.g_wizard.getCancelButton().setEnabled(true);
            Globals.g_wizard.setWizardActive(false);
            Globals.g_wizard.enableButtons();
            if (Globals.g_consoleMode) {
                ConsoleModeEventDriven.breakReadLine();
            }
        }
        if (Globals.g_wizard.getFrame() != null) {
            Globals.g_wizard.getFrame().validate();
        }
    }

    private void updateStats() {
        double currDownload = Globals.g_esdStats.getCurrCount("DOWNLOAD") / 1048576.0;
        double totalDownload = Globals.g_esdStats.getTotalCount("DOWNLOAD") / 1048576.0;
        this.m_downloadStatus.setText(this.bundle.messageString("PanelProgress.DownloadStatus.txt", this.m_numberFormat.format(currDownload), this.m_numberFormat.format(totalDownload)));
        if (currDownload >= totalDownload) {
            this.m_downloadActive = false;
            this.m_downloadImage.setIcon(this.bundle.getImageIcon("Common.download_stop.image"));
        } else if (!this.m_downloadActive && currDownload > 0.0) {
            this.m_downloadActive = true;
            this.m_downloadImage.setIcon(this.bundle.getImageIcon("Common.download.image"));
        }
        double rateDownload = Globals.g_esdStats.getAvg("DOWNLOAD") / 1048576.0;
        if (rateDownload < 1.0) {
            this.m_downloadRate.setText(this.bundle.messageString("PanelProgress.DownloadRateSlow.txt", this.m_numberFormat.format(rateDownload * 1024.0)));
        } else {
            this.m_downloadRate.setText(this.bundle.messageString("PanelProgress.DownloadRate.txt", this.m_numberFormat.format(rateDownload)));
        }
        double currExtract = Globals.g_esdStats.getCurrCount("EXTRACT") / 1048576.0;
        double totalExtract = Globals.g_esdStats.getTotalCount("EXTRACT") / 1048576.0;
        this.m_extractStatus.setText(this.bundle.messageString("PanelProgress.ExtractionStatus.txt", this.m_numberFormat.format(currExtract), this.m_numberFormat.format(totalExtract)));
        if (currExtract >= totalExtract) {
            this.m_extractActive = false;
            this.m_extractImage.setIcon(this.bundle.getImageIcon("Common.extract_stop.image"));
        } else if (!this.m_extractActive && currExtract > 0.0) {
            this.m_extractActive = true;
            this.m_extractImage.setIcon(this.bundle.getImageIcon("Common.extract.image"));
        }
        double rateExtract = Globals.g_esdStats.getAvg("EXTRACT") / 1048576.0;
        if (rateExtract < 1.0) {
            this.m_extractRate.setText(this.bundle.messageString("PanelProgress.ExtractionRateSlow.txt", this.m_numberFormat.format(rateExtract * 1024.0)));
        } else {
            this.m_extractRate.setText(this.bundle.messageString("PanelProgress.ExtractionRate.txt", this.m_numberFormat.format(rateExtract)));
        }
        ArrayList<String> notes = null;
        if (Globals.g_consoleMode) {
            if (this.displayMsgs() && Globals.g_esdStats.newText()) {
                notes = Globals.g_esdStats.getNewText();
                if (this.m_displayNotes) {
                    for (String i : notes) {
                        ConsoleMode.println(i);
                    }
                }
            }
            if ((this.m_downloadActive || this.m_extractActive) && this.displayMsgs()) {
                if (this.m_displayStatsInterval++ % 5 == 0) {
                    ConsoleMode.println(this.m_downloadStatusLabel.getText() + " " + this.m_downloadStatus.getText() + ", " + this.m_downloadRateLabel.getText() + " " + this.m_downloadRate.getText() + System.getProperty("line.separator") + this.m_extractStatusLabel.getText() + " " + this.m_extractStatus.getText() + ", " + this.m_extractRateLabel.getText() + " " + this.m_extractRate.getText());
                } else if (this.m_displayStatsInterval % 20 == 0 && this.displayMsgs()) {
                    int i;
                    int percentage = this.m_progressBar.getValue();
                    StringBuilder displayPercentage = new StringBuilder(this.bundle.messageString("ProgressBar.Progress.txt"));
                    displayPercentage.append(" <");
                    for (i = 0; i < this.m_progressBar.getValue() / 2; ++i) {
                        displayPercentage.append("-");
                    }
                    displayPercentage.append(percentage);
                    displayPercentage.append("%");
                    for (i = this.m_progressBar.getValue() / 2; i < 50; ++i) {
                        displayPercentage.append("-");
                    }
                    displayPercentage.append(">");
                    ConsoleMode.println(displayPercentage.toString());
                    ConsoleMode.println(this.m_progressBar.getTimeRemaining().getText());
                }
            }
        } else if (Globals.g_esdStats.newText()) {
            String fontInfo = "<font size=-1 face=\"" + this.m_headerText.getFont().getFontName() + "\">";
            String listText = "<html>" + fontInfo;
            notes = Globals.g_esdStats.getText();
            for (int i = 0; i < notes.size(); ++i) {
                listText = listText + notes.get(i) + "<br>";
            }
            listText = listText + "</font></html>";
            this.m_details.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.m_details.setText(listText);
            this.m_details.revalidate();
        }
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_headerText, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = Globals.g_mode == 1 ? new Insets(20, 0, 0, 0) : new Insets(100, 30, 0, 30);
        this.m_panel.add((Component)this.m_progressBar, c);
        if (Globals.g_mode == 1) {
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            c.insets = new Insets(10, 0, 0, 0);
            this.m_panel.add((Component)this.m_downloadImage, c);
            this.layoutDownloadPanel();
            c.gridx = 1;
            c.gridy = 2;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 2;
            c.insets = new Insets(10, 10, 0, 0);
            this.m_panel.add((Component)this.m_downloadPanel, c);
            c.gridx = 2;
            c.gridy = 2;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            c.insets = new Insets(10, 10, 0, 0);
            this.m_panel.add((Component)this.m_extractImage, c);
            this.layoutExtractPanel();
            c.gridx = 3;
            c.gridy = 2;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 2;
            c.insets = new Insets(10, 10, 0, 0);
            this.m_panel.add((Component)this.m_extractPanel, c);
            c.gridx = 0;
            c.gridy = 3;
            c.gridwidth = 4;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            c.insets = new Insets(10, 0, 0, 0);
            this.m_panel.add((Component)this.m_scrollPane, c);
        }
    }

    private void layoutDownloadPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 10, 0, 0);
        this.m_downloadPanel.add((Component)this.m_downloadStatusLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(0, 5, 0, 10);
        this.m_downloadPanel.add((Component)this.m_downloadStatus, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(5, 10, 5, 0);
        this.m_downloadPanel.add((Component)this.m_downloadRateLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 10);
        this.m_downloadPanel.add((Component)this.m_downloadRate, c);
    }

    private void layoutExtractPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 10, 0, 0);
        this.m_extractPanel.add((Component)this.m_extractStatusLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(0, 5, 0, 10);
        this.m_extractPanel.add((Component)this.m_extractStatus, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(5, 10, 5, 0);
        this.m_extractPanel.add((Component)this.m_extractRateLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 10);
        this.m_extractPanel.add((Component)this.m_extractRate, c);
    }

    private void startAction() {
        if (Globals.g_mode == 1) {
            Globals.g_esdStats = new EsdDownloadStats();
            if (Globals.g_recordMode && Globals.g_recordOnly) {
                this.m_processing = false;
                this.m_timer.stop();
                return;
            }
            if (Globals.g_resumeESD) {
                String fullKey = Globals.g_wizardData.getPreference("InstallationKey", "");
                String orderNumber = Globals.g_wizardData.getPreference("OrderNumber", "");
                SubsetData.loadSubsetData();
                String jobOrderNumber = null;
                jobOrderNumber = Globals.g_subsetData != null && Globals.g_subsetData.isSubsetActive() ? Globals.g_subsetData.getSubsetOrderNumber() : orderNumber.substring(0, 6);
                if (fullKey.length() == 14) {
                    try {
                        EsdControl esdControl = new EsdControl(orderNumber, fullKey);
                        if (esdControl.isValid()) {
                            Globals.g_control = esdControl;
                            Globals.g_order = jobOrderNumber;
                            Globals.g_deploymentData = new DeploymentData(new File(Globals.g_ssdDestDir, "download"));
                            Globals.g_deploymentData.loadOrders();
                            Logging.log.finer("Order count from new Control file1: " + Globals.g_deploymentData.getOrderCount());
                            if (Globals.g_deploymentData.getOrderCount() < 1) {
                                Logging.log.severe("Bad order information--expected getOrderCount to return >0 entries.");
                                DownloadLogger dl = new DownloadLogger();
                                dl.finalStatus("badControl");
                                dl.Send();
                                if (!Globals.g_quietMode) {
                                    CustMsgBox.showMessageDialog(null, this.bundle.messageString("EsdDownloadController.BadOrder.txt"), this.bundle.getString("Common.Error.txt"), 0);
                                }
                                Globals.g_kit.exitKit(-1);
                            }
                            Globals.g_depotManager = new DepotManager(Globals.g_ssdDestDir);
                            Globals.g_depotManager.setLock(true);
                            Globals.g_job = Globals.g_depotManager.createAddJob(Globals.g_deploymentData, jobOrderNumber);
                            ((DepotManager.AddJob)Globals.g_job).setMode(3);
                            if (Globals.g_subsetData != null && Globals.g_subsetData.isSubsetActive()) {
                                Globals.g_subsetData.omitSkus();
                            }
                            Globals.g_control.setAltSkuList(Globals.g_job.getSpsSkusToProcess());
                            if (!Globals.g_noHotFix) {
                                Globals.g_hotfixData = new HotfixData(Globals.g_order);
                                Globals.g_hotfixData.grabAndAnalyzeHotfixes();
                            }
                        } else {
                            esdControl.checkCancelAndDie();
                            esdControl.checkHoldAndDie();
                            Logging.log.severe("Something went wrong with grabbing the control file during resume, terminating.");
                            Globals.g_kit.exitKit(-1);
                        }
                        this.m_progressBar.resume();
                    }
                    catch (IOException e) {
                        Logging.log.severe(e.getMessage());
                        Logging.log.severe("Terminating due to not being able to download control file");
                        Logging.logStackTrace(e);
                        if (!Globals.g_quietMode) {
                            CustMsgBox.showMessageDialog(null, this.bundle.messageString("EsdDownloadController.BadOrder.txt"), this.bundle.getString("Common.Error.txt"), 0);
                        }
                        Globals.g_kit.exitKit(-1);
                    }
                } else {
                    Logging.log.severe("Key is not 14 characters--can not resume, termination.");
                    if (!Globals.g_quietMode) {
                        CustMsgBox.showMessageDialog(null, this.bundle.messageString("EsdDownloadController.BadOrder.txt"), this.bundle.getString("Common.Error.txt"), 0);
                    }
                    Globals.g_kit.exitKit(-1);
                }
            }
            if (!Globals.g_resumeESD || !Globals.g_esdStats.loadStats()) {
                long totalDownload = Globals.g_control.getRemainingDownloadSize();
                Globals.g_esdStats.addTask("DOWNLOAD", totalDownload);
                Globals.g_esdStats.addTask("EXTRACT", Globals.g_control.getRemainingExtractSize());
                Globals.g_esdStats.addTask("JOB", 100000000);
            }
            this.m_esdDC = new EsdDownloadController();
            if (Globals.g_quietMode) {
                this.m_esdDC.run();
            } else {
                this.m_progressBar.setMaxValue(Globals.g_esdStats.getTotalCount());
                if (Globals.g_resumeESD) {
                    this.m_progressBar.setStartValue(Globals.g_esdStats.getCurrCount());
                } else {
                    this.m_progressBar.setCurrentValue(1.0);
                }
                this.m_esdDC.start();
            }
        } else {
            if (Globals.g_recordMode && Globals.g_recordOnly) {
                this.m_processing = false;
                this.m_timer.stop();
                return;
            }
            if (Globals.g_quietMode) {
                Globals.g_job.run();
                HotfixData hfdata = new HotfixData(Globals.g_order, HotfixData.HFMode.COPY, Globals.g_ssdDestDir);
                hfdata.copyHotfixes(Globals.g_deploymentData.getMediaRoot(), Globals.g_ssdDestDir);
                Globals.g_depotManager.setDescription(Globals.g_order, Globals.g_orderDesc);
                Globals.g_depotManager.setNote(Globals.g_order, Globals.g_orderNotes);
            } else {
                this.m_progressBar.setMaxValue(Globals.g_job.getTotalSize());
                Globals.g_job.start();
            }
        }
    }

    @Override
    public String getHelpTopic() {
        String helpTopic = null;
        helpTopic = Globals.g_mode == 1 ? "PanelProgressESD" : "PanelProgressMedia";
        return helpTopic;
    }

    public void pauseProgressBar() {
        this.m_progressBar.pause();
    }

    public void resumeProgressBar() {
        this.m_progressBar.resume();
    }

    private boolean displayMsgs() {
        return this.m_displayMsgs.intValue() == 0;
    }

    public void pauseMsgs() {
        this.m_displayMsgs.incrementAndGet();
    }

    public void unpauseMsgs() {
        if (this.m_displayMsgs.decrementAndGet() < 0) {
            this.m_displayMsgs.set(0);
        }
    }

    public boolean getHotfixDownloadStopped() {
        return this.m_hotfixDownloadStopped;
    }
}

