/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DynamicDialogs;
import com.sas.ssn.Globals;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.MigrationSchema;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PanelPortRemap
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelPortRemap.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_infoMessage = null;
    private JTable m_componentTable = null;
    private PortRemapTableModel m_componentTableModel = new PortRemapTableModel();
    private boolean m_panelLoaded = false;
    private String m_previousSchema = "";
    private String m_previousMachine = "";
    private String m_previousPlanMachine = "";
    private String[] m_previousPlanConfigs = null;
    private HashMap m_responsePorts = null;

    public PanelPortRemap() {
        this.initialize();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelPortRemap.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelPortRemap.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        if (!Globals.g_quietMode && this.m_componentTable.getCellEditor() != null) {
            this.m_componentTable.getCellEditor().stopCellEditing();
        }
        boolean valid = true;
        String errMsg = null;
        for (PortRemapData data : this.m_componentTableModel.getList()) {
            if (Utils.isValidPortNumber(data.getPort())) continue;
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "PORT_REMAP", data.getPort(), null);
            }
            errMsg = this.bundle.messageString("PanelPortRemap.NotValidPort.txt", data.getPort(), data.getName());
        }
        if (!valid && !Globals.g_quietMode) {
            if (errMsg != null) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
            }
            this.m_componentTable.requestFocus();
        }
        if (valid) {
            DynamicDialogs.loadConfigDialogs();
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return Globals.g_migrate;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = Globals.g_dynamicConfigDialogs != null && Globals.g_dynamicConfigDialogs.length > 0 ? Globals.g_dynamicConfigDialogs[0] : "execute";
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        boolean diffPlannedConfigs;
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
        boolean diffSMUTier = !Globals.g_smuMachine.equals(this.m_previousMachine);
        boolean diffPlanFileMachine = !Globals.g_machine.getName().equals(this.m_previousPlanMachine);
        boolean diffSchemaPath = !Globals.g_migrationSchema.getFile().getAbsolutePath().equals(this.m_previousSchema);
        boolean bl = diffPlannedConfigs = !Arrays.deepEquals(Globals.g_planConfigs, this.m_previousPlanConfigs);
        if (diffSMUTier || diffPlanFileMachine || diffSchemaPath || diffPlannedConfigs) {
            this.m_previousMachine = Globals.g_smuMachine;
            this.m_previousPlanMachine = Globals.g_machine.getName();
            this.m_previousSchema = Globals.g_migrationSchema.getFile().getAbsolutePath();
            this.m_previousPlanConfigs = Globals.g_planConfigs;
            this.populate();
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_componentTable;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            this.populate();
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        if (Globals.g_quietMode && Globals.g_recordMode) {
            return null;
        }
        ArrayList<String> data = new ArrayList<String>();
        ArrayList<PortRemapData> remapList = this.m_componentTableModel.getList();
        if (this.m_panelLoaded) {
            int count = 0;
            for (int i = 0; i < remapList.size(); ++i) {
                data.add(" PORT_REMAP" + Integer.toString(++count) + "=" + remapList.get(i).getPort());
            }
        }
        return data.toArray(new String[0]);
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        ConsoleMode.printInfoText(this.bundle.getString("PanelPortRemap.ConsoleInfo.txt"));
        ArrayList componentIds = this.m_componentTableModel.getComponentIds();
        HashMap components = this.m_componentTableModel.getComponents();
        String[] options = new String[componentIds.size()];
        String id = null;
        PortRemapData data = null;
        for (int i = 0; i < componentIds.size(); ++i) {
            id = (String)componentIds.get(i);
            data = (PortRemapData)components.get(id);
            options[i] = data.getName() + "~" + data.getOldPort() + "~" + data.getPort();
        }
        int selection = 0;
        int selectedrow = 0;
        String header = this.bundle.getString("PanelPortRemap.LabelColumn.txt") + "~" + this.bundle.getString("PanelPortRemap.ConsoleOldPortColumn.txt") + "~" + this.bundle.getString("PanelPortRemap.ConsoleNewPortColumn.txt");
        KitTextField portField = new KitTextField();
        while (selection > -1 && selection < options.length) {
            selection = ConsoleMode.promptSingleChoice(options, null, header, options.length);
            if (selection <= -1 || selection >= options.length) continue;
            id = (String)componentIds.get(selection);
            data = (PortRemapData)components.get(id);
            portField.setText(data.getPort());
            ConsoleMode.printInfoText(this.bundle.messageString("PanelPortRemap.ConsoleOldPortLabel.txt", data.getOldPort()));
            selectedrow = selection;
            selection = ConsoleMode.promptText(this.bundle.getString("PanelPortRemap.ConsoleNewPortLabel.txt"), portField);
            if (selection != 0) continue;
            String newPort = portField.getText().trim();
            if (!Utils.isValidPortNumber(newPort)) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelPortRemap.NotValidPort.txt", newPort, data.getName()), this.bundle.getString("Common.Warning.txt"), 2);
                continue;
            }
            data.setPort(newPort);
            options[selectedrow] = data.getName() + "~" + data.getOldPort() + "~" + data.getPort();
        }
        return selection;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        boolean found = true;
        int productCount = 1;
        String responsePort = null;
        while (found) {
            responsePort = Wizard.getResponse("PORT_REMAP" + Integer.toString(productCount), null);
            if (responsePort == null) {
                found = false;
            } else {
                if (productCount == 1) {
                    this.m_responsePorts = new HashMap();
                }
                this.m_responsePorts.put("PORT_REMAP" + Integer.toString(productCount), responsePort.toLowerCase(Locale.ENGLISH));
            }
            ++productCount;
        }
        return valid;
    }

    private void initialize() {
        this.m_infoMessage = new JTextArea(this.bundle.getString("PanelPortRemap.Information.txt"));
        this.m_infoMessage.setEditable(false);
        this.m_infoMessage.setFocusable(false);
        this.m_infoMessage.setLineWrap(true);
        this.m_infoMessage.setWrapStyleWord(true);
        this.m_infoMessage.setOpaque(false);
        this.m_infoMessage.setVisible(true);
        this.m_componentTable = new JTable(this.m_componentTableModel){

            @Override
            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                super.changeSelection(rowIndex, 2, toggle, extend);
            }
        };
        this.m_componentTable.setCellSelectionEnabled(true);
        this.m_componentTable.setSelectionMode(0);
        this.m_componentTable.requestFocus();
        this.m_componentTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelPortRemap.this.m_componentTable.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        JScrollPane tablePane = new JScrollPane(this.m_componentTable);
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(10, 5, 0, 0);
        this.m_panel.add((Component)this.m_infoMessage, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)tablePane, c);
    }

    private void installRenderers() {
        this.m_componentTable.getColumnModel().getColumn(0).setCellRenderer(new StringCellRenderer());
        this.m_componentTable.getColumnModel().getColumn(1).setCellRenderer(new StringCellRenderer());
        JTextField textField = new JTextField();
        textField.setBorder(BorderFactory.createEmptyBorder());
        this.m_componentTable.getColumnModel().getColumn(2).setCellRenderer(new PortRemapDataCellRenderer());
        this.m_componentTable.getColumnModel().getColumn(2).setCellEditor(new PortRemapDataCellEditor(textField));
        TableColumn column = this.m_componentTable.getColumnModel().getColumn(0);
        int minWidth = Utils.getMinColumnWidth(this.m_componentTable, 0);
        int width = Utils.getPreferredColumnWidth(this.m_componentTable, 0);
        column.setMinWidth(minWidth);
        column.setPreferredWidth(width);
        column.setMaxWidth(width * 2);
        column = this.m_componentTable.getColumnModel().getColumn(1);
        minWidth = Utils.getMinColumnWidth(this.m_componentTable, 1);
        width = Utils.getPreferredColumnWidth(this.m_componentTable, 1);
        column.setMinWidth(minWidth);
        column.setPreferredWidth(width);
        column.setMaxWidth(width * 2);
        column = this.m_componentTable.getColumnModel().getColumn(2);
        minWidth = Utils.getMinColumnWidth(this.m_componentTable, 2);
        width = Utils.getPreferredColumnWidth(this.m_componentTable, 2);
        column.setMinWidth(minWidth);
        column.setPreferredWidth(width);
        column.setMaxWidth(width * 2);
        this.m_componentTable.getTableHeader().setResizingAllowed(true);
        this.m_componentTable.getTableHeader().setReorderingAllowed(false);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    private void populate() {
        this.m_componentTableModel.load();
        int rowHeight = Utils.getPreferredRowHeight(this.m_componentTable);
        if (rowHeight > 0) {
            this.m_componentTable.setRowHeight(rowHeight);
        }
    }

    class PortRemapTableModel
    extends AbstractTableModel {
        public static final int COMPONENT_NAME_COLUMN = 0;
        public static final int COMPONENT_OLDPORT_COLUMN = 1;
        public static final int COMPONENT_NEWPORT_COLUMN = 2;
        protected String[] m_columnNames;
        protected HashMap m_components = new HashMap();
        protected ArrayList m_componentIds = new ArrayList();

        public PortRemapTableModel() {
            this.m_columnNames = new String[]{PanelPortRemap.this.bundle.getString("PanelPortRemap.LabelColumn.txt"), PanelPortRemap.this.bundle.getString("PanelPortRemap.OldPortColumn.txt"), PanelPortRemap.this.bundle.getString("PanelPortRemap.NewPortColumn.txt")};
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.m_columnNames[index];
        }

        public Class getColumnClass(int index) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.m_components.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int colIndex) {
            String id = (String)this.m_componentIds.get(rowIndex);
            if (id != null) {
                PortRemapData component = (PortRemapData)this.m_components.get(id);
                if (colIndex == 0) {
                    if (Globals.g_debug) {
                        return component.getName() + ":  (" + component.getProperty() + ")";
                    }
                    return component.getName();
                }
                if (colIndex == 1) {
                    return component.getOldPort();
                }
                if (colIndex == 2) {
                    return component.getPort();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int colIndex) {
            String id = (String)this.m_componentIds.get(rowIndex);
            return id != null && colIndex == 2;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int colIndex) {
            String id = (String)this.m_componentIds.get(rowIndex);
            if (id != null && colIndex == 2) {
                PortRemapData component = (PortRemapData)this.m_components.get(id);
                component.setPort((String)value);
                this.fireTableCellUpdated(rowIndex, colIndex);
                this.fireTableDataChanged();
            }
        }

        public boolean hasPortConflict(int rowIndex) {
            String id = (String)this.m_componentIds.get(rowIndex);
            if (id != null) {
                PortRemapData port = (PortRemapData)this.m_components.get(id);
                for (int i = 0; i < this.m_componentIds.size(); ++i) {
                    String id2 = (String)this.m_componentIds.get(i);
                    PortRemapData data = (PortRemapData)this.m_components.get(id2);
                    if (port.getIdentifier().equals(data.getIdentifier()) || !port.getPort().equals(data.getPort())) continue;
                    return true;
                }
            }
            return false;
        }

        public ArrayList<PortRemapData> getList() {
            ArrayList<PortRemapData> remapList = new ArrayList<PortRemapData>();
            for (int i = 0; i < this.m_componentIds.size(); ++i) {
                String id = (String)this.m_componentIds.get(i);
                if (id == null) continue;
                PortRemapData data = (PortRemapData)this.m_components.get(id);
                remapList.add(data);
            }
            return remapList;
        }

        public void load() {
            this.m_components.clear();
            this.m_componentIds.clear();
            try {
                Globals.g_migrationSchema = new MigrationSchema(Globals.g_migrationSchemaFile);
            }
            catch (Exception e) {
                Logging.log.severe(e.getMessage());
                Logging.logStackTrace(e);
            }
            MigrationSchema.Tier newTier = Globals.g_migrationSchema.getNewTierWithName(Globals.g_machine.getName());
            if (newTier == null) {
                newTier = Globals.g_migrationSchema.addNewTier(Globals.g_smuMachine);
            }
            this.loadPortRemapData(newTier);
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelPortRemap.this.installRenderers();
        }

        public ArrayList getComponentIds() {
            return this.m_componentIds;
        }

        public HashMap getComponents() {
            return this.m_components;
        }

        private void loadPortRemapData(MigrationSchema.Tier newTier) {
            ArrayList products = newTier.getProducts();
            int response = 1;
            Globals.g_migrate = false;
            DynamicDialogs.loadDialogDefaults(null, 0);
            Globals.g_migrate = true;
            List<String> plannedConfigs = Arrays.asList(Globals.g_planConfigs);
            for (int i = 0; i < products.size(); ++i) {
                String prodCode = ((MigrationSchema.Product)products.get(i)).getID();
                String disable = Globals.g_configDefaults.getDefault(prodCode + ".portremap.disable", "false");
                if (disable.equalsIgnoreCase("true") || !plannedConfigs.contains(prodCode)) continue;
                ArrayList deployments = ((MigrationSchema.Product)products.get(i)).getDeployments();
                for (int j = 0; j < deployments.size(); ++j) {
                    Element deployment = ((MigrationSchema.Deployment)deployments.get(j)).getElement();
                    NodeList ports = deployment.getElementsByTagName("port");
                    for (int k = 0; k < ports.getLength(); ++k) {
                        Element port = (Element)ports.item(k);
                        response = this.setPortData(prodCode, port, deployment, response);
                    }
                }
            }
        }

        private int setPortData(String prodCode, Element port, Element deployment, int response) {
            String url = port.getAttribute("URL");
            String property = port.getAttribute("sdwprop");
            String propDisable = Globals.g_configDefaults.getDefault(prodCode + ".portremap." + property + ".disable", "false");
            if (!propDisable.equalsIgnoreCase("true")) {
                String oldPort = Globals.g_migrationSchema.getOldPort(Globals.g_smuMachine, prodCode, deployment.getAttribute("URL"), url, property);
                String label = this.getLabel(prodCode, property, port, deployment);
                PortRemapData remapData = new PortRemapData(prodCode, deployment, port, oldPort, label);
                if (PanelPortRemap.this.m_responsePorts != null) {
                    remapData.setPort((String)PanelPortRemap.this.m_responsePorts.get("PORT_REMAP" + response));
                    ++response;
                }
                String remapKey = url + property;
                this.m_componentIds.add(remapKey);
                this.m_components.put(remapKey, remapData);
            }
            return response;
        }

        private String getLabel(String prodCode, String property, Element port, Element deployment) {
            String name = null;
            name = port.hasAttribute("functionLabel") && port.getAttribute("functionLabel").length() > 0 ? port.getAttribute("functionLabel") : (deployment.hasAttribute("label") ? deployment.getAttribute("label") : Globals.g_migrationSchema.getProductName(Globals.g_smuMachine, prodCode));
            String label = Globals.g_configDefaults.getDefault(prodCode + ".portremap." + property + ".label", name);
            return label;
        }
    }

    class PortRemapData {
        protected String m_prodcode = null;
        protected String m_oldPort = null;
        protected Element m_deployment = null;
        protected Element m_newPort = null;
        protected String m_label = null;

        public PortRemapData(String prodCode, Element deployment, Element port, String oldPort, String label) {
            this.m_prodcode = prodCode;
            this.m_deployment = deployment;
            this.m_newPort = port;
            this.m_oldPort = oldPort;
            this.m_label = label;
        }

        public String getCode() {
            return this.m_prodcode;
        }

        public String getOldPort() {
            return this.m_oldPort;
        }

        public String getPort() {
            return this.m_newPort.getTextContent();
        }

        public void setPort(String port) {
            this.m_newPort.setTextContent(port);
        }

        public String getName() {
            return this.m_label;
        }

        public boolean doConfig() {
            return true;
        }

        public void setConfig(boolean config) {
        }

        public String getIdentifier() {
            return this.m_deployment.getAttribute("URL");
        }

        public String getProperty() {
            return this.m_newPort.getAttribute("sdwprop");
        }
    }

    private class StringCellRenderer
    extends DefaultTableCellRenderer {
        private StringCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.setText(value.toString());
            } else {
                this.setText("");
            }
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
            return this;
        }
    }

    private class PortRemapDataCellRenderer
    extends JTextField
    implements TableCellRenderer {
        public PortRemapDataCellRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            PortRemapTableModel model = (PortRemapTableModel)table.getModel();
            if (model.hasPortConflict(row)) {
                Font oldFont = this.getFont();
                Font newFont = new Font(oldFont.getName(), 1, oldFont.getSize());
                this.setFont(newFont);
            } else {
                Font oldFont = this.getFont();
                Font newFont = new Font(oldFont.getName(), 0, oldFont.getSize());
                this.setFont(newFont);
            }
            this.setText(value.toString());
            if (isSelected) {
                this.requestFocusInWindow();
                table.editCellAt(row, column);
            }
            return this;
        }
    }

    private class PortRemapDataCellEditor
    extends DefaultCellEditor {
        private JTextField m_textField;

        public PortRemapDataCellEditor(JTextField field) {
            super(field);
            this.clickCountToStart = 0;
            this.m_textField = field;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            PortRemapTableModel model = (PortRemapTableModel)table.getModel();
            if (model.hasPortConflict(row)) {
                Font oldFont = this.m_textField.getFont();
                Font newFont = new Font(oldFont.getName(), 1, oldFont.getSize());
                this.m_textField.setFont(newFont);
            } else {
                Font oldFont = this.m_textField.getFont();
                Font newFont = new Font(oldFont.getName(), 0, oldFont.getSize());
                this.m_textField.setFont(newFont);
            }
            this.m_textField.setText(value.toString());
            if (isSelected) {
                this.m_textField.setForeground(table.getSelectionForeground());
                this.m_textField.setBackground(table.getSelectionBackground());
            } else {
                this.m_textField.setForeground(table.getForeground());
                this.m_textField.setBackground(table.getBackground());
            }
            return this.m_textField;
        }
    }
}

