/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import com.sas.util.SasPasswordString;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class PanelPassword
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelPassword.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JLabel m_userLabel = null;
    private KitTextField m_userField = null;
    private JLabel m_passwordLabel = null;
    private JPasswordField m_passwordField = null;
    private JLabel m_confirmLabel = null;
    private JPasswordField m_confirmField = null;
    private String[] m_instanceIDs = null;
    private boolean m_panelLoaded = false;
    private int m_index = 0;
    private String m_userID = null;
    private String m_responseKey = null;
    private HashMap m_instanceProp = null;

    public PanelPassword(int index, String userID, String[] instanceIDs, HashMap instanceProp) {
        this.m_index = index;
        this.m_userID = userID;
        this.m_instanceIDs = instanceIDs;
        this.m_instanceProp = instanceProp;
        this.m_responseKey = "PASSWORD_FOR" + Utils.stringReplaceAll(userID, " ", "_");
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelPassword.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.messageString("PanelPassword.HeaderDesc.txt", this.m_userID);
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        String password = null;
        String confirm = null;
        String errMsg = null;
        password = String.valueOf(this.m_passwordField.getPassword());
        if (!password.equals(confirm = String.valueOf(this.m_confirmField.getPassword()))) {
            valid = false;
            errMsg = this.bundle.getString("PanelPassword.PasswordInvalid.txt");
        } else if (password.length() < 6) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), this.bundle.getString("PanelPassword.PasswordFieldName.txt"), "", "Password must be at least 6 characters long for \"" + this.m_userID + "\".");
            } else {
                errMsg = this.bundle.getString("PanelPassword.MinPasswordLen.txt");
            }
        }
        if (valid) {
            if (!SasPasswordString.isEncoded(password)) {
                try {
                    password = SasPasswordString.encode("sas002", password);
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
            }
            boolean found = false;
            String fqid = null;
            String propName = null;
            ProductData prodData = null;
            for (int i = 0; i < this.m_instanceIDs.length; ++i) {
                fqid = this.m_instanceIDs[i];
                found = false;
                for (int j = 0; !found && j < Globals.g_instances.length; ++j) {
                    prodData = Globals.g_instances[j];
                    if (!prodData.getInstanceData().getFQID().equals(fqid)) continue;
                    found = true;
                    propName = (String)this.m_instanceProp.get(fqid);
                    prodData.getInstanceData().getProperties().setProperty(propName, password);
                }
            }
        } else if (!Globals.g_quietMode) {
            if (errMsg != null) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
            }
            this.m_passwordField.requestFocus();
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = this.m_index < Globals.g_cmtPasswordDialogs.length - 1 ? Globals.g_cmtPasswordDialogs[this.m_index + 1] : "execute";
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_passwordField;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#" + this.m_responseKey + "=<password value>", " " + this.m_responseKey + "="};
        if (this.m_panelLoaded) {
            String value = String.valueOf(this.m_passwordField.getPassword());
            try {
                if (!SasPasswordString.isEncoded(value)) {
                    value = SasPasswordString.encode("sas002", value);
                }
                data[1] = " " + this.m_responseKey + "=" + value;
            }
            catch (Exception e) {
                Logging.log.severe("Unable to encode the password for: " + this.m_responseKey);
                Logging.logStackTrace(e);
            }
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int returnCode = ConsoleMode.promptText(this.m_userLabel.getText(), this.m_userField);
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptPassword(this.m_passwordLabel.getText(), this.m_passwordField);
        }
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptPassword(this.m_confirmLabel.getText(), this.m_confirmField);
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        String response = Wizard.getResponse(this.m_responseKey, null);
        if (response != null) {
            String decodedPassword = null;
            try {
                decodedPassword = SasPasswordString.decode(response);
                this.m_passwordField.setText(decodedPassword);
                this.m_confirmField.setText(decodedPassword);
            }
            catch (Exception e) {
                Logging.log.warning("Unable to decode the password for: " + this.m_responseKey);
                Logging.logStackTrace(e);
            }
        } else {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), this.m_responseKey);
            }
        }
        return valid;
    }

    private void initialize() {
        this.m_userField = new KitTextField(this.m_userID);
        this.m_userField.setEditable(false);
        this.m_userField.setFocusable(false);
        String mtxt = this.bundle.getString("PanelPassword.UserLabel.txt");
        this.m_userLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_userLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_userLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_userLabel.setLabelFor(this.m_userField);
        this.m_passwordField = new JPasswordField();
        mtxt = this.bundle.getString("PanelPassword.PasswordLabel.txt");
        this.m_passwordLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_passwordLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_passwordLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_passwordLabel.setLabelFor(this.m_passwordField);
        this.m_confirmField = new JPasswordField();
        mtxt = this.bundle.getString("PanelPassword.ConfirmLabel.txt");
        this.m_confirmLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_confirmLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_confirmLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_confirmLabel.setLabelFor(this.m_confirmField);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        c.gridy = 0;
        this.m_panel.add((Component)this.m_userLabel, c);
        c.gridy = 1;
        this.m_panel.add((Component)this.m_userField, c);
        c.gridy = 2;
        this.m_panel.add((Component)this.m_passwordLabel, c);
        c.gridy = 3;
        this.m_panel.add((Component)this.m_passwordField, c);
        c.gridy = 4;
        this.m_panel.add((Component)this.m_confirmLabel, c);
        c.gridy = 5;
        this.m_panel.add((Component)this.m_confirmField, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

