/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.AdvKeyField;
import com.sas.ssn.AdvOrderField;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.ConsoleModeEventDriven;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DeploymentData;
import com.sas.ssn.DownloadLogger;
import com.sas.ssn.EsdControl;
import com.sas.ssn.Globals;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.DefaultEditorKit;

public class PanelOrderInfo
implements WizardPanelIface,
ActionListener {
    private SSNResource bundle = new SSNResource(PanelOrderInfo.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JLabel m_orderNumberLabel = null;
    private AdvOrderField m_orderNumber = null;
    private JLabel m_installationKeyLabel = null;
    private JPanel m_keyPanel = new JPanel(new GridBagLayout());
    private AdvKeyField m_key1 = null;
    private AdvKeyField m_key2 = null;
    private AdvKeyField m_key3 = null;
    private JLabel m_dash1 = null;
    private JLabel m_dash2 = null;
    private JButton m_pasteButton = null;
    private boolean m_pasteButtonClicked = false;
    private boolean m_panelLoaded = false;
    private String m_fullKey = null;
    private JLabel m_leftJustify = null;

    public PanelOrderInfo() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelOrderInfo.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelOrderInfo.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        String errMsg = null;
        String orderNumber = this.m_orderNumber.getText().trim();
        String key1 = this.m_key1.getText().trim();
        String key2 = this.m_key2.getText().trim();
        String key3 = this.m_key3.getText().trim();
        KitTextField focusObj = null;
        EsdControl controlFile = null;
        this.m_orderNumber.setText(orderNumber);
        this.m_key1.setText(key1);
        this.m_key2.setText(key2);
        this.m_key3.setText(key3);
        this.m_fullKey = key1 + "-" + key2 + "-" + key3;
        if (orderNumber.length() == 0) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "ORDER_NUMBER");
            } else {
                errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelOrderInfo.OrderFieldName.txt"));
                focusObj = this.m_orderNumber;
            }
        }
        if (valid && orderNumber.length() < 6) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "ORDER_NUMBER", orderNumber, null);
            } else {
                errMsg = this.bundle.messageString("Common.Error.InvalidField.txt", this.bundle.getString("PanelOrderInfo.OrderFieldName.txt"));
                focusObj = this.m_orderNumber;
            }
        }
        if (valid && (key1.length() == 0 || key2.length() == 0 || key3.length() == 0)) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "SAS_INSTALLATION_KEY", this.m_fullKey, null);
            } else {
                errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelOrderInfo.KeyFieldName.txt"));
                if (key1.length() == 0) {
                    focusObj = this.m_key1;
                } else if (key2.length() == 0) {
                    focusObj = this.m_key2;
                } else if (key3.length() == 0) {
                    focusObj = this.m_key3;
                }
            }
        }
        if (valid && (key1.length() < 4 || key2.length() < 4 || key3.length() < 4)) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "SAS_INSTALLATION_KEY", this.m_fullKey, null);
            } else {
                errMsg = this.bundle.messageString("Common.Error.InvalidField.txt", this.bundle.getString("PanelOrderInfo.KeyFieldName.txt"));
                if (key1.length() < 4) {
                    focusObj = this.m_key1;
                } else if (key2.length() < 4) {
                    focusObj = this.m_key2;
                } else if (key3.length() < 4) {
                    focusObj = this.m_key3;
                }
            }
        }
        if (valid) {
            try {
                Globals.g_order = orderNumber;
                controlFile = new EsdControl(orderNumber, this.m_fullKey);
                valid = controlFile.isValid();
            }
            catch (IOException e) {
                valid = false;
                Logging.log.severe(e.getMessage());
                if (!Globals.g_quietMode) {
                    CustMsgBox.showMessageDialog(null, this.bundle.messageString("Common.ESD.UnexpectedError.txt"), this.bundle.getString("Common.Error.txt"), 0);
                }
                Globals.g_kit.exitKit(-1);
            }
        }
        if (valid) {
            Globals.g_control = controlFile;
            Globals.g_wizardData.setPreference("OrderNumber", orderNumber);
            Globals.g_wizardData.setPreference("InstallationKey", this.m_fullKey);
            if (Globals.g_mode == 1) {
                if (Globals.g_consoleMode) {
                    ConsoleModeEventDriven.busyMsgStart("");
                }
                Globals.g_deploymentData = new DeploymentData(new File(Globals.g_tempLocation, "download"));
                Globals.g_deploymentData.loadOrders();
                if (Globals.g_consoleMode) {
                    ConsoleModeEventDriven.busyMsgStop();
                }
                if (Globals.g_deploymentData.getOrderCount() < 1) {
                    Logging.log.severe("Bad order information--expected getOrderCount to return >0 entries.");
                    DownloadLogger dl = new DownloadLogger();
                    dl.finalStatus("badControl");
                    dl.Send();
                    if (!Globals.g_quietMode) {
                        CustMsgBox.showMessageDialog(null, this.bundle.messageString("PanelOrderInfo.BadOrder.txt"), this.bundle.getString("Common.Error.txt"), 0);
                    }
                    valid = false;
                }
            }
        } else if (!Globals.g_quietMode) {
            if (errMsg != null && (controlFile == null || !controlFile.checkCancelAndContinue() && !controlFile.checkHoldAndContinue())) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
            }
            if (focusObj != null) {
                focusObj.requestFocus();
            }
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        return "addorder";
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            String fullKey;
            if (wizardFramework.getFrame() != null && !wizardFramework.getFrame().isVisible()) {
                wizardFramework.getFrame().pack();
            }
            this.m_key1.setText("WWWW");
            int width = this.m_key1.getPreferredSize().width + this.m_key1.getMargin().left + this.m_key1.getMargin().right;
            this.m_key1.setText("");
            this.m_key1.setPreferredSize(new Dimension(width, this.m_key1.getPreferredSize().height));
            this.m_key2.setPreferredSize(new Dimension(width, this.m_key2.getPreferredSize().height));
            this.m_key3.setPreferredSize(new Dimension(width, this.m_key3.getPreferredSize().height));
            this.m_orderNumber.setPreferredSize(new Dimension(this.m_keyPanel.getPreferredSize().width, this.m_orderNumber.getPreferredSize().height));
            this.m_key1.setMinimumSize(new Dimension(width, this.m_key1.getPreferredSize().height));
            this.m_key2.setMinimumSize(new Dimension(width, this.m_key2.getPreferredSize().height));
            this.m_key3.setMinimumSize(new Dimension(width, this.m_key3.getPreferredSize().height));
            this.m_orderNumber.setMinimumSize(new Dimension(this.m_keyPanel.getPreferredSize().width, this.m_orderNumber.getPreferredSize().height));
            this.loadResponseData();
            if (this.m_orderNumber.getText().length() == 0) {
                this.m_orderNumber.setText(Globals.g_wizardData.getPreference("OrderNumber", ""));
            }
            if ((this.m_key1.getText().length() == 0 || this.m_key2.getText().length() == 0 || this.m_key3.getText().length() == 0) && (fullKey = Globals.g_wizardData.getPreference("InstallationKey", "")).length() == 14) {
                this.m_key1.setText(fullKey.substring(0, 4));
                this.m_key2.setText(fullKey.substring(5, 9));
                this.m_key3.setText(fullKey.substring(10));
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#ORDER_NUMBER=<order number>", " ORDER_NUMBER=", "#SAS_INSTALLATION_KEY=<????-????-????>", " SAS_INSTALLATION_KEY="};
        if (this.m_panelLoaded) {
            data[1] = " ORDER_NUMBER=" + this.m_orderNumber.getText();
            data[3] = " SAS_INSTALLATION_KEY=" + this.m_fullKey;
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        KitTextField key = new KitTextField(this.m_key1.getText() + "-" + this.m_key2.getText() + "-" + this.m_key3.getText());
        int returnCode = ConsoleMode.promptText(this.m_orderNumberLabel.getText(), this.m_orderNumber);
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptText(this.bundle.getString("PanelOrderInfo.ConsoleKey.txt"), key);
        }
        if (returnCode > -1) {
            String keyStr = key.getText();
            if (keyStr == null) {
                returnCode = -1;
            } else if (keyStr.length() == 12) {
                this.m_key1.setText(keyStr.substring(0, 4));
                this.m_key2.setText(keyStr.substring(5, 8));
                this.m_key3.setText(keyStr.substring(8));
                returnCode = 0;
            } else if (keyStr.length() == 14) {
                this.m_key1.setText(keyStr.substring(0, 4));
                this.m_key2.setText(keyStr.substring(5, 9));
                this.m_key3.setText(keyStr.substring(10));
                returnCode = 0;
            } else {
                returnCode = -1;
            }
        }
        if (returnCode > -1) {
            ConsoleMode.println(this.bundle.getString("PanelOrderInfo.Processing.txt"));
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String responseOrder = Wizard.getResponse("ORDER_NUMBER", null);
        if (responseOrder != null) {
            valid = true;
            this.m_orderNumber.setText(responseOrder);
        } else if (Globals.g_quietMode) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "ORDER_NUMBER");
        }
        String responseKey = Wizard.getResponse("SAS_INSTALLATION_KEY", null);
        if (responseKey != null) {
            if (responseKey.length() == 14) {
                this.m_key1.setText(responseKey.substring(0, 4));
                this.m_key2.setText(responseKey.substring(5, 9));
                this.m_key3.setText(responseKey.substring(10));
            } else if (Globals.g_quietMode) {
                valid = false;
                Wizard.logResponseInvalid(this.getHeader(), "SAS_INSTALLATION_KEY", responseKey, null);
            }
        } else if (Globals.g_quietMode) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "SAS_INSTALLATION_KEY");
        }
        return valid;
    }

    private void initialize() {
        this.m_orderNumber = new AdvOrderField();
        String mtxt = this.bundle.getString("PanelOrderInfo.OrderNumber.txt");
        this.m_orderNumberLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_orderNumberLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_orderNumberLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_orderNumberLabel.setLabelFor(this.m_orderNumber);
        mtxt = this.bundle.getString("PanelOrderInfo.InstallationKey.txt");
        this.m_installationKeyLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_installationKeyLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_installationKeyLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        MultiFieldPaste pasteAction = new MultiFieldPaste();
        this.m_key1 = new AdvKeyField(4);
        this.m_key1.getActionMap().put(pasteAction.getValue("Name"), pasteAction);
        this.m_dash1 = new JLabel(" - ");
        this.m_key2 = new AdvKeyField(4);
        this.m_key2.getActionMap().put(pasteAction.getValue("Name"), pasteAction);
        this.m_dash2 = new JLabel(" - ");
        this.m_key3 = new AdvKeyField(4, false);
        this.m_key3.getActionMap().put(pasteAction.getValue("Name"), pasteAction);
        this.m_orderNumber.getActionMap().put(pasteAction.getValue("Name"), pasteAction);
        mtxt = this.bundle.getString("PanelOrderInfo.PasteButton.txt");
        this.m_pasteButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_pasteButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_pasteButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_pasteButton.addActionListener(this);
        this.m_leftJustify = new JLabel(" ");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_pasteButton) {
            this.m_pasteButtonClicked = true;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchKeyEvent(new KeyEvent(this.m_key1, 401, System.currentTimeMillis(), 0, 65487, '\uffff'));
            this.m_pasteButtonClicked = false;
        }
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_orderNumberLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 5;
        c.fill = 2;
        c.insets = new Insets(0, 5, 5, 0);
        this.m_panel.add((Component)this.m_orderNumber, c);
        c.gridx = 6;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_leftJustify, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_installationKeyLabel, c);
        c.gridx = 1;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_panel.add((Component)this.m_key1, c);
        c.gridx = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_dash1, c);
        c.gridx = 3;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_key2, c);
        c.gridx = 4;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_dash2, c);
        c.gridx = 5;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_key3, c);
        c.gridx = 6;
        c.gridy = 1;
        c.insets = new Insets(5, 5, 5, 0);
        this.m_panel.add((Component)this.m_pasteButton, c);
    }

    private class MultiFieldPaste
    extends DefaultEditorKit.PasteAction {
        private MultiFieldPaste() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String data = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
                Pattern pattern_orderNumber1 = Pattern.compile("(?i:Order Number:.*?)(\\w{6}(-\\w)?)(\\z|\\b)");
                Pattern pattern_orderNumber2 = Pattern.compile("(\\A|\\b)(\\w{6}(-\\w)?)(\\z|\\b)");
                Pattern pattern_key = Pattern.compile("(\\A|\\b)(\\w{4})-(\\w{4})-(\\w{4})(\\z|\\b)");
                Matcher matcher_orderNumber1 = pattern_orderNumber1.matcher(data);
                Matcher matcher_orderNumber2 = pattern_orderNumber2.matcher(data);
                Matcher matcher_key = pattern_key.matcher(data);
                boolean found_orderNumber1 = matcher_orderNumber1.find();
                boolean found_orderNumber2 = matcher_orderNumber2.find();
                boolean found_key = matcher_key.find();
                if (found_orderNumber1 || found_orderNumber2 || found_key) {
                    if (found_orderNumber1) {
                        PanelOrderInfo.this.m_orderNumber.setText(matcher_orderNumber1.group(1));
                    } else if (found_orderNumber2) {
                        PanelOrderInfo.this.m_orderNumber.setText(matcher_orderNumber2.group(2));
                    }
                    if (found_key) {
                        PanelOrderInfo.this.m_key1.setText(matcher_key.group(2));
                        PanelOrderInfo.this.m_key2.setText(matcher_key.group(3));
                        PanelOrderInfo.this.m_key3.setText(matcher_key.group(4));
                    }
                } else if (PanelOrderInfo.this.m_pasteButtonClicked) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    this.getFocusedComponent().replaceSelection(data);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

