/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.OrderData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class PanelManageOrHotFix
implements WizardPanelIface,
ActionListener {
    private SSNResource bundle = new SSNResource(PanelManageOrHotFix.class);
    private final String RESPONSE_MANAGESSD = "managessd";
    private final String RESPONSE_CHECKHOTFIX = "checkhotfix";
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JRadioButton m_manageSSDOption = null;
    private JTextArea m_manageSSDInfo = null;
    private JRadioButton m_hotfixesOption = null;
    private JTextArea m_hotfixesInfo = null;
    private boolean m_panelLoaded = false;
    private int numSelectableOrders = 0;

    public PanelManageOrHotFix() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelManageOrHotFix.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelManageOrHotFix.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        if (valid) {
            Globals.g_checkForHotFix = !this.m_manageSSDOption.isSelected();
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        if (Globals.g_mode != 1 && Globals.g_order != null && Globals.g_deploymentData.getOrder(Globals.g_order).getDepotVersionAsInt() < 2) {
            return false;
        }
        if (Globals.g_mode == 0) {
            if (Globals.g_noHotFix) {
                return false;
            }
            return !Globals.g_hfInclOnly;
        }
        return false;
    }

    @Override
    public String getNextPanelID() {
        if (Globals.g_checkForHotFix) {
            return "proxy";
        }
        return "managessd";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            OrderData[] orderData;
            this.numSelectableOrders = 0;
            for (OrderData order : orderData = Globals.g_deploymentData.getOrders()) {
                if (order.getDepotVersionAsInt() < 2) continue;
                ++this.numSelectableOrders;
            }
            if (!this.loadResponseData()) {
                this.m_manageSSDOption.setEnabled(true);
                this.m_manageSSDOption.setSelected(true);
                if (this.numSelectableOrders > 0) {
                    this.m_hotfixesOption.setEnabled(true);
                } else {
                    this.m_hotfixesOption.setEnabled(false);
                }
                this.m_hotfixesOption.setSelected(false);
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        JRadioButton focus = null;
        focus = this.m_manageSSDOption.isSelected() ? this.m_manageSSDOption : (this.m_hotfixesOption.isSelected() ? this.m_hotfixesOption : this.m_manageSSDOption);
        return focus;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#MANAGE_OR_HOT_FIX=managessd/checkhotfix", " MANAGE_OR_HOT_FIX=managessd"};
        if (this.m_panelLoaded && this.m_hotfixesOption != null && this.m_hotfixesOption.isSelected()) {
            data[1] = " MANAGE_OR_HOT_FIX=checkhotfix";
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
        Globals.g_checkForHotFix = false;
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_manageSSDOption, this.m_hotfixesOption};
        JTextArea[] infos = new JTextArea[]{this.m_manageSSDInfo, this.m_hotfixesInfo};
        int returnCode = ConsoleMode.promptRadioButtons(options, infos);
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("MANAGE_OR_HOT_FIX", null);
        if (response != null) {
            if (response.equalsIgnoreCase("managessd")) {
                valid = true;
                this.m_manageSSDOption.setSelected(true);
            } else if (response.equalsIgnoreCase("checkhotfix") && this.m_hotfixesOption != null) {
                valid = true;
                this.m_hotfixesOption.setSelected(true);
            } else if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "MANAGE_OR_HOT_FIX", response, null);
            }
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), "MANAGE_OR_HOT_FIX");
        }
        return valid;
    }

    private void initialize() {
        String mtxt = this.bundle.getString("PanelManageOrHotFix.ManageSSDLabel.txt");
        this.m_manageSSDOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_manageSSDOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_manageSSDOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_manageSSDOption.getFont();
        this.m_manageSSDOption.setFont(optionFont.deriveFont(1));
        this.m_manageSSDInfo = new JTextArea(this.bundle.getString("PanelManageOrHotFix.ManageSSDInfo.txt"));
        this.m_manageSSDInfo.setEditable(false);
        this.m_manageSSDInfo.setFocusable(false);
        this.m_manageSSDInfo.setLineWrap(true);
        this.m_manageSSDInfo.setWrapStyleWord(true);
        this.m_manageSSDInfo.setOpaque(false);
        mtxt = this.bundle.getString("PanelManageOrHotFix.HotfixLabel.txt");
        this.m_hotfixesOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_hotfixesOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_hotfixesOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_hotfixesOption.getFont();
        this.m_hotfixesOption.setFont(optionFont.deriveFont(1));
        this.m_hotfixesInfo = new JTextArea(this.bundle.getString("PanelManageOrHotFix.HotfixInfo.txt"));
        this.m_hotfixesInfo.setEditable(false);
        this.m_hotfixesInfo.setFocusable(false);
        this.m_hotfixesInfo.setLineWrap(true);
        this.m_hotfixesInfo.setWrapStyleWord(true);
        this.m_hotfixesInfo.setOpaque(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_manageSSDOption);
        group.add(this.m_hotfixesOption);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 3, 0);
        this.m_panel.add((Component)this.m_manageSSDOption, c);
        c.gridy = 1;
        c.insets = new Insets(2, 20, 2, 0);
        this.m_panel.add((Component)this.m_manageSSDInfo, c);
        c.gridy = 2;
        c.insets = new Insets(3, 0, 3, 0);
        this.m_panel.add((Component)this.m_hotfixesOption, c);
        c.gridy = 3;
        c.insets = new Insets(2, 20, 3, 0);
        this.m_panel.add((Component)this.m_hotfixesInfo, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

