/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.FileTypeManagementData;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class PanelManageFileTypesSelectProducts
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelManageFileTypesSelectProducts.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_instructions = null;
    private boolean m_manageByExtension = false;
    private JRadioButton m_advancedButton = null;
    private ArrayList<JRadioButton> m_productButtons = new ArrayList();
    private JTable m_extensionList = null;
    private JScrollPane m_listScrollPane = null;
    private ExtensionTableModel m_extensionListModel = null;
    private boolean m_panelLoaded = false;
    private ArrayList<ExtensionData> m_listData = new ArrayList();
    private HashMap<String, TreeSet<String>> m_progIDs = new HashMap();

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSelectDefaultProdFTM.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSelectDefaultProdFTM.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        if (!Globals.g_quietMode) {
            for (int i = 0; i < this.m_productButtons.size(); ++i) {
                if (!this.m_productButtons.get(i).isSelected()) continue;
                Globals.g_fileTypeData.setPendingDefaultProduct(this.m_productButtons.get(i).getText());
            }
            Globals.g_fileTypeData.setManageByFiletype(this.m_advancedButton.isSelected());
        }
        Globals.g_fileTypeData.clearUserSelectedData();
        String pendingDefaultProductCode = "";
        FileTypeManagementData.ProductExtended pendingDefaultProduct = Globals.g_fileTypeData.getPendingDefaultProduct();
        if (pendingDefaultProduct != null && pendingDefaultProduct.getDisplayName().length() > 0) {
            pendingDefaultProductCode = Globals.g_fileTypeData.getProductCodeForDisplayname(pendingDefaultProduct.getDisplayName());
            for (String ext : Globals.g_fileTypeData.getInstalledSharedExtensions()) {
                String currentProduct = Globals.g_fileTypeData.getCurrentProductForFileType(ext);
                if (currentProduct == null || currentProduct.isEmpty() || pendingDefaultProduct.getDisplayName().equals(currentProduct)) continue;
                if (Globals.g_extensionRegistry.getProductsForExtension(ext).contains(pendingDefaultProduct.getCode())) {
                    Globals.g_fileTypeData.setUserSelectedProductForFileType(ext, pendingDefaultProduct);
                    continue;
                }
                Logging.log.info("The selected default product (" + pendingDefaultProductCode + ") does not use extension " + ext);
            }
        }
        if (!Globals.g_quietMode && !this.m_advancedButton.isSelected() && Globals.g_fileTypeData.getUserModifiedFileTypes().isEmpty()) {
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelSelectDefaultProdFTM.NoFTUChangesMsg.txt"), this.bundle.getString("Common.CMTTitle.txt"), -1);
            return false;
        }
        return true;
    }

    @Override
    public boolean displayPanel() {
        boolean display = false;
        display = Globals.g_fileTypeData.installedExtensionsShared();
        return display;
    }

    @Override
    public String getNextPanelID() {
        return "managefiletypes";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.initialize();
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
        this.loadExtData();
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        JComponent focus = null;
        for (int i = 0; i < this.m_productButtons.size(); ++i) {
            if (!this.m_productButtons.get(i).isSelected()) continue;
            focus = this.m_productButtons.get(i);
            break;
        }
        return focus;
    }

    @Override
    public boolean silentEvent() {
        this.initializeSilent();
        boolean valid = this.loadResponseData();
        this.loadExtData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#FTU_PRODUCT_SELECTION=<selected default product>", " FTU_PRODUCT_SELECTION="};
        data[1] = Globals.g_fileTypeData.isManageByFiletype() ? " FTU_PRODUCT_SELECTION=Advanced" : " FTU_PRODUCT_SELECTION=" + Globals.g_fileTypeData.getPendingDefaultProduct().getDisplayName();
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        ConsoleMode.printInfoText(this.m_instructions.getText());
        ConsoleMode.println();
        ArrayList<String> tableText = new ArrayList<String>();
        tableText.add(this.bundle.getString("PanelManageFileTypesSummary.ExtensionField.txt") + "~" + this.bundle.getString("PanelManageFileTypesSummary.OldProductField.txt") + "~" + this.bundle.getString("PanelManageFileTypesSummary.NewProductField.txt"));
        ExtensionData data = null;
        for (int i = 0; i < this.m_listData.size(); ++i) {
            data = this.m_listData.get(i);
            tableText.add(data.getExtension() + "~" + data.getDescription());
        }
        ConsoleMode.printTable(tableText.toArray(new String[0]));
        return ConsoleMode.promptPause();
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("FTU_PRODUCT_SELECTION", null);
        if (response != null) {
            if (!response.equalsIgnoreCase("Advanced")) {
                Globals.g_fileTypeData.setPendingDefaultProduct(response);
                Globals.g_fileTypeData.setManageByFiletype(false);
                if (!Globals.g_quietMode) {
                    for (int i = 0; i < this.m_productButtons.size(); ++i) {
                        if (!this.m_productButtons.get(i).getText().equalsIgnoreCase(response)) continue;
                        this.m_productButtons.get(i).setSelected(true);
                        break;
                    }
                }
            } else {
                Globals.g_fileTypeData.setPendingDefaultProduct("");
                Globals.g_fileTypeData.setManageByFiletype(true);
                if (!Globals.g_quietMode) {
                    this.m_advancedButton.setSelected(true);
                }
            }
            valid = true;
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), "FTU_PRODUCT_SELECTION");
        }
        return valid;
    }

    private void initializeSilent() {
        if (Globals.g_fileTypeData != null && !FileTypeManagementData.extensionRegistryDataLoaded) {
            Globals.g_fileTypeData.setupExtensionRegistryAccess(Globals.g_cmtSASHome.concat("/InstallMisc/ExtensionRegistry.xml"));
        }
    }

    private void initialize() {
        if (Globals.g_fileTypeData != null && !FileTypeManagementData.extensionRegistryDataLoaded) {
            Globals.g_fileTypeData.setupExtensionRegistryAccess(Globals.g_cmtSASHome.concat("/InstallMisc/ExtensionRegistry.xml"));
        }
        this.m_instructions = new JTextArea(this.bundle.getString("PanelSelectDefaultProdFTM.Instructions.txt"));
        this.m_instructions.setEditable(false);
        this.m_instructions.setFocusable(false);
        this.m_instructions.setLineWrap(true);
        this.m_instructions.setWrapStyleWord(true);
        this.m_instructions.setOpaque(false);
        this.m_extensionListModel = new ExtensionTableModel();
        this.m_extensionList = new JTable(this.m_extensionListModel);
        this.m_extensionList.setRowSelectionAllowed(false);
        this.m_extensionList.setColumnSelectionAllowed(false);
        this.m_extensionList.setSelectionMode(0);
        this.m_extensionList.getTableHeader().setResizingAllowed(true);
        this.m_extensionList.getTableHeader().setReorderingAllowed(false);
        this.m_extensionList.getColumnModel().getColumn(0).setCellRenderer(new ExtensionsCellRenderer());
        this.m_extensionList.getColumnModel().getColumn(1).setCellRenderer(new StringCellRenderer());
        this.m_extensionList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelManageFileTypesSelectProducts.this.m_extensionList.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.m_listScrollPane = new JScrollPane(this.m_extensionList);
        this.m_listScrollPane.setPreferredSize(new Dimension(300, 200));
        this.m_listScrollPane.getViewport().setBackground(this.m_extensionList.getBackground());
        ButtonGroup group = new ButtonGroup();
        ArrayList<String> prods = new ArrayList<String>();
        if (Globals.g_extensionRegistry != null) {
            Collection<String> tmp = Globals.g_fileTypeData.getInstalledProductsWithSharedExtensions();
            for (String prod : tmp) {
                int index;
                String product = Globals.g_fileTypeData.getProductDisplayname(prod);
                if (product == null && (index = prod.indexOf("_")) != -1) {
                    String prtCode = prod.substring(0, prod.indexOf("_"));
                    product = Globals.g_fileTypeData.getProductDisplayname(prtCode + "_prt");
                }
                prods.add(product);
            }
        }
        boolean select = false;
        for (String prod : prods) {
            JRadioButton prodButton = new JRadioButton(prod);
            this.m_productButtons.add(prodButton);
            Font optionFont = prodButton.getFont();
            prodButton.setFont(optionFont.deriveFont(1));
            JTextArea prodDescript = new JTextArea(this.bundle.getString("PanelSelectDefaultProdFTM.ProdButton.Descript.txt"));
            prodDescript.setEditable(false);
            prodDescript.setFocusable(false);
            prodDescript.setLineWrap(true);
            prodDescript.setWrapStyleWord(true);
            prodDescript.setOpaque(false);
            if (!select) {
                prodButton.setSelected(true);
                select = true;
            }
            group.add(prodButton);
        }
        this.m_advancedButton = new JRadioButton(this.bundle.getString("PanelSelectDefaultProdFTM.PButton.Label.txt"));
        Font optionFont = this.m_advancedButton.getFont();
        this.m_advancedButton.setFont(optionFont.deriveFont(1));
        group.add(this.m_advancedButton);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_instructions, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 4.0;
        c.fill = 1;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_listScrollPane, c);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 0;
        for (int i = 0; i < prods.size(); ++i) {
            c.gridy = 2 + i;
            this.m_panel.add((Component)this.m_productButtons.get(i), c);
        }
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 0;
        this.m_panel.add((Component)this.m_advancedButton, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    private void loadExtData() {
        this.m_listData.clear();
        this.m_progIDs.clear();
        if (Globals.g_extensionRegistry != null) {
            Collection<String> extList = Globals.g_fileTypeData.getInstalledSharedExtensions();
            String extValue = null;
            String extName = null;
            String progId = null;
            Iterator<String> iter = extList.iterator();
            while (iter.hasNext()) {
                extValue = iter.next().toString();
                progId = Globals.g_fileTypeData.getProgID(extValue);
                extName = Globals.g_extensionRegistry.getExtensionDescription(extValue, progId);
                if (this.m_progIDs.containsKey(progId)) {
                    this.m_progIDs.get(progId).add(extValue);
                    continue;
                }
                TreeSet<String> extset = new TreeSet<String>();
                extset.add(extValue);
                this.m_progIDs.put(progId, extset);
                this.m_listData.add(new ExtensionData(extValue, extName, progId));
            }
        } else {
            Logging.log.info("ExtensionRegistry not found - Filetype data is not available");
        }
    }

    private class ExtensionTableModel
    extends AbstractTableModel {
        public static final int EXTENSION_NAME = 0;
        public static final int EXTENSION_DESCRIPTON = 1;
        private String[] m_columnNames;

        public ExtensionTableModel() {
            this.m_columnNames = new String[]{PanelManageFileTypesSelectProducts.this.bundle.getString("PanelSelectDefaultProdFTM.ExtensionTable.NameColumn.Title.txt"), PanelManageFileTypesSelectProducts.this.bundle.getString("PanelSelectDefaultProdFTM.ExtensionTable.InfoColumn.Title.txt")};
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.m_columnNames[index];
        }

        public Class getColumnClass(int index) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            int count = 0;
            if (PanelManageFileTypesSelectProducts.this.m_listData != null) {
                count = PanelManageFileTypesSelectProducts.this.m_listData.size();
            }
            return count;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String value = null;
            ExtensionData data = (ExtensionData)PanelManageFileTypesSelectProducts.this.m_listData.get(rowIndex);
            if (data != null) {
                if (columnIndex == 0) {
                    value = data.getExtension();
                } else if (columnIndex == 1) {
                    value = data.getDescription();
                }
            }
            return value;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
        }
    }

    class ExtensionData {
        private String m_extCode = null;
        private String m_description = null;
        private String m_progId = null;

        public ExtensionData(String extensionCode, String nameDesc, String progID) {
            this.m_extCode = extensionCode;
            this.m_description = nameDesc;
            this.m_progId = progID;
        }

        public String getExtension() {
            return this.m_extCode;
        }

        public String getDescription() {
            return this.m_description;
        }
    }

    private class ExtensionsCellRenderer
    extends DefaultTableCellRenderer {
        private ExtensionsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
            } else {
                String extensionList = value.toString();
                String progid = Globals.g_fileTypeData.getProgID(value.toString());
                for (String ext : (TreeSet)PanelManageFileTypesSelectProducts.this.m_progIDs.get(progid)) {
                    if (ext.equals(value.toString())) continue;
                    extensionList = extensionList.concat(", " + ext);
                }
                this.setText(extensionList);
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
            }
            return this;
        }
    }

    private class StringCellRenderer
    extends DefaultTableCellRenderer {
        private StringCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
            } else {
                this.setText(value.toString());
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
            }
            return this;
        }
    }
}

