/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.CustMsgBox;
import com.sas.ssn.FileTypeManagementData;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class PanelManageFileTypes
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelManageFileTypes.class);
    private JTable table = null;
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_instructions = null;
    JScrollPane scrollPane = null;
    private boolean m_panelLoaded = false;
    private ArrayList<TableExtensionData> m_listData = new ArrayList();
    private HashMap<String, DefaultCellEditor> editorsHash = new HashMap();
    private HashMap<String, JComboBox> m_productComboBoxHash = new HashMap();

    private boolean loadResponseData() {
        boolean valid = true;
        if (valid) {
            boolean found = true;
            int extensionCount = 1;
            String responseExtension = null;
            while (found) {
                responseExtension = Wizard.getResponse("PRODUCT_FOR_FILETYPE" + Integer.toString(extensionCount), null);
                if (responseExtension != null) {
                    String currentProduct;
                    Vector<String> extAndProduct = new Vector<String>(Arrays.asList(responseExtension.split(",")));
                    if (extAndProduct.size() != 2) {
                        Wizard.logResponseInvalid(this.getHeader(), "PRODUCT_FOR_FILETYPE" + Integer.toString(extensionCount), responseExtension, "Required data is <extension>,<product name>");
                        break;
                    }
                    String ext = extAndProduct.get(0);
                    String selectedProduct = extAndProduct.get(1);
                    if (!selectedProduct.equals(currentProduct = Globals.g_fileTypeData.getCurrentProductForFileType(ext))) {
                        Globals.g_fileTypeData.setUserSelectedProductForFileType(ext, selectedProduct);
                    }
                    if (!Globals.g_quietMode) {
                        this.m_productComboBoxHash.get(ext).getModel().setSelectedItem(selectedProduct);
                    }
                } else {
                    if (extensionCount == 1) {
                        valid = false;
                        if (Globals.g_quietMode) {
                            Wizard.logResponseMissing(this.getHeader(), "PRODUCT_FOR_FILETYPE" + Integer.toString(extensionCount));
                        }
                    }
                    found = false;
                }
                ++extensionCount;
            }
        }
        return valid;
    }

    private void initializeSilent() {
        if (Globals.g_fileTypeData != null && !FileTypeManagementData.extensionRegistryDataLoaded) {
            Globals.g_fileTypeData.setupExtensionRegistryAccess(Globals.g_cmtSASHome.concat("/InstallMisc/ExtensionRegistry.xml"));
        }
    }

    private void initialize() {
        if (Globals.g_fileTypeData != null && !FileTypeManagementData.extensionRegistryDataLoaded) {
            Globals.g_fileTypeData.setupExtensionRegistryAccess(Globals.g_cmtSASHome.concat("/InstallMisc/ExtensionRegistry.xml"));
        }
        if (Globals.g_extensionRegistry != null) {
            Collection<String> extensions = Globals.g_fileTypeData.getSASFileTypes();
            Iterator<String> iterator = extensions.iterator();
            while (iterator.hasNext()) {
                String ext;
                String key = ext = iterator.next();
                ArrayList<String> prods = new ArrayList<String>();
                Collection<String> tmpList = Globals.g_fileTypeData.getInstalledProductsForExtension(ext);
                for (String p : tmpList) {
                    prods.add(Globals.g_fileTypeData.getProductDisplayname(p));
                }
                String currentProd = Globals.g_fileTypeData.getCurrentProductForFileType(ext);
                if (currentProd == null || currentProd.isEmpty()) {
                    Globals.g_fileTypeData.getAssignedProduct(ext).getDisplayName();
                }
                if (!prods.contains(currentProd) && Globals.g_fileTypeData.isUserChoiceExtensionDefault(ext)) {
                    prods.add(currentProd);
                }
                if (currentProd != null && currentProd.equalsIgnoreCase("not found")) {
                    Logging.log.info("selectedProduct not found for " + ext);
                    continue;
                }
                JComboBox<Object> tmpComboBox = new JComboBox<Object>(prods.toArray());
                DefaultCellEditor tmpEditor = new DefaultCellEditor(tmpComboBox);
                tmpComboBox.setSelectedItem(currentProd);
                tmpComboBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        ArrayList<String> exts = new ArrayList<String>();
                        if (itemEvent.getStateChange() == 1) {
                            if (Globals.g_fileTypeData.isUserChoiceExtensionDefault(ext) && itemEvent.getItem().toString().equalsIgnoreCase(Globals.g_fileTypeData.getCurrentProductForFileType(ext))) {
                                exts.add(ext);
                            } else if (Globals.g_fileTypeData.getExtensionsForProgID(Globals.g_fileTypeData.getProgID(ext)).size() > 1) {
                                for (String extension : Globals.g_fileTypeData.getExtensionsForProgID(Globals.g_fileTypeData.getProgID(ext))) {
                                    if (!extension.equalsIgnoreCase(ext) && Globals.g_fileTypeData.isUserChoiceExtensionDefault(extension) && (!Globals.g_fileTypeData.isUserChoiceExtensionDefault(extension) || Globals.g_fileTypeData.getCurrentProductForFileType(extension).equals(((JComboBox)PanelManageFileTypes.this.m_productComboBoxHash.get(extension)).getModel().getSelectedItem()))) continue;
                                    exts.add(extension);
                                }
                            }
                            for (int i = 0; i < PanelManageFileTypes.this.table.getRowCount(); ++i) {
                                int cnt = 0;
                                String currentVal = (String)PanelManageFileTypes.this.table.getValueAt(i, 0);
                                if ((null == currentVal || !ext.equals(currentVal)) && !exts.contains(currentVal)) continue;
                                ++cnt;
                                Object selectedItem = ((JComboBox)itemEvent.getSource()).getSelectedItem();
                                if (null == selectedItem) continue;
                                ((JComboBox)PanelManageFileTypes.this.m_productComboBoxHash.get(currentVal)).getModel().setSelectedItem(selectedItem.toString());
                                PanelManageFileTypes.this.table.setValueAt(selectedItem.toString(), i, 1);
                                if (cnt >= exts.size()) break;
                            }
                        }
                    }
                });
                this.editorsHash.put(key, tmpEditor);
                this.m_productComboBoxHash.put(ext, tmpComboBox);
                this.m_listData.add(new TableExtensionData(ext, prods));
            }
        }
        this.m_instructions = new JTextArea(this.bundle.getString("PanelManageFileTypes.Instructions.txt"));
        this.m_instructions.setEditable(false);
        this.m_instructions.setFocusable(false);
        this.m_instructions.setLineWrap(true);
        this.m_instructions.setWrapStyleWord(true);
        this.m_instructions.setOpaque(false);
        Object[] columnNames = new String[]{this.bundle.getString("PanelManageFileTypes.Extensions.label.txt"), this.bundle.getString("PanelManageFileTypes.Product.Label.txt")};
        Object[][] data = new Object[this.m_listData.size()][2];
        for (int line = 0; line < this.m_listData.size(); ++line) {
            data[line][0] = this.m_listData.get(line).getExtension();
            data[line][1] = Globals.g_fileTypeData.getAssignedProduct(this.m_listData.get(line).getExtension()).getDisplayName();
        }
        DefaultTableModel model = new DefaultTableModel(data, columnNames);
        model.setColumnIdentifiers(columnNames);
        this.table = new JTable(model){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                String ext = null;
                ext = this.getValueAt(row, 0).toString();
                if (ext != null && column == 1) {
                    String currentProduct = Globals.g_fileTypeData.getCurrentProductForFileType(ext).toString();
                    JComboBox comboBox = (JComboBox)PanelManageFileTypes.this.m_productComboBoxHash.get(ext);
                    Object selectedItem = comboBox.getSelectedItem();
                    if (selectedItem == null || selectedItem != null && currentProduct.equalsIgnoreCase(selectedItem.toString())) {
                        c.setFont(this.getFont().deriveFont(0));
                    } else {
                        c.setFont(this.getFont().deriveFont(1));
                    }
                }
                return c;
            }

            @Override
            public TableCellEditor getCellEditor(int row, int column) {
                int modelColumn = this.convertColumnIndexToModel(column);
                if (modelColumn == 1) {
                    return (TableCellEditor)PanelManageFileTypes.this.editorsHash.get(((TableExtensionData)PanelManageFileTypes.this.m_listData.get(row)).getExtension());
                }
                return super.getCellEditor(row, column);
            }

            public Class getColumnClass(int c) {
                return this.getValueAt(0, c).getClass();
            }
        };
        this.table.getColumnModel().getColumn(1).setCellRenderer(new ComboBoxRenderer());
        this.table.setRowHeight(20);
        JScrollPane scrollPane = new JScrollPane(this.table);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_instructions, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)scrollPane, c);
    }

    private void loadExtData() {
        this.m_listData.clear();
        String defaultProd = "";
        FileTypeManagementData.ProductExtended pendingDefaultProduct = Globals.g_fileTypeData.getPendingDefaultProduct();
        if (pendingDefaultProduct != null) {
            defaultProd = pendingDefaultProduct.getCode();
        }
        Collection<String> extList = Globals.g_fileTypeData.getSASFileTypes();
        ArrayList<String> products = new ArrayList<String>();
        for (String extension : extList) {
            products.clear();
            products.addAll(Globals.g_fileTypeData.getInstalledProductsForExtension(extension));
            this.m_listData.add(new TableExtensionData(extension, products));
            String selectedProduct = null;
            try {
                selectedProduct = this.editorsHash.get(extension).getCellEditorValue().toString();
            }
            catch (NullPointerException e) {
                Logging.log.info("selectedProduct not found for " + extension);
                continue;
            }
            if (selectedProduct.equalsIgnoreCase(defaultProd) || !products.contains(defaultProd)) continue;
            this.m_productComboBoxHash.get(extension).getModel().setSelectedItem(defaultProd);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelManageFileTypes.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelManageFileTypes.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        Globals.g_fileTypeData.clearUserSelectedData();
        for (String ext : Globals.g_fileTypeData.getSASFileTypes()) {
            String selectedProduct = "";
            String currentProduct = "";
            try {
                selectedProduct = this.editorsHash.get(ext).getCellEditorValue().toString();
                currentProduct = Globals.g_fileTypeData.getCurrentProductForFileType(ext);
            }
            catch (NullPointerException e) {
                Logging.log.info("selectedProduct or currentProduct not found for " + ext);
                Logging.log.info(e.getMessage());
            }
            if (!selectedProduct.equals(currentProduct)) {
                Globals.g_fileTypeData.setUserSelectedProductForFileType(ext, selectedProduct);
                if (Globals.g_fileTypeData.getExtensionsForProgID(Globals.g_fileTypeData.getProgID(ext)).size() <= 1) continue;
                for (String e : Globals.g_fileTypeData.getExtensionsForProgID(Globals.g_fileTypeData.getProgID(ext))) {
                    if (Globals.g_fileTypeData.isUserChoiceExtensionDefault(e)) continue;
                    Globals.g_fileTypeData.setUserSelectedProductForFileType(e, selectedProduct);
                }
                continue;
            }
            if (!Globals.g_fileTypeData.isUserChoiceExtensionDefault(ext)) continue;
            Globals.g_fileTypeData.setUserChoiceNoChange(ext, selectedProduct);
        }
        if (Globals.g_fileTypeData.getUserModifiedFileTypes().isEmpty()) {
            if (!Globals.g_quietMode) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelManageFileTypes.NoFTUChangesMsg.txt"), this.bundle.getString("Common.CMTTitle.txt"), -1);
            } else {
                Logging.log.warning("No File Type associations were changed.");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean displayPanel() {
        boolean display = false;
        if (Globals.g_fileTypeData != null && Globals.g_fileTypeData.isManageByFiletype()) {
            display = true;
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        return "managefiletypessummary";
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.initialize();
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
        this.loadExtData();
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        this.initializeSilent();
        boolean valid = this.loadResponseData();
        return valid;
    }

    @Override
    public String[] responseData() {
        ArrayList<String> data = new ArrayList<String>();
        int index = 1;
        for (String ext : Globals.g_fileTypeData.getSASFileTypes()) {
            String currentProduct;
            String selectedProduct = this.editorsHash.get(ext).getCellEditorValue().toString();
            if (!selectedProduct.equals(currentProduct = Globals.g_fileTypeData.getCurrentProductForFileType(ext))) {
                Globals.g_fileTypeData.setUserSelectedProductForFileType(ext, selectedProduct);
            }
            data.add(" PRODUCT_FOR_FILETYPE" + Integer.toString(index++) + "=" + ext + "," + selectedProduct);
        }
        return data.toArray(new String[0]);
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        return 0;
    }

    class TableExtensionData {
        private String m_extCode = null;
        private Collection<String> m_products = null;

        public TableExtensionData(String extensionCode, Collection<String> prods) {
            this.m_extCode = extensionCode;
            this.m_products = prods;
        }

        public String getExtension() {
            return this.m_extCode;
        }

        public Collection<String> getProductList() {
            return this.m_products;
        }
    }

    private class ComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        private ComboBoxRenderer() {
        }

        @Override
        public void updateUI() {
            super.updateUI();
        }

        @Override
        public void revalidate() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.removeAllItems();
                this.addItem(value);
            }
            return this;
        }
    }
}

