/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConfigureData;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DynamicDialogs;
import com.sas.ssn.Globals;
import com.sas.ssn.HyperlinkField;
import com.sas.ssn.InstallDefaults;
import com.sas.ssn.JREData;
import com.sas.ssn.KitAction;
import com.sas.ssn.KitBrowseButton;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Language;
import com.sas.ssn.Logging;
import com.sas.ssn.PanelExecute;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.SSNResource;
import com.sas.ssn.ThirdParty;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.ssn.WizardPromptedIface;
import com.sas.swing.visuals.util.Util;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;

public class PanelJRE
implements WizardPanelIface,
WizardPromptedIface,
ActionListener {
    private final String RESPONSE_NONE = "none";
    private final String RESPONSE_RECOMMENDED = "recommended";
    private final String RESPONSE_SELECTED = "selected";
    private SSNResource bundle = new SSNResource(PanelJRE.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_headerText = null;
    private HyperlinkField m_supportLink = null;
    private JRadioButton m_noneOption = null;
    private JTextArea m_noneText = null;
    private JRadioButton m_recommendedOption = null;
    private JTextArea m_recommendedText = null;
    private KitTextField m_jreDestDir = null;
    private KitBrowseButton m_destBrowseButton = null;
    private JRadioButton m_selectedOption = null;
    private JTextArea m_selectedText = null;
    private KitTextField m_jreDir = null;
    private KitBrowseButton m_browseButton = null;
    private boolean m_panelLoaded = false;
    private boolean m_displayErrMsg = true;
    private int m_level = -1;
    private String m_code = null;
    private String m_version = null;
    private String m_name = null;
    private String m_location = null;
    private String m_lastJREPath = "";
    private String m_lastJREVer = "";
    private String m_recommendedVer = "";
    private boolean m_jreRecommended = false;
    private boolean is_jreResetNeeded = false;

    public PanelJRE() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelJRE.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        if (Utils.getOS() == 8 || Utils.getOS() == 10) {
            return this.bundle.getString("PanelJRE.HeaderDesc.txt");
        }
        return this.bundle.getString("PanelJRE.Info.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        String errMsg = null;
        this.m_level = -1;
        Globals.g_deploymentJREHome = null;
        if (this.m_noneOption != null && this.m_noneOption.isSelected()) {
            String javahome = System.getProperty("java.home");
            if (javahome.startsWith(Globals.g_startupLocation)) {
                String dst;
                Logging.log.info("This system does not have a JRE installed. Make a copy under SAS Home.");
                String ProductPath = Globals.g_deploymentData.getProductDir(Globals.g_order, "privatejre", true, false);
                Globals.g_deploymentJREHome = dst = Utils.joinPath(Utils.getSDMHome(Globals.g_wizardData.getPreference("SASHome", "")), ProductPath);
                JREData.copyJREToSASHomeMVS = true;
            } else {
                Globals.g_deploymentJREHome = javahome;
            }
            Globals.g_jreHome = null;
        } else if (this.m_recommendedOption != null && this.m_recommendedOption.isSelected()) {
            if (this.m_jreDestDir != null) {
                String jreDestDir = this.m_jreDestDir.getText().trim();
                this.m_jreDestDir.setText(jreDestDir);
                if (jreDestDir.length() == 0) {
                    valid = false;
                    if (Globals.g_quietMode) {
                        Wizard.logResponseMissing(this.getHeader(), "JRE_DESTINATION");
                    } else {
                        errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelJRE.DestFieldName.txt"));
                    }
                }
                if (valid) {
                    if (Utils.getOS() == 6) {
                        jreDestDir = Utils.VMSToUnixPath(jreDestDir);
                    }
                    if (Utils.pathContainsValidChars(jreDestDir)) {
                        valid = Utils.validatePath(jreDestDir);
                        if (valid) {
                            this.m_level = 0;
                        } else if (Globals.g_quietMode) {
                            Wizard.logResponseInvalid(this.getHeader(), "JRE_DESTINATION", jreDestDir, null);
                        } else {
                            errMsg = this.bundle.messageString("Common.Error.InvalidField.txt", this.bundle.getString("PanelJRE.DestFieldName.txt"));
                        }
                    } else {
                        valid = false;
                        if (Globals.g_quietMode) {
                            String quietMsg = null;
                            quietMsg = Utils.getOS() == 1 ? "The following characters are invalid: / : * ? \" < > |" : (Utils.getOS() == 9 ? "The following characters are invalid: \\ :" : "The following characters are invalid: <space> % * \" & ? : < > \\ | ( )");
                            Wizard.logResponseInvalid(this.getHeader(), "JRE_DESTINATION", jreDestDir, quietMsg);
                        } else {
                            errMsg = Utils.getOS() == 1 ? this.bundle.messageString("Common.Error.InvalidChars.Windows.txt", this.bundle.getString("PanelJRE.DestFieldName.txt")) : (Utils.getOS() == 9 ? this.bundle.messageString("Common.Error.InvalidChars.Mac.txt", this.bundle.getString("PanelJRE.DestFieldName.txt")) : this.bundle.messageString("Common.Error.InvalidChars.UNIX.txt", this.bundle.getString("PanelJRE.DestFieldName.txt")));
                        }
                    }
                }
                if (!(!valid || Globals.g_skipSpaceCheck || Globals.g_recordMode && Globals.g_recordOnly)) {
                    long totalSize = Globals.g_deploymentData.getSpsSkuByProdCode(Globals.g_order, "javaruntime", Utils.getOS_Suffix(), false).getInstalledSize(Utils.getOS_Suffix(), new String[]{Language.gs_SelectedLanguage});
                    long freeSpace = Utils.getFreeSpace(jreDestDir);
                    String displayTotalSize = Utils.getAdjustedSize(totalSize);
                    String displayFreeSpace = Utils.getAdjustedSize(freeSpace);
                    if (totalSize > freeSpace) {
                        if (Globals.g_quietMode) {
                            valid = false;
                            Logging.log.severe("The Java Runtime Environment requires " + displayTotalSize + " and the specified directory only has " + displayFreeSpace + " available.");
                        } else if (CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelJRE.InsufficientSpace.txt", displayTotalSize, displayFreeSpace), Globals.g_wizard.getWizardTitle(), 0, 3, 1) == 1) {
                            valid = false;
                        }
                    }
                }
                if (!(!valid || Globals.g_recordMode && Globals.g_recordOnly || Utils.canWriteToPath(jreDestDir))) {
                    valid = false;
                    if (Globals.g_quietMode) {
                        Wizard.logResponseInvalid(this.getHeader(), "JRE_DESTINATION", jreDestDir, "Insufficient permission to write to the Java Runtime Environment Destination specified.");
                    } else {
                        errMsg = this.bundle.messageString("Common.Error.NoPermissions.txt", this.bundle.getString("PanelJRE.DestFieldName.txt"));
                    }
                }
            }
            if (valid) {
                String jrePath;
                if (!this.m_jreRecommended && (jrePath = ThirdParty.getInstalledPath("privatejre")) != null) {
                    Globals.g_jreHome = jrePath;
                }
                if (this.m_jreDestDir != null) {
                    Globals.g_jreHome = this.m_jreDestDir.getText();
                } else if (Utils.getOS() == 1) {
                    if (!this.m_jreRecommended) {
                        if (Utils.getOS_Suffix().equals("wx6")) {
                            String ProgramFilesDir = WinRegAPI.getWindowsRegistryValue(8, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion", "ProgramFilesDir");
                            Globals.g_jreHome = Utils.joinPath(ProgramFilesDir, "Java", "jre" + this.m_recommendedVer);
                        } else {
                            Globals.g_jreHome = Utils.joinPath(Utils.getProgramFilesDir(), "Java", "jre" + this.m_recommendedVer);
                        }
                        Logging.log.info("Recommended JRE not found. Install to: " + Globals.g_jreHome);
                    } else {
                        Globals.g_jreHome = this.m_location;
                        Logging.log.info("Recommended JRE found: " + this.m_location);
                    }
                }
                if (Utils.getOS_Suffix() == "lax" || Utils.getOS_Suffix() == "r64" || Utils.getOS_Suffix() == "s64" || Utils.getOS_Suffix() == "sax" || Utils.getOS_Suffix() == "h6i") {
                    Globals.g_jreHome = Utils.joinPath(Globals.g_jreHome, "jre");
                }
                if (valid && !ThirdParty.verifyJreFunction(Globals.g_jreHome)) {
                    Logging.log.warning("Wizard has detected problems with the recommended JRE " + this.m_recommendedVer + " that you have chosen to use for this installation.");
                    if (!Globals.g_skipThirdPartyCheck) {
                        valid = false;
                        if (!Globals.g_quietMode) {
                            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelJRE.corruptedJREPath.txt", this.m_recommendedVer), this.bundle.getString("Common.Warning.txt"), 2);
                            this.m_displayErrMsg = false;
                        }
                    }
                }
            } else if (!Globals.g_quietMode) {
                if (errMsg != null) {
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
                }
                this.m_jreDestDir.requestFocus();
            }
        } else {
            String jreDir = this.m_jreDir.getText().trim();
            this.m_jreDir.setText(jreDir);
            if (jreDir.length() == 0) {
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseMissing(this.getHeader(), "JRE_PATH");
                } else {
                    errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelJRE.FieldName.txt"));
                }
            }
            if (valid) {
                this.m_displayErrMsg = true;
                if (Utils.getOS() == 6) {
                    jreDir = Utils.VMSToUnixPath(jreDir);
                }
                if (!valid) {
                    if (Globals.g_quietMode) {
                        Wizard.logResponseInvalid(this.getHeader(), "JRE_PATH", jreDir, null);
                    } else if (this.m_displayErrMsg) {
                        errMsg = this.bundle.getString("PanelJRE.BadJREPath.txt");
                    }
                }
            }
            if (valid) {
                if (Utils.getOS_Suffix() == "lax" && new File(jreDir, "lib/i386/jvm.cfg").isFile()) {
                    valid = false;
                } else if (Utils.getOS_Suffix() == "wx6") {
                    if (Globals.g_sasinstallPlat != null && Globals.g_sasinstallPlat.equalsIgnoreCase("win")) {
                        if (!new File(jreDir, "lib/i386/jvm.cfg").isFile()) {
                            errMsg = this.bundle.getString("PanelJRE.32BitX64JREPathRequired.txt");
                            valid = false;
                        }
                    } else if (new File(jreDir, "lib/i386/jvm.cfg").isFile()) {
                        errMsg = this.bundle.getString("PanelJRE.64BitX64JREPathRequired.txt");
                        valid = false;
                    }
                }
                if (!valid && Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), "JRE_PATH", jreDir, null);
                }
            }
            if (valid) {
                Globals.g_jreHome = jreDir;
            } else if (!Globals.g_quietMode) {
                if (errMsg != null) {
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
                }
                this.m_jreDir.requestFocus();
            }
        }
        if (valid) {
            this.m_location = Globals.g_jreHome;
            this.loadInstallDialogs();
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean displayPanel() {
        String jreVersion;
        int level;
        Logging.log.info("Globals.g_sasinstallPlat=" + Globals.g_sasinstallPlat);
        boolean display = false;
        if (Globals.g_zos && !Globals.g_forceJREPrompt) {
            JREData.jreNeeded = false;
        } else if (Utils.getOS() == 8) {
            this.m_code = "javaruntime";
            this.m_version = Globals.g_majorReleaseVersion;
            this.m_name = "Java Platform Standard Edition Runtime Environment";
            JREData.jreNeeded = true;
            if (Globals.g_forceJREPrompt || Globals.g_recordMode && Globals.g_recordOnly) {
                display = true;
            }
            if (JREData.jreNeeded) {
                String jrePath = null;
                RegistryAccess m_registryAccess = null;
                try {
                    String sashome = Globals.g_wizardData.getPreference("SASHome", "");
                    File deployRegJar = new File(Utils.joinPath(sashome, "deploymntreg"), "sas.tools.deploymntreg.jar");
                    m_registryAccess = new RegistryAccess(deployRegJar.getAbsolutePath());
                    if (m_registryAccess != null && m_registryAccess.open()) {
                        jrePath = m_registryAccess.getInstallLoc("javaruntime", Globals.g_majorReleaseVersion);
                    }
                }
                catch (FileNotFoundException sashome) {
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
                finally {
                    if (m_registryAccess != null) {
                        m_registryAccess.close();
                        m_registryAccess = null;
                    }
                }
                if (jrePath == null) {
                    display = true;
                } else {
                    this.m_location = jrePath;
                    Globals.g_jreHome = jrePath;
                    Logging.log.info("JRE path = " + jrePath);
                }
            }
        } else {
            display = false;
            JREData.jreNeeded = false;
            ProductData jreData = Globals.g_deploymentData.getProduct(Globals.g_order, "javaruntime", false);
            if (jreData != null) {
                this.m_code = jreData.getProdCode();
                this.m_version = jreData.getProdVersion();
                this.m_name = jreData.getProdName();
                if (Globals.g_forceJREPrompt) {
                    JREData.jreNeeded = true;
                    display = true;
                } else {
                    JREData.jreNeeded = false;
                    if (Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired()) {
                        JREData.jreNeeded = true;
                    }
                }
                if (JREData.jreNeeded) {
                    String jrePath = null;
                    RegistryAccess m_registryAccess = null;
                    try {
                        String sashome = Globals.g_wizardData.getPreference("SASHome", "");
                        File deployRegJar = new File(Utils.joinPath(sashome, "deploymntreg"), "sas.tools.deploymntreg.jar");
                        m_registryAccess = new RegistryAccess(deployRegJar.getAbsolutePath());
                        if (m_registryAccess != null && m_registryAccess.open()) {
                            jrePath = m_registryAccess.getInstallLoc(this.m_code, Globals.g_majorReleaseVersion, jreData.getPlatform());
                            String version = null;
                            if (jrePath != null && (version = ThirdParty.getVersion("javaruntime", jrePath)) == null) {
                                jrePath = null;
                            }
                            if (jrePath == null && (jrePath = m_registryAccess.getInstallLoc(this.m_code, this.m_version, jreData.getPlatform())) != null && (version = ThirdParty.getVersion("javaruntime", jrePath)) == null) {
                                jrePath = null;
                            }
                            if (jrePath != null && !ThirdParty.verifyJreFunction(jrePath)) {
                                jrePath = null;
                            }
                            if (jrePath != null) {
                                Logging.log.info("JRE path = " + jrePath);
                            }
                        }
                    }
                    catch (FileNotFoundException sashome) {
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                    finally {
                        if (m_registryAccess != null) {
                            m_registryAccess.close();
                            m_registryAccess = null;
                        }
                    }
                    if (jrePath == null && this.is_jreResetNeeded) {
                        jrePath = ThirdParty.getInstalledPath("javaruntime");
                        if (jrePath != null) {
                            this.m_location = jrePath;
                        }
                        this.is_jreResetNeeded = true;
                        display = true;
                    } else {
                        this.m_location = jrePath;
                        Globals.g_jreHome = jrePath;
                    }
                }
            }
        }
        JREData.g_jrePrompted = display;
        if (!display && JREData.getPrivateJREDest() != null) {
            Globals.g_jreHome = JREData.getPrivateJREHOME();
            Logging.log.fine("Globals.g_jreHome=" + Globals.g_jreHome);
            Logging.log.fine("JREData.jrehome=" + JREData.getPrivateJREHOME());
        }
        if (Utils.getOS() == 1 && display && (level = ThirdParty.getLevel("javaruntime", jreVersion = ThirdParty.getVersion("javaruntime", this.m_location))) == 0) {
            this.m_jreRecommended = true;
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = Globals.g_srwOnly ? "systemrequisitesrequired" : (Globals.g_dynamicInstallDialogs != null && Globals.g_dynamicInstallDialogs.length > 0 ? Globals.g_dynamicInstallDialogs[0] : "systemcheck");
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        this.m_recommendedVer = ThirdParty.getRecommendedVersion("javaruntime");
        if (!this.m_panelLoaded || this.is_jreResetNeeded) {
            boolean responseLoaded = this.loadResponseData();
            if (this.is_jreResetNeeded && this.m_jreDestDir != null && this.m_jreDestDir.getText().length() == 0) {
                this.m_jreDestDir.setText(this.getDefaultJREDestDir());
            }
            if (this.is_jreResetNeeded) {
                if (this.m_jreDir != null && this.m_jreDir.getText().length() == 0 && this.m_location != null) {
                    this.m_jreDir.setText(this.m_location);
                }
                if (!((responseLoaded || Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired()) && !this.is_jreResetNeeded || this.m_selectedOption == null)) {
                    this.m_selectedOption.setSelected(true);
                }
            }
            this.m_panelLoaded = true;
        }
        this.setRadioState();
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        JComponent focus = null;
        focus = Utils.getOS() == 8 || Utils.getOS() == 10 ? (this.m_noneOption != null && this.m_noneOption.isSelected() ? this.m_noneOption : (this.m_recommendedOption != null && this.m_recommendedOption.isSelected() ? this.m_recommendedOption : this.m_noneOption)) : this.m_selectedText;
        return focus;
    }

    @Override
    public boolean silentEvent() {
        this.m_recommendedVer = ThirdParty.getRecommendedVersion("javaruntime");
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = null;
        if (Utils.getOS() != 8 && Utils.getOS() != 10) {
            String path = "";
            if (this.m_jreDir != null) {
                path = this.m_jreDir.getText();
            }
            data = new String[]{"#JRE_OPTION=recommended/selected/none", " JRE_OPTION=selected", "#JRE_PATH=<full path - only if JRE_OPTION=selected>", " JRE_PATH=" + path};
        } else {
            data = Globals.g_quietMode && Globals.g_recordMode ? new String[]{"#JRE_OPTION=recommended/selected/none", " JRE_OPTION=recommended", "#JRE_PATH=<full path - only if JRE_OPTION=selected>", " JRE_PATH=", "#JRE_DESTINATION=<full path - only if JRE_OPTION=recommended>", " JRE_DESTINATION="} : (Utils.getOS() == 8 ? new String[]{"#JRE_OPTION=none/selected", " JRE_OPTION=selected", "#JRE_PATH=<full path - only if JRE_OPTION=selected>", " JRE_PATH="} : new String[]{"#JRE_OPTION=recommended/selected", " JRE_OPTION=recommended", "#JRE_PATH=<full path - only if JRE_OPTION=selected>", " JRE_PATH=", "#JRE_DESTINATION=<full path - only if JRE_OPTION=recommended>", " JRE_DESTINATION="});
            if (this.m_panelLoaded) {
                if (this.m_noneOption != null && this.m_noneOption.isSelected()) {
                    data[1] = " JRE_OPTION=none";
                }
                if (this.m_selectedOption != null && this.m_selectedOption.isSelected()) {
                    data[1] = " JRE_OPTION=selected";
                    data[3] = " JRE_PATH=" + this.m_jreDir.getText();
                } else if (this.m_jreDestDir != null) {
                    data[5] = " JRE_DESTINATION=" + this.m_jreDestDir.getText();
                }
            }
        }
        return data;
    }

    @Override
    public void initializePanel() {
        this.loadInstallDialogs();
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        JTextArea[] infos;
        JRadioButton[] options = null;
        options = Utils.getOS_Suffix() == "z64" || Utils.getOS_Suffix() == "mvs" ? new JRadioButton[]{this.m_noneOption, this.m_selectedOption} : new JRadioButton[]{this.m_noneOption, this.m_recommendedOption, this.m_selectedOption};
        int returnCode = ConsoleMode.promptRadioButtons(options, infos = new JTextArea[]{this.m_noneText, this.m_recommendedText, this.m_selectedText});
        if (returnCode > -1) {
            this.setRadioState();
            if (this.m_recommendedOption != null && this.m_recommendedOption.isSelected()) {
                if (this.m_jreDestDir != null) {
                    returnCode = ConsoleMode.promptText(this.bundle.getString("PanelJRE.DestFieldName.txt"), this.m_jreDestDir);
                }
            } else if (this.m_selectedOption != null && this.m_selectedOption.isSelected()) {
                returnCode = ConsoleMode.promptText(this.bundle.getString("PanelJRE.SelectedText.txt"), this.m_jreDir);
            }
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String responseOption = Wizard.getResponse("JRE_OPTION", null);
        if (responseOption != null) {
            if (this.m_noneOption != null && responseOption.equalsIgnoreCase("none")) {
                valid = true;
                this.m_noneOption.setSelected(true);
            } else if (this.m_recommendedOption != null && responseOption.equalsIgnoreCase("recommended")) {
                valid = true;
                this.m_recommendedOption.setSelected(true);
            } else if (responseOption.equalsIgnoreCase("selected")) {
                valid = true;
                if (this.m_selectedOption != null) {
                    this.m_selectedOption.setSelected(true);
                }
            } else if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "JRE_OPTION", responseOption, null);
            }
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), "JRE_OPTION");
        }
        String responseJREPath = Wizard.getResponse("JRE_PATH", null);
        if (responseJREPath != null) {
            this.m_jreDir.setText(responseJREPath);
        } else if (Globals.g_quietMode && (Utils.getOS_Suffix() == "z64" || Utils.getOS_Suffix() == "mvs") && this.m_selectedOption.isSelected()) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "JRE_PATH");
        }
        if (this.m_jreDestDir != null) {
            String jreDest = Wizard.getResponse("JRE_DESTINATION", null);
            if (jreDest != null) {
                if (jreDest.length() == 0) {
                    this.m_jreDestDir.setText(this.getDefaultJREDestDir());
                } else {
                    this.m_jreDestDir.setText(jreDest);
                }
            } else if (Globals.g_quietMode && this.m_recommendedOption.isSelected()) {
                valid = false;
                Wizard.logResponseMissing(this.getHeader(), "JRE_DESTINATION");
            }
        }
        return valid;
    }

    private void initialize() {
        if (Utils.getOS_Suffix() == "z64" || Utils.getOS_Suffix() == "mvs") {
            this.initialize_mvs();
        } else {
            this.initialize_others();
        }
    }

    private void initialize_mvs() {
        this.m_headerText = new JTextArea(this.bundle.getString("PanelJRE.Info.txt"));
        this.m_headerText.setEditable(false);
        this.m_headerText.setFocusable(false);
        this.m_headerText.setLineWrap(true);
        this.m_headerText.setWrapStyleWord(true);
        this.m_headerText.setOpaque(false);
        this.m_supportLink = new HyperlinkField();
        this.m_supportLink.setOpaque(false);
        this.m_supportLink.setEditable(false);
        this.m_supportLink.setContentType("text/html");
        this.m_supportLink.setText(this.bundle.getString("PanelJRE.SupportLink.txt"), this.getSupportLink());
        this.m_supportLink.setCaretPosition(0);
        String mtxt = null;
        Font optionFont = null;
        mtxt = this.bundle.getString("PanelJRE.NoneOption.txt");
        this.m_noneOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_noneOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_noneOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_noneOption.getFont();
        this.m_noneOption.setFont(optionFont.deriveFont(1));
        this.m_noneText = new JTextArea(this.bundle.getString("PanelJRE.NoneText.txt"));
        this.m_noneText.setEditable(false);
        this.m_noneText.setFocusable(false);
        this.m_noneText.setLineWrap(true);
        this.m_noneText.setWrapStyleWord(true);
        this.m_noneText.setOpaque(false);
        mtxt = this.bundle.getString("PanelJRE.SelectedOption.txt");
        this.m_selectedOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_selectedOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_selectedOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_selectedOption.setSelected(true);
        optionFont = this.m_selectedOption.getFont();
        this.m_selectedOption.setFont(optionFont.deriveFont(1));
        this.m_selectedText = new JTextArea(this.bundle.getString("PanelJRE.SelectedText.txt"));
        this.m_selectedText.setEditable(false);
        this.m_selectedText.setFocusable(false);
        this.m_selectedText.setLineWrap(true);
        this.m_selectedText.setWrapStyleWord(true);
        this.m_selectedText.setOpaque(false);
        this.m_jreDir = new KitTextField();
        this.is_jreResetNeeded = true;
        mtxt = this.bundle.getString("Common.Browse2.txt");
        this.m_browseButton = new KitBrowseButton(Util.getLabelWithoutMnemonic(mtxt), "", 0, this.m_jreDir);
        this.m_browseButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_browseButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_browseButton.setFileSelectionMode(1);
        ButtonGroup group = new ButtonGroup();
        if (this.m_noneOption != null) {
            group.add(this.m_noneOption);
            this.m_noneOption.addActionListener(this);
        }
        if (this.m_recommendedOption != null) {
            group.add(this.m_recommendedOption);
            this.m_recommendedOption.addActionListener(this);
        }
        group.add(this.m_selectedOption);
        this.m_selectedOption.addActionListener(this);
    }

    private void initialize_others() {
        this.m_headerText = new JTextArea(this.bundle.getString("PanelJRE.Info.txt"));
        this.m_headerText.setEditable(false);
        this.m_headerText.setFocusable(false);
        this.m_headerText.setLineWrap(true);
        this.m_headerText.setWrapStyleWord(true);
        this.m_headerText.setOpaque(false);
        this.m_selectedText = new JTextArea(this.bundle.getString("PanelJRE.SelectedText.others.txt"));
        this.m_selectedText.setEditable(false);
        this.m_selectedText.setFocusable(false);
        this.m_selectedText.setLineWrap(true);
        this.m_selectedText.setWrapStyleWord(true);
        this.m_selectedText.setOpaque(false);
        this.m_jreDir = new KitTextField();
        String mtxt = null;
        mtxt = this.bundle.getString("Common.Browse2.txt");
        this.m_browseButton = new KitBrowseButton(Util.getLabelWithoutMnemonic(mtxt), "", 0, this.m_jreDir);
        this.m_browseButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_browseButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_browseButton.setFileSelectionMode(1);
        this.m_supportLink = new HyperlinkField();
        this.m_supportLink.setOpaque(false);
        this.m_supportLink.setEditable(false);
        this.m_supportLink.setContentType("text/html");
        this.m_supportLink.setText(this.bundle.getString("PanelJRE.SupportLink.txt"), this.getSupportLink());
        this.m_supportLink.setCaretPosition(0);
        ButtonGroup group = new ButtonGroup();
        if (this.m_noneOption != null) {
            group.add(this.m_noneOption);
            this.m_noneOption.addActionListener(this);
        }
        if (this.m_recommendedOption != null) {
            group.add(this.m_recommendedOption);
            this.m_recommendedOption.addActionListener(this);
        }
    }

    @Override
    public String getProductCode() {
        return this.m_code;
    }

    @Override
    public String getVersion() {
        return this.m_version;
    }

    @Override
    public String getProductName() {
        return this.m_name;
    }

    @Override
    public String getLocation() {
        return this.m_location;
    }

    @Override
    public int getLevel() {
        return this.m_level;
    }

    @Override
    public String getSelectedVersion() {
        return null;
    }

    private void layoutWidgets() {
        if (Utils.getOS_Suffix() == "z64" || Utils.getOS_Suffix() == "mvs") {
            this.layoutWidgets_mvs();
        } else {
            this.layoutWidgets_others();
        }
    }

    private void layoutWidgets_mvs() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_headerText, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_supportLink, c);
        if (this.m_noneOption != null) {
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.anchor = 18;
            c.fill = 2;
            c.insets = new Insets(10, 0, 0, 0);
            this.m_panel.add((Component)this.m_noneOption, c);
            c.gridx = 0;
            c.gridy = 3;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.anchor = 18;
            c.fill = 2;
            c.insets = new Insets(10, 20, 0, 0);
            this.m_panel.add((Component)this.m_noneText, c);
        }
        if (this.m_recommendedOption != null) {
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.anchor = 18;
            c.fill = 2;
            c.insets = new Insets(10, 0, 0, 0);
            this.m_panel.add((Component)this.m_recommendedOption, c);
            c.gridx = 0;
            c.gridy = 3;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.anchor = 18;
            c.fill = 2;
            c.insets = new Insets(10, 20, 0, 0);
            this.m_panel.add((Component)this.m_recommendedText, c);
        }
        if (this.m_jreDestDir != null) {
            c.gridx = 0;
            c.gridy = 4;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.anchor = 18;
            c.fill = 2;
            c.insets = new Insets(10, 20, 0, 0);
            this.m_panel.add((Component)this.m_jreDestDir, c);
            c.gridx = 1;
            c.gridy = 4;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.anchor = 18;
            c.fill = 0;
            c.insets = new Insets(10, 5, 0, 0);
            this.m_panel.add((Component)this.m_destBrowseButton, c);
        }
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_selectedOption, c);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 20, 0, 0);
        this.m_panel.add((Component)this.m_selectedText, c);
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 20, 0, 0);
        this.m_panel.add((Component)this.m_jreDir, c);
        c.gridx = 1;
        c.gridy = 7;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 0;
        c.insets = new Insets(10, 5, 0, 0);
        this.m_panel.add((Component)this.m_browseButton, c);
    }

    private void layoutWidgets_others() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        if (this.m_noneOption != null) {
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.anchor = 18;
            c.fill = 2;
            c.insets = new Insets(10, 0, 0, 0);
            this.m_panel.add((Component)this.m_noneOption, c);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.anchor = 18;
            c.fill = 2;
            c.insets = new Insets(10, 20, 0, 0);
            this.m_panel.add((Component)this.m_noneText, c);
        }
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_selectedText, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_jreDir, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 0;
        c.insets = new Insets(10, 5, 0, 0);
        this.m_panel.add((Component)this.m_browseButton, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_supportLink, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_noneOption || obj == this.m_recommendedOption || obj == this.m_selectedOption) {
            this.setRadioState();
        }
    }

    private void setRadioState() {
        if (Utils.getOS_Suffix() == "z64" || Utils.getOS_Suffix() == "mvs") {
            boolean selectedOption = this.m_selectedOption.isSelected();
            if (this.m_jreDestDir != null) {
                this.m_jreDestDir.setEnabled(!selectedOption);
                this.m_destBrowseButton.setEnabled(!selectedOption);
            }
            this.m_jreDir.setEnabled(selectedOption);
            this.m_browseButton.setEnabled(selectedOption);
        }
    }

    private String getSupportLink() {
        String link = "https://support.sas.com/resources/thirdpartysupport/index.html";
        return link;
    }

    private boolean validateJREPath(String jrePath) {
        boolean valid = true;
        String jreVersion = ThirdParty.getVersion("javaruntime", jrePath);
        if (jreVersion == null) {
            if (Globals.g_skipThirdPartyCheck && new File(jrePath).isDirectory()) {
                this.m_level = 2;
            } else {
                valid = false;
            }
        } else {
            this.m_level = ThirdParty.getLevel("javaruntime", jreVersion);
            if (this.m_level != 0 && this.m_level != 1) {
                File fileJREPath;
                if (Globals.g_quietMode) {
                    Logging.log.warning("Version " + jreVersion + " of the JRE was selected in quiet mode.");
                } else if (!(Globals.g_skipThirdPartyCheck || this.m_lastJREPath.equals((fileJREPath = new File(jrePath)).getAbsolutePath()) && this.m_lastJREVer.equals(jreVersion))) {
                    this.m_displayErrMsg = false;
                    if (Utils.getOS() == 8 || Utils.getOS() == 10 && jreVersion != this.m_recommendedVer) {
                        valid = false;
                        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelJRE.BadJREVersionMVS.txt", jreVersion, this.m_recommendedVer), this.bundle.getString("Common.Error.txt"), 0);
                    } else if (CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelJRE.BadJREVersion.txt", jreVersion, this.m_recommendedVer), Globals.g_wizard.getWizardTitle(), 0, 3, 1) == 1) {
                        valid = false;
                    }
                    if (valid) {
                        this.m_lastJREPath = fileJREPath.getAbsolutePath();
                        this.m_lastJREVer = jreVersion;
                    }
                }
            }
            if (valid && !ThirdParty.verifyJreFunction(jrePath)) {
                Logging.log.warning("Wizard has detected problems with the JRE " + jreVersion + " that you have chosen to use for this installation.");
                if (!Globals.g_skipThirdPartyCheck) {
                    valid = false;
                    if (!Globals.g_quietMode) {
                        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelJRE.corruptedJREPath.txt", jreVersion), this.bundle.getString("Common.Warning.txt"), 2);
                        this.m_displayErrMsg = false;
                    }
                }
            }
        }
        return valid;
    }

    private String getDefaultJREDestDir() {
        return Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "jre" + this.m_recommendedVer);
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            KitAction.launchWebBrowser(event.getURL());
        }
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    private void loadInstallDialogs() {
        if (Globals.g_install) {
            File tmpFile;
            String parent;
            PanelExecute panelExecute = (PanelExecute)Globals.g_wizard.getPanel("execute");
            panelExecute.getInstallProducts(true);
            Globals.g_installDefaults = new InstallDefaults();
            if (Globals.g_zos) {
                if (Globals.g_zosCartridge) {
                    Globals.g_installData.setProperty("zos.media.type", "true");
                } else {
                    Globals.g_installData.setProperty("zos.media.type", "false");
                }
            }
            if (Utils.getOS_Suffix() == "mvs") {
                if (Globals.g_z64) {
                    Globals.g_installData.setProperty("zos.bit.count", "64");
                } else {
                    Globals.g_installData.setProperty("zos.bit.count", "31");
                }
            }
            if (Globals.g_plannedInstall) {
                Globals.g_installData.setProperty("deployment.is.planned", "true");
            } else {
                Globals.g_installData.setProperty("deployment.is.planned", "false");
            }
            HashMap<String, String> localeProperties = ConfigureData.getLocaleProperties();
            for (String key : localeProperties.keySet()) {
                Globals.g_installData.setProperty(key, localeProperties.get(key));
            }
            String programDataDir = "";
            if (Utils.getOS() == 1 && (programDataDir = System.getenv("ALLUSERSPROFILE")) == null) {
                programDataDir = "";
            }
            Globals.g_installData.setProperty("os.localhost.fqdn.host.name", ConfigureData.getDefaultHost());
            Globals.g_installData.setProperty("os.localhost.host.name", ConfigureData.getHostName());
            Globals.g_installData.setProperty("wizard.type", "sdw");
            Globals.g_installData.setProperty("sas.home.dir", Globals.g_wizardData.getPreference("SASHome", ""));
            Globals.g_installData.setProperty("win.program.data", programDataDir);
            Globals.g_installData.setProperty("sas.startup.location", Globals.g_startupLocation);
            Globals.g_installData.setProperty("os.localhost.userid", System.getProperty("user.name"));
            Globals.g_installData.setProperty("os.localhost.logon.domain", Utils.getUserDomain());
            if (Globals.g_mominstallSID != null) {
                Globals.g_installData.setProperty("mominstall.products.sidlocation", Globals.g_mominstallSID.getSIDFile().toString());
            }
            if ((parent = (tmpFile = new File(Globals.g_installData.getProperty("sas.home.dir", null))).getParent()) == null) {
                parent = "";
            }
            Globals.g_installData.setProperty("sas.home.parent.dir", parent);
            DynamicDialogs.createDialogs(1);
        }
    }
}

