/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.OrderData;
import com.sas.ssn.PanelStart;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class PanelIncompleteDeployment
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelStart.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JRadioButton m_resumeOption = null;
    private JRadioButton m_ignoreOption = null;
    private JTextArea m_resumeInfo = null;
    private JTextArea m_ignoreInfo = null;
    private boolean m_panelLoaded = false;
    private boolean m_panelFinished = false;

    public PanelIncompleteDeployment() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelIncompleteDeployment.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        if (Globals.g_mode == 0) {
            if (Globals.g_incompleteConfiguration) {
                return this.bundle.getString("PanelIncompleteDeployment.SDWHeaderOtherDesc.txt");
            }
            return this.bundle.getString("PanelIncompleteDeployment.SDWHeaderDesc.txt");
        }
        if (Globals.g_incompleteConfiguration) {
            return this.bundle.getString("PanelIncompleteDeployment.SDMHeaderDesc.txt");
        }
        return this.bundle.getString("PanelIncompleteDeployment.SDMHeaderOtherDesc.txt");
    }

    @Override
    public boolean validateData() {
        if (this.m_resumeOption.isSelected()) {
            Globals.g_resumeChain = true;
            Globals.g_recordMode = false;
            Globals.g_partialPrompt = !Globals.g_quietMode;
            Globals.g_hotFixUpdate = true;
            if (Globals.g_mode == 2 && !Globals.g_incompleteConfiguration || Globals.g_mode == 0 && Globals.g_incompleteConfiguration) {
                Globals.g_deleteChainData = false;
                this.m_panelFinished = true;
            } else {
                Globals.g_chainData.load(true);
                File installRetryPropFile = new File(Utils.getSDWDataPath(false), "installRetry.properties");
                if (installRetryPropFile.exists()) {
                    Globals.g_overrideInstallPropertiesFile = Utils.joinPath(Utils.getSDWDataPath(false), "installRetry.properties");
                } else {
                    Logging.log.warning("Cannot retry installation without a saved installRetry.properties file.");
                }
                File configRetryPropFile = new File(Utils.getSDWDataPath(false), "configRetry.properties");
                if (configRetryPropFile.exists()) {
                    Globals.g_overridePropertiesFile = Utils.joinPath(Utils.getSDWDataPath(false), "configRetry.properties");
                } else {
                    Logging.log.warning("Cannot retry configuration without a saved configRetry.properties file.");
                }
            }
        } else if (this.m_ignoreOption.isSelected()) {
            if (Globals.g_incompleteConfiguration) {
                Globals.g_wizardData.removePreference("IncompleteConfiguration");
                Globals.g_wizardData.removePreference("ConfigDirectory");
                Globals.g_wizardData.save();
                Globals.g_applyConfigMaint = false;
                Globals.g_cmtConfigDirSet = false;
                Globals.g_incompleteConfiguration = false;
            } else {
                Globals.g_wizardData.removePreference("ResumedOrder");
                Globals.g_wizardData.save();
            }
            Globals.g_chainData.delete();
            Globals.g_wizard.createSDWChainRFile(true);
        }
        return true;
    }

    @Override
    public boolean displayPanel() {
        if (Globals.g_resumeChain) {
            if (!Globals.g_chainData.load(true)) {
                // empty if block
            }
            Logging.log.severe("The sdwchainrfile.properties is missing from directory " + Utils.getSDWDataPath(false));
            if (Globals.g_mode != 2) {
                File installRetryPropFile = new File(Utils.getSDWDataPath(false), "installRetry.properties");
                if (installRetryPropFile.exists()) {
                    Globals.g_overrideInstallPropertiesFile = Utils.joinPath(Utils.getSDWDataPath(false), "installRetry.properties");
                } else {
                    Logging.log.warning("Cannot retry installation without a saved installRetry.properties file.");
                }
                File configRetryPropFile = new File(Utils.getSDWDataPath(false), "configRetry.properties");
                if (configRetryPropFile.exists()) {
                    Globals.g_overridePropertiesFile = Utils.joinPath(Utils.getSDWDataPath(false), "configRetry.properties");
                } else {
                    Logging.log.warning("Cannot retry configuration without a saved configRetry.properties file.");
                }
            }
            return false;
        }
        return Globals.g_chainData.load(false);
    }

    @Override
    public String getNextPanelID() {
        if (Globals.g_mode == 2) {
            if (this.m_panelFinished) {
                return "finish";
            }
            return "sdmstart";
        }
        if (this.m_panelFinished) {
            return "finish";
        }
        return "start";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            if (this.m_resumeOption.isEnabled()) {
                this.m_resumeOption.setSelected(true);
            } else {
                this.m_ignoreOption.setSelected(true);
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        JRadioButton focus = null;
        focus = this.m_resumeOption.isSelected() ? this.m_resumeOption : this.m_ignoreOption;
        return focus;
    }

    @Override
    public boolean silentEvent() {
        this.m_ignoreOption.setSelected(true);
        Logging.log.warning("Re-entry will not occur due to running in silent mode.");
        this.validateData();
        return true;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_resumeOption, this.m_ignoreOption};
        JTextArea[] infos = new JTextArea[]{this.m_resumeInfo, this.m_ignoreInfo};
        return ConsoleMode.promptRadioButtons(options, infos);
    }

    private boolean isOrder() {
        boolean isOrder = false;
        if (Globals.g_mode == 2) {
            isOrder = true;
        } else if (Globals.g_order != null && Globals.g_order.equals(Globals.g_wizardData.getPreference("ResumedOrder", null))) {
            isOrder = true;
        } else if (Globals.g_deploymentData.getOrderCount() > 1) {
            OrderData[] orders = Globals.g_deploymentData.getOrders();
            for (int i = 0; i < orders.length && !isOrder; ++i) {
                if (!orders[i].getOrder().equals(Globals.g_wizardData.getPreference("ResumedOrder", null))) continue;
                isOrder = true;
            }
        }
        return isOrder;
    }

    private void initialize() {
        String mtxt = this.bundle.getString("PanelIncompleteDeployment.resumeLabel.txt");
        this.m_resumeOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_resumeOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_resumeOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_resumeOption.getFont();
        this.m_resumeOption.setFont(optionFont.deriveFont(1));
        this.m_resumeOption.setEnabled(this.isOrder());
        if (Globals.g_mode == 0) {
            this.m_resumeInfo = Globals.g_incompleteConfiguration ? new JTextArea(this.bundle.getString("PanelIncompleteDeployment.SDWresumeOtherInfo.txt")) : new JTextArea(this.bundle.getString("PanelIncompleteDeployment.SDWresumeInfo.txt"));
        } else if (Globals.g_mode == 2) {
            this.m_resumeInfo = Globals.g_incompleteConfiguration ? new JTextArea(this.bundle.getString("PanelIncompleteDeployment.SDMresumeInfo.txt")) : new JTextArea(this.bundle.getString("PanelIncompleteDeployment.SDMresumeOtherInfo.txt"));
        }
        this.m_resumeInfo.setEditable(false);
        this.m_resumeInfo.setFocusable(false);
        this.m_resumeInfo.setLineWrap(true);
        this.m_resumeInfo.setWrapStyleWord(true);
        this.m_resumeInfo.setOpaque(false);
        if (Globals.g_mode == 0) {
            mtxt = Globals.g_incompleteConfiguration ? this.bundle.getString("PanelIncompleteDeployment.SDWignoreOtherLabel.txt") : this.bundle.getString("PanelIncompleteDeployment.ignoreLabel.txt");
        } else if (Globals.g_mode == 2) {
            mtxt = Globals.g_incompleteConfiguration ? this.bundle.getString("PanelIncompleteDeployment.ignoreLabel.txt") : this.bundle.getString("PanelIncompleteDeployment.SDMignoreOtherLabel.txt");
        }
        this.m_ignoreOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_ignoreOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_ignoreOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_ignoreOption.getFont();
        this.m_ignoreOption.setFont(optionFont.deriveFont(1));
        if (Globals.g_mode == 0) {
            this.m_ignoreInfo = Globals.g_incompleteConfiguration ? new JTextArea(this.bundle.getString("PanelIncompleteDeployment.SDWignoreOtherInfo.txt")) : new JTextArea(this.bundle.getString("PanelIncompleteDeployment.SDWignoreInfo.txt"));
        } else if (Globals.g_mode == 2) {
            this.m_ignoreInfo = Globals.g_incompleteConfiguration ? new JTextArea(this.bundle.getString("PanelIncompleteDeployment.SDMignoreInfo.txt")) : new JTextArea(this.bundle.getString("PanelIncompleteDeployment.SDMignoreOtherInfo.txt"));
        }
        this.m_ignoreInfo.setEditable(false);
        this.m_ignoreInfo.setFocusable(false);
        this.m_ignoreInfo.setLineWrap(true);
        this.m_ignoreInfo.setWrapStyleWord(true);
        this.m_ignoreInfo.setOpaque(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_resumeOption);
        group.add(this.m_ignoreOption);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.gridy = 1;
        c.insets = new Insets(5, 20, 5, 0);
        this.m_panel.add((Component)this.m_resumeOption, c);
        c.gridy = 2;
        c.insets = new Insets(5, 40, 5, 0);
        this.m_panel.add((Component)this.m_resumeInfo, c);
        c.gridy = 3;
        c.insets = new Insets(5, 20, 5, 0);
        this.m_panel.add((Component)this.m_ignoreOption, c);
        c.gridy = 4;
        c.insets = new Insets(5, 40, 5, 0);
        this.m_panel.add((Component)this.m_ignoreInfo, c);
    }

    @Override
    public String getHelpTopic() {
        String helpTopic = null;
        if (Globals.g_mode == 0) {
            helpTopic = Globals.g_incompleteConfiguration ? "PanelIncompleteDeploymentSDWWithIncompleteSDM" : "PanelIncompleteDeploymentSDWWithIncompleteSDW";
        } else if (Globals.g_mode == 2) {
            helpTopic = Globals.g_incompleteConfiguration ? "PanelIncompleteDeploymentSDMWithIncompleteSDM" : "PanelIncompleteDeploymentSDMWithIncompleteSDW";
        }
        return helpTopic;
    }
}

