/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.HotFix;
import com.sas.ssn.InstallToolConnector;
import com.sas.ssn.KitAction;
import com.sas.ssn.Logging;
import com.sas.ssn.PrintableEditorPane;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class PanelHotFixPreInstallSummary
implements WizardPanelIface,
HyperlinkListener,
ActionListener {
    private SSNResource bundle = new SSNResource(PanelHotFixPreInstallSummary.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_instructions = null;
    private JScrollPane m_scrollPane = null;
    private PrintableEditorPane m_summaryText = null;
    private JButton m_printButton = null;
    private PageFormat m_pageFormat = null;

    public PanelHotFixPreInstallSummary() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelHotFixPreInstallSummary.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelHotFixPreInstallSummary.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return Globals.g_cmtRunInstall;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = Globals.g_cmtRunConfigure ? "selectconfigdir" : "execute";
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        this.updateTextArea();
        this.m_printButton.setMinimumSize(wizardFramework.getHelpButton().getPreferredSize());
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid;
        boolean bl = valid = Globals.g_resumeChain || !Globals.g_partialPrompt;
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    private String getStatus(ProductData hotFix) {
        String status = "";
        status = ((HotFix)hotFix).isHotFixAlreadyInstalled() ? this.bundle.getString("PanelHotFixPreInstallSummary.Status.AlreadyInstalled.txt") : this.bundle.getString("PanelHotFixPreInstallSummary.Status.ReadyToInstall.txt");
        return status;
    }

    @Override
    public int consoleEvent() {
        int charColumnWidth = 35;
        ConsoleMode.printInfoText(this.m_instructions.getText());
        ConsoleMode.printInfoText(this.bundle.getString("PanelHotFixPreInstallSummary.Header.txt"));
        ArrayList<String> text = new ArrayList<String>();
        text.add(Utils.removeHTMLTags(this.bundle.getString("PanelHotFixPreInstallSummary.ColumnHeader.Products.txt")) + "~" + Utils.removeHTMLTags(this.bundle.getString("PanelHotFixPreInstallSummary.ColumnHeader.InstalledVersion.txt")) + "~" + Utils.removeHTMLTags(this.bundle.getString("PanelHotFixPreInstallSummary.ColumnHeader.Updates.txt")) + "~" + Utils.removeHTMLTags(this.bundle.getString("PanelHotFixPreInstallSummary.ColumnHeader.Status.txt")));
        for (ProductData hotFix : Globals.g_selectedHotFixesToInstall) {
            if (hotFix.getProdCode().equalsIgnoreCase("installtool")) continue;
            String status = this.getStatus(hotFix);
            int prodNameLen = hotFix.getProdName().length();
            String prodName = "";
            if (prodNameLen > 35) {
                String spacePadding = " ";
                prodName = hotFix.getProdName().substring(0, 34);
                if (!prodName.endsWith(" ") && !hotFix.getProdName().substring(34, 35).endsWith(" ")) {
                    prodName = prodName + "-";
                    spacePadding = "  ";
                }
                text.add(prodName + "~" + hotFix.getProdCustVersion() + "~" + ((HotFix)hotFix).getHotFixName() + "~" + status);
                prodName = hotFix.getProdName().substring(34);
                prodName = spacePadding + prodName;
                text.add(prodName + "~" + "" + "~" + "" + "~" + "");
                continue;
            }
            text.add(hotFix.getProdName() + "~" + hotFix.getProdCustVersion() + "~" + ((HotFix)hotFix).getHotFixName() + "~" + status);
        }
        ConsoleMode.printTable(text.toArray(new String[0]));
        if (Utils.getOS_Suffix() == "mvs") {
            ConsoleMode.printInfoText(this.bundle.getString("PanelHotFixPreInstallSummary.MVSUSS.AuditLogsBelow.txt"));
        } else {
            ConsoleMode.printInfoText(this.bundle.getString("PanelHotFixPreInstallSummary.AuditLogsBelow.txt"));
        }
        for (ProductData hotFix : Globals.g_selectedHotFixesToInstall) {
            if (hotFix.getProdCode().equalsIgnoreCase("installtool") || ((HotFix)hotFix).getSpsSkuData().getPlatform().equalsIgnoreCase("mvs") || ((HotFix)hotFix).getSpsSkuData().getPlatform().equalsIgnoreCase("z64")) continue;
            ConsoleMode.printInfoText(hotFix.getProdNameExtended() + ":");
            String preExecuteAuditLogPath = null;
            preExecuteAuditLogPath = hotFix.getPreExecuteAuditLogPath();
            if (preExecuteAuditLogPath != null) {
                ConsoleMode.println(preExecuteAuditLogPath);
                continue;
            }
            ConsoleMode.println(this.bundle.getString("PanelHotFixPreInstallSummary.AuditLogNotAvailable.txt"));
        }
        if (Utils.getOS_Suffix() == "mvs" && Utils.areAnyMVSMVAHotFixes()) {
            String userParamCNTLDSN = InstallToolConnector.getMvsUserParam("CNTLDSN");
            ConsoleMode.println("");
            if (Globals.g_zosJobSubmit) {
                ConsoleMode.println(this.bundle.messageString("PanelHotFixPreInstallSummary.WithJobSubmit.Promote.txt", userParamCNTLDSN));
            } else {
                ConsoleMode.println(this.bundle.messageString("PanelHotFixPreInstallSummary.WithNoJobSubmit.Promote.txt", userParamCNTLDSN));
            }
        }
        return ConsoleMode.promptPause();
    }

    private void initialize() {
        this.m_instructions = new JTextArea(this.bundle.getString("PanelHotFixPreInstallSummary.Instructions.txt"));
        this.m_instructions.setEditable(false);
        this.m_instructions.setFocusable(false);
        this.m_instructions.setLineWrap(true);
        this.m_instructions.setWrapStyleWord(true);
        this.m_instructions.setOpaque(false);
        this.m_summaryText = new PrintableEditorPane();
        this.m_summaryText.setOpaque(false);
        this.m_summaryText.setEditable(false);
        this.m_summaryText.setContentType("text/html");
        this.m_summaryText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.m_scrollPane = new JScrollPane(this.m_summaryText);
        this.m_summaryText.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelHotFixPreInstallSummary.this.m_summaryText.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.m_summaryText.addHyperlinkListener(this);
        String mtxt = this.bundle.getString("Common.Print.txt");
        this.m_printButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_printButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_printButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_printButton.addActionListener(this);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(0, 0, 10, 0);
        this.m_panel.add((Component)this.m_instructions, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_scrollPane, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 18;
        c.insets = new Insets(10, 5, 0, 0);
        this.m_panel.add((Component)this.m_printButton, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_printButton) {
            this.onPrint();
        }
    }

    private void updateTextArea() {
        int charColumnWidth = 45;
        String listText = "<html>";
        if (Utils.getOS_Suffix() == "mvs" && Utils.areAnyMVSMVAHotFixes()) {
            String userParamCNTLDSN = InstallToolConnector.getMvsUserParam("CNTLDSN");
            listText = Globals.g_zosJobSubmit ? listText + this.bundle.messageString("PanelHotFixPreInstallSummary.WithJobSubmit.Promote.txt", userParamCNTLDSN) : listText + this.bundle.messageString("PanelHotFixPreInstallSummary.WithNoJobSubmit.Promote.txt", userParamCNTLDSN);
            listText = listText + "<hr>";
        }
        listText = listText + "<table valign=top cellspacing=1 cellpadding=0>";
        listText = listText + "<tr>";
        listText = listText + "<td nowrap>" + this.bundle.getString("PanelHotFixPreInstallSummary.ColumnHeader.Products.txt") + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>" + this.bundle.getString("PanelHotFixPreInstallSummary.ColumnHeader.InstalledVersion.txt") + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>" + this.bundle.getString("PanelHotFixPreInstallSummary.ColumnHeader.Updates.txt") + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>" + this.bundle.getString("PanelHotFixPreInstallSummary.ColumnHeader.Status.txt") + "</td>";
        listText = listText + "</tr>";
        for (ProductData hotFix : Globals.g_selectedHotFixesToInstall) {
            if (hotFix.getProdCode().equalsIgnoreCase("installtool")) continue;
            String status = this.getStatus(hotFix);
            int prodNameLen = hotFix.getProdName().length();
            if (prodNameLen > 45) {
                String prodName = "";
                String spacePadding = " ";
                prodName = hotFix.getProdName().substring(0, 44);
                if (!prodName.endsWith(" ") && !hotFix.getProdName().substring(44, 45).endsWith(" ")) {
                    prodName = prodName + "-";
                    spacePadding = "  ";
                }
                listText = listText + this.getTextForTableRow(prodName, hotFix.getProdCustVersion(), ((HotFix)hotFix).getHotFixName(), status);
                prodName = hotFix.getProdName().substring(44);
                prodName = spacePadding + prodName;
                listText = listText + this.getTextForTableRow(prodName, "", "", "");
                continue;
            }
            listText = listText + this.getTextForTableRow(hotFix.getProdName(), hotFix.getProdCustVersion(), ((HotFix)hotFix).getHotFixName(), status);
        }
        listText = listText + "<tr></tr>";
        listText = listText + "</table>";
        listText = listText + "<hr>";
        listText = listText + "<table valign=top cellspacing=1 cellpadding=0>";
        listText = Utils.getOS_Suffix() == "mvs" ? listText + "<tr>" + this.bundle.getString("PanelHotFixPreInstallSummary.MVSUSS.AuditLogsBelow.txt") + "</tr>" : listText + "<tr>" + this.bundle.getString("PanelHotFixPreInstallSummary.AuditInfo.txt") + "</tr>";
        listText = listText + "<tr></tr>";
        for (ProductData hotFix : Globals.g_selectedHotFixesToInstall) {
            if (hotFix.getProdCode().equalsIgnoreCase("installtool") || ((HotFix)hotFix).getSpsSkuData().getPlatform().equalsIgnoreCase("mvs") || ((HotFix)hotFix).getSpsSkuData().getPlatform().equalsIgnoreCase("z64")) continue;
            String logPath = null;
            logPath = hotFix.getPreExecuteAuditLogPath();
            if (logPath != null) {
                listText = listText + "<tr>" + hotFix.getProdNameExtended() + "</tr>";
                File preexecLogFile = new File(logPath);
                String link = "file://" + preexecLogFile.getAbsolutePath();
                listText = listText + "<tr>" + this.bundle.getString("PanelHotFixPreInstallSummary.AuditLog.txt") + " <a href=\"" + link + "\">" + link + "</a></tr>";
            } else {
                listText = listText + "<tr>" + this.bundle.getString("PanelHotFixPreInstallSummary.AuditLogNotAvailable.txt") + "</tr>";
            }
            listText = listText + "<tr><hr></tr>";
            listText = listText + "<tr></tr>";
        }
        listText = listText + "</table>";
        listText = listText + "</html>";
        this.m_summaryText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.m_summaryText.setText(listText);
        this.m_summaryText.setCaretPosition(0);
        this.m_summaryText.revalidate();
    }

    private String getTextForTableRow(String productName, String version, String hotFixName, String status) {
        return "<tr><td nowrap>&nbsp;&nbsp;&nbsp;" + productName + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>" + version + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>" + hotFixName + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap align=center>" + status + "</td></tr>";
    }

    private void onPrint() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.m_pageFormat == null) {
            this.m_pageFormat = printerJob.defaultPage();
        }
        PrinterDialogThread printerThread = new PrinterDialogThread(printerJob);
        printerThread.start();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            KitAction.launchWebBrowser(event.getURL());
        }
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    class PrinterDialogThread
    extends Thread {
        PrinterJob m_printerJob;

        public PrinterDialogThread(PrinterJob printerJob) {
            this.m_printerJob = printerJob;
            this.setPriority(1);
        }

        @Override
        public void run() {
            this.m_printerJob.setPrintable(PanelHotFixPreInstallSummary.this.m_summaryText, PanelHotFixPreInstallSummary.this.m_pageFormat);
            this.m_printerJob.validatePage(PanelHotFixPreInstallSummary.this.m_pageFormat);
            if (this.m_printerJob.printDialog()) {
                try {
                    this.m_printerJob.setPrintable(PanelHotFixPreInstallSummary.this.m_summaryText, PanelHotFixPreInstallSummary.this.m_pageFormat);
                    this.m_printerJob.validatePage(PanelHotFixPreInstallSummary.this.m_pageFormat);
                    this.m_printerJob.print();
                }
                catch (Exception e) {
                    Logging.log.info(e.getMessage());
                    System.err.println(e);
                }
            }
        }
    }
}

