/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.HotFix;
import com.sas.ssn.InstallToolConnector;
import com.sas.ssn.KitAction;
import com.sas.ssn.Logging;
import com.sas.ssn.PrintableEditorPane;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class PanelHotFixPostInstallSummary
implements WizardPanelIface,
HyperlinkListener,
ActionListener {
    private SSNResource bundle = new SSNResource(PanelHotFixPostInstallSummary.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_instructions = null;
    private JScrollPane m_scrollPane = null;
    private PrintableEditorPane m_summaryText = null;
    private JButton m_printButton = null;
    private PageFormat m_pageFormat = null;

    public PanelHotFixPostInstallSummary() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelHotFixPostInstallSummary.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelHotFixPostInstallSummary.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return Globals.g_cmtRunInstall;
    }

    @Override
    public String getNextPanelID() {
        String panelID = "finish";
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        this.updateTextArea();
        this.m_printButton.setMinimumSize(wizardFramework.getHelpButton().getPreferredSize());
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid;
        boolean bl = valid = Globals.g_resumeChain || !Globals.g_partialPrompt;
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    private String getStatus(ProductData hotFix) {
        String status = "";
        status = ((HotFix)hotFix).isSuccessfulInstall() ? (((HotFix)hotFix).getSpsSkuData().getPlatform().equalsIgnoreCase("mvs") || ((HotFix)hotFix).getSpsSkuData().getPlatform().equalsIgnoreCase("z64") ? (InstallToolConnector.postProcessingCalled() && InstallToolConnector.postProcessingSuccessful() ? (Globals.g_zosJobSubmit ? this.bundle.getString("PanelHotFixPostInstallSummary.Status.ReadyToPromote.txt") : this.bundle.getString("PanelHotFixPostInstallSummary.Status.ReadyToSubmit.txt")) : this.bundle.getString("PanelHotFixPostInstallSummary.Status.NotInstalled.txt")) : this.bundle.getString("PanelHotFixPostInstallSummary.Status.Installed.txt")) : this.bundle.getString("PanelHotFixPostInstallSummary.Status.NotInstalled.txt");
        return status;
    }

    @Override
    public int consoleEvent() {
        int charColumnWidth = 35;
        ConsoleMode.printInfoText(this.m_instructions.getText());
        ConsoleMode.printInfoText(this.bundle.getString("PanelHotFixPostInstallSummary.Header.txt"));
        ArrayList<String> text = new ArrayList<String>();
        text.add(Utils.removeHTMLTags(this.bundle.getString("PanelHotFixPostInstallSummary.ColumnHeader.Products.txt")) + "~" + Utils.removeHTMLTags(this.bundle.getString("PanelHotFixPostInstallSummary.ColumnHeader.InstalledVersion.txt")) + "~" + Utils.removeHTMLTags(this.bundle.getString("PanelHotFixPostInstallSummary.ColumnHeader.Updates.txt")) + "~" + Utils.removeHTMLTags(this.bundle.getString("PanelHotFixPostInstallSummary.ColumnHeader.Status.txt")));
        for (ProductData hotFix : Globals.g_selectedHotFixesToInstall) {
            if (hotFix.getProdCode().equalsIgnoreCase("installtool")) continue;
            String status = this.getStatus(hotFix);
            int prodNameLen = hotFix.getProdName().length();
            String prodName = "";
            if (prodNameLen > 35) {
                String spacePadding = " ";
                prodName = hotFix.getProdName().substring(0, 34);
                if (!prodName.endsWith(" ") && !hotFix.getProdName().substring(34, 35).endsWith(" ")) {
                    prodName = prodName + "-";
                    spacePadding = "  ";
                }
                text.add(prodName + "~" + hotFix.getProdCustVersion() + "~" + ((HotFix)hotFix).getHotFixName() + "~" + status);
                prodName = hotFix.getProdName().substring(34);
                prodName = spacePadding + prodName;
                text.add(prodName + "~" + "" + "~" + "" + "~" + "");
                continue;
            }
            text.add(hotFix.getProdName() + "~" + hotFix.getProdCustVersion() + "~" + ((HotFix)hotFix).getHotFixName() + "~" + status);
        }
        ConsoleMode.printTable(text.toArray(new String[0]));
        if (Utils.getOS_Suffix() == "mvs") {
            ConsoleMode.printInfoText(this.bundle.getString("PanelHotFixPostInstallSummary.MVSUSS.AuditLogsBelow.txt"));
        } else {
            ConsoleMode.printInfoText(this.bundle.getString("PanelHotFixPostInstallSummary.AuditLogsBelow.txt"));
        }
        for (ProductData hotFix : Globals.g_selectedHotFixesToInstall) {
            if (hotFix.getProdCode().equalsIgnoreCase("installtool") || ((HotFix)hotFix).getSpsSkuData().getPlatform().equalsIgnoreCase("mvs") || ((HotFix)hotFix).getSpsSkuData().getPlatform().equalsIgnoreCase("z64")) continue;
            ConsoleMode.printInfoText(hotFix.getProdNameExtended() + ":");
            String postExecuteAuditLogPath = null;
            postExecuteAuditLogPath = hotFix.getPostExecuteAuditLogPath();
            if (postExecuteAuditLogPath != null) {
                ConsoleMode.println(postExecuteAuditLogPath);
                continue;
            }
            ConsoleMode.println(this.bundle.getString("PanelHotFixPostInstallSummary.AuditLogNotAvailable.txt"));
        }
        if (Utils.getOS_Suffix() == "mvs" && InstallToolConnector.getMvsFinalJobNames() != null && !InstallToolConnector.getMvsFinalJobNames().isEmpty()) {
            String userParamCNTLDSN = InstallToolConnector.getMvsUserParam("CNTLDSN");
            ConsoleMode.println("");
            if (Globals.g_zosJobSubmit) {
                if (InstallToolConnector.postProcessingCalled() && InstallToolConnector.postProcessingSuccessful()) {
                    ConsoleMode.println(this.bundle.messageString("PanelHotFixPostInstallSummary.WithJobSubmit.Promote.txt", InstallToolConnector.getMvsUserParam("CNTLDSN")));
                }
            } else {
                ConsoleMode.println(this.bundle.getString("PanelHotFixPostInstallSummary.WithNoJobSubmit.PromoteHeader.txt"));
                for (String job : InstallToolConnector.getMvsFinalJobNames()) {
                    ConsoleMode.println(job);
                }
                ConsoleMode.println("in " + userParamCNTLDSN);
                if (Globals.g_zosJobChain) {
                    ConsoleMode.println(this.bundle.getString("PanelHotFixPostInstallSummary.WithNoJobSubmit.PromoteInstructions.txt"));
                } else {
                    ConsoleMode.println(this.bundle.getString("PanelHotFixPostInstallSummary.WithNoJobSubmitNoChain.PromoteInstructions.txt"));
                }
            }
        }
        return ConsoleMode.promptPause();
    }

    private void initialize() {
        this.m_instructions = new JTextArea(this.bundle.getString("PanelHotFixPostInstallSummary.Instructions.txt"));
        this.m_instructions.setEditable(false);
        this.m_instructions.setFocusable(false);
        this.m_instructions.setLineWrap(true);
        this.m_instructions.setWrapStyleWord(true);
        this.m_instructions.setOpaque(false);
        this.m_summaryText = new PrintableEditorPane();
        this.m_summaryText.setOpaque(false);
        this.m_summaryText.setEditable(false);
        this.m_summaryText.setContentType("text/html");
        this.m_summaryText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.m_scrollPane = new JScrollPane(this.m_summaryText);
        this.m_summaryText.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelHotFixPostInstallSummary.this.m_summaryText.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.m_summaryText.addHyperlinkListener(this);
        String mtxt = this.bundle.getString("Common.Print.txt");
        this.m_printButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_printButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_printButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_printButton.addActionListener(this);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(0, 0, 10, 0);
        this.m_panel.add((Component)this.m_instructions, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_scrollPane, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 18;
        c.insets = new Insets(10, 5, 0, 0);
        this.m_panel.add((Component)this.m_printButton, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_printButton) {
            this.onPrint();
        }
    }

    private void updateTextArea() {
        int charColumnWidth = 45;
        String listText = "<html>";
        if (Globals.g_recordMode && Globals.g_recordOnly) {
            listText = listText + "Recording a responsfile, no changes have been made to your system.";
        } else {
            if (Utils.getOS_Suffix() == "mvs" && InstallToolConnector.getMvsFinalJobNames() != null && !InstallToolConnector.getMvsFinalJobNames().isEmpty()) {
                String userParamCNTLDSN = InstallToolConnector.getMvsUserParam("CNTLDSN");
                if (Globals.g_zosJobSubmit) {
                    if (InstallToolConnector.postProcessingCalled() && InstallToolConnector.postProcessingSuccessful()) {
                        listText = listText + this.bundle.messageString("PanelHotFixPostInstallSummary.WithJobSubmit.Promote.txt", InstallToolConnector.getMvsUserParam("CNTLDSN"));
                    }
                } else {
                    listText = listText + this.bundle.getString("PanelHotFixPostInstallSummary.WithNoJobSubmit.PromoteHeader.txt");
                    listText = listText + "<table valign=top cellspacing=1 cellpadding=0>";
                    for (String job : InstallToolConnector.getMvsFinalJobNames()) {
                        listText = listText + "<tr>";
                        listText = listText + "<td nowrap>" + job + "</td>";
                        listText = listText + "</tr>";
                    }
                    listText = listText + "<tr>";
                    listText = listText + "<td nowrap>in " + userParamCNTLDSN + "</td>";
                    listText = listText + "</tr>";
                    listText = listText + "</table>";
                    listText = Globals.g_zosJobChain ? listText + this.bundle.getString("PanelHotFixPostInstallSummary.WithNoJobSubmit.PromoteInstructions.txt") : listText + this.bundle.getString("PanelHotFixPostInstallSummary.WithNoJobSubmitNoChain.PromoteInstructions.txt");
                }
                listText = listText + "<hr>";
            }
            listText = listText + "<table valign=top cellspacing=1 cellpadding=0>";
            listText = listText + "<tr>";
            listText = listText + "<td nowrap>" + this.bundle.getString("PanelHotFixPostInstallSummary.ColumnHeader.Products.txt") + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>" + this.bundle.getString("PanelHotFixPostInstallSummary.ColumnHeader.InstalledVersion.txt") + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>" + this.bundle.getString("PanelHotFixPostInstallSummary.ColumnHeader.Updates.txt") + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>" + this.bundle.getString("PanelHotFixPostInstallSummary.ColumnHeader.Status.txt") + "</td>";
            listText = listText + "</tr>";
            for (ProductData hotFix : Globals.g_selectedHotFixesToInstall) {
                if (hotFix.getProdCode().equalsIgnoreCase("installtool")) continue;
                String status = this.getStatus(hotFix);
                int prodNameLen = hotFix.getProdName().length();
                if (prodNameLen > 45) {
                    String prodName = "";
                    String spacePadding = " ";
                    prodName = hotFix.getProdName().substring(0, 44);
                    if (!prodName.endsWith(" ") && !hotFix.getProdName().substring(44, 45).endsWith(" ")) {
                        prodName = prodName + "-";
                        spacePadding = "  ";
                    }
                    listText = listText + this.getTextForTableRow(prodName, hotFix.getProdCustVersion(), ((HotFix)hotFix).getHotFixName(), status);
                    prodName = hotFix.getProdName().substring(44);
                    prodName = spacePadding + prodName;
                    listText = listText + this.getTextForTableRow(prodName, "", "", "");
                    continue;
                }
                listText = listText + this.getTextForTableRow(hotFix.getProdName(), hotFix.getProdCustVersion(), ((HotFix)hotFix).getHotFixName(), status);
            }
            listText = listText + "<tr></tr>";
            listText = listText + "</table>";
            listText = listText + "<hr>";
            listText = listText + "<table valign=top cellspacing=1 cellpadding=0>";
            listText = Utils.getOS_Suffix() == "mvs" ? listText + "<tr>" + this.bundle.getString("PanelHotFixPostInstallSummary.MVSUSS.AuditLogsBelow.txt") + "</tr>" : listText + "<tr>" + this.bundle.getString("PanelHotFixPostInstallSummary.AuditLogsBelow.txt") + "</tr>";
            listText = listText + "<tr></tr>";
            for (ProductData hotFix : Globals.g_selectedHotFixesToInstall) {
                if (hotFix.getProdCode().equalsIgnoreCase("installtool") || ((HotFix)hotFix).getSpsSkuData().getPlatform().equalsIgnoreCase("mvs") || ((HotFix)hotFix).getSpsSkuData().getPlatform().equalsIgnoreCase("z64")) continue;
                listText = listText + "<tr>" + hotFix.getProdNameExtended() + "</tr>";
                if (((HotFix)hotFix).isSuccessfulInstall()) {
                    String logPath = null;
                    logPath = hotFix.getPostExecuteAuditLogPath();
                    if (logPath != null) {
                        File postexecLogFile = new File(logPath);
                        String link = "file://" + postexecLogFile.getAbsolutePath();
                        listText = listText + "<tr>" + this.bundle.getString("PanelHotFixPostInstallSummary.AuditLog.txt") + " <a href=\"" + link + "\">" + link + "</a></tr>";
                        String bkupDir = hotFix.getUpdateBackupDirectory();
                        link = "file://" + bkupDir;
                        listText = listText + "<tr>" + this.bundle.getString("PanelHotFixPostInstallSummary.BackupDirectory.txt") + " <a href=\"" + link + "\">" + link + "</tr>";
                    } else {
                        listText = listText + "<tr>" + this.bundle.getString("PanelHotFixPostInstallSummary.AuditLogNotAvailable.txt") + "</tr>";
                    }
                } else {
                    listText = listText + "<tr>" + this.bundle.getString("PanelHotFixPostInstallSummary.HotFixInstallFailed.txt") + "</tr>";
                }
                listText = listText + "<tr></tr>";
                listText = listText + "<tr><hr></tr>";
                listText = listText + "<tr></tr>";
            }
            listText = listText + "</table>";
        }
        listText = listText + "</html>";
        this.m_summaryText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.m_summaryText.setText(listText);
        this.m_summaryText.setCaretPosition(0);
        this.m_summaryText.revalidate();
    }

    private String getTextForTableRow(String productName, String version, String hotFixName, String status) {
        return "<tr><td nowrap>&nbsp;&nbsp;&nbsp;" + productName + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>" + version + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>" + hotFixName + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap align=center>" + status + "</td></tr>";
    }

    private void onPrint() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.m_pageFormat == null) {
            this.m_pageFormat = printerJob.defaultPage();
        }
        PrinterDialogThread printerThread = new PrinterDialogThread(printerJob);
        printerThread.start();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            KitAction.launchWebBrowser(event.getURL());
        }
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    class PrinterDialogThread
    extends Thread {
        PrinterJob m_printerJob;

        public PrinterDialogThread(PrinterJob printerJob) {
            this.m_printerJob = printerJob;
            this.setPriority(1);
        }

        @Override
        public void run() {
            this.m_printerJob.setPrintable(PanelHotFixPostInstallSummary.this.m_summaryText, PanelHotFixPostInstallSummary.this.m_pageFormat);
            this.m_printerJob.validatePage(PanelHotFixPostInstallSummary.this.m_pageFormat);
            if (this.m_printerJob.printDialog()) {
                try {
                    this.m_printerJob.setPrintable(PanelHotFixPostInstallSummary.this.m_summaryText, PanelHotFixPostInstallSummary.this.m_pageFormat);
                    this.m_printerJob.validatePage(PanelHotFixPostInstallSummary.this.m_pageFormat);
                    this.m_printerJob.print();
                }
                catch (Exception e) {
                    Logging.log.info(e.getMessage());
                    System.err.println(e);
                }
            }
        }
    }
}

