/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.ControlBrowse;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DialogData;
import com.sas.ssn.DynamicDialogs;
import com.sas.ssn.Globals;
import com.sas.ssn.InstallToolConnector;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.MetadataAccess;
import com.sas.ssn.PropertyRules;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.ssn.utils.PropertyJarFile;
import com.sas.ssn.validate.ValidationResult;
import com.sas.ssn.validate.ValidationResultPrompt;
import com.sas.ssn.validate.ValidatorRunner;
import com.sas.swing.visuals.util.Util;
import com.sas.util.SasPasswordString;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.commons.lang.StringUtils;

public class PanelDynamic
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelDynamic.class);
    private SSNResource en_bundle = SSNResource.EnglishResource(PanelDynamic.class);
    private static HashMap<String, List<PropertyJarFile>> groupedJarLists = new HashMap();
    private JPanel m_panel = null;
    private ArrayList m_controls = new ArrayList();
    private ArrayList m_confirmPrompts = new ArrayList();
    private ArrayList<DialogData.Property> m_promptedProperties = new ArrayList();
    private ArrayList<DialogData.Property> m_nonPromptedProps = new ArrayList();
    private boolean m_panelLoaded = false;
    private boolean m_configUpgrade = false;
    private boolean m_hasTask = false;
    private int m_index = 0;
    private int m_dialogType = 0;
    private String m_panelID = null;
    private DialogData.Property[] m_dialogProperties = null;
    private HashMap m_forceDisplayProps = new HashMap();
    private HashMap m_alwaysDisplayedProps = new HashMap();
    private int m_validationAttempts = 0;

    private static void removeFoundJarsForProperty(String namespacePrefix, String propertyName) {
        List<PropertyJarFile> existingJarList;
        if (namespacePrefix != null && propertyName != null && (existingJarList = groupedJarLists.get(namespacePrefix)) != null) {
            Iterator<PropertyJarFile> it = existingJarList.iterator();
            while (it.hasNext()) {
                PropertyJarFile jarFile = it.next();
                String propertyOwner = jarFile.getPropertyOwner();
                if (propertyOwner == null || !propertyOwner.equalsIgnoreCase(propertyName)) continue;
                it.remove();
            }
        }
    }

    private static void addFoundJarList(String namespacePrefix, List<PropertyJarFile> jarList) {
        if (namespacePrefix != null && jarList != null) {
            List<PropertyJarFile> existingJarList = groupedJarLists.get(namespacePrefix);
            if (existingJarList == null) {
                groupedJarLists.put(namespacePrefix, jarList);
            } else {
                existingJarList.addAll(jarList);
            }
        }
    }

    private static void addFoundJarFile(String namespacePrefix, PropertyJarFile jarFile) {
        if (namespacePrefix != null && jarFile != null) {
            List<PropertyJarFile> existingJarList = groupedJarLists.get(namespacePrefix);
            if (existingJarList == null) {
                existingJarList = new ArrayList<PropertyJarFile>();
                existingJarList.add(jarFile);
                groupedJarLists.put(namespacePrefix, existingJarList);
            } else {
                existingJarList.add(jarFile);
            }
        }
    }

    private static List<PropertyJarFile> getExistingJarList(String namespacePrefix) {
        return groupedJarLists.get(namespacePrefix);
    }

    public PanelDynamic(int index, String panelID, DialogData.Property[] dialogProperties, int type, boolean hasTask) {
        if (!Globals.g_quietMode) {
            this.m_panel = new JPanel(new GridBagLayout());
        }
        this.m_index = index;
        this.m_panelID = panelID;
        this.m_dialogProperties = dialogProperties;
        this.m_dialogType = type;
        this.m_hasTask = hasTask;
        this.m_configUpgrade = Globals.g_mode == 2 && Globals.g_cmtTask == 5;
        this.m_alwaysDisplayedProps.put("levdirroot.prompted.hostname", true);
        this.m_alwaysDisplayedProps.put("levdirroot.persisted.hostname", true);
        this.m_alwaysDisplayedProps.put("levdirroot.hostname.validator", true);
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        String header = null;
        header = this.m_dialogType == 1 ? DynamicDialogs.getInstallDialogProperty(this.m_panelID + ".header") : DynamicDialogs.getConfigDialogProperty(this.m_panelID + ".header");
        return header;
    }

    public String getHelpHeader() {
        String header = null;
        header = this.m_dialogType == 1 ? DynamicDialogs.getInstallDialogProperty(this.m_panelID + ".header.help") : DynamicDialogs.getConfigDialogProperty(this.m_panelID + ".header.help");
        return header;
    }

    @Override
    public String getHeaderDesc() {
        String headerDesc = null;
        headerDesc = this.m_dialogType == 1 ? DynamicDialogs.getInstallDialogProperty(this.m_panelID + ".desc") : DynamicDialogs.getConfigDialogProperty(this.m_panelID + ".desc");
        return headerDesc;
    }

    @Override
    public boolean validateData() {
        String name;
        DialogData.Property property;
        boolean valid = true;
        String superMsg = "";
        if (this.m_promptedProperties != null && this.m_promptedProperties.size() > 0) {
            int response;
            int i;
            property = null;
            name = null;
            String value = null;
            String confirm = null;
            int type = 0;
            String errMsg = null;
            String label = null;
            String user = null;
            KitTextField text = null;
            JTextArea textArea = null;
            JPasswordField password = null;
            JCheckBox checkBox = null;
            JComboBox comboBox = null;
            ControlBrowse path = null;
            JComponent focusObj = null;
            boolean generic = true;
            int minLength = 0;
            DialogData.Property validatorProperty = null;
            String validatorClassName = null;
            String hostname = null;
            Object nospace = null;
            for (i = 0; i < this.m_promptedProperties.size() && valid; ++i) {
                property = this.m_promptedProperties.get(i);
                name = property.getName();
                type = property.getType(this.m_configUpgrade);
                label = this.m_dialogType == 1 ? Util.getDisplayLabel(DynamicDialogs.getInstallDialogProperty(name + ".label")) : Util.getDisplayLabel(DynamicDialogs.getConfigDialogProperty(name + ".label"));
                if (this.isTextField(type)) {
                    text = (KitTextField)this.m_controls.get(i);
                    value = text.getText().trim();
                    focusObj = text;
                    if (DynamicDialogs.useDefaultPropertyValue || type != 25 && type != 7) {
                        text.setText(value);
                    }
                    if (type == 5 || type == 6 || type == 49 || type == 7) {
                        user = value;
                    }
                } else if (this.isTextArea(type)) {
                    textArea = (JTextArea)this.m_controls.get(i);
                    value = textArea.getText().trim();
                } else if (this.isPasswordField(type)) {
                    password = (JPasswordField)this.m_controls.get(i);
                    value = String.valueOf(password.getPassword());
                    focusObj = password;
                } else if (this.isBrowseField(type)) {
                    path = (ControlBrowse)this.m_controls.get(i);
                    value = path.getText().trim();
                    focusObj = path;
                    path.setText(value);
                } else if (this.isCheckBoxField(type)) {
                    checkBox = (JCheckBox)this.m_controls.get(i);
                    value = checkBox.isSelected() ? "true" : "false";
                    focusObj = checkBox;
                } else if (this.isComboField(type)) {
                    comboBox = (JComboBox)this.m_controls.get(i);
                    value = comboBox.getSelectedIndex() > -1 ? ((DynamicComboData)comboBox.getSelectedItem()).getValue() : "";
                    focusObj = comboBox;
                } else {
                    value = "";
                    focusObj = null;
                }
                if (type != 1 && type != 25 && type != 7 && type != 26 && type != 19 && type != 16 && type != 34 && type != 13 && type != 43 && type != 45 && value.length() == 0) {
                    valid = false;
                    if (Globals.g_quietMode) {
                        Wizard.logResponseMissing(this.getHeader(), name);
                    } else {
                        errMsg = type == 32 ? this.bundle.messageString("PanelDynamic.MissingDependency.txt", label) : this.bundle.messageString("Common.Error.RequiredField.txt", label);
                    }
                }
                minLength = property.getMinLength();
                if (valid && value.length() < minLength && (type != 25 && type != 7 && type != 34 && type != 13 || type == 34 && value.length() > 0 || type == 13 && value.length() > 0)) {
                    valid = false;
                    if (Globals.g_quietMode) {
                        if (this.isPasswordField(type)) {
                            Wizard.logResponseInvalid(this.getHeader(), name, "", "This value must be at least " + Integer.toString(minLength) + " characters long.");
                        } else {
                            Wizard.logResponseInvalid(this.getHeader(), name, value, "This value must be at least " + Integer.toString(minLength) + " characters long.");
                        }
                    } else {
                        errMsg = this.bundle.messageString("PanelDynamic.MinLength.txt", label, Integer.toString(minLength));
                    }
                }
                if (valid) {
                    block286: {
                        generic = true;
                        if (type == 26) {
                            String uniqueData = property.getUniqueData();
                            if (PropertyRules.containsProperty(uniqueData)) {
                                uniqueData = PropertyRules.resolveProperties(uniqueData, this.m_dialogType);
                            }
                            if (!(valid = MetadataAccess.isUnique(Globals.g_configData.getProperty("iomsrv.metadatasrv.host", null), Globals.g_configData.getProperty("iomsrv.metadatasrv.port", null), Globals.g_configData.getProperty("oma.repository.foundation.name", null), Globals.g_configData.getProperty("oma.person.admin.login.userid", null), Globals.g_configData.getProperty("oma.person.admin.login.passwd", null), uniqueData, value))) {
                                generic = false;
                                if (Globals.g_quietMode) {
                                    Wizard.logResponseInvalid(this.getHeader(), name, value, "This value is already defined in metadata and must be unique.");
                                } else {
                                    errMsg = this.bundle.messageString("PanelDynamic.NotUnique.txt", label);
                                }
                            }
                        } else if (type == 24) {
                            if (!Utils.isValidJobcard(value)) {
                                valid = false;
                                generic = false;
                                if (Globals.g_quietMode) {
                                    Wizard.logResponseInvalid(this.getHeader(), name, value, this.en_bundle.messageString("PanelDynamic.JobcardInvalid.txt", label));
                                } else {
                                    errMsg = this.bundle.messageString("PanelDynamic.JobcardInvalid.txt", label);
                                }
                            }
                        } else if (type == 28) {
                            if (!Utils.isValidHighLevelQualifier(value)) {
                                valid = false;
                                generic = false;
                                if (Globals.g_quietMode) {
                                    Wizard.logResponseInvalid(this.getHeader(), name, value, this.en_bundle.messageString("PanelDynamic.HighLevelQualifierInvalid.txt", label));
                                } else {
                                    errMsg = this.bundle.messageString("PanelDynamic.HighLevelQualifierInvalid.txt", label);
                                }
                            }
                            if (valid) {
                                boolean rc;
                                Properties dsProperties = Globals.g_installData.getProperties();
                                StringBuffer msgs = new StringBuffer(256);
                                if (!Globals.g_z64 && !(rc = InstallToolConnector.checkMvsDataSetParams(2, value, dsProperties, Logging.log, Globals.g_quietMode, msgs))) {
                                    valid = false;
                                    generic = false;
                                    if (Globals.g_quietMode) {
                                        Wizard.logResponseInvalid(this.getHeader(), name, value, msgs.toString());
                                    } else {
                                        errMsg = msgs.toString();
                                    }
                                }
                                if (valid && Globals.g_zosPreCheck && !(rc = InstallToolConnector.checkMvsDataSetParams(3, value, dsProperties, Logging.log, Globals.g_quietMode, msgs))) {
                                    valid = false;
                                    generic = false;
                                    if (Globals.g_quietMode) {
                                        Wizard.logResponseInvalid(this.getHeader(), name, value, this.en_bundle.messageString("PanelDynamic.DataSetAllocationParameterInvalid.txt", msgs));
                                    } else {
                                        int response2 = CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), msgs + "\n\n" + this.bundle.messageString("PanelDynamic.IgnoreConfirmation.txt") + this.bundle.messageString("PanelDynamic.ErrorConfirmation.txt"), this.bundle.getString("Common.Warning.txt"), 0, 2, 1);
                                        if (response2 == 0) {
                                            Logging.log.info(String.format("Warning for invalid High-Level Qualifier value '%s' has been ignored", value));
                                            valid = true;
                                        }
                                    }
                                }
                                InstallToolConnector.resetITMvsextractTask();
                            }
                        } else if (type == 55 || type == 56 || type == 57) {
                            if (Globals.g_zosPreCheck) {
                                Properties dsProperties = Globals.g_installData.getProperties();
                                StringBuffer msgs = new StringBuffer(256);
                                String valueName = "";
                                boolean rc = false;
                                switch (type) {
                                    case 55: {
                                        valueName = "DISKUNIT";
                                        rc = InstallToolConnector.checkMvsDataSetParams(6, value, dsProperties, Logging.log, Globals.g_quietMode, msgs);
                                        break;
                                    }
                                    case 56: {
                                        valueName = "TMPUNI";
                                        rc = InstallToolConnector.checkMvsDataSetParams(7, value, dsProperties, Logging.log, Globals.g_quietMode, msgs);
                                        break;
                                    }
                                    case 57: {
                                        valueName = "VOLDISK";
                                        rc = InstallToolConnector.checkMvsDataSetParams(8, value, dsProperties, Logging.log, Globals.g_quietMode, msgs);
                                    }
                                }
                                if (!rc) {
                                    valid = false;
                                    generic = false;
                                    if (Globals.g_quietMode) {
                                        Wizard.logResponseInvalid(this.getHeader(), name, value, this.en_bundle.messageString("PanelDynamic.DataSetAllocationParameterInvalid.txt", msgs));
                                    } else {
                                        response = CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), msgs + "\n\n" + this.bundle.messageString("PanelDynamic.IgnoreConfirmation.txt") + this.bundle.messageString("PanelDynamic.ErrorConfirmation.txt"), this.bundle.getString("Common.Warning.txt"), 0, 2, 1);
                                        if (response == 0) {
                                            Logging.log.info(String.format("Warning for invalid %s value '%s' has been ignored", valueName, value));
                                            valid = true;
                                        }
                                    }
                                }
                                InstallToolConnector.resetITMvsextractTask();
                            }
                        } else if (type == 29) {
                            if (!Utils.isValidWorkspc(value)) {
                                valid = false;
                                generic = false;
                                if (Globals.g_quietMode) {
                                    Wizard.logResponseInvalid(this.getHeader(), name, value, this.en_bundle.messageString("PanelDynamic.WorkspaceInvalid.txt", label));
                                } else {
                                    errMsg = this.bundle.messageString("PanelDynamic.WorkspaceInvalid.txt", label);
                                }
                            }
                        } else if (type == 30) {
                            if (!Utils.isValidIntrdr(value)) {
                                valid = false;
                                generic = false;
                                if (Globals.g_quietMode) {
                                    Wizard.logResponseInvalid(this.getHeader(), name, value, this.en_bundle.messageString("PanelDynamic.InternalReaderInvalid.txt", label));
                                } else {
                                    errMsg = this.bundle.messageString("PanelDynamic.InternalReaderInvalid.txt", label);
                                }
                            }
                        } else if (type == 35) {
                            if (!Utils.isValidMulticast(value)) {
                                valid = false;
                                generic = false;
                                if (Globals.g_quietMode) {
                                    Wizard.logResponseInvalid(this.getHeader(), name, value, "Specify a valid IP multicast address.");
                                } else {
                                    errMsg = this.bundle.messageString("PanelDynamic.MulticastInvalid.txt", label);
                                }
                            }
                        } else if (type == 31) {
                            if (value.length() > 0) {
                                StringTokenizer tokens = new StringTokenizer(value, "@", true);
                                if (tokens.countTokens() == 3) {
                                    String firstToken = tokens.nextToken();
                                    String secondToken = tokens.nextToken();
                                    String thirdToken = tokens.nextToken();
                                    if (firstToken.length() < 1 || firstToken.equals("@") || !secondToken.equals("@") || thirdToken.length() < 1 || thirdToken.equals("@")) {
                                        valid = false;
                                    }
                                } else {
                                    valid = false;
                                }
                            }
                        } else if (type == 22) {
                            valid = Utils.isValidPortNumber(value);
                        } else if (type == 46) {
                            generic = false;
                            String propertyNamespacePrefix = DialogData.Property.parseNamespacePrefix(name);
                            String hostPropertyName = propertyNamespacePrefix + ".host";
                            String portHost = "";
                            portHost = this.m_dialogType == 1 ? Globals.g_installData.getProperty(hostPropertyName, "localhost") : Globals.g_configData.getProperty(hostPropertyName, "localhost");
                            if (hostname != null && hostname.length() > 0) {
                                portHost = hostname;
                            }
                            String warnMsg = "";
                            switch (Utils.checkPortAvailability(portHost, value)) {
                                case -1: {
                                    Logging.log.warning("The port value is invalid: " + value);
                                    valid = false;
                                    if (Globals.g_quietMode) {
                                        Wizard.logResponseInvalid(this.getHeader(), name, value, "The supplied port needs to be in numeric form between the values of 0 and 65535.");
                                        break;
                                    }
                                    errMsg = this.bundle.messageString("PanelDynamic.portInvalid.txt", label);
                                    break;
                                }
                                case 0: {
                                    Logging.log.info("The port value is available: " + value);
                                    valid = true;
                                    break;
                                }
                                case 1: {
                                    Logging.log.warning("The port value is not open: " + value);
                                    valid = false;
                                    warnMsg = this.bundle.messageString("PanelDynamic.portNotOpen.txt", value, label);
                                    break;
                                }
                                case 2: {
                                    Logging.log.warning("The supplied host was not found: " + portHost);
                                    valid = false;
                                    warnMsg = this.bundle.messageString("PanelDynamic.hostnameNotFound.txt", portHost);
                                }
                            }
                            if (!valid && warnMsg != "") {
                                if (Globals.g_quietMode) {
                                    Logging.log.warning("Panel " + this.getHeader() + " encountered the following warning during validation: " + warnMsg);
                                    valid = true;
                                } else {
                                    response = CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), warnMsg + "\n\n" + this.bundle.messageString("PanelDynamic.WarningConfirmation.txt"), this.bundle.getString("Common.Warning.txt"), 0, 2);
                                    if (response == 0) {
                                        valid = true;
                                    }
                                }
                            }
                        } else if (type == 3) {
                            valid = Utils.isValidNumber(value);
                        } else if (type == 36) {
                            Object[] rangeData = this.getRangeData(property.getRangeData());
                            if (rangeData.length == 2 && Utils.isValidNumber(rangeData[0]) && Utils.isValidNumber(rangeData[1])) {
                                valid = Utils.isValidNumber(value);
                                if (valid && !Utils.isNumberWithinRange(value, (String)rangeData[0], (String)rangeData[1])) {
                                    valid = false;
                                    generic = false;
                                    if (Globals.g_quietMode) {
                                        Wizard.logResponseInvalid(this.getHeader(), name, value, "The value for " + name + " is not valid. You must specify a value between " + (String)rangeData[0] + " and " + (String)rangeData[1] + ", inclusively.");
                                    } else {
                                        errMsg = this.bundle.messageString("PanelDynamic.RangeInvalid.txt", label, rangeData[0], rangeData[1]);
                                    }
                                }
                            } else {
                                Logging.log.warning("Invalid arguments supplied to RANGE[] type: {" + StringUtils.join(rangeData, ",") + "}. Validating NUMBER input only.");
                                valid = Utils.isValidNumber(value);
                            }
                        } else if (type == 6 || type == 49) {
                            String fqid;
                            if (!value.toLowerCase(Locale.ENGLISH).endsWith("@saspw")) {
                                valid = false;
                                generic = false;
                                if (Globals.g_quietMode) {
                                    Wizard.logResponseInvalid(this.getHeader(), name, value, "User name must end with @saspw.");
                                } else {
                                    errMsg = this.bundle.messageString("PanelDynamic.UserIDMSInvalid.txt", label);
                                }
                            }
                            if (valid && type == 49 && (fqid = MetadataAccess.getInternalLoginFqid(Globals.g_configData.getProperty("iomsrv.metadatasrv.host", null), Globals.g_configData.getProperty("iomsrv.metadatasrv.port", null), Globals.g_configData.getProperty("oma.repository.foundation.name", null), Globals.g_configData.getProperty("oma.person.admin.login.userid", null), Globals.g_configData.getProperty("oma.person.admin.login.passwd", null), value)) != null) {
                                valid = false;
                                generic = false;
                                if (Globals.g_quietMode) {
                                    Wizard.logResponseInvalid(this.getHeader(), name, value, "User name is already defined in metadata and must be unique.");
                                } else {
                                    errMsg = this.bundle.messageString("PanelDynamic.NotUnique.txt", label);
                                }
                            }
                        } else if (type == 8 || type == 34 || type == 13 || type == 12 || (type == 9 || type == 10) && Utils.getOS() != 1) {
                            password = (JPasswordField)this.m_confirmPrompts.get(i);
                            if (password != null && !value.equals(confirm = String.valueOf(password.getPassword()))) {
                                valid = false;
                                generic = false;
                                if (Globals.g_quietMode) {
                                    Wizard.logResponseInvalid(this.getHeader(), name, "", "Password does not match the confirmation password.");
                                } else {
                                    errMsg = this.bundle.messageString("PanelDynamic.PasswordInvalid.txt", label);
                                }
                            }
                        } else if (type == 11) {
                            if (user != null) {
                                valid = Globals.g_mode == 2 ? Utils.isMSPasswordValid(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, user, value) : Utils.isMSPasswordValid(Globals.g_configData.getProperty("iomsrv.metadatasrv.host", ""), Globals.g_configData.getProperty("iomsrv.metadatasrv.port", ""), user, value);
                                user = null;
                                if (!valid) {
                                    generic = false;
                                    if (Globals.g_quietMode) {
                                        Wizard.logResponseInvalid(this.getHeader(), name, "", "Unable to connect.  This may be due to invalid credentials (user ID and/or password), incorrect connection information (host and/or port), or no server running.");
                                    } else {
                                        errMsg = this.bundle.messageString("PanelDynamic.UnableToConnect.txt", label);
                                    }
                                }
                            }
                        } else if (!(type != 9 && type != 10 || Utils.getOS() != 1 || Globals.g_skipPasswordCheck)) {
                            if (user != null) {
                                int rc = Utils.isOSPasswordValid(user, value, false);
                                boolean bl = valid = rc == 0;
                                if (rc == 219) {
                                    generic = false;
                                    if (Globals.g_quietMode) {
                                        Wizard.logResponseInvalid(this.getHeader(), user, "", "The user ID must be in qualified format (for example, domain\\userID or machine\\userID).");
                                    } else {
                                        errMsg = this.bundle.messageString("PanelDynamic.DomainRequired.txt");
                                    }
                                } else if (valid && type == 10) {
                                    if (Utils.isOSPasswordValid(user, value, true) == 0) {
                                        if (name.equalsIgnoreCase("oma.person.gensrvusr.login.passwd")) {
                                            Globals.g_configData.setSDWProperty("os.win.security.gensrvusr.prompt", "false");
                                        } else if (name.equalsIgnoreCase("oma.person.demo.login.passwd")) {
                                            Globals.g_configData.setSDWProperty("os.win.security.demo.prompt", "false");
                                        }
                                    } else if (name.equalsIgnoreCase("oma.person.gensrvusr.login.passwd")) {
                                        Globals.g_configData.setSDWProperty("os.win.security.gensrvusr.prompt", "true");
                                    } else if (name.equalsIgnoreCase("oma.person.demo.login.passwd")) {
                                        Globals.g_configData.setSDWProperty("os.win.security.demo.prompt", "true");
                                    }
                                } else if (!valid) {
                                    generic = false;
                                    if (Globals.g_quietMode) {
                                        Wizard.logResponseInvalid(this.getHeader(), user, "", "The supplied password is invalid.");
                                    } else {
                                        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelDynamic.PasswordCheckFail.txt", label), this.bundle.getString("Common.Error.txt"), 0);
                                    }
                                }
                                user = null;
                            }
                        } else if (type == 17 || type == 14 || type == 19 || type == 16) {
                            if ((type == 19 || type == 16) && value.length() == 0) {
                                valid = true;
                            } else if (Utils.pathContainsValidChars(value)) {
                                valid = Utils.validatePath(value);
                            } else {
                                valid = false;
                                generic = false;
                                if (Globals.g_quietMode) {
                                    String quietMsg = null;
                                    quietMsg = Utils.getOS() == 1 ? "The following characters are invalid: / : * ? \" < > |" : (Utils.getOS() == 9 ? "The following characters are invalid: \\ :" : "The following characters are invalid: <space> % * \" & ? : < > \\ | ( )");
                                    Wizard.logResponseInvalid(this.getHeader(), name, value, quietMsg);
                                } else {
                                    errMsg = Utils.getOS() == 1 ? this.bundle.messageString("Common.Error.InvalidChars.Windows.txt", label) : (Utils.getOS() == 9 ? this.bundle.messageString("Common.Error.InvalidChars.Mac.txt", label) : this.bundle.messageString("Common.Error.InvalidChars.UNIX.txt", label));
                                }
                            }
                        } else if (type == 18) {
                            valid = new File(value).isDirectory();
                        } else if (type == 40) {
                            List<PropertyJarFile> foundJars = this.processJarDirExistsProperty(property, value);
                            if (foundJars == null) {
                                valid = false;
                            }
                        } else if (type == 44) {
                            boolean bl = valid = !new File(value).isDirectory();
                            if (!valid) {
                                generic = false;
                                if (Globals.g_quietMode) {
                                    Wizard.logResponseInvalid(this.getHeader(), name, value, "The selected directory already exists. It must be one that does not exist.");
                                } else {
                                    errMsg = this.bundle.messageString("PanelDynamic.DirCannotExist", label);
                                }
                            }
                        } else if (type == 38) {
                            valid = Utils.canWriteToPath(value);
                            if (!valid) {
                                generic = false;
                                if (Globals.g_quietMode) {
                                    Wizard.logResponseInvalid(this.getHeader(), name, value, "The selected directory is not writable.");
                                } else {
                                    errMsg = this.bundle.messageString("PanelDynamic.unwritableDirectoryMsg.txt", label);
                                }
                            }
                        } else if (type == 15) {
                            valid = new File(value).isFile();
                        } else if (type == 39) {
                            PropertyJarFile jarFile = this.processJarExistsProperty(property, value);
                            if (jarFile == null) {
                                valid = false;
                            }
                        } else if (type == 27) {
                            if (Utils.pathContainsValidChars(value)) {
                                if (Utils.validatePath(value) || value.startsWith(File.separator)) {
                                    valid = false;
                                    generic = false;
                                    if (Globals.g_quietMode) {
                                        Wizard.logResponseInvalid(this.getHeader(), name, value, "The value should be a relative directory that does not include a starting directory separator.");
                                    } else {
                                        errMsg = this.bundle.messageString("Common.Error.InvalidRelativePath.txt", label);
                                    }
                                }
                            } else {
                                valid = false;
                                generic = false;
                                if (Globals.g_quietMode) {
                                    String quietMsg = null;
                                    quietMsg = Utils.getOS() == 1 ? "The following characters are invalid: / : * ? \" < > |" : (Utils.getOS() == 9 ? "The following characters are invalid: \\ :" : "The following characters are invalid: <space> % * \" & ? : < > \\ | ( )");
                                    Wizard.logResponseInvalid(this.getHeader(), name, value, quietMsg);
                                } else {
                                    errMsg = Utils.getOS() == 1 ? this.bundle.messageString("Common.Error.InvalidChars.Windows.txt", label) : (Utils.getOS() == 9 ? this.bundle.messageString("Common.Error.InvalidChars.Mac.txt", label) : this.bundle.messageString("Common.Error.InvalidChars.UNIX.txt", label));
                                }
                            }
                        } else if (type == 50 || type == 51 || type == 52) {
                            String quietMsg = null;
                            String promptErrMsg = null;
                            if (type == 50) {
                                quietMsg = "The following characters are invalid: / : * ? \" < > |";
                                promptErrMsg = this.bundle.messageString("Common.Error.InvalidChars.Windows.txt", label);
                                valid = Utils.validWinPath(value);
                            } else if (type == 51) {
                                quietMsg = "The following characters are invalid: <space> % * \" & ? : < > \\ | ( )";
                                promptErrMsg = this.bundle.messageString("Common.Error.InvalidChars.UNIX.txt", label);
                                valid = Utils.validUnxPath(value);
                            } else if (type == 52) {
                                quietMsg = "The following characters are invalid: \\ :";
                                promptErrMsg = this.bundle.messageString("Common.Error.InvalidChars.Mac.txt", label);
                                valid = Utils.validMacPath(value);
                            }
                            if (!valid) {
                                generic = false;
                                if (Globals.g_quietMode) {
                                    Wizard.logResponseInvalid(this.getHeader(), name, value, quietMsg);
                                } else {
                                    errMsg = promptErrMsg;
                                }
                            }
                        } else if (type == 33) {
                            valid = Utils.isValidSvcNumber(value);
                        } else if (type == 20) {
                            value = Utils.toLowerCaseHostNameForUrl(value);
                            generic = false;
                            try {
                                URL url = new URL(value);
                                String host = url.getHost();
                                if (!host.isEmpty()) break block286;
                                valid = false;
                                if (Globals.g_quietMode) {
                                    Wizard.logResponseInvalid(this.getHeader(), name, value, "The URL does not contain a recognizable hostname.");
                                    break block286;
                                }
                                errMsg = this.bundle.messageString("Common.Error.MissingURLHostname.txt", label);
                            }
                            catch (MalformedURLException e) {
                                valid = false;
                                if (Globals.g_quietMode) {
                                    Wizard.logResponseInvalid(this.getHeader(), name, value, "The URL is malformed. Reason: " + e.getMessage() + ".");
                                    break block286;
                                }
                                errMsg = this.bundle.messageString("Common.Error.MalformedURL.txt", label, e.getMessage());
                            }
                        } else if (type == 37) {
                            if (!(Globals.g_planConfigs == null || Globals.g_remoteWebApps || Globals.g_reconfigure || Globals.g_skipUniqueServerNames)) {
                                boolean found = false;
                                for (int j = 0; j < Globals.g_planConfigs.length && !found; ++j) {
                                    if (Globals.g_planConfigs[j].equalsIgnoreCase("jboss")) {
                                        File serverNameDir;
                                        File serverDir;
                                        found = true;
                                        String jbossInstallDir = Globals.g_configData.getProperty("jboss.install.dir", null);
                                        if (jbossInstallDir == null || !(serverDir = new File(jbossInstallDir, "server")).isDirectory() || !(serverNameDir = new File(serverDir, value)).isDirectory()) continue;
                                        valid = false;
                                        generic = false;
                                        if (Globals.g_quietMode) {
                                            Wizard.logResponseInvalid(this.getHeader(), name, value, "Already defined in the selected web application server and must be unique.");
                                            continue;
                                        }
                                        errMsg = this.bundle.messageString("PanelDynamic.WebAppServerNameInvalid.txt", label);
                                        continue;
                                    }
                                    if (Globals.g_planConfigs[j].equalsIgnoreCase("weblogic")) {
                                        found = true;
                                        continue;
                                    }
                                    if (Globals.g_planConfigs[j].equalsIgnoreCase("vfabrictcsvr") || Globals.g_planConfigs[j].equalsIgnoreCase("tcsclusterc")) {
                                        found = true;
                                        continue;
                                    }
                                    if (Globals.g_planConfigs[j].equalsIgnoreCase("webspherend")) {
                                        File profileNameDir;
                                        File profilesDir;
                                        found = true;
                                        String websphereInstallDir = Globals.g_configData.getProperty("webspherend.install.dir", null);
                                        if (websphereInstallDir == null || !(profilesDir = new File(websphereInstallDir, "profiles")).isDirectory() || !(profileNameDir = new File(profilesDir, value)).isDirectory()) continue;
                                        valid = false;
                                        generic = false;
                                        if (Globals.g_quietMode) {
                                            Wizard.logResponseInvalid(this.getHeader(), name, value, "Already defined in the selected web application server and must be unique.");
                                            continue;
                                        }
                                        errMsg = this.bundle.messageString("PanelDynamic.WebAppServerNameInvalid.txt", label);
                                        continue;
                                    }
                                    if (!Globals.g_planConfigs[j].equalsIgnoreCase("websphereba")) continue;
                                    found = true;
                                }
                            }
                        } else if (type == 42 || type == 43) {
                            valid = Utils.isValidHostNameChars(value);
                            if (!valid) {
                                generic = false;
                                if (Globals.g_quietMode) {
                                    Wizard.logResponseInvalid(this.getHeader(), name, value, "Invalid underscore character in hostname.");
                                } else {
                                    errMsg = this.bundle.messageString("PanelHostName.InvalidChar.txt", label);
                                }
                            }
                            hostname = value;
                        } else if (type == 45) {
                            boolean bl = valid = !value.contains(" ");
                            if (!valid) {
                                generic = false;
                                if (Globals.g_quietMode) {
                                    Wizard.logResponseInvalid(this.getHeader(), name, value, "Value contains white space which is not valid. Need to remove white space to continue.");
                                } else {
                                    errMsg = this.bundle.messageString("PanelDynamic.HasWhiteSpaceError.txt", label);
                                }
                            }
                        }
                    }
                    if (Utils.getOS() == 8 && (name.equals("zos.host.logon.user") || name.equals("zos.job.copymod") || name.equals("zos.job.ftp") || name.equals("zos.job.diskunit") || name.equals("z64.job.diskunit") || name.equals("zos.job.intrdr") || name.equals("zos.high.level.qualifier") || name.equals("z64.high.level.qualifier") || name.equals("zos.host.logon.host") || name.equals("zos.sms.dc") || name.equals("z64.sms.dc") || name.equals("zos.sms.mc") || name.equals("z64.sms.mc") || name.equals("zos.sms.sc") || name.equals("z64.sms.sc") || name.equals("zos.sms.pdse.dc") || name.equals("z64.sms.pdse.dc") || name.equals("zos.sms.pdse.mc") || name.equals("z64.sms.pdse.mc") || name.equals("zos.sms.pdse.sc") || name.equals("z64.sms.pdse.sc") || name.equals("zos.job.voldisk") || name.equals("z64.job.voldisk") || name.equals("zos.entry.point") || name.equals("zos.job.tmpuni") || name.equals("zos.job.cards.job1") || name.equals("zos.job.cards.job2") || name.equals("zos.job.cards.job3") || name.equals("zos.job.cards.job4") || name.equals("zos.job.cards.job5") || name.equals("iomsrv.metadatasrv.stcname") || name.equals("spawner.objectspawnr.stcname") || name.equals("iomsrv.olapserver.stcname") || name.equals("server.sharesrv.stcname") || name.equals("iomsrv.dffedsvrcfg.stcname") || name.equals("spawner.connectsrv.stcname") || name.equals("wipschedsvcs.cache.locator.stcname") || name.equals("iomsrv.tableserver.stcname"))) {
                        value = value.toUpperCase(Locale.ENGLISH);
                    }
                    if (!valid && generic) {
                        if (Globals.g_quietMode) {
                            Wizard.logResponseInvalid(this.getHeader(), name, value, null);
                        } else {
                            errMsg = this.bundle.messageString("Common.Error.InvalidField.txt", label);
                        }
                    }
                }
                if (Globals.g_resumeChain && valid && this.isPasswordField(type)) {
                    try {
                        String savedPwHash = "";
                        if (this.m_dialogType == 1) {
                            savedPwHash = Globals.g_installData.getProperty(name + ".hash", Globals.g_installDefaults.getDefault(name + ".hash", ""));
                            if (!savedPwHash.equals("") && Globals.g_installPasswords != null) {
                                Globals.g_installPasswords.put(name + ".hash", null);
                            }
                        } else {
                            savedPwHash = Globals.g_configData.getProperty(name + ".hash", Globals.g_configDefaults.getDefault(name + ".hash", ""));
                            if (!savedPwHash.equals("") && Globals.g_configPasswords != null) {
                                Globals.g_configPasswords.put(name + ".hash", null);
                            }
                        }
                        StringTokenizer tokenizer = new StringTokenizer(savedPwHash, "|");
                        String seed = "";
                        while (tokenizer.hasMoreTokens()) {
                            seed = tokenizer.nextToken();
                        }
                        String enteredPwHash = Utils.makeSHA256Hash(value, Integer.parseInt(seed));
                        if (enteredPwHash == null || !savedPwHash.equals(enteredPwHash)) {
                            valid = false;
                            if (Globals.g_quietMode) {
                                Wizard.logResponseInvalid(this.getHeader(), name, value, null);
                            } else {
                                errMsg = this.bundle.messageString("Common.Error.Reentry.PasswordMismatch.txt", label);
                            }
                        }
                    }
                    catch (Exception savedPwHash) {
                        // empty catch block
                    }
                }
                if (valid) {
                    if (type == 8 || type == 34 || type == 11 || type == 12 || type == 9 || type == 10) {
                        String pwHash;
                        if (!Globals.g_resumeChain && (pwHash = Utils.makeSHA256Hash(value)) != null) {
                            if (this.m_dialogType == 1 && Globals.g_installPasswords != null) {
                                Globals.g_installData.setProperty(name + ".hash", pwHash);
                                Globals.g_installPasswords.put(name + ".hash", null);
                            } else if (this.m_dialogType == 0 && Globals.g_configPasswords != null) {
                                Globals.g_configData.setProperty(name + ".hash", pwHash);
                                Globals.g_configPasswords.put(name + ".hash", null);
                            }
                        }
                        if (!SasPasswordString.isEncoded(value)) {
                            try {
                                value = SasPasswordString.encode("sas002", value);
                            }
                            catch (Exception e) {
                                Logging.log.severe("Unable to encode the password for: " + name);
                                Logging.logStackTrace(e);
                            }
                        }
                    }
                    if (this.m_dialogType == 1) {
                        Globals.g_installData.setProperty(name, value);
                    } else {
                        Globals.g_configData.setProperty(name, value);
                        if (this.m_configUpgrade) {
                            Globals.g_cmtDynamicProps.put(name, null);
                        }
                    }
                    if (!Globals.g_superMode) continue;
                    superMsg = superMsg + name + " = " + value + "\n";
                    continue;
                }
                if (!(errMsg == null || Globals.g_resumeChain && this.m_validationAttempts <= 0)) {
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
                }
                if (focusObj == null) continue;
                focusObj.requestFocus();
            }
            if (valid && this.m_nonPromptedProps != null) {
                for (i = 0; i < this.m_nonPromptedProps.size(); ++i) {
                    boolean rc;
                    StringBuffer msgs;
                    Properties dsProperties;
                    property = this.m_nonPromptedProps.get(i);
                    name = property.getName();
                    type = property.getType(this.m_configUpgrade);
                    if (this.isComboField(type)) continue;
                    value = this.getPropertyValue(property, false);
                    if (this.m_dialogType == 1) {
                        Globals.g_installData.setProperty(name, value);
                    } else {
                        Globals.g_configData.setProperty(name, value);
                        if (this.m_configUpgrade) {
                            Globals.g_cmtDynamicProps.put(name, null);
                        }
                    }
                    if (Globals.g_superMode) {
                        superMsg = superMsg + name + " = " + value + "\n";
                    }
                    if (type == 41) {
                        if (Globals.g_skipvalidators || !name.startsWith("certframe") && (Utils.getOS() == 8 || Utils.getOS() == 10)) continue;
                        validatorProperty = property;
                        String productCode = property.getOwner().toLowerCase();
                        if (productCode.equalsIgnoreCase("temp")) continue;
                        if (productCode.equalsIgnoreCase("globalroot")) {
                            productCode = "cfgwizard";
                        }
                        validatorClassName = value;
                        continue;
                    }
                    if (type == 40) {
                        this.processJarDirExistsProperty(property, value);
                        continue;
                    }
                    if (type == 39) {
                        this.processJarExistsProperty(property, value);
                        continue;
                    }
                    if (type == 47) {
                        if (!name.equals("mominstall.products.none.selected") || this.numberCheckBoxesSelected() > 0 || (valid = false)) continue;
                        if (Globals.g_quietMode) {
                            Wizard.logResponseInvalid(this.getHeader(), name, value, "At least one selection must be made.");
                            continue;
                        }
                        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelDynamic.CheckboxGroupNeedsSelection.txt"), this.bundle.getString("Common.Warning.txt"), 2);
                        continue;
                    }
                    if (type == 53 || type == 54) {
                        if (!Globals.g_zosPreCheck) continue;
                        dsProperties = Globals.g_installData.getProperties();
                        msgs = new StringBuffer(256);
                        String valueName = "";
                        if (type == 53) {
                            valueName = "SMS Parameters";
                            rc = InstallToolConnector.checkMvsDataSetParams(4, null, dsProperties, Logging.log, Globals.g_quietMode, msgs);
                        } else {
                            valueName = "SMS PDS/E Parameters";
                            rc = InstallToolConnector.checkMvsDataSetParams(5, null, dsProperties, Logging.log, Globals.g_quietMode, msgs);
                        }
                        if (!rc) {
                            valid = false;
                            generic = false;
                            if (Globals.g_quietMode) {
                                Wizard.logResponseInvalid(this.getHeader(), name, value, this.en_bundle.messageString("PanelDynamic.DataSetAllocationParameterInvalid.txt", msgs));
                            } else {
                                response = CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), msgs + "\n\n" + this.bundle.messageString("PanelDynamic.IgnoreConfirmation.txt") + this.bundle.messageString("PanelDynamic.ErrorConfirmation.txt"), this.bundle.getString("Common.Warning.txt"), 0, 2, 1);
                                if (response == 0) {
                                    Logging.log.info(String.format("Warning for invalid %s value '%s' has been ignored", valueName, value));
                                    valid = true;
                                }
                            }
                        }
                        InstallToolConnector.resetITMvsextractTask();
                        continue;
                    }
                    if (type != 58) continue;
                    dsProperties = Globals.g_installData.getProperties();
                    msgs = new StringBuffer(256);
                    if (!valid) continue;
                    rc = InstallToolConnector.checkMvsDataSetParams(1, null, dsProperties, Logging.log, Globals.g_quietMode, msgs);
                    if (!rc) {
                        valid = false;
                        generic = false;
                        if (Globals.g_quietMode) {
                            Wizard.logResponseInvalid(this.getHeader(), name, value, this.en_bundle.messageString("PanelDynamic.DataSetInUse.txt", msgs));
                        } else {
                            errMsg = this.bundle.messageString("PanelDynamic.DataSetInUse.txt", msgs);
                            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
                        }
                    }
                    InstallToolConnector.resetITMvsextractTask();
                }
            }
            if (valid && validatorClassName != null && !(valid = this.runGroovyValidatorClass(validatorProperty, validatorClassName)) && focusObj != null && !Globals.g_quietMode && !Globals.g_consoleMode) {
                focusObj.requestFocus();
            }
        }
        if (valid && Globals.g_debug) {
            int i;
            if (this.m_dialogType == 1) {
                if (Globals.g_installDebugFile != null) {
                    Globals.g_installDebugFile.println("<***");
                    Globals.g_installDebugFile.println("Displayed Dialog: " + this.m_panelID);
                }
            } else if (Globals.g_configDebugFile != null) {
                Globals.g_configDebugFile.println("<***");
                Globals.g_configDebugFile.println("Displayed Dialog: " + this.m_panelID);
            }
            property = null;
            name = null;
            for (i = 0; i < this.m_promptedProperties.size(); ++i) {
                property = this.m_promptedProperties.get(i);
                name = property.getName();
                if (this.m_dialogType == 1) {
                    if (Globals.g_installDebugFile == null) continue;
                    Globals.g_installDebugFile.println("   Property: " + name);
                    Globals.g_installDebugFile.println("      Value:   " + Globals.g_installData.getProperty(name, ""));
                    continue;
                }
                if (Globals.g_configDebugFile == null) continue;
                Globals.g_configDebugFile.println("   Property: " + name);
                Globals.g_configDebugFile.println("      Value:   " + Globals.g_configData.getProperty(name, ""));
            }
            for (i = 0; i < this.m_nonPromptedProps.size(); ++i) {
                property = this.m_nonPromptedProps.get(i);
                name = property.getName();
                if (this.m_dialogType == 1) {
                    if (Globals.g_installDebugFile == null) continue;
                    Globals.g_installDebugFile.println("   Property: " + name);
                    Globals.g_installDebugFile.println("      Value:   " + Globals.g_installData.getProperty(name, ""));
                    continue;
                }
                if (Globals.g_configDebugFile == null) continue;
                Globals.g_configDebugFile.println("   Property: " + name);
                Globals.g_configDebugFile.println("      Value:   " + Globals.g_configData.getProperty(name, ""));
            }
            if (this.m_dialogType == 1) {
                if (Globals.g_installDebugFile != null) {
                    Globals.g_installDebugFile.println("***>");
                }
            } else if (Globals.g_configDebugFile != null) {
                Globals.g_configDebugFile.println("***>");
            }
            if (this.m_dialogType == 0) {
                Globals.g_configData.save();
            }
        }
        if (valid && Globals.g_superMode && !Globals.g_consoleMode) {
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), superMsg, this.m_panelID, 1);
        }
        ++this.m_validationAttempts;
        return valid;
    }

    private int numberCheckBoxesSelected() {
        DialogData.Property property = null;
        int numSelected = 0;
        for (int j = 0; j < this.m_promptedProperties.size(); ++j) {
            JCheckBox checkBox;
            property = this.m_promptedProperties.get(j);
            String name = property.getName();
            int type = property.getType(this.m_configUpgrade);
            if (!name.startsWith("mominstall.products") || !this.isCheckBoxField(type) || !(checkBox = (JCheckBox)this.m_controls.get(j)).isSelected()) continue;
            ++numSelected;
        }
        return numSelected;
    }

    public PropertyJarFile processJarExistsProperty(DialogData.Property property, String jarPath) {
        PropertyJarFile jarFile = null;
        String propertyName = property.getName();
        String namespacePrefix = DialogData.Property.parseNamespacePrefix(propertyName);
        PanelDynamic.removeFoundJarsForProperty(namespacePrefix, propertyName);
        File file = new File(jarPath);
        if (file.isFile() && jarPath.toLowerCase().endsWith(".jar")) {
            try {
                jarFile = new PropertyJarFile(file);
                jarFile.setPropertyOwner(propertyName);
                PanelDynamic.addFoundJarFile(namespacePrefix, jarFile);
                Logging.log.finer("PanelDynamic:processJarExistsProperty() Added found jar file: " + jarPath);
            }
            catch (IOException ioe) {
                Logging.log.severe("PanelDynamic:processJarExistsProperty() Cannot load jar file: " + jarPath);
            }
        }
        return jarFile;
    }

    public List<PropertyJarFile> processJarDirExistsProperty(DialogData.Property property, String directoryPath) {
        ArrayList<PropertyJarFile> jarFileList = null;
        String propertyName = property.getName();
        String namespacePrefix = DialogData.Property.parseNamespacePrefix(propertyName);
        PanelDynamic.removeFoundJarsForProperty(namespacePrefix, propertyName);
        File dir = new File(directoryPath);
        boolean valid = dir.isDirectory();
        if (valid) {
            Logging.log.finer("PanelDynamic:processJarDirExistsProperty() Searching for jars in directory: " + directoryPath);
            FilenameFilter jarFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".jar");
                }
            };
            File[] filteredFiles = dir.listFiles(jarFilter);
            if (jarFileList == null) {
                jarFileList = new ArrayList<PropertyJarFile>(filteredFiles.length);
            }
            for (File file : filteredFiles) {
                String jarPath = "";
                try {
                    jarPath = file.getCanonicalPath();
                    PropertyJarFile jarFile = new PropertyJarFile(jarPath);
                    jarFile.setPropertyOwner(propertyName);
                    jarFileList.add(jarFile);
                    Logging.log.finer("PanelDynamic:processJarDirExistsProperty() Added found jar file: " + jarPath);
                }
                catch (Exception e) {
                    Logging.log.severe("PanelDynamic:processJarDirExistsProperty() Cannot load jar file: " + jarPath);
                }
            }
            PanelDynamic.addFoundJarList(namespacePrefix, jarFileList);
        }
        return jarFileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runGroovyValidatorClass(DialogData.Property validatorProperty, String validatorClassName) {
        boolean valid = true;
        ValidatorRunner validator = null;
        try {
            String namespacePrefix = DialogData.Property.parseNamespacePrefix(validatorProperty.getName());
            List<PropertyJarFile> dependendJars = PanelDynamic.getExistingJarList(namespacePrefix);
            validator = new ValidatorRunner(validatorProperty, validatorClassName, dependendJars, this.m_dialogType);
            ValidationResult result = validator.validateData();
            ValidationResultPrompt prompt = new ValidationResultPrompt(validator, result);
            int answer = prompt.showPromptReturnAnswer();
            switch (answer) {
                case 1: {
                    valid = false;
                    break;
                }
                case 2: {
                    valid = false;
                }
            }
        }
        catch (Throwable e) {
            Logging.log.warning("Unable to run validation for Groovy class: " + validatorClassName);
            Logging.logStackTrace(e);
            if (Globals.g_quietMode) {
                boolean dependendJars = true;
                return dependendJars;
            }
            String error = e.getMessage();
            if (error == null) {
                error = "";
            }
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("GroovyValidator.UnableToExecuteGroovyClass.txt", validatorClassName, error), this.bundle.getString("Common.Warning.txt"), 2);
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        boolean display = false;
        boolean valid = false;
        boolean persist = false;
        String rule = null;
        String name = null;
        String owner = null;
        float version = 0.0f;
        boolean missingDefault = this.missingDefault();
        for (int i = 0; i < this.m_dialogProperties.length && !display; ++i) {
            rule = this.m_dialogProperties[i].getRule();
            valid = PropertyRules.resolveBooleanRule(rule, false, this.m_dialogType);
            if (this.m_configUpgrade && valid) {
                version = this.m_dialogProperties[i].getVersion();
                if (version == 0.0f) {
                    persist = this.m_dialogProperties[i].getPersist();
                    name = this.m_dialogProperties[i].getName();
                    owner = this.m_dialogProperties[i].getOwner();
                    valid = persist && !DynamicDialogs.isPropertyPersisted(name, owner);
                } else if (version == -1.0f) {
                    valid = true;
                } else {
                    boolean bl = valid = version > Globals.g_cmtFromDialogVer && version <= Globals.g_cmtToDialogVer;
                }
            }
            if (!valid) continue;
            display = this.displayProperty(this.m_dialogProperties[i], missingDefault);
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = this.m_dialogType == 1 ? (this.m_index < Globals.g_dynamicInstallDialogs.length - 1 ? Globals.g_dynamicInstallDialogs[this.m_index + 1] : (Globals.g_mode == 2 ? (Globals.g_cmtRunITTarget ? "systemcheck" : "execute") : "systemcheck")) : (this.m_index < Globals.g_dynamicConfigDialogs.length - 1 ? Globals.g_dynamicConfigDialogs[this.m_index + 1] : (Globals.g_apprentice ? "apprentice" : "execute"));
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        this.initialize();
        this.refreshDefaults();
        if (!this.m_panelLoaded) {
            if (!this.loadResponseData()) {
                // empty if block
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = null;
        if (this.m_promptedProperties != null && this.m_promptedProperties.size() > 0) {
            int i;
            DialogData.Property property = null;
            String name = null;
            int type = 0;
            String value = null;
            String notes = null;
            KitTextField text = null;
            JTextArea textArea = null;
            JPasswordField password = null;
            JCheckBox checkBox = null;
            JComboBox comboBox = null;
            ControlBrowse path = null;
            int dataCount = 0;
            for (i = 0; i < this.m_promptedProperties.size(); ++i) {
                property = this.m_promptedProperties.get(i);
                type = property.getType(this.m_configUpgrade);
                if (type == 25 || type == 7) continue;
                ++dataCount;
            }
            data = new String[dataCount * 2];
            dataCount = 0;
            for (i = 0; i < this.m_promptedProperties.size(); ++i) {
                property = this.m_promptedProperties.get(i);
                name = property.getName();
                type = property.getType(this.m_configUpgrade);
                if (type == 1 || type == 2 || type == 26 || type == 28 || type == 29 || type == 30 || type == 31 || type == 42 || type == 43 || type == 45 || type == 37) {
                    notes = "<text value>";
                } else if (type == 3 || type == 36) {
                    notes = "<number value>";
                } else if (type == 4) {
                    notes = "yes/no";
                } else if (type == 5 || type == 6) {
                    notes = "<user name value>";
                } else if (this.isPasswordField(type)) {
                    notes = "<password value>";
                } else if (type == 14 || type == 15) {
                    notes = "<full path to file>";
                } else if (type == 39) {
                    notes = "<full path to jar file>";
                } else if (type == 40) {
                    notes = "<full path containing jars>";
                } else if (type == 16) {
                    notes = "<full path to file (optional)>";
                } else if (type == 17 || type == 18 || type == 38 || type == 44 || type == 50 || type == 51 || type == 52) {
                    notes = "<full path>";
                } else if (type == 19) {
                    notes = "<full path (optional)>";
                } else if (type == 27) {
                    notes = "<relative path>";
                } else if (type == 20) {
                    notes = "<URL value>";
                } else if (type == 21) {
                    notes = "<URI value>";
                } else if (type == 22) {
                    notes = "<port number value>";
                } else if (type == 46) {
                    notes = "<port number value>";
                } else if (type == 47) {
                    notes = "<boolean group validator>";
                } else if (this.isComboField(type)) {
                    notes = "";
                    DynamicComboData[] comboData = this.getComboData(property.getComboData(), type == 32);
                    for (int j = 0; j < comboData.length; ++j) {
                        if (notes.length() > 0) {
                            notes = notes + "/";
                        }
                        notes = notes + comboData[j].getValue();
                    }
                } else if (type == 24) {
                    notes = "<jobcard value>";
                } else if (type == 33) {
                    notes = "<svc number value>";
                } else if (type == 35) {
                    notes = "<IP multicast address>";
                }
                if (this.isTextField(type)) {
                    text = (KitTextField)this.m_controls.get(i);
                    value = text.getText();
                } else if (this.isTextArea(type)) {
                    textArea = (JTextArea)this.m_controls.get(i);
                    value = textArea.getText();
                } else if (this.isPasswordField(type)) {
                    password = (JPasswordField)this.m_controls.get(i);
                    value = String.valueOf(password.getPassword());
                    if (type != 13 && !SasPasswordString.isEncoded(value)) {
                        try {
                            value = SasPasswordString.encode("sas002", value);
                        }
                        catch (Exception e) {
                            Logging.log.severe("Unable to encode the password for: " + name);
                            Logging.logStackTrace(e);
                        }
                    }
                } else if (this.isBrowseField(type)) {
                    path = (ControlBrowse)this.m_controls.get(i);
                    value = path.getText();
                } else if (this.isCheckBoxField(type)) {
                    checkBox = (JCheckBox)this.m_controls.get(i);
                    value = checkBox.isSelected() ? "yes" : "no";
                } else if (this.isComboField(type)) {
                    comboBox = (JComboBox)this.m_controls.get(i);
                    value = comboBox.getSelectedIndex() > -1 ? ((DynamicComboData)comboBox.getSelectedItem()).getValue() : "";
                } else {
                    notes = "<undefined property type>";
                    value = "";
                }
                if (type == 25 || type == 7) continue;
                data[dataCount * 2] = "#" + name + "=" + notes;
                data[dataCount * 2 + 1] = " " + name + "=" + value;
                ++dataCount;
            }
        }
        return data;
    }

    @Override
    public void initializePanel() {
        this.initialize();
    }

    @Override
    public void backEvent(String backPanelID) {
        DialogData.Property property = null;
        String name = null;
        if (this.m_promptedProperties != null && this.m_promptedProperties.size() > 0) {
            String value = null;
            String defaultVal = null;
            int type = 0;
            boolean changed = false;
            KitTextField text = null;
            JTextArea textArea = null;
            JPasswordField password = null;
            JCheckBox checkBox = null;
            JComboBox comboBox = null;
            ControlBrowse path = null;
            for (int i = 0; i < this.m_promptedProperties.size(); ++i) {
                property = this.m_promptedProperties.get(i);
                name = property.getName();
                type = property.getType(this.m_configUpgrade);
                if (this.isTextField(type)) {
                    text = (KitTextField)this.m_controls.get(i);
                    value = text.getText();
                } else if (this.isTextArea(type)) {
                    textArea = (JTextArea)this.m_controls.get(i);
                    value = textArea.getText();
                } else if (this.isPasswordField(type)) {
                    password = (JPasswordField)this.m_controls.get(i);
                    value = String.valueOf(password.getPassword());
                } else if (this.isBrowseField(type)) {
                    path = (ControlBrowse)this.m_controls.get(i);
                    value = path.getText();
                } else {
                    value = this.isCheckBoxField(type) ? ((checkBox = (JCheckBox)this.m_controls.get(i)).isSelected() ? "true" : "false") : (this.isComboField(type) ? ((comboBox = (JComboBox)this.m_controls.get(i)).getSelectedIndex() > -1 ? ((DynamicComboData)comboBox.getSelectedItem()).getValue() : "") : "");
                }
                if (!(type != 8 && type != 34 && type != 11 && type != 12 && type != 9 && type != 10 || SasPasswordString.isEncoded(value))) {
                    try {
                        value = SasPasswordString.encode("sas002", value);
                    }
                    catch (Exception e) {
                        Logging.log.severe("Unable to encode the password for: " + name);
                        Logging.logStackTrace(e);
                    }
                }
                defaultVal = this.getPropertyDefault(property, true);
                if (this.isCheckBoxField(type)) {
                    changed = !value.equalsIgnoreCase(defaultVal);
                } else {
                    boolean bl = changed = !value.equals(defaultVal);
                }
                if (changed) {
                    if (this.m_dialogType == 1) {
                        Globals.g_installData.setProperty(name, value);
                        continue;
                    }
                    Globals.g_configData.setProperty(name, value);
                    if (!this.m_configUpgrade) continue;
                    Globals.g_cmtDynamicProps.put(name, null);
                    continue;
                }
                if (this.m_dialogType == 1) {
                    Globals.g_installData.removeProperty(name);
                    continue;
                }
                Globals.g_configData.removeProperty(name);
                if (!this.m_configUpgrade) continue;
                Globals.g_cmtDynamicProps.remove(name);
            }
        }
        if (this.m_nonPromptedProps != null && this.m_nonPromptedProps.size() > 0) {
            for (int i = 0; i < this.m_nonPromptedProps.size(); ++i) {
                property = this.m_nonPromptedProps.get(i);
                name = property.getName();
                if (this.m_dialogType == 1) {
                    Globals.g_installData.removeProperty(name);
                    continue;
                }
                Globals.g_configData.removeProperty(name);
            }
        }
        if (this.m_index > 0) {
            String panelID = null;
            panelID = this.m_dialogType == 1 ? Globals.g_dynamicInstallDialogs[this.m_index - 1] : Globals.g_dynamicConfigDialogs[this.m_index - 1];
            if (panelID != null && !panelID.equalsIgnoreCase(backPanelID)) {
                WizardPanelIface panel = (WizardPanelIface)Globals.g_wizard.getPanel(panelID);
                panel.backEvent(backPanelID);
            }
        }
        if (Globals.g_debug && this.m_dialogType == 0) {
            Globals.g_configData.save();
        }
    }

    @Override
    public int consoleEvent() {
        int returnCode = 0;
        if (this.m_promptedProperties != null && this.m_promptedProperties.size() > 0) {
            DialogData.Property property = null;
            int type = 0;
            String name = null;
            for (int i = 0; returnCode > -1 && i < this.m_promptedProperties.size(); ++i) {
                property = this.m_promptedProperties.get(i);
                name = property.getName();
                type = property.getType(this.m_configUpgrade);
                if (this.isStaticField(type)) {
                    returnCode = ConsoleMode.promptStaticText(this.getLabel(name), (KitTextField)this.m_controls.get(i));
                    continue;
                }
                if (this.isTextField(type)) {
                    returnCode = ConsoleMode.promptText(this.getLabel(name), (KitTextField)this.m_controls.get(i));
                    continue;
                }
                if (this.isTextArea(type)) {
                    returnCode = ConsoleMode.promptStaticText(this.getLabel(name), (JTextArea)this.m_controls.get(i));
                    continue;
                }
                if (this.isPasswordField(type)) {
                    returnCode = ConsoleMode.promptPassword(this.getLabel(name), (JPasswordField)this.m_controls.get(i));
                    if (returnCode <= -1 || type != 8 && type != 34 && type != 13 && type != 12 && (type != 9 && type != 10 || Utils.getOS() == 1)) continue;
                    returnCode = ConsoleMode.promptPassword(this.getConfirmLabel(name), (JPasswordField)this.m_confirmPrompts.get(i));
                    continue;
                }
                if (this.isBrowseField(type)) {
                    returnCode = ConsoleMode.promptText(this.getLabel(name), ((ControlBrowse)this.m_controls.get(i)).getTextField());
                    continue;
                }
                if (this.isCheckBoxField(type)) {
                    returnCode = ConsoleMode.promptBoolean((JCheckBox)this.m_controls.get(i));
                    continue;
                }
                if (!this.isComboField(type)) continue;
                returnCode = ConsoleMode.promptComboBox((JComboBox)this.m_controls.get(i));
            }
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        if (this.m_promptedProperties != null && this.m_promptedProperties.size() > 0) {
            DialogData.Property property = null;
            String name = null;
            int type = 0;
            String value = null;
            KitTextField text = null;
            JTextArea textArea = null;
            JPasswordField password = null;
            JCheckBox checkBox = null;
            JComboBox comboBox = null;
            ControlBrowse path = null;
            for (int i = 0; valid && i < this.m_promptedProperties.size(); ++i) {
                property = this.m_promptedProperties.get(i);
                name = property.getName();
                value = Wizard.getResponse(name, null);
                if (Globals.g_resumeChain) {
                    value = null;
                }
                if (value != null) {
                    type = property.getType(this.m_configUpgrade);
                    if (this.isTextField(type)) {
                        text = (KitTextField)this.m_controls.get(i);
                        text.setText(value);
                        continue;
                    }
                    if (this.isTextArea(type)) {
                        textArea = (JTextArea)this.m_controls.get(i);
                        textArea.setText(value);
                        continue;
                    }
                    if (this.isPasswordField(type)) {
                        String decodedPassword = null;
                        if (type == 13) {
                            decodedPassword = value;
                        } else {
                            try {
                                decodedPassword = SasPasswordString.decode(value);
                            }
                            catch (Exception e) {
                                decodedPassword = "";
                                Logging.log.warning("Unable to decode the password for: " + name);
                                Logging.logStackTrace(e);
                            }
                        }
                        password = (JPasswordField)this.m_controls.get(i);
                        if (password != null) {
                            password.setText(decodedPassword);
                        }
                        if ((password = (JPasswordField)this.m_confirmPrompts.get(i)) == null) continue;
                        password.setText(decodedPassword);
                        continue;
                    }
                    if (this.isBrowseField(type)) {
                        path = (ControlBrowse)this.m_controls.get(i);
                        path.setText(value);
                        continue;
                    }
                    if (this.isCheckBoxField(type)) {
                        checkBox = (JCheckBox)this.m_controls.get(i);
                        if (value.equalsIgnoreCase("yes")) {
                            checkBox.setSelected(true);
                            continue;
                        }
                        if (value.equalsIgnoreCase("no")) {
                            checkBox.setSelected(false);
                            continue;
                        }
                        valid = false;
                        Wizard.logResponseInvalid(this.getHeader(), name, value, null);
                        continue;
                    }
                    if (!this.isComboField(type)) continue;
                    comboBox = (JComboBox)this.m_controls.get(i);
                    boolean found = false;
                    for (int j = 0; j < comboBox.getItemCount() && !found; ++j) {
                        if (!((DynamicComboData)comboBox.getItemAt(j)).getValue().equalsIgnoreCase(value)) continue;
                        comboBox.setSelectedIndex(j);
                        found = true;
                    }
                    if (found) continue;
                    valid = false;
                    Wizard.logResponseInvalid(this.getHeader(), name, value, null);
                    continue;
                }
                type = property.getType(this.m_configUpgrade);
                if (!DynamicDialogs.useDefaultPropertyValue) {
                    if (type != 25 && type != 7) continue;
                    value = this.getPropertyValue(property, true);
                    text = (KitTextField)this.m_controls.get(i);
                    text.setText(value);
                    continue;
                }
                if (type == 25 || type == 7 || type == 22 || type == 2) {
                    value = this.getPropertyValue(property, true);
                    text = (KitTextField)this.m_controls.get(i);
                    text.setText(value);
                } else if (type == 18 || type == 38 || type == 17 || type == 44 || type == 19 || type == 50 || type == 51 || type == 52) {
                    path = (ControlBrowse)this.m_controls.get(i);
                    value = this.getPropertyValue(property, true);
                    path.setText(value);
                }
                Logging.log.fine("Default property," + property + " has value," + value);
            }
        }
        return valid;
    }

    private void initialize() {
        String reposName;
        boolean valid = false;
        boolean validType = true;
        boolean display = false;
        boolean persist = false;
        boolean getRepos = false;
        String rule = null;
        String name = null;
        String genType = null;
        String owner = null;
        int type = 0;
        int size = 0;
        int pathCount = 0;
        int row = 0;
        String value = null;
        String mtxt = null;
        String labelTxt = null;
        JTextArea info = null;
        JLabel label = null;
        KitTextField text = null;
        JTextArea textArea = null;
        JPasswordField password = null;
        JCheckBox checkBox = null;
        JComboBox<Object> comboBox = null;
        ControlBrowse path = null;
        JComponent control = null;
        JLabel padding = null;
        GridBagConstraints c = new GridBagConstraints();
        String superMsg = "";
        String infoText = null;
        int maxLength = 0;
        float version = 0.0f;
        if (Globals.g_debug) {
            if (this.m_dialogType == 1) {
                if (Globals.g_installDebugFile == null) {
                    String debugInstallFile = Utils.joinPath(Utils.getSDWDataPath(true), "debug_dynamic_install.txt");
                    try {
                        Globals.g_installDebugFile = new PrintWriter(new BufferedWriter(new FileWriter(debugInstallFile)));
                    }
                    catch (Exception e) {
                        Logging.log.info("Error creating dynamic install dialog debug file: " + debugInstallFile);
                        Logging.logStackTrace(e);
                    }
                }
                if (Globals.g_installDebugFile != null) {
                    Globals.g_installDebugFile.println("Dialog: " + this.m_panelID);
                }
            } else {
                if (Globals.g_configDebugFile == null) {
                    String debugConfigFile = Utils.joinPath(Utils.getSDWDataPath(true), "debug_dynamic_config.txt");
                    try {
                        Globals.g_configDebugFile = new PrintWriter(new BufferedWriter(new FileWriter(debugConfigFile)));
                        if (this.m_configUpgrade) {
                            Globals.g_configDebugFile.println("From Dialog Version: " + Globals.g_cmtFromDialogVer);
                            Globals.g_configDebugFile.println("To Dialog Version:   " + Globals.g_cmtToDialogVer);
                            Globals.g_configDebugFile.println();
                        }
                    }
                    catch (Exception e) {
                        Logging.log.info("Error creating dynamic configure dialog debug file: " + debugConfigFile);
                        Logging.logStackTrace(e);
                    }
                }
                if (Globals.g_configDebugFile != null) {
                    Globals.g_configDebugFile.println("Dialog: " + this.m_panelID);
                }
            }
        }
        if (this.m_panel != null) {
            this.m_panel.removeAll();
        }
        this.m_controls.clear();
        this.m_confirmPrompts.clear();
        this.m_promptedProperties.clear();
        this.m_nonPromptedProps.clear();
        boolean missingDefault = this.missingDefault();
        for (int i = 0; i < this.m_dialogProperties.length; ++i) {
            name = this.m_dialogProperties[i].getName();
            if (name.equals("mominstall.products.none.selected")) {
                String string = "yada";
            }
            boolean bl = valid = PropertyRules.resolveBooleanRule(rule = this.m_dialogProperties[i].getRule(), false, this.m_dialogType) || this.m_hasTask;
            if (this.m_configUpgrade && valid) {
                version = this.m_dialogProperties[i].getVersion();
                if (version == 0.0f) {
                    persist = this.m_dialogProperties[i].getPersist();
                    owner = this.m_dialogProperties[i].getOwner();
                    valid = persist && !DynamicDialogs.isPropertyPersisted(name, owner);
                } else if (version == -1.0f) {
                    valid = true;
                } else {
                    boolean bl2 = valid = version > Globals.g_cmtFromDialogVer && version <= Globals.g_cmtToDialogVer;
                }
            }
            if (Globals.g_debug) {
                if (this.m_dialogType == 1) {
                    if (Globals.g_installDebugFile != null) {
                        Globals.g_installDebugFile.println("   Property: " + name);
                        if (valid) {
                            Globals.g_installDebugFile.println("      Rule:    TRUE  -> " + rule);
                        } else {
                            Globals.g_installDebugFile.println("      Rule:    FALSE -> " + rule);
                        }
                    }
                } else if (Globals.g_configDebugFile != null) {
                    Globals.g_configDebugFile.println("   Property: " + name);
                    if (this.m_configUpgrade) {
                        owner = this.m_dialogProperties[i].getOwner();
                        Globals.g_configDebugFile.println("      Owner:   " + owner);
                        persist = this.m_dialogProperties[i].getPersist();
                        Globals.g_configDebugFile.println("      Persist: " + persist);
                        version = this.m_dialogProperties[i].getVersion();
                        Globals.g_configDebugFile.println("      Version: " + version);
                    }
                    if (valid) {
                        Globals.g_configDebugFile.println("      Rule:    TRUE  -> " + rule);
                    } else {
                        Globals.g_configDebugFile.println("      Rule:    FALSE -> " + rule);
                    }
                }
            }
            if (valid) {
                Object comboData;
                display = this.displayProperty(this.m_dialogProperties[i], missingDefault);
                if (Globals.g_debug) {
                    if (this.m_dialogType == 1) {
                        if (Globals.g_installDebugFile != null) {
                            if (display) {
                                if (this.m_dialogProperties[i].getGenPrompt() != null) {
                                    Globals.g_installDebugFile.println("      Display: TRUE  -> " + this.m_dialogProperties[i].getGenPrompt());
                                } else {
                                    Globals.g_installDebugFile.println("      Display: TRUE");
                                }
                            } else if (this.m_dialogProperties[i].getGenPrompt() != null) {
                                Globals.g_installDebugFile.println("      Display: FALSE -> " + this.m_dialogProperties[i].getGenPrompt());
                            } else {
                                Globals.g_installDebugFile.println("      Display: FALSE");
                            }
                            Globals.g_installDebugFile.println("      Default: " + Globals.g_installDefaults.getDefault(name, ""));
                        }
                    } else if (Globals.g_configDebugFile != null) {
                        String typeData;
                        String uniqueData;
                        if (display) {
                            if (this.m_dialogProperties[i].getGenPrompt() != null) {
                                Globals.g_configDebugFile.println("      Display: TRUE  -> " + this.m_dialogProperties[i].getGenPrompt());
                            } else {
                                Globals.g_configDebugFile.println("      Display: TRUE");
                            }
                        } else if (this.m_dialogProperties[i].getGenPrompt() != null) {
                            Globals.g_configDebugFile.println("      Display: FALSE -> " + this.m_dialogProperties[i].getGenPrompt());
                        } else {
                            Globals.g_configDebugFile.println("      Display: FALSE");
                        }
                        Globals.g_configDebugFile.println("      Default: " + Globals.g_configDefaults.getDefault(name, ""));
                        comboData = this.m_dialogProperties[i].getComboData();
                        if (comboData != null && ((String)comboData).length() > 0) {
                            if (PropertyRules.containsProperty((String)comboData)) {
                                comboData = PropertyRules.resolveProperties((String)comboData, this.m_dialogType);
                            }
                            Globals.g_configDebugFile.println("      Combo:   " + (String)comboData);
                        }
                        if ((uniqueData = this.m_dialogProperties[i].getUniqueData()) != null && uniqueData.length() > 0) {
                            if (PropertyRules.containsProperty(uniqueData)) {
                                uniqueData = PropertyRules.resolveProperties(uniqueData, this.m_dialogType);
                            }
                            Globals.g_configDebugFile.println("      Unique:  " + uniqueData);
                        }
                        if ((typeData = this.m_dialogProperties[i].getGenType()) != null && typeData.length() > 0) {
                            if (PropertyRules.containsProperty(typeData)) {
                                typeData = PropertyRules.resolveProperties(typeData, this.m_dialogType);
                            }
                            Globals.g_configDebugFile.println("      GenType: " + PropertyRules.resolveStringRule(typeData, this.m_dialogType) + " -> " + typeData);
                        }
                    }
                }
                if (display) {
                    if (Globals.g_debug) {
                        if (this.m_dialogType == 1) {
                            if (Globals.g_installDebugFile != null) {
                                Globals.g_installDebugFile.println("      Value:   " + this.getPropertyDefault(this.m_dialogProperties[i], true));
                            }
                        } else if (Globals.g_configDebugFile != null) {
                            Globals.g_configDebugFile.println("      Value:   " + this.getPropertyDefault(this.m_dialogProperties[i], true));
                        }
                    }
                    if ((infoText = this.m_dialogType == 1 ? DynamicDialogs.getInstallDialogProperty(name + ".info") : DynamicDialogs.getConfigDialogProperty(name + ".info")) != null && !infoText.equals(name + ".info")) {
                        info = new JTextArea(infoText);
                        info.setEditable(false);
                        info.setFocusable(false);
                        info.setLineWrap(true);
                        info.setWrapStyleWord(true);
                        info.setOpaque(false);
                        c.gridx = 0;
                        c.gridy = row;
                        c.gridwidth = 3;
                        c.gridheight = 1;
                        c.weightx = 1.0;
                        c.weighty = 0.0;
                        c.anchor = 17;
                        c.fill = 2;
                        c.insets = row == 0 ? new Insets(0, 0, 5, 0) : new Insets(10, 0, 5, 0);
                        if (this.m_panel != null) {
                            this.m_panel.add((Component)info, c);
                        }
                        ++row;
                    }
                    if ((genType = this.m_dialogProperties[i].getGenType()) != null) {
                        this.m_dialogProperties[i].setType(PropertyRules.resolveStringRule(genType, this.m_dialogType));
                    }
                    type = this.m_dialogProperties[i].getType(this.m_configUpgrade);
                    size = this.m_dialogProperties[i].getSize();
                    maxLength = this.m_dialogProperties[i].getMaxLength();
                    if (Globals.g_resumeChain && !this.isPasswordField(type)) {
                        type = 25;
                        this.m_dialogProperties[i].setType("static");
                    }
                    validType = true;
                    if (this.isTextField(type)) {
                        text = new KitTextField();
                        if (type == 25 || type == 7) {
                            text.setEditable(false);
                            text.setFocusable(false);
                        } else if (maxLength > 0) {
                            text.setDocument(new MaxLengthDocument(maxLength));
                        }
                        this.m_controls.add(text);
                        control = text;
                    } else if (this.isTextArea(type)) {
                        textArea = new JTextArea();
                        textArea.setEditable(false);
                        textArea.setFocusable(false);
                        textArea.setLineWrap(true);
                        textArea.setWrapStyleWord(true);
                        textArea.setOpaque(false);
                        this.m_controls.add(textArea);
                        control = textArea;
                    } else if (this.isPasswordField(type)) {
                        password = new JPasswordField();
                        if (maxLength > 0) {
                            password.setDocument(new MaxLengthDocument(maxLength));
                        }
                        this.m_controls.add(password);
                        control = password;
                    } else if (this.isBrowseField(type)) {
                        int mode = 1;
                        if (type == 14 || type == 15 || type == 39 || type == 16) {
                            mode = 0;
                        }
                        if (++pathCount > 5) {
                            pathCount = 1;
                        }
                        mtxt = this.bundle.getString("Common.Browse" + pathCount + ".txt");
                        path = new ControlBrowse("", mtxt, mode);
                        if (maxLength > 0) {
                            path.setDocument(new MaxLengthDocument(maxLength));
                        }
                        this.m_controls.add(path);
                        control = path;
                    } else if (this.isCheckBoxField(type)) {
                        checkBox = new JCheckBox();
                        this.m_controls.add(checkBox);
                        control = checkBox;
                    } else if (this.isComboField(type)) {
                        comboBox = new JComboBox<Object>();
                        comboData = this.getComboData(this.m_dialogProperties[i].getComboData(), type == 32);
                        for (int j = 0; j < ((Object)comboData).length; ++j) {
                            comboBox.addItem(comboData[j]);
                        }
                        this.m_controls.add(comboBox);
                        control = comboBox;
                    } else {
                        validType = false;
                    }
                    if (validType) {
                        this.m_promptedProperties.add(this.m_dialogProperties[i]);
                        mtxt = this.m_dialogType == 1 ? DynamicDialogs.getInstallDialogProperty(name + ".label") : DynamicDialogs.getConfigDialogProperty(name + ".label");
                        if (!this.isCheckBoxField(type)) {
                            labelTxt = Globals.g_debug ? Util.getLabelWithoutMnemonic(mtxt) + " (" + name + "):" : Util.getLabelWithoutMnemonic(mtxt) + ":";
                            label = new JLabel(labelTxt);
                            label.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
                            label.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
                            label.setLabelFor(control);
                            c.gridx = 0;
                            c.gridy = row;
                            c.gridwidth = 3;
                            c.gridheight = 1;
                            c.weightx = 1.0;
                            c.weighty = 0.0;
                            c.anchor = 17;
                            c.fill = 2;
                            c.insets = row == 0 ? new Insets(0, 0, 5, 0) : new Insets(10, 0, 5, 0);
                            if (this.m_panel != null) {
                                this.m_panel.add((Component)label, c);
                            }
                        } else {
                            if (Globals.g_debug) {
                                checkBox.setText(Util.getLabelWithoutMnemonic(mtxt) + " (" + name + ")");
                            } else {
                                checkBox.setText(Util.getLabelWithoutMnemonic(mtxt));
                            }
                            checkBox.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
                        }
                        c.gridx = 0;
                        c.gridy = ++row;
                        c.gridheight = 1;
                        c.weighty = 0.0;
                        c.anchor = 17;
                        c.fill = 2;
                        c.insets = this.isCheckBoxField(type) && row > 0 ? new Insets(10, 0, 0, 0) : new Insets(0, 0, 0, 0);
                        DialogData.Property cfr_ignored_0 = this.m_dialogProperties[i];
                        if (size == 1) {
                            c.gridwidth = 1;
                            c.weightx = 1.0;
                        } else {
                            DialogData.Property cfr_ignored_1 = this.m_dialogProperties[i];
                            if (size == 2) {
                                c.gridwidth = 2;
                                c.weightx = 1.0;
                            } else {
                                DialogData.Property cfr_ignored_2 = this.m_dialogProperties[i];
                                if (size == 3) {
                                    c.gridwidth = 3;
                                    c.weightx = 1.0;
                                }
                            }
                        }
                        if (this.m_panel != null) {
                            this.m_panel.add((Component)control, c);
                        }
                        DialogData.Property cfr_ignored_3 = this.m_dialogProperties[i];
                        if (size != 3) {
                            padding = new JLabel();
                            c.gridy = row;
                            c.gridheight = 1;
                            c.weighty = 0.0;
                            c.anchor = 17;
                            c.fill = 2;
                            c.insets = new Insets(0, 0, 0, 0);
                            DialogData.Property cfr_ignored_4 = this.m_dialogProperties[i];
                            if (size == 1) {
                                c.gridx = 1;
                                c.gridwidth = 2;
                                c.weightx = 1.0;
                            } else {
                                DialogData.Property cfr_ignored_5 = this.m_dialogProperties[i];
                                if (size == 2) {
                                    c.gridx = 2;
                                    c.gridwidth = 1;
                                    c.weightx = 1.0;
                                }
                            }
                            if (this.m_panel != null) {
                                this.m_panel.add((Component)padding, c);
                            }
                        }
                        ++row;
                        if (type == 8 || type == 34 || type == 13 || type == 12 || (type == 9 || type == 10) && Utils.getOS() != 1) {
                            password = new JPasswordField();
                            mtxt = this.m_dialogType == 1 ? DynamicDialogs.getInstallDialogProperty(name + ".confirm") : DynamicDialogs.getConfigDialogProperty(name + ".confirm");
                            labelTxt = Globals.g_debug ? Util.getLabelWithoutMnemonic(mtxt) + " (" + name + "):" : Util.getLabelWithoutMnemonic(mtxt) + ":";
                            label = new JLabel(labelTxt);
                            label.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
                            label.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
                            label.setLabelFor(password);
                            c.gridx = 0;
                            c.gridy = row;
                            c.gridwidth = 3;
                            c.gridheight = 1;
                            c.weightx = 1.0;
                            c.weighty = 0.0;
                            c.anchor = 17;
                            c.fill = 2;
                            c.insets = new Insets(10, 0, 5, 0);
                            if (this.m_panel != null) {
                                this.m_panel.add((Component)label, c);
                            }
                            c.gridx = 0;
                            c.gridy = ++row;
                            c.gridheight = 1;
                            c.weighty = 0.0;
                            c.anchor = 17;
                            c.fill = 2;
                            c.insets = new Insets(0, 0, 0, 0);
                            DialogData.Property cfr_ignored_6 = this.m_dialogProperties[i];
                            if (size == 1) {
                                c.gridwidth = 1;
                                c.weightx = 1.0;
                            } else {
                                DialogData.Property cfr_ignored_7 = this.m_dialogProperties[i];
                                if (size == 2) {
                                    c.gridwidth = 2;
                                    c.weightx = 1.0;
                                } else {
                                    DialogData.Property cfr_ignored_8 = this.m_dialogProperties[i];
                                    if (size == 3) {
                                        c.gridwidth = 3;
                                        c.weightx = 1.0;
                                    }
                                }
                            }
                            if (this.m_panel != null) {
                                this.m_panel.add((Component)password, c);
                            }
                            DialogData.Property cfr_ignored_9 = this.m_dialogProperties[i];
                            if (size != 3) {
                                padding = new JLabel();
                                c.gridy = row;
                                c.gridheight = 1;
                                c.weighty = 0.0;
                                c.anchor = 17;
                                c.fill = 2;
                                c.insets = new Insets(0, 0, 0, 0);
                                DialogData.Property cfr_ignored_10 = this.m_dialogProperties[i];
                                if (size == 1) {
                                    c.gridx = 1;
                                    c.gridwidth = 2;
                                    c.weightx = 1.0;
                                } else {
                                    DialogData.Property cfr_ignored_11 = this.m_dialogProperties[i];
                                    if (size == 2) {
                                        c.gridx = 2;
                                        c.gridwidth = 1;
                                        c.weightx = 1.0;
                                    }
                                }
                                if (this.m_panel != null) {
                                    this.m_panel.add((Component)padding, c);
                                }
                            }
                            ++row;
                            this.m_confirmPrompts.add(password);
                        } else {
                            this.m_confirmPrompts.add(null);
                        }
                    }
                } else {
                    if (Globals.g_resumeChain && !this.isPasswordField(this.m_dialogProperties[i].getType(this.m_configUpgrade))) {
                        this.m_dialogProperties[i].setType("static");
                    }
                    comboData = null;
                    if (this.isComboField(this.m_dialogProperties[i].getType(this.m_configUpgrade))) {
                        comboData = this.getComboData(this.m_dialogProperties[i].getComboData(), this.m_dialogProperties[i].getType(this.m_configUpgrade) == 32);
                    }
                    if (comboData != null && (comboData).length == 1) {
                        value = comboData[0].getValue();
                    } else {
                        value = this.getPropertyValue(this.m_dialogProperties[i], false);
                        if (this.m_dialogProperties[i].getType(this.m_configUpgrade) == 4 && value.length() == 0) {
                            value = "false";
                        }
                    }
                    maxLength = this.m_dialogProperties[i].getMaxLength();
                    if (maxLength > 0 && value.length() > maxLength) {
                        value = value.substring(0, maxLength);
                    }
                    if (this.m_dialogType == 1) {
                        Globals.g_installData.setProperty(name, value);
                    } else {
                        Globals.g_configData.setProperty(name, value);
                        if (this.m_configUpgrade) {
                            Globals.g_cmtDynamicProps.put(name, null);
                        }
                    }
                    if (Globals.g_debug) {
                        if (this.m_dialogType == 1) {
                            if (Globals.g_installDebugFile != null) {
                                Globals.g_installDebugFile.println("      Value:   " + value);
                            }
                        } else if (Globals.g_configDebugFile != null) {
                            Globals.g_configDebugFile.println("      Value:   " + value);
                        }
                    }
                    if (Globals.g_superMode) {
                        superMsg = superMsg + name + " = " + value + "\n";
                    }
                    this.m_nonPromptedProps.add(this.m_dialogProperties[i]);
                }
                if (Globals.g_mode == 2 || this.m_dialogType != 0 || !name.equalsIgnoreCase("oma.person.admin.login.passwd")) continue;
                getRepos = true;
                continue;
            }
            if (this.m_dialogType == 1) {
                if (Globals.g_installData.getProperty(name, null) == null) continue;
                Globals.g_installData.removeProperty(name);
                continue;
            }
            if (Globals.g_configData.getProperty(name, null) == null) continue;
            if (Globals.g_cmtPersistedProps != null && Globals.g_cmtPersistedProps.containsKey(name)) {
                Globals.g_configData.setProperty(name, (String)Globals.g_cmtPersistedProps.get(name));
                if (!Globals.g_debug || Globals.g_configDebugFile == null) continue;
                Globals.g_configDebugFile.println("      From MD: " + Globals.g_configData.getProperty(name, "(not defined)"));
                continue;
            }
            Globals.g_configData.removeProperty(name);
        }
        if (getRepos && (reposName = MetadataAccess.getRepositoryName(Globals.g_configData.getProperty("iomsrv.metadatasrv.host", ""), Globals.g_configData.getProperty("iomsrv.metadatasrv.port", ""), Globals.g_configData.getProperty("oma.person.admin.login.userid", ""), Globals.g_configData.getProperty("oma.person.admin.login.passwd", ""))) != null) {
            Logging.log.info("Setting oma.repository.foundation.name: " + reposName);
            Globals.g_configData.setProperty("oma.repository.foundation.name", reposName);
        }
        if (Globals.g_debug) {
            if (this.m_dialogType == 1) {
                if (Globals.g_installDebugFile != null) {
                    Globals.g_installDebugFile.flush();
                }
            } else if (Globals.g_configDebugFile != null) {
                Globals.g_configDebugFile.flush();
            }
        }
        if (this.m_promptedProperties.size() == 0) {
            if (Globals.g_debug && this.m_dialogType == 0) {
                Globals.g_configData.save();
            }
            if (Globals.g_superMode && this.m_nonPromptedProps.size() > 0 && !Globals.g_consoleMode) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), superMsg, this.m_panelID, 1);
            }
        }
    }

    private void refreshDefaults() {
        if (this.m_promptedProperties != null) {
            DialogData.Property property = null;
            String name = null;
            int type = 0;
            String value = null;
            KitTextField text = null;
            JTextArea textArea = null;
            JPasswordField password = null;
            JCheckBox checkBox = null;
            JComboBox comboBox = null;
            ControlBrowse path = null;
            for (int i = 0; i < this.m_promptedProperties.size(); ++i) {
                property = this.m_promptedProperties.get(i);
                name = property.getName();
                type = property.getType(this.m_configUpgrade);
                value = this.getPropertyValue(property, true);
                if (this.isTextField(type)) {
                    text = (KitTextField)this.m_controls.get(i);
                    text.setText(value);
                    continue;
                }
                if (this.isTextArea(type)) {
                    textArea = (JTextArea)this.m_controls.get(i);
                    textArea.setText(value);
                    continue;
                }
                if (this.isPasswordField(type)) {
                    String decodedPassword = null;
                    if (type == 13) {
                        decodedPassword = value;
                    } else {
                        try {
                            decodedPassword = SasPasswordString.decode(value);
                        }
                        catch (Exception e) {
                            decodedPassword = "";
                            Logging.log.warning("Unable to decode the password for: " + name);
                            Logging.logStackTrace(e);
                        }
                    }
                    password = (JPasswordField)this.m_controls.get(i);
                    if (password != null) {
                        password.setText(decodedPassword);
                    }
                    if ((password = (JPasswordField)this.m_confirmPrompts.get(i)) == null) continue;
                    password.setText(decodedPassword);
                    continue;
                }
                if (this.isBrowseField(type)) {
                    path = (ControlBrowse)this.m_controls.get(i);
                    path.setText(value);
                    continue;
                }
                if (this.isCheckBoxField(type)) {
                    checkBox = (JCheckBox)this.m_controls.get(i);
                    checkBox.setSelected(value.equalsIgnoreCase("true"));
                    continue;
                }
                if (!this.isComboField(type)) continue;
                comboBox = (JComboBox)this.m_controls.get(i);
                boolean found = false;
                for (int j = 0; j < comboBox.getItemCount() && !found; ++j) {
                    if (!((DynamicComboData)comboBox.getItemAt(j)).getValue().equalsIgnoreCase(value)) continue;
                    comboBox.setSelectedIndex(j);
                    found = true;
                }
            }
        }
    }

    private String getPropertyValue(DialogData.Property property, boolean prompted) {
        String value = null;
        String defaultVal = this.getPropertyDefault(property, prompted);
        if (prompted) {
            if (this.m_dialogType == 1) {
                value = Globals.g_installData.getProperty(property.getName(), defaultVal);
                if (Globals.g_mode == 2 && PropertyRules.containsProperty(value)) {
                    value = PropertyRules.resolveProperties(value, this.m_dialogType, true);
                }
            } else {
                value = Globals.g_configData.getProperty(property.getName(), defaultVal);
            }
        } else {
            value = defaultVal;
        }
        return value;
    }

    private String getPropertyDefault(DialogData.Property property, boolean prompted) {
        String defaultVal = null;
        if (this.m_configUpgrade) {
            if (Globals.g_instances != null && prompted) {
                boolean found = false;
                String[] owners = null;
                owners = property.getOwner().equalsIgnoreCase("globalroot") || property.getOwner().equalsIgnoreCase("levdirroot") ? new String[]{"cfgwizard"} : (property.getOwner().equalsIgnoreCase("webappsrv") ? new String[]{"jboss", "vfabrictcsvr", "tcsclusterc", "weblogic", "websphereba", "webspherend"} : new String[]{property.getOwner()});
                for (int i = 0; i < Globals.g_instances.length && !found; ++i) {
                    for (int j = 0; j < owners.length && !found; ++j) {
                        if (!owners[j].equalsIgnoreCase(Globals.g_instances[i].getInstanceData().getCode())) continue;
                        found = true;
                        Properties instanceProps = Globals.g_instances[i].getInstanceData().getProperties();
                        if (instanceProps == null) continue;
                        defaultVal = instanceProps.getProperty(property.getName(), null);
                    }
                }
            }
            if (defaultVal == null && PropertyRules.containsProperty(defaultVal = Globals.g_configDefaults.getDefault(property.getName(), ""))) {
                defaultVal = PropertyRules.resolveProperties(defaultVal, this.m_dialogType, true);
            }
        } else {
            defaultVal = this.m_dialogType == 1 ? Globals.g_installDefaults.getDefault(property.getName(), "") : Globals.g_configDefaults.getDefault(property.getName(), "");
            if (PropertyRules.containsProperty(defaultVal)) {
                defaultVal = PropertyRules.resolveProperties(defaultVal, this.m_dialogType, true);
            }
        }
        return defaultVal;
    }

    private boolean displayProperty(DialogData.Property property, boolean missingDefault) {
        boolean display = false;
        if (Globals.g_mode == 2 && Globals.g_cmtTask == 54) {
            String promptStr = property.getGenPrompt();
            if (promptStr == null) {
                promptStr = "";
            }
            if ((promptStr = promptStr.trim()).contains("global.certframe.tls.int.state")) {
                return PropertyRules.resolveBooleanRule(promptStr, false, this.m_dialogType);
            }
            return !promptStr.isEmpty() || property.getPrompt();
        }
        display = property.getGenPrompt() != null ? PropertyRules.resolveBooleanRule(property.getGenPrompt(), false, this.m_dialogType) : property.getPrompt();
        if (this.m_dialogType == 0) {
            if (display && Globals.g_configPromptLevel != 2) {
                if (property.getLevel() == 2) {
                    display = false;
                }
            }
            if (display && Globals.g_configPromptLevel == 0 && !missingDefault && !this.m_alwaysDisplayedProps.containsKey(property.getName())) {
                display = false;
            }
        }
        if (display) {
            if (property.getType(this.m_configUpgrade) == 23) {
                if (this.getComboData(property.getComboData(), false).length < 2) {
                    display = false;
                }
            } else if (property.getType(this.m_configUpgrade) == 32 && this.getComboData(property.getComboData(), true).length == 1) {
                display = false;
            }
        } else if (property.getType(this.m_configUpgrade) == 26) {
            String name = property.getName();
            if (this.m_forceDisplayProps.containsKey(name)) {
                display = true;
            } else {
                boolean valid;
                String value = this.getPropertyValue(property, true);
                String uniqueData = property.getUniqueData();
                if (PropertyRules.containsProperty(uniqueData)) {
                    uniqueData = PropertyRules.resolveProperties(uniqueData, this.m_dialogType);
                }
                if (!(valid = MetadataAccess.isUnique(Globals.g_configData.getProperty("iomsrv.metadatasrv.host", null), Globals.g_configData.getProperty("iomsrv.metadatasrv.port", null), Globals.g_configData.getProperty("oma.repository.foundation.name", null), Globals.g_configData.getProperty("oma.person.admin.login.userid", null), Globals.g_configData.getProperty("oma.person.admin.login.passwd", null), uniqueData, value))) {
                    display = true;
                    if (!this.m_forceDisplayProps.containsKey(name)) {
                        this.m_forceDisplayProps.put(name, null);
                    }
                }
            }
        }
        return display;
    }

    private boolean missingDefault() {
        boolean missingDefault = false;
        if (this.m_dialogType == 0 && Globals.g_configPromptLevel == 0) {
            String defaultValue = null;
            String propertyRule = null;
            for (int i = 0; i < this.m_dialogProperties.length && !missingDefault; ++i) {
                String conditionalPrompt;
                boolean willPrompt;
                propertyRule = this.m_dialogProperties[i].getRule();
                if (!PropertyRules.resolveBooleanRule(propertyRule, false, this.m_dialogType)) continue;
                defaultValue = Globals.g_configDefaults.getDefault(this.m_dialogProperties[i].getName(), "");
                if (PropertyRules.containsProperty(defaultValue)) {
                    defaultValue = PropertyRules.resolveProperties(defaultValue, this.m_dialogType);
                }
                boolean bl = willPrompt = (conditionalPrompt = this.m_dialogProperties[i].getGenPrompt()) != null ? PropertyRules.resolveBooleanRule(conditionalPrompt, false, this.m_dialogType) : this.m_dialogProperties[i].getPrompt();
                if (defaultValue.length() != 0 || !willPrompt || this.m_dialogProperties[i].getType(this.m_configUpgrade) == 1 || this.m_dialogProperties[i].getType(this.m_configUpgrade) == 25 || this.m_dialogProperties[i].getType(this.m_configUpgrade) == 7 || this.m_dialogProperties[i].getType(this.m_configUpgrade) == 26 || this.m_dialogProperties[i].getType(this.m_configUpgrade) == 19 || this.m_dialogProperties[i].getType(this.m_configUpgrade) == 16 || this.m_dialogProperties[i].getType(this.m_configUpgrade) == 4) continue;
                missingDefault = true;
            }
        }
        return missingDefault;
    }

    private String[] getRangeData(String value) {
        String[] rangeData = null;
        if (value.indexOf(",") > -1) {
            rangeData = value.split(",");
        } else {
            value = PropertyRules.resolveProperties(value, this.m_dialogType);
            rangeData = value.split(",");
        }
        for (int i = 0; i < rangeData.length; ++i) {
            String param = rangeData[i];
            if (PropertyRules.containsProperty(param = param.trim())) {
                param = PropertyRules.resolveProperties(param, this.m_dialogType);
            }
            rangeData[i] = param;
        }
        return rangeData;
    }

    private DynamicComboData[] getComboData(String value, boolean uniqueValues) {
        String comboValue = null;
        comboValue = PropertyRules.containsProperty(value) ? PropertyRules.resolveProperties(value, this.m_dialogType) : value;
        ArrayList<DynamicComboData> comboData = new ArrayList<DynamicComboData>();
        StringTokenizer tokens = new StringTokenizer(comboValue, "|");
        DynamicComboData comboItem = null;
        DynamicComboData tempItem = null;
        StringTokenizer comboParts = null;
        boolean found = false;
        int i = 0;
        while (tokens.hasMoreTokens()) {
            comboParts = new StringTokenizer(tokens.nextToken(), "=");
            comboItem = comboParts.countTokens() == 1 ? new DynamicComboData(comboParts.nextToken()) : (comboParts.countTokens() == 2 ? new DynamicComboData(comboParts.nextToken(), comboParts.nextToken()) : null);
            if (comboItem != null && !comboItem.isEmpty()) {
                found = false;
                for (int j = 0; j < comboData.size() && !found; ++j) {
                    tempItem = (DynamicComboData)comboData.get(j);
                    if (tempItem.getDisplayText().equals(comboItem.getDisplayText()) && tempItem.getValue().equals(comboItem.getValue())) {
                        found = true;
                        continue;
                    }
                    if (!uniqueValues || !tempItem.getValue().equalsIgnoreCase(comboItem.getValue())) continue;
                    found = true;
                }
                if (!found) {
                    comboData.add(comboItem);
                }
            }
            ++i;
        }
        return comboData.toArray(new DynamicComboData[0]);
    }

    private String getLabel(String name) {
        String mtxt = null;
        String label = null;
        mtxt = this.m_dialogType == 1 ? DynamicDialogs.getInstallDialogProperty(name + ".label") : DynamicDialogs.getConfigDialogProperty(name + ".label");
        label = Globals.g_debug ? Util.getLabelWithoutMnemonic(mtxt) + " (" + name + "):" : Util.getLabelWithoutMnemonic(mtxt) + ":";
        return label;
    }

    private String getConfirmLabel(String name) {
        String mtxt = null;
        String label = null;
        mtxt = this.m_dialogType == 1 ? DynamicDialogs.getInstallDialogProperty(name + ".confirm") : DynamicDialogs.getConfigDialogProperty(name + ".confirm");
        label = Globals.g_debug ? Util.getLabelWithoutMnemonic(mtxt) + " (" + name + "):" : Util.getLabelWithoutMnemonic(mtxt) + ":";
        return label;
    }

    private boolean isStaticField(int type) {
        boolean isStatic = false;
        if (type == 25 || type == 7) {
            isStatic = true;
        }
        return isStatic;
    }

    private boolean isTextArea(int type) {
        boolean isTextArea = false;
        if (type == 48) {
            isTextArea = true;
        }
        return isTextArea;
    }

    private boolean isTextField(int type) {
        boolean isText = false;
        if (type == 1 || type == 2 || type == 25 || type == 3 || type == 22 || type == 46 || type == 20 || type == 21 || type == 5 || type == 6 || type == 49 || type == 7 || type == 24 || type == 26 || type == 27 || type == 28 || type == 33 || type == 29 || type == 30 || type == 55 || type == 56 || type == 57 || type == 35 || type == 31 || type == 36 || type == 42 || type == 43 || type == 45 || type == 37 || type == 50 || type == 51 || type == 52) {
            isText = true;
        }
        return isText;
    }

    private boolean isPasswordField(int type) {
        boolean isPassword = false;
        if (type == 8 || type == 34 || type == 13 || type == 11 || type == 12 || type == 9 || type == 10) {
            isPassword = true;
        }
        return isPassword;
    }

    private boolean isHostnameField(int type) {
        boolean isHostname = false;
        if (type == 42 || type == 43) {
            isHostname = true;
        }
        return isHostname;
    }

    private boolean isBrowseField(int type) {
        boolean isBrowse = false;
        if (type == 17 || type == 14 || type == 18 || type == 38 || type == 15 || type == 39 || type == 40 || type == 19 || type == 44 || type == 16) {
            isBrowse = true;
        }
        return isBrowse;
    }

    private boolean isCheckBoxField(int type) {
        boolean isCheckBox = false;
        if (type == 4) {
            isCheckBox = true;
        }
        return isCheckBox;
    }

    private boolean isMultiCheckBoxFields(int type) {
        boolean isCheckBoxes = false;
        if (type == 47) {
            isCheckBoxes = true;
        }
        return isCheckBoxes;
    }

    private boolean isComboField(int type) {
        boolean isCombo = false;
        if (type == 23 || type == 32) {
            isCombo = true;
        }
        return isCombo;
    }

    @Override
    public String getHelpTopic() {
        String helpTopic = null;
        File helpFile = new File(Globals.g_tempLocation, "PanelDynamic.html");
        try {
            PrintStream out = new PrintStream((OutputStream)new FileOutputStream(helpFile), false, "UTF-8");
            out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">");
            out.println("<HTML>");
            out.println("<head>");
            out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            out.println("</head>");
            out.println("<BODY>");
            out.println("<H1>" + this.getHelpHeader() + "</H1>");
            String header = null;
            header = this.m_dialogType == 1 ? DynamicDialogs.getInstallDialogProperty(this.m_panelID + ".help") : DynamicDialogs.getConfigDialogProperty(this.m_panelID + ".help");
            if (header != null && header.length() > 0) {
                out.println("<p>" + header + "</p>");
            }
            DialogData.Property property = null;
            String name = null;
            String helpText = null;
            for (int i = 0; i < this.m_promptedProperties.size(); ++i) {
                property = this.m_promptedProperties.get(i);
                name = property.getName();
                helpText = this.m_dialogType == 1 ? DynamicDialogs.getInstallDialogProperty(name + ".help") : DynamicDialogs.getConfigDialogProperty(name + ".help");
                out.println("<p>" + helpText + "</p>");
            }
            out.println("</BODY>");
            out.println("</HTML>");
            out.close();
            helpTopic = helpFile.toString();
        }
        catch (Exception e) {
            Logging.log.info("Error creating dynamic help file: " + helpFile.toString());
            Logging.logStackTrace(e);
        }
        return helpTopic;
    }

    class DynamicComboData {
        private String m_displayText = null;
        private String m_value = null;

        public DynamicComboData(String displayText) {
            this.m_displayText = PropertyRules.containsProperty(displayText) ? PropertyRules.resolveProperties(displayText, PanelDynamic.this.m_dialogType) : displayText;
            this.m_value = this.m_displayText;
        }

        public DynamicComboData(String displayText, String value) {
            this.m_displayText = PropertyRules.containsProperty(displayText) ? PropertyRules.resolveProperties(displayText, PanelDynamic.this.m_dialogType) : displayText;
            if (Globals.g_debug) {
                this.m_displayText = this.m_displayText + " = " + value;
            }
            this.m_value = value;
        }

        public boolean isEmpty() {
            boolean empty = true;
            if (this.m_displayText != null && this.m_displayText.length() > 0) {
                empty = false;
            }
            return empty;
        }

        public String getDisplayText() {
            return this.m_displayText;
        }

        public String getValue() {
            return this.m_value;
        }

        public String toString() {
            return this.m_displayText;
        }
    }

    class MaxLengthDocument
    extends PlainDocument {
        private int m_maxLength = 0;

        public MaxLengthDocument(int maxLength) {
            this.m_maxLength = maxLength;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (super.getLength() + str.length() <= this.m_maxLength) {
                super.insertString(offs, str, a);
            } else {
                super.insertString(offs, str.substring(0, this.m_maxLength - super.getLength()), a);
            }
        }
    }
}

