/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.KitBrowseButton;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Recipes;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardCallbackIface;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PanelDepotSubsetSelectRecipe
implements WizardPanelIface,
WizardCallbackIface,
ActionListener {
    private final String RESPONSE_CUSTOMIZED = "customized";
    private final String RESPONSE_STANDARD = "standard";
    private SSNResource bundle = new SSNResource(PanelDepotSubsetSelectRecipe.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JRadioButton m_standardOption = null;
    private JRadioButton m_customOption = null;
    private KitTextField m_recipeDir = null;
    private KitBrowseButton m_browseButton = null;
    private JTextArea m_comboDesc = null;
    private JComboBox m_combo = null;
    private JEditorPane m_recipeInfo = null;
    private JTextArea m_recipeDesc = null;
    private JScrollPane m_scrollPane = null;
    private JSeparator m_separator = null;
    private JLabel m_warning = null;
    private boolean m_panelLoaded = false;
    private String m_lastOrder = "";
    private boolean m_comboIsEmpty = true;
    private Recipes m_standardRecipes = null;
    private Recipes m_customRecipes = null;

    public PanelDepotSubsetSelectRecipe() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelDepotSubsetSelectRecipe.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        if (Globals.g_showCustomizedRecipeOption) {
            return this.bundle.getString("PanelDepotSubsetSelectRecipe.HeaderDesc.Customized.txt");
        }
        return this.bundle.getString("PanelDepotSubsetSelectRecipe.HeaderDesc.NonCustomized.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = false;
        if (this.m_standardOption.isSelected() && this.m_standardRecipes != null && this.m_standardRecipes.status()) {
            Globals.g_subsetRecipes = this.m_standardRecipes;
            valid = true;
        } else if (this.m_customOption.isSelected() && this.m_customRecipes != null && this.m_customRecipes.status()) {
            Globals.g_subsetRecipes = this.m_customRecipes;
            valid = true;
        }
        if (!valid) {
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelDepotSubsetSelectRecipe.RecipeRequired.txt"), this.bundle.getString("Common.Warning.txt"), 2);
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return Globals.g_deploymentData.getOrder(Globals.g_order).getDepotVersionAsInt() >= 2;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = "selectbyplatprodlang";
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_lastOrder.equalsIgnoreCase(Globals.g_order)) {
            this.m_standardRecipes = new Recipes();
            this.m_standardRecipes.initDefaultRecipes();
            this.updateRecipeLocation();
            if (this.m_recipeDir.getText().length() == 0) {
                this.m_recipeDir.setText(Globals.g_wizardData.getPreference("LastProjDir", ""));
            }
            if (!this.m_panelLoaded) {
                this.m_panelLoaded = true;
            }
            this.loadComboBox();
            this.setRadioState();
            this.updateTextArea();
            if (Globals.g_showCustomizedRecipeOption) {
                this.m_standardOption.setEnabled(true);
                this.m_standardOption.setVisible(true);
                this.m_separator.setEnabled(true);
                this.m_separator.setVisible(true);
                this.m_customOption.setEnabled(true);
                this.m_customOption.setVisible(true);
                this.m_browseButton.setEnabled(true);
                this.m_browseButton.setVisible(true);
                this.m_recipeDir.setEnabled(true);
                this.m_recipeDir.setVisible(true);
            } else {
                this.m_standardOption.setEnabled(false);
                this.m_standardOption.setVisible(false);
                this.m_separator.setEnabled(false);
                this.m_separator.setVisible(false);
                this.m_customOption.setEnabled(false);
                this.m_customOption.setVisible(false);
                this.m_browseButton.setEnabled(false);
                this.m_browseButton.setVisible(false);
                this.m_recipeDir.setEnabled(false);
                this.m_recipeDir.setVisible(false);
            }
            this.m_panel.validate();
            this.m_lastOrder = Globals.g_order;
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        JRadioButton focus = null;
        focus = this.m_customOption.isSelected() ? this.m_customOption : this.m_standardOption;
        return focus;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            this.loadComboBox();
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        if (Globals.g_quietMode && Globals.g_recordMode) {
            return null;
        }
        String[] data = new String[]{"#PLAN_TYPE=customized/standard", " PLAN_TYPE=customized", "#CUSTOMIZED_PLAN_PATH=<full path - only if PLAN_TYPE=customized>", " CUSTOMIZED_PLAN_PATH=", "#STANDARD_PLAN_NAME=<standard plan name - only if PLAN_TYPE=standard>", " STANDARD_PLAN_NAME="};
        if (this.m_panelLoaded) {
            if (this.m_standardOption.isSelected()) {
                data[1] = " PLAN_TYPE=standard";
                data[5] = " STANDARD_PLAN_NAME=" + (String)this.m_combo.getSelectedItem();
            } else {
                data[3] = " CUSTOMIZED_PLAN_PATH=" + this.m_recipeDir.getText();
            }
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
        Globals.g_subsetRecipes = null;
        Globals.g_subsetWithRecipe = false;
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_standardOption, this.m_customOption};
        options[0].setEnabled(this.m_standardRecipes.status());
        int returnCode = Globals.g_showCustomizedRecipeOption ? ConsoleMode.promptRadioButtons(options, null) : 0;
        if (returnCode > -1) {
            this.loadComboBox();
            this.setRadioState();
            this.updateTextArea();
            if (this.m_standardOption.isSelected()) {
                this.loadComboBox();
                if (this.m_comboIsEmpty) {
                    ConsoleMode.printInfoText(this.m_warning.getText());
                    returnCode = -1;
                }
            } else if (this.m_customOption.isSelected()) {
                ConsoleMode.printInfoText(Util.getLabelWithoutMnemonic(this.bundle.getString("PanelDepotSubsetSelectRecipe.CustomOption.txt")));
                returnCode = ConsoleMode.promptText(this.m_customOption.getText(), this.m_recipeDir);
                this.updateRecipeLocation();
                if (this.m_customRecipes == null) {
                    ConsoleMode.printInfoText(this.bundle.getString("PanelDepotSubsetSelectRecipe.Custom.InValidRecipe.EmptyComboBox.txt"));
                    return -1;
                }
                if (!this.m_customRecipes.status()) {
                    ConsoleMode.printInfoText(this.bundle.getString("PanelDepotSubsetSelectRecipe.Custom.ValidRecipe.EmptyComboBox.txt"));
                    return -1;
                }
            }
            returnCode = ConsoleMode.promptComboBox(this.m_combo);
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String responseType = Wizard.getResponse("PLAN_TYPE", null);
        if (responseType != null) {
            if (responseType.equalsIgnoreCase("customized")) {
                valid = true;
                this.m_customOption.setSelected(true);
            } else if (responseType.equalsIgnoreCase("standard")) {
                valid = true;
                this.m_standardOption.setSelected(true);
            } else if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "PLAN_TYPE", responseType, null);
            }
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), "PLAN_TYPE");
        }
        String responsePath = Wizard.getResponse("CUSTOMIZED_PLAN_PATH", null);
        if (responsePath != null) {
            this.m_recipeDir.setText(responsePath);
        } else if (Globals.g_quietMode && this.m_customOption.isSelected()) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "CUSTOMIZED_PLAN_PATH");
        }
        return valid;
    }

    private void initialize() {
        this.m_recipeInfo = new JEditorPane();
        this.m_scrollPane = new JScrollPane(this.m_recipeInfo);
        this.m_combo = new JComboBox();
        this.m_recipeDir = new KitTextField();
        this.m_recipeDir.getDocument().addDocumentListener(new TextChangeListener());
        this.m_comboDesc = Globals.g_showCustomizedRecipeOption ? new JTextArea(this.bundle.getString("PanelDepotSubsetSelectRecipe.RecipeOption.Customized.txt")) : new JTextArea(this.bundle.getString("PanelDepotSubsetSelectRecipe.RecipeOption.NonCustomized.txt"));
        this.m_comboDesc.setEditable(false);
        this.m_comboDesc.setFocusable(false);
        this.m_comboDesc.setLineWrap(false);
        this.m_comboDesc.setOpaque(false);
        this.m_recipeDesc = new JTextArea(this.bundle.getString("PanelDepotSubsetSelectRecipe.RecipeDesc.txt"));
        this.m_recipeDesc.setEditable(false);
        this.m_recipeDesc.setFocusable(false);
        this.m_recipeDesc.setLineWrap(false);
        this.m_recipeDesc.setOpaque(false);
        String mtxt = this.bundle.getString("Common.Browse2.txt");
        this.m_browseButton = new KitBrowseButton(Util.getLabelWithoutMnemonic(mtxt), "", 0, this.m_recipeDir);
        this.m_browseButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_browseButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_browseButton.setCallbackPanel(this);
        this.m_recipeInfo.setOpaque(false);
        this.m_recipeInfo.setEditable(false);
        this.m_recipeInfo.setContentType("text/html");
        this.m_warning = new JLabel();
        this.m_warning.setIcon(this.bundle.getImageIcon("Common.warning_small.image"));
        this.m_warning.setFocusable(false);
        this.m_warning.setOpaque(false);
        this.m_separator = new JSeparator(0);
        mtxt = this.bundle.getString("PanelDepotSubsetSelectRecipe.StandardOption.txt");
        this.m_standardOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_standardOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_standardOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_standardOption.getFont();
        this.m_standardOption.setFont(optionFont.deriveFont(1));
        this.m_standardOption.setSelected(true);
        this.m_warning.setFont(optionFont.deriveFont(1));
        mtxt = this.bundle.getString("PanelDepotSubsetSelectRecipe.CustomOption.txt");
        this.m_customOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_customOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_customOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_customOption.getFont();
        this.m_customOption.setFont(optionFont.deriveFont(1));
        this.m_customOption.setSelected(!this.m_standardOption.isSelected());
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_standardOption);
        group.add(this.m_customOption);
        this.m_standardOption.addActionListener(this);
        this.m_combo.addActionListener(this);
        this.m_customOption.addActionListener(this);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_standardOption, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_customOption, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 20, 5, 0);
        this.m_panel.add((Component)this.m_recipeDir, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        c.fill = 0;
        c.insets = new Insets(0, 5, 5, 0);
        this.m_panel.add((Component)this.m_browseButton, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 5, 0, 5);
        this.m_panel.add((Component)this.m_separator, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = Globals.g_showCustomizedRecipeOption ? new Insets(10, 0, 5, 0) : new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_comboDesc, c);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_combo, c);
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_recipeDesc, c);
        c.gridx = 0;
        c.gridy = 8;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_scrollPane, c);
        c.gridx = 0;
        c.gridy = 9;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_warning, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_combo) {
            this.updateTextArea();
        } else if (obj == this.m_standardOption || obj == this.m_customOption) {
            this.loadComboBox();
            this.setRadioState();
            this.updateTextArea();
        }
    }

    private void loadComboBox() {
        int selectedIndex = 0;
        this.m_combo.removeAllItems();
        Recipes recipes = null;
        recipes = this.m_standardOption.isSelected() ? this.m_standardRecipes : this.m_customRecipes;
        if (recipes != null && recipes.status()) {
            String[] titles = recipes.recipeIDs().toArray(new String[0]);
            for (int i = 0; i < titles.length; ++i) {
                this.m_combo.addItem(titles[i]);
            }
        }
        if (this.m_combo.getItemCount() > 0) {
            this.m_combo.setSelectedIndex(selectedIndex);
            this.m_warning.setVisible(false);
            this.m_comboIsEmpty = false;
        } else {
            this.m_comboIsEmpty = true;
            if (this.m_standardOption.isSelected()) {
                this.m_warning.setText(this.bundle.getString("PanelDepotSubsetSelectRecipe.Standard.EmptyComboBox.txt"));
                this.m_warning.setVisible(true);
            } else if (recipes != null) {
                this.m_warning.setText(this.bundle.getString("PanelDepotSubsetSelectRecipe.Custom.ValidRecipe.EmptyComboBox.txt"));
                this.m_warning.setVisible(true);
            } else {
                this.m_warning.setText(this.bundle.getString("PanelDepotSubsetSelectRecipe.Custom.InValidRecipe.EmptyComboBox.txt"));
                this.m_warning.setVisible(true);
            }
        }
    }

    private void setRadioState() {
        if (this.m_standardOption.isSelected()) {
            if (this.m_standardRecipes != null && this.m_standardRecipes.status()) {
                if (this.m_comboIsEmpty) {
                    this.m_combo.setEnabled(false);
                    this.m_recipeInfo.setEnabled(false);
                } else {
                    this.m_combo.setEnabled(true);
                    this.m_recipeInfo.setEnabled(true);
                }
                this.m_browseButton.setEnabled(false);
                this.m_recipeDir.setEnabled(false);
            } else {
                this.m_combo.setEnabled(false);
                this.m_recipeInfo.setEnabled(false);
                this.m_browseButton.setEnabled(false);
                this.m_recipeDir.setEnabled(false);
            }
        } else if (this.m_customRecipes != null && this.m_customRecipes.status()) {
            if (this.m_comboIsEmpty) {
                this.m_combo.setEnabled(false);
                this.m_recipeInfo.setEnabled(false);
            } else {
                this.m_combo.setEnabled(true);
                this.m_recipeInfo.setEnabled(true);
            }
            this.m_browseButton.setEnabled(true);
            this.m_recipeDir.setEnabled(true);
        } else {
            this.m_combo.setEnabled(false);
            this.m_recipeInfo.setEnabled(false);
            this.m_browseButton.setEnabled(true);
            this.m_recipeDir.setEnabled(true);
        }
    }

    private void updateRecipeLocation() {
        String recipeFileName = this.m_recipeDir.getText();
        File recipeFile = new File(recipeFileName);
        if (recipeFile != null && recipeFile.isFile()) {
            this.m_customRecipes = new Recipes();
            this.m_customRecipes.initCustomRecipes(recipeFileName);
        } else {
            this.m_customRecipes = null;
            this.m_comboIsEmpty = true;
        }
        this.loadComboBox();
        this.setRadioState();
        this.updateTextArea();
    }

    @Override
    public void updateTextArea() {
        String recipeId = null;
        String recipeDesc = null;
        if (this.m_standardOption.isSelected()) {
            if (this.m_standardRecipes != null && this.m_combo.getSelectedItem() != null && !this.m_comboIsEmpty) {
                recipeId = (String)this.m_combo.getSelectedItem();
                if (recipeId != null && !recipeId.isEmpty()) {
                    recipeDesc = this.m_standardRecipes.recipeDescription(recipeId);
                }
                this.m_standardRecipes.setSelectedRecipeId(recipeId);
            }
        } else if (this.m_customOption.isSelected() && this.m_customRecipes != null && this.m_customRecipes.status() && this.m_recipeDir.getText() != null && (recipeId = (String)this.m_combo.getSelectedItem()) != null && !recipeId.isEmpty() && this.m_customRecipes != null) {
            recipeDesc = this.m_customRecipes.recipeDescription(recipeId);
            this.m_customRecipes.setSelectedRecipeId(recipeId);
        }
        this.m_recipeInfo.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.m_recipeInfo.setText(recipeDesc);
        this.m_recipeInfo.setCaretPosition(0);
        this.m_recipeInfo.revalidate();
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    class TextChangeListener
    implements DocumentListener {
        TextChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PanelDepotSubsetSelectRecipe.this.updateRecipeLocation();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PanelDepotSubsetSelectRecipe.this.updateRecipeLocation();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PanelDepotSubsetSelectRecipe.this.updateRecipeLocation();
        }
    }
}

