/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.PanelDepotSubsetBase;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import java.awt.Component;

public class PanelDepotSubsetProducts
extends PanelDepotSubsetBase
implements WizardPanelIface {
    @Override
    public void backEvent(String backPanelID) {
        this.saveSelections();
        Globals.g_subsetData.clearProductSelections();
    }

    @Override
    public boolean displayPanel() {
        if (Globals.g_subsetData != null) {
            this.listData = Globals.g_subsetData.loadProducts();
            if (this.listData.size() > 0) {
                if (Globals.g_subsetWithRecipe) {
                    Globals.g_subsetRecipes.loadRecipeData(this.listData);
                }
                if (Globals.g_subsetData.isSubsetByProducts()) {
                    return true;
                }
                if (!Globals.g_subsetWithRecipe) {
                    this.loadProdInfo();
                    this.selectAll();
                }
            }
        }
        return false;
    }

    @Override
    public String getHeader() {
        String headerProperty = Globals.g_subsetClients ? this.bundle.getString("PanelDepotSubsetProducts.Header.SubsetClient.txt") : (Globals.g_subsetNonConfig ? this.bundle.getString("PanelDepotSubsetProducts.Header.SubsetNonConfigurable.txt") : (Globals.g_subsetWithRecipe || Globals.g_subsetAll ? this.bundle.getString("PanelDepotSubsetProducts.Header.SubsetProducts.txt") : this.bundle.getString("PanelDepotSubsetProducts.Header.SubsetSASFoundation.txt")));
        return headerProperty;
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelDepotSubsetProducts.HeaderDesc.txt");
    }

    @Override
    public String getNextPanelID() {
        return "selectsubsetLanguages";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        this.restoreSelections();
        this.loadProdInfo();
        if (Globals.g_subsetResetSelectionsProducts) {
            this.selectAll();
            Globals.g_subsetResetSelectionsProducts = false;
        }
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        this.saveSelections();
        if (!this.anythingSelected()) {
            String requiredStepMsgStr = "PanelDepotSubsetProducts.RequiredStepMsg.txt";
            if (Globals.g_quietMode) {
                if (Globals.g_subsetAll || Globals.g_subsetClients) {
                    Logging.log.severe("To subset this order, you must choose at least one of the products.");
                } else {
                    Logging.log.severe("To subset this order, you must choose at least one of the SAS Foundation products.");
                }
            } else {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString(requiredStepMsgStr), this.bundle.getString("Common.Warning.txt"), 2);
            }
            valid = false;
        } else {
            Globals.g_subsetData.addProductDependencies();
            if (Globals.g_subsetAll) {
                Globals.g_subsetData.addUniqueUnselectableSkus();
            }
        }
        return valid;
    }
}

