/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SubsetData;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class PanelDepotSubsetChoices
implements WizardPanelIface,
ActionListener {
    private SSNResource bundle = new SSNResource(PanelDepotSubsetChoices.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JRadioButton m_userSubsetOption = null;
    private JTextArea m_userSubsetOptionInfo = null;
    private JTextArea m_userSubsetTypeInfo = null;
    private JComboBox m_userSubsetType = null;
    private JRadioButton m_recipeSubsetOption = null;
    private JTextArea m_recipeSubsetInfo = null;
    private boolean m_panelLoaded = false;

    public PanelDepotSubsetChoices() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelDepotSubsetChoices.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelDepotSubsetChoices.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        if (valid) {
            Globals.g_subsetData.setSubsetActive(true);
            if (this.m_recipeSubsetOption.isSelected()) {
                Globals.g_subsetWithRecipe = true;
                Logging.log.info("Subsetting by Recipe selected.");
            } else {
                Globals.g_subsetWithRecipe = false;
                Globals.g_subsetClients = false;
                Globals.g_subsetAll = false;
                Globals.g_subsetNonConfig = false;
                if (this.m_userSubsetType.getSelectedIndex() == 1) {
                    Globals.g_subsetClients = true;
                    Logging.log.info("Subset by Clients selected.");
                } else if (this.m_userSubsetType.getSelectedIndex() == 2) {
                    Globals.g_subsetNonConfig = true;
                    Logging.log.info("Subset by NonConfig selected.");
                } else if (this.m_userSubsetType.getSelectedIndex() == 3) {
                    Globals.g_subsetAll = true;
                    Logging.log.info("Subset All selected.");
                }
            }
            Globals.g_subsetData.setOrigOrder(Globals.g_order);
            Globals.g_subsetData.setOrigDepot(Globals.g_deploymentData.getMediaRoot());
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return Globals.g_deploymentData.getOrder(Globals.g_order).getDepotVersionAsInt() >= 2;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = this.m_recipeSubsetOption.isSelected() ? "selectsubsetrecipe" : "selectbyplatprodlang";
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            if (!this.loadResponseData()) {
                this.m_userSubsetOption.setEnabled(true);
                this.m_userSubsetOption.setSelected(true);
                this.m_recipeSubsetOption.setEnabled(true);
                this.m_recipeSubsetOption.setSelected(false);
            }
            Globals.g_subsetData = new SubsetData();
            this.m_panelLoaded = true;
        }
        this.setRadioState();
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        JRadioButton focus = null;
        focus = this.m_userSubsetOption.isSelected() ? this.m_userSubsetOption : (this.m_recipeSubsetOption.isSelected() ? this.m_recipeSubsetOption : this.m_userSubsetOption);
        return focus;
    }

    @Override
    public boolean silentEvent() {
        return true;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
        Globals.g_subsetData.resetData();
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_userSubsetOption, this.m_recipeSubsetOption};
        JTextArea[] infos = new JTextArea[]{this.m_userSubsetOptionInfo, this.m_recipeSubsetInfo};
        int returnCode = ConsoleMode.promptRadioButtons(options, infos);
        if (returnCode > -1 && this.m_userSubsetOption.isSelected()) {
            ConsoleMode.printInfoText(this.m_userSubsetTypeInfo.getText());
            returnCode = ConsoleMode.promptComboBox(this.m_userSubsetType);
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        return valid;
    }

    private void initialize() {
        String NF = null;
        NF = Globals.g_subsetAll || Globals.g_subsetClients ? "NF" : "";
        String mtxt = this.bundle.getString("PanelDepotSubsetChoices.UserSubsetOptionLabel.txt");
        this.m_userSubsetOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_userSubsetOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_userSubsetOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_userSubsetOption.getFont();
        this.m_userSubsetOption.setFont(optionFont.deriveFont(1));
        this.m_userSubsetOptionInfo = new JTextArea(this.bundle.getString("PanelDepotSubsetChoices.UserSubsetOptionInfo.txt"));
        this.m_userSubsetOptionInfo.setEditable(false);
        this.m_userSubsetOptionInfo.setFocusable(false);
        this.m_userSubsetOptionInfo.setLineWrap(true);
        this.m_userSubsetOptionInfo.setWrapStyleWord(true);
        this.m_userSubsetOptionInfo.setOpaque(false);
        this.m_userSubsetTypeInfo = new JTextArea(this.bundle.getString("PanelDepotSubsetChoices.UserSubsetTypeInfo.txt"));
        this.m_userSubsetTypeInfo.setEditable(false);
        this.m_userSubsetTypeInfo.setFocusable(false);
        this.m_userSubsetTypeInfo.setLineWrap(true);
        this.m_userSubsetTypeInfo.setWrapStyleWord(true);
        this.m_userSubsetTypeInfo.setOpaque(false);
        this.m_userSubsetType = new JComboBox<String>(this.getSubsetTypes());
        this.m_userSubsetType.setFocusable(true);
        if (Globals.g_subsetClients) {
            this.m_userSubsetType.setSelectedIndex(1);
        } else if (Globals.g_subsetNonConfig) {
            this.m_userSubsetType.setSelectedIndex(2);
        } else if (Globals.g_subsetAll) {
            this.m_userSubsetType.setSelectedIndex(3);
        } else {
            this.m_userSubsetType.setSelectedIndex(0);
        }
        mtxt = this.bundle.getString("PanelDepotSubsetChoices.RecipeSubsetOptionLabel.txt");
        this.m_recipeSubsetOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_recipeSubsetOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_recipeSubsetOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_recipeSubsetOption.getFont();
        this.m_recipeSubsetOption.setFont(optionFont.deriveFont(1));
        this.m_recipeSubsetInfo = new JTextArea(this.bundle.getString("PanelDepotSubsetChoices.RecipeSubsetOptionInfo.txt"));
        this.m_recipeSubsetInfo.setEditable(false);
        this.m_recipeSubsetInfo.setFocusable(false);
        this.m_recipeSubsetInfo.setLineWrap(true);
        this.m_recipeSubsetInfo.setWrapStyleWord(true);
        this.m_recipeSubsetInfo.setOpaque(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_userSubsetOption);
        group.add(this.m_recipeSubsetOption);
        this.m_userSubsetOption.addActionListener(this);
        this.m_recipeSubsetOption.addActionListener(this);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 3, 0);
        this.m_panel.add((Component)this.m_userSubsetOption, c);
        c.gridy = 1;
        c.insets = new Insets(2, 20, 2, 0);
        this.m_panel.add((Component)this.m_userSubsetOptionInfo, c);
        c.gridy = 2;
        c.insets = new Insets(10, 20, 2, 0);
        this.m_panel.add((Component)this.m_userSubsetTypeInfo, c);
        c.gridy = 3;
        c.insets = new Insets(2, 20, 2, 0);
        this.m_panel.add((Component)this.m_userSubsetType, c);
        c.gridy = 4;
        c.insets = new Insets(5, 0, 3, 0);
        this.m_panel.add((Component)this.m_recipeSubsetOption, c);
        c.gridy = 5;
        c.insets = new Insets(2, 20, 3, 0);
        this.m_panel.add((Component)this.m_recipeSubsetInfo, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_userSubsetOption || obj == this.m_recipeSubsetOption) {
            this.setRadioState();
        }
    }

    private void setRadioState() {
        this.m_userSubsetType.setEnabled(this.m_userSubsetOption.isSelected());
    }

    private Vector<String> getSubsetTypes() {
        Vector<String> types = new Vector<String>();
        types.add(this.bundle.getString("PanelDepotSubsetChoices.Foundation.txt"));
        types.add(this.bundle.getString("PanelDepotSubsetChoices.Clients.txt"));
        types.add(this.bundle.getString("PanelDepotSubsetChoices.NonConfig.txt"));
        if (Globals.g_subsetAll) {
            types.add(this.bundle.getString("PanelDepotSubsetChoices.All.txt"));
        }
        return types;
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

