/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.OrderData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;

public class PanelDepotSubsetByPlatProdLang
implements WizardPanelIface,
ActionListener {
    private SSNResource bundle = new SSNResource(PanelDepotSubsetByPlatProdLang.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JRadioButton m_fullRecipeOption = null;
    private JTextArea m_fullRecipeInfo = null;
    private JRadioButton m_subsetRecipeOption = null;
    private JEditorPane m_subsetOrderInfo = null;
    private JTextArea m_subsetOrderInfoTxtForConsole = null;
    private JCheckBox m_platformsCheckBox = null;
    private JCheckBox m_productsCheckBox = null;
    private JCheckBox m_languagesCheckBox = null;
    private JTextArea m_userSubsetTypeInfo = null;
    private JComboBox m_userSubsetType = null;
    private boolean m_panelLoaded = false;
    private int m_previousSelectedIndex = 0;
    private boolean m_previousPlatformsSetting = false;
    private boolean m_previousProductsSetting = false;
    private boolean m_previousLanguagesSetting = false;

    public PanelDepotSubsetByPlatProdLang() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelDepotSubsetByPlatProdLang.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelDepotSubsetByPlatProdLang.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        if (this.m_subsetRecipeOption.isSelected() && !this.m_platformsCheckBox.isSelected() && !this.m_productsCheckBox.isSelected() && !this.m_languagesCheckBox.isSelected()) {
            if (Globals.g_quietMode) {
                Logging.log.severe("Response data required for one of the following 3 fields:\n   Panel: " + this.getHeader() + "\n   Field: Platform, Products, and language");
            } else {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelDepotSubsetByPlatProdLang.RequiredStepMsg.txt"), this.bundle.getString("Common.Warning.txt"), 2);
                this.m_platformsCheckBox.requestFocus();
            }
            valid = false;
        }
        Globals.g_subsetClients = false;
        Globals.g_subsetAll = false;
        Globals.g_subsetNonConfig = false;
        if (this.m_productsCheckBox.isSelected()) {
            Globals.g_subsetAllForPlatAndLang = false;
            if (this.m_userSubsetType.getSelectedIndex() == 1) {
                Globals.g_subsetClients = true;
                Logging.log.info("Subset by Clients selected.");
            } else if (this.m_userSubsetType.getSelectedIndex() == 2) {
                Globals.g_subsetNonConfig = true;
                Logging.log.info("Subset by NonConfig selected.");
            } else if (this.m_userSubsetType.getSelectedIndex() == 3) {
                Globals.g_subsetAll = true;
                Logging.log.info("Subset All selected.");
            }
        } else {
            Globals.g_subsetAllForPlatAndLang = true;
        }
        if (valid) {
            Globals.g_subsetData.setSubsetActive(true);
            Globals.g_subsetData.loadOrderData();
            if (this.m_subsetRecipeOption.isSelected() || !Globals.g_subsetWithRecipe) {
                Globals.g_subsetData.setSubsetByPlatform(this.m_platformsCheckBox.isSelected());
                Globals.g_subsetData.setSubsetByProducts(this.m_productsCheckBox.isSelected());
                Globals.g_subsetData.setSubsetByLanguage(this.m_languagesCheckBox.isSelected());
            } else {
                Globals.g_subsetData.setSubsetByPlatform(false);
                Globals.g_subsetData.setSubsetByProducts(false);
                Globals.g_subsetData.setSubsetByLanguage(false);
            }
            Globals.g_subsetData.setOrigOrder(Globals.g_order);
            Globals.g_subsetData.setOrigDepot(Globals.g_deploymentData.getMediaRoot());
        }
        if (this.m_userSubsetType.getSelectedIndex() != this.m_previousSelectedIndex) {
            Globals.g_subsetResetSelectionsPlatforms = true;
            Globals.g_subsetResetSelectionsProducts = true;
            Globals.g_subsetResetSelectionsLanguages = true;
        } else {
            if (this.m_previousPlatformsSetting != this.m_platformsCheckBox.isSelected()) {
                Globals.g_subsetResetSelectionsPlatforms = true;
            }
            if (this.m_previousProductsSetting != this.m_productsCheckBox.isSelected()) {
                Globals.g_subsetResetSelectionsProducts = true;
            }
            if (this.m_previousLanguagesSetting != this.m_languagesCheckBox.isSelected()) {
                Globals.g_subsetResetSelectionsLanguages = true;
            }
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return Globals.g_deploymentData.getOrder(Globals.g_order).getDepotVersionAsInt() >= 2;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = "selectsubsetPlatform";
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        String order;
        OrderData orderData;
        boolean usingRecipes = Globals.g_subsetWithRecipe;
        String additionalInfo = "";
        String additionalInfoFormatted = "";
        if (!Globals.g_subsetAll && (orderData = Globals.g_deploymentData.getOrder(order = Globals.g_order)) != null && orderData.isPlanning()) {
            additionalInfo = this.bundle.getString("PanelDepotSubsetByPlatProdLang.subsetOrderOptionPlanningAdditionalInfo.txt");
            additionalInfoFormatted = String.format("<p>%s</p>", additionalInfo);
        }
        String orderOptionInfo = String.format("<html>%s%s</html>", this.bundle.getString("PanelDepotSubsetByPlatProdLang.subsetOrderOptionInfo.txt"), additionalInfoFormatted);
        this.m_subsetOrderInfo.setText(orderOptionInfo);
        orderOptionInfo = String.format("%s\n\n%s", this.bundle.getString("PanelDepotSubsetByPlatProdLang.subsetOrderOptionInfo.txt"), additionalInfo);
        this.m_subsetOrderInfoTxtForConsole.setText(orderOptionInfo);
        if (!this.m_panelLoaded || Globals.g_subsetResetSelectionsPlatProdLang) {
            Globals.g_subsetData.setSubsetByPlatform(true);
            Globals.g_subsetData.setSubsetByProducts(!usingRecipes);
            Globals.g_subsetData.setSubsetByLanguage(true);
            this.m_userSubsetTypeInfo.setVisible(!usingRecipes);
            this.m_userSubsetType.setEnabled(!usingRecipes);
            this.m_userSubsetType.setVisible(!usingRecipes);
            this.m_panelLoaded = true;
            Globals.g_subsetResetSelectionsPlatProdLang = false;
        }
        if (!this.loadResponseData()) {
            this.m_fullRecipeOption.setEnabled(usingRecipes);
            this.m_fullRecipeOption.setSelected(true);
            this.m_fullRecipeOption.setVisible(usingRecipes);
            this.m_fullRecipeInfo.setVisible(usingRecipes);
            this.m_subsetRecipeOption.setEnabled(usingRecipes);
            this.m_subsetRecipeOption.setSelected(false);
            this.m_subsetRecipeOption.setVisible(usingRecipes);
            this.m_platformsCheckBox.setSelected(Globals.g_subsetData.isSubsetByPlatform());
            this.m_platformsCheckBox.setEnabled(true);
            this.m_productsCheckBox.setSelected(!usingRecipes && Globals.g_subsetData.isSubsetByProducts());
            this.m_productsCheckBox.setEnabled(!usingRecipes);
            this.m_productsCheckBox.setVisible(!usingRecipes);
            this.m_userSubsetType.setEnabled(this.m_productsCheckBox.isSelected());
            this.m_languagesCheckBox.setSelected(Globals.g_subsetData.isSubsetByLanguage());
            this.m_languagesCheckBox.setEnabled(true);
        }
        this.m_previousSelectedIndex = this.m_userSubsetType.getSelectedIndex();
        this.m_previousPlatformsSetting = this.m_platformsCheckBox.isSelected();
        this.m_previousProductsSetting = this.m_productsCheckBox.isSelected();
        this.m_previousLanguagesSetting = this.m_languagesCheckBox.isSelected();
        this.setRadioState();
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        JToggleButton focus = null;
        focus = !Globals.g_subsetWithRecipe ? this.m_platformsCheckBox : (this.m_fullRecipeOption.isSelected() ? this.m_fullRecipeOption : (this.m_subsetRecipeOption.isSelected() ? this.m_subsetRecipeOption : this.m_fullRecipeOption));
        return focus;
    }

    @Override
    public boolean silentEvent() {
        return true;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
        Globals.g_subsetData.resetData();
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_fullRecipeOption, this.m_subsetRecipeOption};
        JTextArea[] infos = new JTextArea[]{this.m_fullRecipeInfo, this.m_subsetOrderInfoTxtForConsole};
        int returnCode = 0;
        if (Globals.g_subsetWithRecipe) {
            returnCode = ConsoleMode.promptRadioButtons(options, infos);
        }
        if (!Globals.g_subsetWithRecipe || returnCode > -1 && Globals.g_subsetWithRecipe && this.m_subsetRecipeOption.isSelected()) {
            ConsoleMode.printInfoText(this.m_subsetOrderInfo.getText());
            returnCode = ConsoleMode.promptBoolean(this.m_platformsCheckBox);
            if (returnCode > -1) {
                returnCode = ConsoleMode.promptBoolean(this.m_languagesCheckBox);
            }
            if (returnCode > -1 && !Globals.g_subsetWithRecipe) {
                ConsoleMode.promptBoolean(this.m_productsCheckBox);
                ConsoleMode.printInfoText(this.m_userSubsetTypeInfo.getText());
                returnCode = ConsoleMode.promptComboBox(this.m_userSubsetType);
            }
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        return valid;
    }

    private void initialize() {
        String mtxt = null;
        Font optionFont = null;
        mtxt = this.bundle.getString("PanelDepotSubsetByPlatProdLang.fullRecipeOptionLabel.txt");
        this.m_fullRecipeOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_fullRecipeOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_fullRecipeOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_fullRecipeOption.getFont();
        this.m_fullRecipeOption.setFont(optionFont.deriveFont(1));
        this.m_fullRecipeInfo = new JTextArea(this.bundle.getString("PanelDepotSubsetByPlatProdLang.fullRecipeOptionInfo.txt"));
        this.m_fullRecipeInfo.setEditable(false);
        this.m_fullRecipeInfo.setFocusable(false);
        this.m_fullRecipeInfo.setLineWrap(true);
        this.m_fullRecipeInfo.setWrapStyleWord(true);
        this.m_fullRecipeInfo.setOpaque(false);
        mtxt = this.bundle.getString("PanelDepotSubsetByPlatProdLang.subsetOrderOptionLabel.txt");
        this.m_subsetRecipeOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_subsetRecipeOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_subsetRecipeOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_subsetRecipeOption.getFont();
        this.m_subsetRecipeOption.setFont(optionFont.deriveFont(1));
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_fullRecipeOption);
        group.add(this.m_subsetRecipeOption);
        this.m_fullRecipeOption.addActionListener(this);
        this.m_subsetRecipeOption.addActionListener(this);
        this.m_subsetOrderInfo = new JEditorPane("text/html", "");
        this.m_subsetOrderInfo.setEditable(false);
        this.m_subsetOrderInfo.setFocusable(false);
        this.m_subsetOrderInfo.setOpaque(false);
        this.m_subsetOrderInfoTxtForConsole = new JTextArea();
        this.m_subsetOrderInfoTxtForConsole.setEditable(false);
        this.m_subsetOrderInfoTxtForConsole.setFocusable(false);
        this.m_subsetOrderInfoTxtForConsole.setLineWrap(true);
        this.m_subsetOrderInfoTxtForConsole.setWrapStyleWord(true);
        this.m_subsetOrderInfoTxtForConsole.setOpaque(false);
        mtxt = this.bundle.getString("PanelDepotSubsetByPlatProdLang.platformsCheckBoxLabel.txt");
        this.m_platformsCheckBox = new JCheckBox(Util.getLabelWithoutMnemonic(mtxt));
        this.m_platformsCheckBox.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_platformsCheckBox.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_platformsCheckBox.getFont();
        this.m_platformsCheckBox.setFont(optionFont.deriveFont(1));
        mtxt = this.bundle.getString("PanelDepotSubsetByPlatProdLang.productsCheckBoxLabel.txt");
        this.m_productsCheckBox = new JCheckBox(Util.getLabelWithoutMnemonic(mtxt));
        this.m_productsCheckBox.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_productsCheckBox.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_productsCheckBox.getFont();
        this.m_productsCheckBox.setFont(optionFont.deriveFont(1));
        mtxt = this.bundle.getString("PanelDepotSubsetByPlatProdLang.languagesCheckBoxLabel.txt");
        this.m_languagesCheckBox = new JCheckBox(Util.getLabelWithoutMnemonic(mtxt));
        this.m_languagesCheckBox.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_languagesCheckBox.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_languagesCheckBox.getFont();
        this.m_languagesCheckBox.setFont(optionFont.deriveFont(1));
        this.m_userSubsetTypeInfo = new JTextArea(this.bundle.getString("PanelDepotSubsetChoices.UserSubsetTypeInfo.txt"));
        this.m_userSubsetTypeInfo.setEditable(false);
        this.m_userSubsetTypeInfo.setFocusable(false);
        this.m_userSubsetTypeInfo.setLineWrap(true);
        this.m_userSubsetTypeInfo.setWrapStyleWord(true);
        this.m_userSubsetTypeInfo.setOpaque(false);
        this.m_userSubsetType = new JComboBox<String>(this.getSubsetTypes());
        this.m_userSubsetType.setFocusable(true);
        if (Globals.g_subsetClients) {
            this.m_userSubsetType.setSelectedIndex(1);
        } else if (Globals.g_subsetNonConfig) {
            this.m_userSubsetType.setSelectedIndex(2);
        } else if (Globals.g_subsetAll) {
            this.m_userSubsetType.setSelectedIndex(3);
        } else {
            this.m_userSubsetType.setSelectedIndex(0);
        }
        this.m_productsCheckBox.addActionListener(this);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 3, 0);
        this.m_panel.add((Component)this.m_fullRecipeOption, c);
        c.gridy = 1;
        c.insets = new Insets(2, 20, 2, 0);
        this.m_panel.add((Component)this.m_fullRecipeInfo, c);
        c.gridy = 2;
        c.insets = new Insets(3, 0, 3, 0);
        this.m_panel.add((Component)this.m_subsetRecipeOption, c);
        c.gridy = 3;
        c.insets = new Insets(2, 20, 3, 0);
        this.m_panel.add((Component)this.m_subsetOrderInfo, c);
        c.gridy = 4;
        c.insets = new Insets(2, 20, 2, 0);
        this.m_panel.add((Component)this.m_platformsCheckBox, c);
        c.gridy = 5;
        c.insets = new Insets(2, 20, 2, 0);
        this.m_panel.add((Component)this.m_languagesCheckBox, c);
        c.gridy = 6;
        c.insets = new Insets(2, 20, 2, 0);
        this.m_panel.add((Component)this.m_productsCheckBox, c);
        c.gridy = 7;
        c.insets = new Insets(2, 40, 2, 0);
        this.m_panel.add((Component)this.m_userSubsetTypeInfo, c);
        c.gridy = 8;
        c.insets = new Insets(2, 40, 2, 0);
        this.m_panel.add((Component)this.m_userSubsetType, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        this.m_userSubsetType.setEnabled(this.m_productsCheckBox.isSelected());
        if (obj == this.m_fullRecipeOption || obj == this.m_subsetRecipeOption) {
            this.setRadioState();
        }
    }

    private void setRadioState() {
        this.m_platformsCheckBox.setEnabled(!Globals.g_subsetWithRecipe || this.m_subsetRecipeOption.isSelected());
        this.m_productsCheckBox.setEnabled(!Globals.g_subsetWithRecipe || this.m_subsetRecipeOption.isSelected());
        this.m_languagesCheckBox.setEnabled(!Globals.g_subsetWithRecipe || this.m_subsetRecipeOption.isSelected());
    }

    private Vector<String> getSubsetTypes() {
        Vector<String> types = new Vector<String>();
        types.add(this.bundle.getString("PanelDepotSubsetChoices.Foundation.txt"));
        types.add(this.bundle.getString("PanelDepotSubsetChoices.Clients.txt"));
        types.add(this.bundle.getString("PanelDepotSubsetChoices.NonConfig.txt"));
        if (Globals.g_subsetAll) {
            types.add(this.bundle.getString("PanelDepotSubsetChoices.All.txt"));
        }
        return types;
    }

    @Override
    public String getHelpTopic() {
        if (Globals.g_subsetWithRecipe) {
            return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length()) + "Recipe";
        }
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

