/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.PanelStart;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class PanelCreateBatch
implements WizardPanelIface {
    private final String RESPONSE_SRWNOW = "srwnow";
    private final String RESPONSE_SRWLATER = "srwlater";
    private SSNResource bundle = new SSNResource(PanelStart.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JPanel m_createBatchPanel = new JPanel(new GridBagLayout());
    private JSeparator m_createBatchSeparator = new JSeparator();
    private JTextArea m_createBatchLabel = null;
    private JRadioButton m_srwNowOption = null;
    private JRadioButton m_srwLaterOption = null;
    private JTextArea m_srwNowInfo = null;
    private JTextArea m_srwLaterInfo = null;
    private boolean m_panelLoaded = false;

    public PanelCreateBatch() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelCreateBatch.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelCreateBatch.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        return true;
    }

    @Override
    public boolean displayPanel() {
        return Globals.g_srwOnly;
    }

    @Override
    public String getNextPanelID() {
        Globals.g_createBatch = false;
        if (!(!this.m_srwLaterOption.isSelected() || Globals.g_recordMode && Globals.g_recordOnly)) {
            Globals.g_createBatch = true;
        }
        return "selectorder";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            if (!this.loadResponseData()) {
                this.m_srwLaterOption.setSelected(true);
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        JRadioButton focus = null;
        focus = this.m_srwNowOption.isSelected() ? this.m_srwNowOption : this.m_srwLaterOption;
        return focus;
    }

    @Override
    public boolean silentEvent() {
        this.loadResponseData();
        this.validateData();
        return true;
    }

    @Override
    public String[] responseData() {
        if (this.m_srwNowOption.isSelected()) {
            return new String[]{" CREATE_BATCH=srwnow"};
        }
        return new String[]{" CREATE_BATCH=srwlater"};
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_srwNowOption, this.m_srwLaterOption};
        JTextArea[] infos = new JTextArea[]{this.m_srwNowInfo, this.m_srwLaterInfo};
        return ConsoleMode.promptRadioButtons(options, infos);
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("CREATE_BATCH", null);
        if (response != null) {
            if (response.equalsIgnoreCase("srwnow")) {
                valid = true;
                this.m_srwNowOption.setSelected(true);
            } else if (response.equalsIgnoreCase("srwlater")) {
                valid = true;
                this.m_srwLaterOption.setSelected(true);
            } else if (Globals.g_quietMode) {
                this.m_srwLaterOption.setSelected(true);
            }
        } else if (Globals.g_quietMode) {
            this.m_srwLaterOption.setSelected(true);
        }
        return valid;
    }

    private void initialize() {
        this.m_createBatchLabel = new JTextArea(this.bundle.getString("PanelCreateBatch.createBatchLabel.txt"));
        this.m_createBatchLabel.setEditable(false);
        this.m_createBatchLabel.setFocusable(false);
        this.m_createBatchLabel.setLineWrap(false);
        this.m_createBatchLabel.setOpaque(false);
        String mtxt = this.bundle.getString("PanelCreateBatch.srwNowLabel.txt");
        this.m_srwNowOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_srwNowOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_srwNowOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_srwNowOption.getFont();
        this.m_srwNowOption.setFont(optionFont.deriveFont(1));
        this.m_srwNowInfo = new JTextArea(this.bundle.getString("PanelCreateBatch.srwNowInfo.txt"));
        this.m_srwNowInfo.setEditable(false);
        this.m_srwNowInfo.setFocusable(false);
        this.m_srwNowInfo.setLineWrap(true);
        this.m_srwNowInfo.setWrapStyleWord(true);
        this.m_srwNowInfo.setOpaque(false);
        mtxt = this.bundle.getString("PanelCreateBatch.srwLaterLabel.txt");
        this.m_srwLaterOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_srwLaterOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_srwLaterOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_srwLaterOption.getFont();
        this.m_srwLaterOption.setFont(optionFont.deriveFont(1));
        this.m_srwLaterInfo = new JTextArea(this.bundle.getString("PanelCreateBatch.srwLaterInfo.txt"));
        this.m_srwLaterInfo.setEditable(false);
        this.m_srwLaterInfo.setFocusable(false);
        this.m_srwLaterInfo.setLineWrap(true);
        this.m_srwLaterInfo.setWrapStyleWord(true);
        this.m_srwLaterInfo.setOpaque(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_srwNowOption);
        group.add(this.m_srwLaterOption);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        this.layoutEndUserSeparator();
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_createBatchPanel, c);
        c.gridy = 1;
        c.insets = new Insets(5, 20, 5, 0);
        this.m_panel.add((Component)this.m_srwLaterOption, c);
        c.gridy = 2;
        c.insets = new Insets(5, 40, 5, 0);
        this.m_panel.add((Component)this.m_srwLaterInfo, c);
        c.gridy = 3;
        c.insets = new Insets(5, 20, 5, 0);
        this.m_panel.add((Component)this.m_srwNowOption, c);
        c.gridy = 4;
        c.insets = new Insets(5, 40, 5, 0);
        this.m_panel.add((Component)this.m_srwNowInfo, c);
    }

    private void layoutEndUserSeparator() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.anchor = 18;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_createBatchPanel.add((Component)this.m_createBatchLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_createBatchPanel.add((Component)this.m_createBatchSeparator, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

