/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class PanelConfigOption
implements WizardPanelIface {
    private final String RESPONSE_MINIMUM = "minimum";
    private final String RESPONSE_MODERATE = "moderate";
    private final String RESPONSE_FULL = "full";
    private SSNResource bundle = new SSNResource(PanelConfigOption.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_infoText = null;
    private JRadioButton m_minimumOption = null;
    private JTextArea m_minimumText = null;
    private JRadioButton m_moderateOption = null;
    private JTextArea m_moderateText = null;
    private JRadioButton m_fullOption = null;
    private JTextArea m_fullText = null;
    private boolean m_panelLoaded = false;

    public PanelConfigOption() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelConfigOption.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelConfigOption.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        Globals.g_configPromptLevel = this.m_minimumOption.isSelected() ? 0 : (this.m_moderateOption.isSelected() ? 1 : 2);
        return true;
    }

    @Override
    public boolean displayPanel() {
        boolean display = true;
        if (Globals.g_singleAccount) {
            display = false;
            Globals.g_configPromptLevel = 0;
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = Globals.g_mode == 2 ? "hostname" : "configdir";
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            if (Globals.g_mode == 2) {
                this.m_minimumOption.setVisible(false);
                this.m_minimumText.setVisible(false);
            }
            if (!this.loadResponseData()) {
                this.m_moderateOption.setSelected(true);
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        if (this.m_minimumOption.isSelected()) {
            return this.m_minimumOption;
        }
        if (this.m_moderateOption.isSelected()) {
            return this.m_moderateOption;
        }
        if (this.m_fullOption.isSelected()) {
            return this.m_fullOption;
        }
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        if (Globals.g_quietMode && Globals.g_recordMode) {
            return null;
        }
        String[] data = new String[]{"#CONFIGURATION_PROMPTS=minimum/moderate/full", " CONFIGURATION_PROMPTS=moderate"};
        if (this.m_panelLoaded) {
            if (this.m_minimumOption.isSelected()) {
                data[1] = " CONFIGURATION_PROMPTS=minimum";
            } else if (this.m_fullOption.isSelected()) {
                data[1] = " CONFIGURATION_PROMPTS=full";
            }
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_minimumOption, this.m_moderateOption, this.m_fullOption};
        JTextArea[] infos = new JTextArea[]{this.m_minimumText, this.m_moderateText, this.m_fullText};
        return ConsoleMode.promptRadioButtons(options, infos);
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("CONFIGURATION_PROMPTS", null);
        if (response != null) {
            if (response.equalsIgnoreCase("minimum")) {
                valid = true;
                this.m_minimumOption.setSelected(true);
            } else if (response.equalsIgnoreCase("moderate")) {
                valid = true;
                this.m_moderateOption.setSelected(true);
            } else if (response.equalsIgnoreCase("full")) {
                valid = true;
                this.m_fullOption.setSelected(true);
            } else if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "CONFIGURATION_PROMPTS", response, null);
            }
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), "CONFIGURATION_PROMPTS");
        }
        return valid;
    }

    private void initialize() {
        this.m_infoText = new JTextArea(this.bundle.getString("PanelConfigOption.Instructions.txt"));
        this.m_infoText.setEditable(false);
        this.m_infoText.setFocusable(false);
        this.m_infoText.setLineWrap(true);
        this.m_infoText.setWrapStyleWord(true);
        this.m_infoText.setOpaque(false);
        String mtxt = this.bundle.getString("PanelConfigOption.MinimumOption.txt");
        this.m_minimumOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_minimumOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_minimumOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_minimumOption.getFont();
        this.m_minimumOption.setFont(optionFont.deriveFont(1));
        this.m_minimumText = new JTextArea(this.bundle.getString("PanelConfigOption.MinimumText.txt"));
        this.m_minimumText.setEditable(false);
        this.m_minimumText.setFocusable(false);
        this.m_minimumText.setLineWrap(true);
        this.m_minimumText.setWrapStyleWord(true);
        this.m_minimumText.setOpaque(false);
        mtxt = this.bundle.getString("PanelConfigOption.ModerateOption.txt");
        this.m_moderateOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_moderateOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_moderateOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_moderateOption.getFont();
        this.m_moderateOption.setFont(optionFont.deriveFont(1));
        this.m_moderateText = new JTextArea(this.bundle.getString("PanelConfigOption.ModerateText.txt"));
        this.m_moderateText.setEditable(false);
        this.m_moderateText.setFocusable(false);
        this.m_moderateText.setLineWrap(true);
        this.m_moderateText.setWrapStyleWord(true);
        this.m_moderateText.setOpaque(false);
        mtxt = this.bundle.getString("PanelConfigOption.FullOption.txt");
        this.m_fullOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_fullOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_fullOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_fullOption.getFont();
        this.m_fullOption.setFont(optionFont.deriveFont(1));
        this.m_fullText = new JTextArea(this.bundle.getString("PanelConfigOption.FullText.txt"));
        this.m_fullText.setEditable(false);
        this.m_fullText.setFocusable(false);
        this.m_fullText.setLineWrap(true);
        this.m_fullText.setWrapStyleWord(true);
        this.m_fullText.setOpaque(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_minimumOption);
        group.add(this.m_moderateOption);
        group.add(this.m_fullOption);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 18;
        c.fill = 2;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_infoText, c);
        c.gridy = 1;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_minimumOption, c);
        c.gridy = 2;
        c.insets = new Insets(5, 20, 0, 0);
        this.m_panel.add((Component)this.m_minimumText, c);
        c.gridy = 3;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_moderateOption, c);
        c.gridy = 4;
        c.insets = new Insets(5, 20, 0, 0);
        this.m_panel.add((Component)this.m_moderateText, c);
        c.gridy = 5;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_fullOption, c);
        c.gridy = 6;
        c.insets = new Insets(5, 20, 0, 0);
        this.m_panel.add((Component)this.m_fullText, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

