/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ChainConfigMaint;
import com.sas.ssn.ConfigStatus;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.OrderData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class PanelConfigMaint
implements WizardPanelIface {
    public static final int CONFIG_STATUS_INITIAL = 0;
    public static final int CONFIG_STATUS_RUNNING = 1;
    public static final int CONFIG_STATUS_SUCCESS = 2;
    public static final int CONFIG_STATUS_FAILED = 3;
    public static final int CONFIG_STATUS_WARNING = 4;
    public static final int CONFIG_STATUS_CANCEL = 5;
    public static final int PROMPT_STOP = 0;
    public static final int PROMPT_RETRY = 1;
    public static final int PROMPT_CONTINUE = 2;
    private SSNResource bundle = new SSNResource(PanelConfigMaint.class);
    private final ImageIcon m_emptyIcon = this.bundle.getImageIcon("Common.empty.image");
    private final ImageIcon m_runningIcon = this.bundle.getImageIcon("Common.running.image");
    private final ImageIcon m_successIcon = this.bundle.getImageIcon("Common.success.image");
    private final ImageIcon m_failureIcon = this.bundle.getImageIcon("Common.failure.image");
    private final ImageIcon m_warningIcon = this.bundle.getImageIcon("Common.warning.image");
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_infoText = null;
    private JTable m_configDirTable = null;
    private JScrollPane m_listScrollPane = null;
    private ActionListener m_columnActionListener = null;
    private JPanel m_buttonPanel = new JPanel(new GridBagLayout());
    private JButton m_selectAllButton = null;
    private JButton m_clearAllButton = null;
    private JLabel m_processing = null;
    private Timer m_timer = null;
    private ActionListener m_timerAction = null;
    private ImageIcon m_time1 = this.bundle.getImageIcon("Common.time1.image");
    private ImageIcon m_time2 = this.bundle.getImageIcon("Common.time2.image");
    private ImageIcon m_time3 = this.bundle.getImageIcon("Common.time3.image");
    private ImageIcon m_time4 = this.bundle.getImageIcon("Common.time4.image");
    private ImageIcon m_time5 = this.bundle.getImageIcon("Common.time5.image");
    private boolean m_panelLoaded = false;
    private boolean m_running = false;
    private boolean m_ignoreErrors = false;
    private int m_imageCount = 1;
    private String m_sasHomeDir = null;
    private String m_sdmInstallDir = null;
    private HashMap m_responseData = null;
    private ListTableModel m_listTableModel = null;
    private RunningTableModel m_runningTableModel = null;
    private ArrayList m_listData = new ArrayList();
    private ChainConfigMaint m_chain = null;

    public PanelConfigMaint() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelConfigMaint.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelConfigMaint.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = false;
        if (Globals.g_consoleMode || Globals.g_recordMode && Globals.g_recordOnly) {
            valid = true;
        } else if (this.m_running) {
            valid = true;
            this.stopTimer();
        } else {
            this.m_running = true;
            String mtxt = this.bundle.getString("PanelConfigMaint.StopButton.txt");
            Globals.g_wizard.getNextButton().setText(Util.getLabelWithoutMnemonic(mtxt));
            Globals.g_wizard.getNextButton().setMnemonic(Util.getDisplayedMnemonic(mtxt));
            Globals.g_wizard.getNextButton().setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            Globals.g_wizard.getHelpButton().setEnabled(false);
            Globals.g_wizard.getBackButton().setEnabled(false);
            Globals.g_wizard.getCancelButton().setEnabled(false);
            this.morphForRunning();
            this.m_buttonPanel.setVisible(false);
            this.startTimer();
            this.m_chain = new ChainConfigMaint(this.m_listData, this, this.m_sdmInstallDir);
            this.m_chain.start();
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        boolean display = false;
        OrderData orderData = Globals.g_deploymentData.getOrder(Globals.g_order);
        if ((Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired() && this.loadConfigDirs().size() > 0 && !orderData.isWeb() || Globals.g_forceConfigMaint) && !Globals.g_DocUpdate) {
            display = true;
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        return "finish";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.m_sasHomeDir = Globals.g_wizardData.getPreference("SASHome", null);
            if (this.m_sasHomeDir != null) {
                this.m_listData = this.loadConfigDirs();
                this.m_sdmInstallDir = Utils.getSDMHome(this.m_sasHomeDir);
            }
            this.m_selectAllButton.setEnabled(this.m_listData.size() > 0);
            this.m_clearAllButton.setEnabled(this.m_listData.size() > 0);
            this.loadResponseData();
            TableColumn column = this.m_configDirTable.getColumnModel().getColumn(1);
            int minWidth = Utils.getMinColumnWidth(this.m_configDirTable, 1);
            int width = Utils.getPreferredColumnWidth(this.m_configDirTable, 1);
            column.setMinWidth(minWidth);
            column.setPreferredWidth(width);
            column.setMaxWidth(width * 2);
            int rowHeight = Utils.getPreferredRowHeight(this.m_configDirTable);
            if (rowHeight > 0) {
                this.m_configDirTable.setRowHeight(rowHeight);
            }
            this.m_panelLoaded = true;
        }
        if (!Globals.g_recordMode || !Globals.g_recordOnly) {
            String mtxt = this.bundle.getString("PanelConfigMaint.StartButton.txt");
            wizardFramework.getNextButton().setText(Util.getLabelWithoutMnemonic(mtxt));
            wizardFramework.getNextButton().setMnemonic(Util.getDisplayedMnemonic(mtxt));
            wizardFramework.getNextButton().setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = true;
        if (Globals.g_partialPrompt) {
            valid = false;
        } else if (this.loadResponseData()) {
            this.m_chain = new ChainConfigMaint(this.m_listData, this, this.m_sdmInstallDir);
            this.m_chain.run();
            valid = this.m_chain.finished();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        if (this.m_panelLoaded) {
            ArrayList<String> data = new ArrayList<String>();
            int count = 0;
            ListData listData = null;
            for (int i = 0; i < this.m_listData.size(); ++i) {
                listData = (ListData)this.m_listData.get(i);
                if (!listData.getSelected()) continue;
                data.add(" CONFIGURE_MAINTENANCE" + Integer.toString(++count) + "=" + Utils.joinPath(listData.getConfigDir(), listData.getConfigLev()));
            }
            return data.toArray(new String[0]);
        }
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        ConsoleMode.printInfoText(this.bundle.getString("PanelConfigMaint.ConsoleMessage.txt"));
        return ConsoleMode.promptPause();
    }

    private boolean loadResponseData() {
        boolean valid = true;
        this.m_responseData = null;
        boolean found = true;
        int count = 1;
        String response = null;
        while (found) {
            response = Wizard.getResponse("CONFIGURE_MAINTENANCE" + Integer.toString(count), null);
            if (response == null) {
                found = false;
            } else {
                if (count == 1) {
                    this.m_responseData = new HashMap();
                }
                this.m_responseData.put(response, null);
            }
            ++count;
        }
        return valid;
    }

    private void initialize() {
        this.m_infoText = new JTextArea(this.bundle.getString("PanelConfigMaint.Instructions.txt"));
        this.m_infoText.setEditable(false);
        this.m_infoText.setFocusable(false);
        this.m_infoText.setLineWrap(true);
        this.m_infoText.setWrapStyleWord(true);
        this.m_infoText.setOpaque(false);
        this.m_listTableModel = new ListTableModel();
        this.m_configDirTable = new JTable(this.m_listTableModel);
        this.m_configDirTable.setCellSelectionEnabled(true);
        this.m_configDirTable.setSelectionMode(0);
        this.m_configDirTable.getColumnModel().getColumn(0).setCellRenderer(new CheckBoxCellRenderer());
        this.m_configDirTable.getColumnModel().getColumn(0).setCellEditor(new CheckBoxCellEditor(new JCheckBox()));
        this.m_configDirTable.getTableHeader().setResizingAllowed(false);
        this.m_configDirTable.getTableHeader().setReorderingAllowed(false);
        this.m_configDirTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelConfigMaint.this.m_configDirTable.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.m_listScrollPane = new JScrollPane(this.m_configDirTable);
        String mtxt = this.bundle.getString("Common.SelectAll.txt");
        this.m_selectAllButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_selectAllButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_selectAllButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        mtxt = this.bundle.getString("Common.ClearAll.txt");
        this.m_clearAllButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_clearAllButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_clearAllButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_columnActionListener = new ColumnActionListener();
        this.m_selectAllButton.addActionListener(this.m_columnActionListener);
        this.m_clearAllButton.addActionListener(this.m_columnActionListener);
        this.m_processing = new JLabel();
        this.m_processing.setVisible(false);
        this.m_timerAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PanelConfigMaint.this.timerEvent();
            }
        };
        this.m_timer = new Timer(250, this.m_timerAction);
    }

    private void initButtonPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.gridx = 0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 5);
        this.m_buttonPanel.add((Component)this.m_selectAllButton, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_buttonPanel.add((Component)this.m_clearAllButton, c);
        if (this.m_selectAllButton.getPreferredSize().getWidth() < this.m_clearAllButton.getPreferredSize().getWidth()) {
            this.m_selectAllButton.setPreferredSize(this.m_clearAllButton.getPreferredSize());
        } else if (this.m_clearAllButton.getPreferredSize().getWidth() < this.m_selectAllButton.getPreferredSize().getWidth()) {
            this.m_clearAllButton.setPreferredSize(this.m_selectAllButton.getPreferredSize());
        }
    }

    private void timerEvent() {
        ++this.m_imageCount;
        if (this.m_imageCount > 8) {
            this.m_imageCount = 1;
        }
        switch (this.m_imageCount) {
            case 1: {
                this.m_processing.setIcon(this.m_time1);
                break;
            }
            case 2: {
                this.m_processing.setIcon(this.m_time2);
                break;
            }
            case 3: {
                this.m_processing.setIcon(this.m_time3);
                break;
            }
            case 4: {
                this.m_processing.setIcon(this.m_time4);
                break;
            }
            case 5: {
                this.m_processing.setIcon(this.m_time5);
                break;
            }
            case 6: {
                this.m_processing.setIcon(this.m_time4);
                break;
            }
            case 7: {
                this.m_processing.setIcon(this.m_time3);
                break;
            }
            default: {
                this.m_processing.setIcon(this.m_time2);
            }
        }
        this.m_runningTableModel.refreshTable();
        if (Globals.g_wizard.getFrame() != null) {
            Globals.g_wizard.getFrame().validate();
        }
    }

    private void startTimer() {
        this.m_processing.setVisible(true);
        this.m_processing.setIcon(this.m_time1);
        this.m_timer.start();
    }

    private void stopTimer() {
        this.m_timer.stop();
        this.m_processing.setVisible(false);
        this.m_imageCount = 1;
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 18;
        c.gridy = 0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_infoText, c);
        c.gridy = 1;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_listScrollPane, c);
        this.initButtonPanel();
        c.gridy = 2;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_panel.add((Component)this.m_buttonPanel, c);
        c.gridy = 3;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_panel.add((Component)this.m_processing, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList loadConfigDirs() {
        ArrayList<ListData> listData = new ArrayList<ListData>();
        if (Utils.getOS() != 8 || !Globals.g_z64 && Globals.g_zosJobSubmit) {
            String[] configDirs = null;
            RegistryAccess registryAccess = null;
            try {
                registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                if (registryAccess != null && registryAccess.open()) {
                    configDirs = registryAccess.getConfigLocs();
                }
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
            finally {
                if (registryAccess != null) {
                    registryAccess.close();
                    registryAccess = null;
                }
            }
            String sasHome = Globals.g_wizardData.getPreference("SASHome", null);
            if (configDirs != null && sasHome != null) {
                for (int i = 0; i < configDirs.length; ++i) {
                    for (int j = 0; j < Globals.g_configLevels.length; ++j) {
                        if (!PanelConfigMaint.isConfigDirEligible(configDirs[i], Globals.g_configLevels[j], sasHome)) continue;
                        listData.add(new ListData(true, configDirs[i], Globals.g_configLevels[j]));
                    }
                }
            }
        }
        return listData;
    }

    public static boolean isConfigDirEligible(String configDir, String level, String sasHome) {
        File statusFile;
        boolean eligible = false;
        String configSASHome = null;
        File fullDir = new File(configDir, level);
        if (fullDir.isDirectory() && (statusFile = new File(Utils.joinPath(fullDir.toString(), "ConfigData", "status.xml"))).isFile()) {
            try {
                ConfigStatus status = new ConfigStatus(statusFile);
                ConfigStatus.StatusEntry[] statusEntries = status.getStatusEntries();
                if (statusEntries != null) {
                    String fqid = null;
                    String code = null;
                    for (int i = 0; i < statusEntries.length && !eligible; ++i) {
                        fqid = statusEntries[i].getFQID();
                        code = statusEntries[i].getCode();
                        if (fqid == null || code == null || fqid.equalsIgnoreCase(code) && !code.equalsIgnoreCase("grdcnode") && !code.equalsIgnoreCase("grdcsasgsub") && !code.equalsIgnoreCase("grdcnodeo") && !code.equalsIgnoreCase("grdcsasgsubo")) continue;
                        eligible = true;
                    }
                }
            }
            catch (Exception e) {
                Logging.log.warning("Error loading status.xml file: " + statusFile.toString());
                Logging.logStackTrace(e);
            }
            if (eligible) {
                eligible = false;
                File propsFile = new File(Utils.joinPath(fullDir.toString(), "Utilities", "configuration.properties"));
                if (propsFile.isFile()) {
                    try {
                        FileInputStream fileInStream = new FileInputStream(propsFile);
                        Properties configProps = new Properties();
                        configProps.load(fileInStream);
                        fileInStream.close();
                        configSASHome = configProps.getProperty("sas.home.dir", null);
                        if (configSASHome != null && Utils.isEqualPaths(configSASHome, sasHome)) {
                            eligible = true;
                        }
                    }
                    catch (Exception e) {
                        Logging.log.warning("Error loading properties file: " + propsFile.toString());
                        Logging.logStackTrace(e);
                    }
                }
            }
        }
        return eligible;
    }

    public void morphForSummary() {
        this.stopTimer();
        Globals.g_wizard.enableButtons();
    }

    public int retryPrompt(boolean lastConfigDir, ListData listElement) {
        int promptVal = 2;
        if (!this.m_ignoreErrors) {
            String title = this.bundle.getString("PanelConfigMaint.ErrorTitle.txt");
            String configDir = Utils.joinPath(listElement.getConfigDir(), listElement.getConfigLev());
            if (lastConfigDir) {
                Object[] options = new Object[]{Util.getLabelWithoutMnemonic(this.bundle.getString("Common.No.txt")), Util.getLabelWithoutMnemonic(this.bundle.getString("Common.RetryButton.txt"))};
                String msgTxt = this.bundle.messageString("PanelConfigMaint.ErrorMessageLast.txt", configDir);
                switch (JOptionPane.showOptionDialog(Globals.g_wizard.getFrame(), msgTxt, title, 0, 0, null, options, options[1])) {
                    case 0: {
                        promptVal = 2;
                        break;
                    }
                    default: {
                        promptVal = 1;
                        break;
                    }
                }
            } else {
                Object[] options = null;
                int defaultButton = 0;
                if (Globals.g_allowContinue) {
                    options[0] = Util.getLabelWithoutMnemonic(this.bundle.getString("Common.No.txt"));
                    options[1] = Util.getLabelWithoutMnemonic(this.bundle.getString("Common.Yes.txt"));
                    options[2] = Util.getLabelWithoutMnemonic(this.bundle.getString("Common.YesToAllButton.txt"));
                    options[3] = Util.getLabelWithoutMnemonic(this.bundle.getString("Common.RetryButton.txt"));
                    defaultButton = 3;
                } else {
                    options[0] = Util.getLabelWithoutMnemonic(this.bundle.getString("PanelConfigMaint.StopButton.txt"));
                    options[1] = Util.getLabelWithoutMnemonic(this.bundle.getString("Common.RetryButton.txt"));
                    defaultButton = 1;
                }
                String msgTxt = this.bundle.messageString("PanelConfigMaint.ErrorMessage.txt", configDir);
                switch (JOptionPane.showOptionDialog(Globals.g_wizard.getFrame(), msgTxt, title, 1, 0, null, options, options[defaultButton])) {
                    case 0: {
                        promptVal = 0;
                        break;
                    }
                    case 1: {
                        promptVal = Globals.g_allowContinue ? 2 : 1;
                        break;
                    }
                    case 2: {
                        promptVal = 2;
                        this.m_ignoreErrors = true;
                        break;
                    }
                    default: {
                        promptVal = 1;
                    }
                }
            }
        }
        return promptVal;
    }

    private void morphForRunning() {
        this.m_runningTableModel = new RunningTableModel();
        this.m_configDirTable.setModel(this.m_runningTableModel);
        this.m_configDirTable.setCellSelectionEnabled(false);
        this.m_configDirTable.getColumnModel().getColumn(0).setCellRenderer(new GraphicCellRenderer());
        TableColumn column = this.m_configDirTable.getColumnModel().getColumn(0);
        int minWidth = Utils.getMinColumnWidth(this.m_configDirTable, 0);
        int width = Utils.getPreferredColumnWidth(this.m_configDirTable, 0);
        column.setMinWidth(minWidth);
        column.setPreferredWidth(width);
        column.setMaxWidth(width * 2);
        column = this.m_configDirTable.getColumnModel().getColumn(2);
        minWidth = Utils.getMinColumnWidth(this.m_configDirTable, 2);
        width = Utils.getPreferredColumnWidth(this.m_configDirTable, 2);
        column.setMinWidth(minWidth);
        column.setPreferredWidth(width);
        column.setMaxWidth(width * 2);
    }

    class ListTableModel
    extends AbstractTableModel {
        public static final int TABLE_COLUMN_DIR = 0;
        public static final int TABLE_COLUMN_LEV = 1;
        private String[] m_columnNames;

        public ListTableModel() {
            this.m_columnNames = new String[]{PanelConfigMaint.this.bundle.getString("PanelConfigMaint.DirColumn.txt"), PanelConfigMaint.this.bundle.getString("PanelConfigMaint.LevColumn.txt")};
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.m_columnNames[index];
        }

        public Class getColumnClass(int index) {
            if (index == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            int count = 0;
            if (PanelConfigMaint.this.m_listData != null) {
                count = PanelConfigMaint.this.m_listData.size();
            }
            return count;
        }

        @Override
        public Object getValueAt(int rowIndex, int colIndex) {
            Object value = null;
            ListData data = (ListData)PanelConfigMaint.this.m_listData.get(rowIndex);
            if (data != null) {
                if (colIndex == 0) {
                    value = data.getSelected();
                } else if (colIndex == 1) {
                    value = data.getConfigLev();
                }
            }
            return value;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int colIndex) {
            ListData data = (ListData)PanelConfigMaint.this.m_listData.get(rowIndex);
            return data != null && colIndex == 0;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int colIndex) {
            ListData data = (ListData)PanelConfigMaint.this.m_listData.get(rowIndex);
            if (data != null && value instanceof Boolean && colIndex == 0) {
                data.setSelected((Boolean)value);
                this.fireTableCellUpdated(rowIndex, colIndex);
            }
        }

        public void selectAll(boolean value) {
            ListData data = null;
            for (int i = 0; i < PanelConfigMaint.this.m_listData.size(); ++i) {
                data = (ListData)PanelConfigMaint.this.m_listData.get(i);
                if (data == null) continue;
                data.setSelected(value);
            }
            this.fireTableDataChanged();
        }
    }

    class RunningTableModel
    extends AbstractTableModel {
        public static final int TABLE_COLUMN_STATUS = 0;
        public static final int TABLE_COLUMN_DIR = 1;
        public static final int TABLE_COLUMN_LEV = 2;
        private String[] m_columnNames;

        public RunningTableModel() {
            this.m_columnNames = new String[]{PanelConfigMaint.this.bundle.getString("PanelConfigMaint.StatusColumn.txt"), PanelConfigMaint.this.bundle.getString("PanelConfigMaint.DirColumn.txt"), PanelConfigMaint.this.bundle.getString("PanelConfigMaint.LevColumn.txt")};
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.m_columnNames[index];
        }

        public Class getColumnClass(int index) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            int count = 0;
            if (PanelConfigMaint.this.m_listData != null) {
                count = PanelConfigMaint.this.m_listData.size();
            }
            return count;
        }

        @Override
        public Object getValueAt(int rowIndex, int colIndex) {
            String value = null;
            ListData data = (ListData)PanelConfigMaint.this.m_listData.get(rowIndex);
            if (data != null) {
                if (colIndex == 0) {
                    value = Integer.toString(data.getStatus());
                }
                if (colIndex == 1) {
                    value = data.getConfigDir();
                } else if (colIndex == 2) {
                    value = data.getConfigLev();
                }
            }
            return value;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int colIndex) {
            return false;
        }

        public void refreshTable() {
            this.fireTableDataChanged();
        }
    }

    public class ListData {
        private boolean m_selected = false;
        private int m_status = 0;
        private String m_configDir = null;
        private String m_configLev = null;

        public ListData(boolean selected, String configDir, String configLev) {
            this.m_selected = selected;
            this.m_configDir = configDir;
            this.m_configLev = configLev;
        }

        public String getConfigDir() {
            return this.m_configDir;
        }

        public String getConfigLev() {
            return this.m_configLev;
        }

        public boolean getSelected() {
            return this.m_selected;
        }

        public void setSelected(boolean selected) {
            this.m_selected = selected;
        }

        public int getStatus() {
            return this.m_status;
        }

        public void setStatus(int status) {
            this.m_status = status;
        }
    }

    private class CheckBoxCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
                this.setSelected(false);
                this.setEnabled(false);
            } else {
                ListData data;
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (value instanceof Boolean && (data = (ListData)PanelConfigMaint.this.m_listData.get(row)) != null) {
                    this.setText(data.getConfigDir());
                    this.setSelected(data.getSelected());
                }
            }
            return this;
        }
    }

    private class CheckBoxCellEditor
    extends DefaultCellEditor {
        private JCheckBox m_checkBox;

        public CheckBoxCellEditor(JCheckBox checkBox) {
            super(checkBox);
            this.m_checkBox = null;
            this.m_checkBox = checkBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                this.m_checkBox.setText("");
                this.m_checkBox.setSelected(false);
                this.m_checkBox.setEnabled(false);
            } else {
                ListData data;
                if (isSelected) {
                    this.m_checkBox.setForeground(table.getSelectionForeground());
                    this.m_checkBox.setBackground(table.getSelectionBackground());
                } else {
                    this.m_checkBox.setForeground(table.getForeground());
                    this.m_checkBox.setBackground(table.getBackground());
                }
                if (value instanceof Boolean && (data = (ListData)PanelConfigMaint.this.m_listData.get(row)) != null) {
                    this.m_checkBox.setText(data.getConfigDir());
                    this.m_checkBox.setSelected(data.getSelected());
                }
            }
            return this.m_checkBox;
        }
    }

    class ColumnActionListener
    implements ActionListener {
        ColumnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PanelConfigMaint.this.m_selectAllButton) {
                PanelConfigMaint.this.m_listTableModel.selectAll(true);
            } else if (e.getSource() == PanelConfigMaint.this.m_clearAllButton) {
                PanelConfigMaint.this.m_listTableModel.selectAll(false);
            }
        }
    }

    private class GraphicCellRenderer
    extends DefaultTableCellRenderer {
        public GraphicCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int status = Integer.valueOf((String)value);
            switch (status) {
                case 0: {
                    this.setIcon(PanelConfigMaint.this.m_emptyIcon);
                    break;
                }
                case 1: {
                    this.setIcon(PanelConfigMaint.this.m_runningIcon);
                    break;
                }
                case 2: {
                    this.setIcon(PanelConfigMaint.this.m_successIcon);
                    break;
                }
                case 3: {
                    this.setIcon(PanelConfigMaint.this.m_failureIcon);
                    break;
                }
                case 4: {
                    this.setIcon(PanelConfigMaint.this.m_warningIcon);
                    break;
                }
                case 5: {
                    this.setIcon(PanelConfigMaint.this.m_failureIcon);
                    break;
                }
                default: {
                    this.setIcon(PanelConfigMaint.this.m_emptyIcon);
                }
            }
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }
}

