/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConfigStatus;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.KitBrowseButton;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class PanelConfigDir
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelConfigDir.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_infoText = null;
    private JTextArea m_backupText = null;
    private JLabel m_configDirLabel = null;
    private KitTextField m_configDir = null;
    private KitBrowseButton m_browseButton = null;
    private JLabel m_configLevLabel = null;
    private JComboBox m_configLev = null;
    private boolean m_panelLoaded = false;
    private String m_previousPlan = "";
    private String m_previousMachine = "";
    private String m_previousDir = "";

    public PanelConfigDir() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelConfigDir.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelConfigDir.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        String configLevDir;
        Object sasHome;
        Set<String> sasHomes;
        boolean valid = true;
        String errMsg = null;
        String configDir = Utils.trimTrailingSlashes(this.m_configDir.getText());
        String configLev = "";
        String levNum = "";
        JComponent focusObj = null;
        Globals.g_reconfigure = false;
        this.m_configDir.setText(configDir);
        if (configDir.length() == 0) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "CONFIGURATION_DIRECTORY");
            } else {
                errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelConfigDir.DirFieldName.txt"));
                focusObj = this.m_configDir;
            }
        }
        if ((sasHomes = Globals.g_wizardData.getPreferencesStartsWith("SASHome")).isEmpty() && (sasHome = System.getProperty("SASHome")) != null) {
            sasHomes.add((String)sasHome);
        }
        for (String sasHomeDir : sasHomes) {
            if (!Utils.doesDirectoryHaveParent(configDir, sasHomeDir)) continue;
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "CONFIGURATION_DIRECTORY");
                break;
            }
            errMsg = this.bundle.messageString("PanelConfigDir.ErrorConfigDirUnderSASHome.txt", sasHomeDir);
            focusObj = this.m_configDir;
            break;
        }
        if (valid) {
            if (this.m_configLev.getSelectedIndex() < 0) {
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseMissing(this.getHeader(), "CONFIGURATION_LEVEL");
                } else {
                    errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelConfigDir.LevFieldName.txt"));
                    focusObj = this.m_configLev;
                }
            } else {
                configLev = Globals.g_configLevels[this.m_configLev.getSelectedIndex()];
                levNum = Integer.toString((this.m_configLev.getSelectedIndex() + 1) % 10);
            }
        }
        if (valid) {
            if (Utils.getOS() == 6) {
                configDir = Utils.VMSToUnixPath(configDir);
            }
            if (Utils.pathContainsValidChars(configDir)) {
                valid = Utils.validatePath(configDir);
                if (!valid) {
                    if (Globals.g_quietMode) {
                        Wizard.logResponseInvalid(this.getHeader(), "CONFIGURATION_DIRECTORY", configDir, null);
                    } else {
                        errMsg = this.bundle.messageString("Common.Error.InvalidField.txt", this.bundle.getString("PanelConfigDir.DirFieldName.txt"));
                        focusObj = this.m_configDir;
                    }
                }
            } else {
                valid = false;
                if (Globals.g_quietMode) {
                    String quietMsg = null;
                    quietMsg = Utils.getOS() == 1 ? "The following characters are invalid: / : * ? \" < > |" : (Utils.getOS() == 9 ? "The following characters are invalid: \\ :" : "The following characters are invalid: <space> % * \" & ? : < > \\ | ( )");
                    Wizard.logResponseInvalid(this.getHeader(), "CONFIGURATION_DIRECTORY", configDir, quietMsg);
                } else {
                    errMsg = Utils.getOS() == 1 ? this.bundle.messageString("Common.Error.InvalidChars.Windows.txt", this.bundle.getString("PanelConfigDir.DirFieldName.txt")) : (Utils.getOS() == 9 ? this.bundle.messageString("Common.Error.InvalidChars.Mac.txt", this.bundle.getString("PanelConfigDir.DirFieldName.txt")) : this.bundle.messageString("Common.Error.InvalidChars.UNIX.txt", this.bundle.getString("PanelConfigDir.DirFieldName.txt")));
                    focusObj = this.m_configDir;
                }
            }
        }
        if (valid && (new File(configDir, "configuration.properties").isFile() || new File(configDir, "instructions.html").isFile())) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "CONFIGURATION_DIRECTORY", configDir, "The specified configuration directory contains an existing 9.1 configuration.");
            } else {
                errMsg = this.bundle.getString("PanelConfigDir.LegacyConfigDir.txt");
                focusObj = this.m_configDir;
            }
        }
        if (valid && !Globals.g_skipVerCheck) {
            ProductData prodData = Globals.g_deploymentData.getProduct(Globals.g_order, "deploywiz", false);
            String sdmVer = prodData.getProdCustVersion();
            if (sdmVer != null && sdmVer.length() > 3) {
                sdmVer = sdmVer.substring(0, 3);
            }
            String configVer = null;
            try {
                String utilitiesDir = Utils.joinPath(configDir, configLev, "Utilities");
                File propsFile = new File(utilitiesDir, "configuration.properties");
                if (propsFile.isFile()) {
                    FileInputStream fileInStream = new FileInputStream(propsFile);
                    Properties configProps = new Properties();
                    configProps.load(fileInStream);
                    fileInStream.close();
                    configVer = configProps.getProperty("deploywiz.version", null);
                    if (configVer != null && configVer.length() > 3) {
                        configVer = configVer.substring(0, 3);
                    }
                }
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
            if (sdmVer != null && configVer != null && !sdmVer.equals(configVer)) {
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), "CONFIGURATION_DIRECTORY", configDir, "The specified configuration directory contains an existing 9.2 configuration.");
                } else {
                    errMsg = this.bundle.getString("PanelConfigDir.Legacy92ConfigDir.txt");
                    focusObj = this.m_configDir;
                }
            }
        }
        if (valid && !(valid = Utils.canWriteToPath(configDir))) {
            if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "CONFIGURATION_DIRECTORY", configDir, "Insufficient permission to write to the Configuration Directory specified.");
            } else {
                errMsg = this.bundle.messageString("Common.Error.NoPermissions.txt", this.bundle.getString("PanelConfigDir.DirFieldName.txt"));
                focusObj = this.m_configDir;
            }
        }
        if (valid && !(valid = Utils.canWriteToPath(Utils.joinPath(configDir, configLev)))) {
            if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "CONFIGURATION_LEVEL", configLev, "Insufficient permission to write to the Configuration Level specified.");
            } else {
                errMsg = this.bundle.messageString("Common.Error.NoPermissions.txt", this.bundle.getString("PanelConfigDir.LevFieldName.txt"));
                focusObj = this.m_configLev;
            }
        }
        if (valid) {
            File configDirPlusLev = new File(Utils.joinPath(configDir, configLev));
            boolean isFirstOnMachine = true;
            if (Globals.g_machine != null && Globals.g_stepNumber != null) {
                isFirstOnMachine = Globals.g_machine.isStepFirstOnMachine(Globals.g_stepNumber);
            }
            if (Utils.pathContainsFiles(configDirPlusLev)) {
                if (isFirstOnMachine) {
                    valid = this.confirmPrompt(this.bundle.getString("PanelConfigDir.ExistingFilesMsg.txt"));
                }
                if (valid) {
                    Globals.g_reconfigure = true;
                } else {
                    focusObj = this.m_configLev;
                }
            } else if (!isFirstOnMachine) {
                valid = this.confirmPrompt(this.bundle.getString("PanelConfigDir.InitialStepNotRun.txt"));
                if (valid) {
                    Globals.g_reconfigure = true;
                } else {
                    focusObj = this.m_configLev;
                }
            }
        }
        if (valid && !(configLevDir = Utils.joinPath(configDir, configLev)).equals(this.m_previousDir)) {
            try {
                File statusFile = new File(configLevDir, Utils.joinPath("ConfigData", "status.xml"));
                Globals.g_configStatus = new ConfigStatus(statusFile);
                ConfigStatus.StatusEntry[] statusEntries = Globals.g_configStatus.getStatusEntries();
                boolean found = false;
                String code = null;
                for (int i = 0; i < statusEntries.length && !found; ++i) {
                    code = statusEntries[i].getCode();
                    if (!code.equalsIgnoreCase("levdirroot")) continue;
                    found = true;
                    String fqid = statusEntries[i].getFQID();
                    Globals.g_configData.setProperty("levdirroot.configobj.fqid", fqid);
                    Logging.log.info("FQID from status.xml added as levdirroot.configobj.fqid = " + fqid);
                }
                if (!found) {
                    Globals.g_configData.removeProperty("levdirroot.configobj.fqid");
                }
            }
            catch (Exception e) {
                valid = false;
                Globals.g_configData.removeProperty("levdirroot.configobj.fqid");
                Logging.logStackTrace(e);
            }
            this.m_previousDir = configLevDir;
        }
        if (valid) {
            String configDirName = new File(configDir).getName();
            Globals.g_configData.setProperty("config.dir.name", configDirName);
            Globals.g_configData.setProperty("config.home.dir", configDir);
            Globals.g_configData.setProperty("config.level.name", configLev);
            Globals.g_configData.setProperty("config.level.num", levNum);
        } else if (!Globals.g_quietMode) {
            if (errMsg != null) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
            }
            if (focusObj != null) {
                focusObj.requestFocus();
            }
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        return "selectconfigs";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (Globals.g_plan != null && !this.m_previousPlan.equals(Globals.g_plan.getFile())) {
            this.m_configDir.setText(this.getConfigDirDefault());
        }
        if (Globals.g_plan != null && !this.m_previousPlan.equals(Globals.g_plan.getFile()) || Globals.g_machine != null && !this.m_previousMachine.equals(Globals.g_machine.getName())) {
            boolean showBackupText = true;
            if (Globals.g_planConfigs != null) {
                for (int i = 0; i < Globals.g_planConfigs.length && showBackupText; ++i) {
                    if (!Globals.g_planConfigs[i].equalsIgnoreCase("metadatasrv")) continue;
                    showBackupText = false;
                }
            }
            this.m_backupText.setVisible(showBackupText);
            if (Globals.g_plan != null) {
                this.m_previousPlan = Globals.g_plan.getFile();
            }
            if (Globals.g_machine != null) {
                this.m_previousMachine = Globals.g_machine.getName();
            }
        }
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            if (this.m_configLev.getSelectedIndex() < 0) {
                this.m_configLev.setSelectedIndex(0);
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_configDir;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        if (Globals.g_quietMode && Globals.g_recordMode) {
            return null;
        }
        String[] data = new String[]{"#CONFIGURATION_DIRECTORY=<full path>", " CONFIGURATION_DIRECTORY=", "#CONFIGURATION_LEVEL=<subdirectory>", " CONFIGURATION_LEVEL="};
        if (this.m_panelLoaded) {
            data[1] = " CONFIGURATION_DIRECTORY=" + this.m_configDir.getText();
            data[3] = " CONFIGURATION_LEVEL=" + Globals.g_configLevels[this.m_configLev.getSelectedIndex()];
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int returnCode = 0;
        returnCode = ConsoleMode.promptText(this.m_configDirLabel.getText(), this.m_configDir);
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptComboBox(this.m_configLev);
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String responseConfigDir = Wizard.getResponse("CONFIGURATION_DIRECTORY", null);
        if (responseConfigDir != null) {
            valid = true;
            this.m_configDir.setText(responseConfigDir);
        } else if (Globals.g_quietMode) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "CONFIGURATION_DIRECTORY");
        }
        String responseConfigLev = Wizard.getResponse("CONFIGURATION_LEVEL", null);
        if (responseConfigLev != null) {
            boolean found = false;
            for (int i = 0; i < Globals.g_configLevels.length && !found; ++i) {
                if (!responseConfigLev.equalsIgnoreCase(Globals.g_configLevels[i])) continue;
                found = true;
                this.m_configLev.setSelectedIndex(i);
            }
            if (!found) {
                Wizard.logResponseInvalid(this.getHeader(), "CONFIGURATION_LEVEL", responseConfigLev, null);
            }
        } else if (Globals.g_quietMode) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "CONFIGURATION_LEVEL");
        }
        return valid;
    }

    private void initialize() {
        this.m_infoText = new JTextArea(this.bundle.getString("PanelConfigDir.Instructions.txt"));
        this.m_infoText.setEditable(false);
        this.m_infoText.setFocusable(false);
        this.m_infoText.setLineWrap(true);
        this.m_infoText.setWrapStyleWord(true);
        this.m_infoText.setOpaque(false);
        this.m_backupText = new JTextArea(this.bundle.getString("PanelConfigDir.Backup.txt"));
        this.m_backupText.setEditable(false);
        this.m_backupText.setFocusable(false);
        this.m_backupText.setLineWrap(true);
        this.m_backupText.setWrapStyleWord(true);
        this.m_backupText.setOpaque(false);
        this.m_configDir = new KitTextField();
        if (Utils.getOS() == 8) {
            this.m_configDir.setDocument(new MaxLengthDocument(56));
        }
        String mtxt = this.bundle.getString("PanelConfigDir.ConfigDirLabel.txt");
        this.m_configDirLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_configDirLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_configDirLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_configDirLabel.setLabelFor(this.m_configDir);
        mtxt = this.bundle.getString("Common.Browse1.txt");
        this.m_browseButton = new KitBrowseButton(Util.getLabelWithoutMnemonic(mtxt), "", 0, this.m_configDir);
        this.m_browseButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_browseButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_browseButton.setFileSelectionMode(1);
        this.m_configLev = new JComboBox();
        this.loadComboBox();
        mtxt = this.bundle.getString("PanelConfigDir.ConfigLevLabel.txt");
        this.m_configLevLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_configLevLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_configLevLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_configLevLabel.setLabelFor(this.m_configLev);
    }

    private String getConfigDirDefault() {
        String configDirectory;
        String configDir = "";
        if (Globals.g_plan != null && (configDirectory = Globals.g_plan.getProperty("ConfigDirectory")) != null) {
            configDir = Utils.getOS() == 1 ? Utils.joinPath(Globals.g_windowsSystemDrive, "SAS", configDirectory) : Utils.joinPath("/usr/local", configDirectory.toLowerCase(Locale.ENGLISH));
        }
        return configDir;
    }

    private void loadComboBox() {
        this.m_configLev.removeAllItems();
        for (int i = 0; i < Globals.g_configLevels.length; ++i) {
            this.m_configLev.addItem(Globals.g_configLevels[i]);
        }
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.weighty = 0.0;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_infoText, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_backupText, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_configDirLabel, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_configDir, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_panel.add((Component)this.m_browseButton, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_configLevLabel, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_configLev, c);
    }

    private boolean confirmPrompt(String message) {
        boolean valid = true;
        if (this.m_panelLoaded && !Globals.g_quietMode && CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), message, Globals.g_wizard.getWizardTitle(), 0, 3, 0) == 1) {
            valid = false;
        }
        return valid;
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    class MaxLengthDocument
    extends PlainDocument {
        private int m_maxLength = 0;

        public MaxLengthDocument(int maxLength) {
            this.m_maxLength = maxLength;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (super.getLength() + str.length() <= this.m_maxLength) {
                super.insertString(offs, str, a);
            } else {
                super.insertString(offs, str.substring(0, this.m_maxLength - super.getLength()), a);
            }
        }
    }
}

