/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import com.sas.util.SasPasswordString;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class PanelChangePassPhrase
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelChangePassPhrase.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JLabel m_passwordLabel = null;
    private JPasswordField m_passwordField = null;
    private JLabel m_confirmLabel = null;
    private JPasswordField m_confirmField = null;
    private boolean m_panelLoaded = false;

    public PanelChangePassPhrase() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelChangePassPhrase.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelChangePassPhrase.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        int resp;
        boolean valid = true;
        String password = null;
        String confirm = null;
        String errMsg = null;
        password = String.valueOf(this.m_passwordField.getPassword());
        if (!password.equals(confirm = String.valueOf(this.m_confirmField.getPassword()))) {
            valid = false;
            errMsg = this.bundle.getString("PanelChangePassPhrase.PassphraseInvalid.txt");
        } else if (password.length() == 0 && !Globals.g_quietMode && (resp = CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelChangePassPhrase.ConfirmClearPassPhrase.txt"), this.bundle.getString("Common.Warning.txt"), 0)) == 1) {
            valid = false;
        }
        if (valid) {
            if (!SasPasswordString.isEncoded(password)) {
                try {
                    password = SasPasswordString.encode("sas002", password);
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
            }
        } else if (!Globals.g_quietMode) {
            if (errMsg != null) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
            }
            this.m_passwordField.requestFocus();
        }
        if (valid) {
            Globals.g_configData.setProperty("metadata.new.passphrase", password);
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String panelID = "execute";
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_passwordField;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#PASSPHRASE=<passphrase value>", " PASSPHRASE="};
        if (this.m_panelLoaded) {
            String value = String.valueOf(this.m_passwordField.getPassword());
            try {
                if (!SasPasswordString.isEncoded(value)) {
                    value = SasPasswordString.encode("sas002", value);
                }
                data[1] = " PASSPHRASE=" + value;
            }
            catch (Exception e) {
                Logging.log.severe("Unable to encode the password for: PASSPHRASE");
                Logging.logStackTrace(e);
            }
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int returnCode = 0;
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptPassword(this.m_passwordLabel.getText(), this.m_passwordField);
        }
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptPassword(this.m_confirmLabel.getText(), this.m_confirmField);
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        String response = Wizard.getResponse("PASSPHRASE", null);
        if (response != null) {
            String decodedPassword = null;
            try {
                decodedPassword = SasPasswordString.decode(response);
                this.m_passwordField.setText(decodedPassword);
                this.m_confirmField.setText(decodedPassword);
            }
            catch (Exception e) {
                Logging.log.warning("Unable to decode the password for: PASSPHRASE");
                Logging.logStackTrace(e);
            }
        } else {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "PASSPHRASE");
            }
        }
        return valid;
    }

    private void initialize() {
        this.m_passwordField = new JPasswordField();
        String mtxt = this.bundle.getString("PanelChangePassPhrase.PassphraseLabel.txt");
        this.m_passwordLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_passwordLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_passwordLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_passwordLabel.setLabelFor(this.m_passwordField);
        this.m_confirmField = new JPasswordField();
        mtxt = this.bundle.getString("PanelChangePassPhrase.ConfirmLabel.txt");
        this.m_confirmLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_confirmLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_confirmLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_confirmLabel.setLabelFor(this.m_confirmField);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        c.gridy = 2;
        this.m_panel.add((Component)this.m_passwordLabel, c);
        c.gridy = 3;
        this.m_panel.add((Component)this.m_passwordField, c);
        c.gridy = 4;
        this.m_panel.add((Component)this.m_confirmLabel, c);
        c.gridy = 5;
        this.m_panel.add((Component)this.m_confirmField, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

