/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.PanelSDMStart;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardCallbackIface;
import com.sas.ssn.WizardPanelIface;
import com.sas.ssn.ssl.CertFileBrowseButton;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class PanelCertificateRemove
implements WizardPanelIface,
WizardCallbackIface {
    public static final String BUNDLE_KEY_HEADER = "PanelCertificateRemove.Header.txt";
    public static final String BUNDLE_KEY_HEADER_DESC = "PanelCertificateRemove.HeaderDesc.txt";
    public static final String BUNDLE_KEY_INFO = "PanelCertificateRemove.Info.txt";
    public static final String BUNDLE_KEY_CERT_LOC_LABEL = "PanelCertificateRemove.CertLocLabel.txt";
    public static final String BUNDLE_KEY_FIELD_NAME = "PanelCertificateRemove.FieldName.txt";
    public static final String BUNDLE_KEY_INVALID_SELECTION_FILE_DOES_NOT_EXIT = "PanelCertificateRemove.InvalidSelection.FileDoesNotExist.txt";
    public static final String BUNDLE_KEY_INVALID_SELECTION_DIRECTORY_SELECTED = "PanelCertificateRemove.InvalidSelection.DirectorySelected.txt";
    public static final String BUNDLE_KEY_INVALID_SELECTION_INVALID_DIRECTORY_SELECTED = "PanelCertificateRemove.InvalidSelection.InvalidDirectorySelected.txt";
    public static final String BUNDLE_KEY_INVALID_SELECTION_REMOVE_CERTIFICATE_NOT_ALLOWED = "PanelCertificateRemove.InvalidSelection.RemoveCertificateNotAllowed.txt";
    public static final String BUNDLE_KEY_FILE_LOAD_FAILED = "PanelCertificateRemove.FileLoadFailed.txt";
    private SSNResource bundle;
    private JPanel m_panel;
    private JLabel m_warningImage;
    private JTextArea m_certRemoveInfo;
    private JLabel m_certRemoveLabel;
    private KitTextField m_certsDirCtrl;
    private CertFileBrowseButton m_browseButton;
    private boolean m_panelLoaded;
    private String m_certFrameCertsDirStr;
    private String m_sasHomeDirStr;

    public PanelCertificateRemove() {
        Logging.log.fine("PanelCertificateRemove(): BEGIN");
        this.bundle = new SSNResource(PanelSDMStart.class);
        this.m_panel = new JPanel(new GridBagLayout());
        this.m_warningImage = null;
        this.m_certRemoveInfo = null;
        this.m_certRemoveLabel = null;
        this.m_certsDirCtrl = null;
        this.m_browseButton = null;
        this.m_panelLoaded = false;
        this.m_certFrameCertsDirStr = null;
        this.m_sasHomeDirStr = null;
        this.initialize();
        this.layoutWidgets();
        Logging.log.fine("PanelCertificateRemove(): END");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        String mtxt = null;
        String certFrameCertsDirStr = null;
        this.m_warningImage = new JLabel();
        this.m_warningImage.setIcon(this.bundle.getImageIcon("Common.info_small.image"));
        this.m_certRemoveInfo = new JTextArea(this.bundle.getString(BUNDLE_KEY_INFO));
        this.m_certRemoveInfo.setEditable(false);
        this.m_certRemoveInfo.setFocusable(false);
        this.m_certRemoveInfo.setLineWrap(true);
        this.m_certRemoveInfo.setWrapStyleWord(true);
        this.m_certRemoveInfo.setOpaque(false);
        this.m_certsDirCtrl = new KitTextField();
        mtxt = this.bundle.getString(BUNDLE_KEY_CERT_LOC_LABEL);
        this.m_certRemoveLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_certRemoveLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_certRemoveLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_certRemoveLabel.setLabelFor(this.m_certsDirCtrl);
        try (RegistryAccess registryAccess = null;){
            RegistryData.setRegistry(Globals.g_cmtSASHome);
            registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
            if (registryAccess != null && registryAccess.open()) {
                ProductData prodData = Globals.g_deploymentData.getProduct(Globals.g_order, "certframe", true);
                String[] versions = registryAccess.getInstallVersions("certframe");
                String latestRegistryVersion = null;
                if (versions != null && versions.length > 0) {
                    List<String> al = Arrays.asList(versions);
                    Collections.sort(al);
                    latestRegistryVersion = al.get(al.size() - 1);
                }
                certFrameCertsDirStr = registryAccess.getInstallLoc("certframe", latestRegistryVersion, prodData.getPlatform());
                Logging.log.fine("PanelCertificateRemove.initialize(): certframe install loc = " + certFrameCertsDirStr);
                if (certFrameCertsDirStr == null) {
                    Logging.log.severe("PanelCertificateRemove.initialize(): certframe install loc not found");
                    throw new Exception("certframe install loc not found");
                }
            }
            certFrameCertsDirStr = Utils.joinPath(certFrameCertsDirStr, "cacerts");
            this.m_certFrameCertsDirStr = certFrameCertsDirStr = certFrameCertsDirStr.replaceAll(Pattern.compile("^/(\\.\\.?/)+").toString(), "/");
            Logging.log.fine("PanelCertificateRemove.initialize(): certs dir = " + this.m_certFrameCertsDirStr);
        }
        if (this.m_certFrameCertsDirStr != null) {
            this.m_certsDirCtrl.setText(this.m_certFrameCertsDirStr);
            this.m_certsDirCtrl.setEditable(true);
            this.m_certsDirCtrl.setFocusable(false);
        } else {
            this.m_certsDirCtrl.setText(this.m_sasHomeDirStr);
        }
        mtxt = this.bundle.getString("Common.Browse1.txt");
        this.m_browseButton = new CertFileBrowseButton(Util.getLabelWithoutMnemonic(mtxt), this.m_certFrameCertsDirStr, this.m_certsDirCtrl);
        this.m_browseButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_browseButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_browseButton.setCallbackPanel(this);
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString(BUNDLE_KEY_HEADER);
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString(BUNDLE_KEY_HEADER_DESC);
    }

    @Override
    public boolean validateData() {
        boolean validCertFileBoolean = true;
        String errMsg = null;
        String chosenCertFileStr = Utils.trimTrailingSlashes(this.m_certsDirCtrl.getText());
        this.m_certsDirCtrl.setText(chosenCertFileStr);
        File chosenCertFile = new File(chosenCertFileStr);
        if (!chosenCertFile.exists()) {
            validCertFileBoolean = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "CERTIFICATE_TO_REMOVE");
            } else {
                errMsg = this.bundle.getString(BUNDLE_KEY_INVALID_SELECTION_FILE_DOES_NOT_EXIT);
            }
        } else if (chosenCertFile.isDirectory()) {
            validCertFileBoolean = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "CERTIFICATE_TO_REMOVE", chosenCertFileStr, this.bundle.getString(BUNDLE_KEY_INVALID_SELECTION_DIRECTORY_SELECTED));
            } else {
                errMsg = this.bundle.getString(BUNDLE_KEY_INVALID_SELECTION_DIRECTORY_SELECTED);
            }
        } else if (chosenCertFile.isFile()) {
            Logging.log.fine("PanelCertificateRemove.validateData(): validating chosen cert to remove");
            if (!this.validateDirectory(chosenCertFile)) {
                validCertFileBoolean = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), "CERTIFICATE_TO_REMOVE", chosenCertFileStr, this.bundle.messageString(BUNDLE_KEY_INVALID_SELECTION_INVALID_DIRECTORY_SELECTED, this.m_certFrameCertsDirStr));
                } else {
                    errMsg = this.bundle.messageString(BUNDLE_KEY_INVALID_SELECTION_INVALID_DIRECTORY_SELECTED, this.m_certFrameCertsDirStr);
                }
            } else {
                StringBuffer strBuf1 = new StringBuffer("cacerts.pem");
                StringBuffer strBuf2 = new StringBuffer("cacerts.p12");
                StringBuffer strBuf3 = new StringBuffer("trustedcerts.pem");
                StringBuffer strBuf4 = new StringBuffer("trustedcerts.p12");
                String chosenCertFileStrLowerCase = chosenCertFile.getName().toLowerCase();
                if (chosenCertFileStrLowerCase.equals(new String(strBuf1).toLowerCase()) || chosenCertFileStrLowerCase.equals(new String(strBuf2).toLowerCase()) || chosenCertFileStrLowerCase.equals(new String(strBuf3).toLowerCase()) || chosenCertFileStrLowerCase.equals(new String(strBuf4).toLowerCase())) {
                    validCertFileBoolean = false;
                    if (Globals.g_quietMode) {
                        Wizard.logResponseInvalid(this.getHeader(), "CERTIFICATE_TO_REMOVE", chosenCertFileStr, this.bundle.messageString(BUNDLE_KEY_INVALID_SELECTION_REMOVE_CERTIFICATE_NOT_ALLOWED, chosenCertFileStrLowerCase));
                    } else {
                        errMsg = this.bundle.messageString(BUNDLE_KEY_INVALID_SELECTION_REMOVE_CERTIFICATE_NOT_ALLOWED, chosenCertFileStrLowerCase);
                    }
                }
            }
        }
        if (!validCertFileBoolean && !Globals.g_quietMode) {
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
        }
        if (validCertFileBoolean && Globals.g_quietMode) {
            this.updateTextArea();
        }
        this.m_certsDirCtrl.requestFocus();
        return validCertFileBoolean;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = "execute";
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            if (this.m_certsDirCtrl.getText().length() == 0) {
                this.m_certsDirCtrl.setText(this.m_sasHomeDirStr);
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        KitTextField focus = null;
        focus = this.m_certsDirCtrl;
        return focus;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#CERTIFICATE_TO_REMOVE=<full path>", " CERTIFICATE_TO_REMOVE="};
        if (this.m_panelLoaded) {
            data[1] = " CERTIFICATE_TO_REMOVE=" + this.m_certsDirCtrl.getText();
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int returnCode = 0;
        returnCode = ConsoleMode.promptText(this.m_certRemoveLabel.getText(), this.m_certsDirCtrl);
        if (returnCode == 0) {
            this.updateTextArea();
        }
        return returnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateCert(File chosenCertFile) {
        boolean retVal = true;
        FileInputStream inStream = null;
        CertificateFactory cf = null;
        X509Certificate cert = null;
        String chosenCertFileStr = chosenCertFile.getName();
        try {
            inStream = new FileInputStream(chosenCertFile);
            cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(inStream);
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
            retVal = false;
        }
        finally {
            try {
                if (inStream != null) {
                    ((InputStream)inStream).close();
                }
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
        return retVal;
    }

    private boolean validateDirectory(File chosenCertFile) {
        boolean retVal = true;
        String certFilePathStr = null;
        String certFileNameStr = null;
        String certFilePathMinusNameStr = null;
        String certFrameInstallDirStr = Utils.trimTrailingSlashes(this.m_certFrameCertsDirStr);
        try {
            certFilePathStr = chosenCertFile.getAbsolutePath();
            certFileNameStr = chosenCertFile.getName();
            int endIndex = certFilePathStr.lastIndexOf(certFileNameStr);
            certFilePathMinusNameStr = certFilePathStr.substring(0, endIndex);
            certFilePathMinusNameStr = Utils.trimTrailingSlashes(certFilePathMinusNameStr);
            if (!certFilePathMinusNameStr.equals(certFrameInstallDirStr)) {
                retVal = false;
            }
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
            retVal = false;
        }
        return retVal;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("CERTIFICATE_TO_REMOVE", null);
        if (response != null) {
            this.m_certsDirCtrl.setText(response);
            valid = true;
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), "CERTIFICATE_TO_REMOVE");
        }
        return valid;
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        c.gridwidth = 2;
        this.m_panel.add((Component)this.m_certRemoveInfo, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        c.gridwidth = 1;
        this.m_panel.add((Component)this.m_certRemoveLabel, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_certsDirCtrl, c);
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_panel.add((Component)this.m_browseButton, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    @Override
    public void updateTextArea() {
        String chosenFileStr = this.m_certsDirCtrl.getText();
        Globals.g_installData.setProperty("certframe.remove.file", chosenFileStr);
    }
}

