/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanelAutoloadLasrArtifacts
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelAutoloadLasrArtifacts.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JLabel m_lasrArtifactsLabel = null;
    private JComboBox m_lasrArtifactsField = null;
    private boolean m_panelLoaded = false;

    public PanelAutoloadLasrArtifacts() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelAutoloadLasrArtifacts.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelAutoloadLasrArtifacts.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        String errMsg = null;
        String response = null;
        String artifactType = (String)this.m_lasrArtifactsField.getSelectedItem();
        if (artifactType == null || artifactType.length() <= 0) {
            valid = false;
            response = "LASR_ARTIFACTS";
            errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelAutoloadLasrArtifacts.LasrArtifactsField.txt"));
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), response);
            } else {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
            }
        } else if (!(artifactType.equalsIgnoreCase(this.bundle.getString("PanelAutoloadLasrArtifacts.DistributedArtifactsType.txt")) || artifactType.equalsIgnoreCase(this.bundle.getString("PanelAutoloadLasrArtifacts.NonDistributedArtifactsType.txt")) || artifactType.equalsIgnoreCase(this.bundle.getString("PanelAutoloadLasrArtifacts.PreExistingArtifactsType.txt")))) {
            valid = false;
            response = "LASR_ARTIFACTS";
            errMsg = this.bundle.messageString("PanelAutoloadLasrArtifacts.responseInvalidNotes.txt", this.bundle.getString("PanelAutoloadLasrArtifacts.NonDistributedArtifactsType.txt"), this.bundle.getString("PanelAutoloadLasrArtifacts.DistributedArtifactsType.txt"), this.bundle.getString("PanelAutoloadLasrArtifacts.PreExistingArtifactsType.txt"));
            if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), this.bundle.getString("PanelAutoloadLasrArtifacts.LasrArtifactsField.txt"), artifactType, response);
            } else {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
            }
        } else if (artifactType.equalsIgnoreCase(this.bundle.getString("PanelAutoloadLasrArtifacts.DistributedArtifactsType.txt"))) {
            Globals.g_configData.setProperty("cfgwizard.lasrserver.type", "cfgwizard.lasrmpp");
        } else if (artifactType.equalsIgnoreCase(this.bundle.getString("PanelAutoloadLasrArtifacts.NonDistributedArtifactsType.txt"))) {
            Globals.g_configData.setProperty("cfgwizard.lasrserver.type", "cfgwizard.lasrsmp");
        } else if (artifactType.equalsIgnoreCase(this.bundle.getString("PanelAutoloadLasrArtifacts.PreExistingArtifactsType.txt"))) {
            Globals.g_configData.setProperty("cfgwizard.lasrserver.type", "cfgwizard.lasrnone");
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String lasrServerType = Globals.g_configData.getProperty("cfgwizard.lasrserver.type", null);
        if (lasrServerType != null && lasrServerType.equalsIgnoreCase("cfgwizard.lasrnone")) {
            return "autoloadexistinglibrary";
        }
        return "autoloadlasrserver";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_lasrArtifactsField;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#LASR_ARTIFACTS=<string value>, one of: " + this.bundle.getString("PanelAutoloadLasrArtifacts.NonDistributedArtifactsType.txt") + ", " + this.bundle.getString("PanelAutoloadLasrArtifacts.DistributedArtifactsType.txt") + ", or " + this.bundle.getString("PanelAutoloadLasrArtifacts.PreExistingArtifactsType.txt"), " LASR_ARTIFACTS="};
        if (this.m_panelLoaded) {
            data[1] = " LASR_ARTIFACTS=" + (String)this.m_lasrArtifactsField.getSelectedItem();
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int returnCode = ConsoleMode.promptComboBox(this.m_lasrArtifactsField);
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        String response = Wizard.getResponse("LASR_ARTIFACTS", null);
        if (response != null) {
            this.m_lasrArtifactsField.setSelectedItem(response);
        } else if (Globals.g_quietMode) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "LASR_ARTIFACTS");
        }
        return valid;
    }

    private void initialize() {
        this.m_lasrArtifactsField = new JComboBox();
        this.m_lasrArtifactsField.removeAllItems();
        this.m_lasrArtifactsField.addItem(this.bundle.getString("PanelAutoloadLasrArtifacts.NonDistributedArtifactsType.txt"));
        this.m_lasrArtifactsField.addItem(this.bundle.getString("PanelAutoloadLasrArtifacts.DistributedArtifactsType.txt"));
        this.m_lasrArtifactsField.addItem(this.bundle.getString("PanelAutoloadLasrArtifacts.PreExistingArtifactsType.txt"));
        this.m_lasrArtifactsField.setSelectedItem(0);
        String mtxt = this.bundle.getString("PanelAutoloadLasrArtifacts.LasrArtifactsLabel.txt");
        this.m_lasrArtifactsLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_lasrArtifactsLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_lasrArtifactsLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_lasrArtifactsLabel.setLabelFor(this.m_lasrArtifactsField);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_lasrArtifactsLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_lasrArtifactsField, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

