/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class PanelAccountType
implements WizardPanelIface {
    private final String RESPONSE_SINGLE = "single";
    private final String RESPONSE_MULTIPLE = "multiple";
    private SSNResource bundle = new SSNResource(PanelAccountType.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_infoText = null;
    private JRadioButton m_singleAccount = null;
    private JTextArea m_singleInfo = null;
    private JRadioButton m_multipleAccounts = null;
    private JTextArea m_multipleInfo = null;
    private boolean m_panelLoaded = false;

    public PanelAccountType() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelAccountType.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelAccountType.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        Globals.g_singleAccount = this.m_singleAccount.isSelected();
        if (this.m_singleAccount.isSelected()) {
            Globals.g_configData.setProperty("config.singlelogin.is_enabled", "True");
        } else {
            Globals.g_configData.setProperty("config.singlelogin.is_enabled", "False");
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        String singleUserID;
        boolean display = false;
        Globals.g_singleAccount = false;
        if (Globals.g_plan != null && (singleUserID = Globals.g_plan.getProperty("plan.singlelogin.mode")) != null) {
            if (singleUserID.equalsIgnoreCase("true")) {
                display = true;
            } else if (singleUserID.equalsIgnoreCase("force")) {
                Globals.g_singleAccount = true;
                Globals.g_configData.setProperty("config.singlelogin.is_enabled", "True");
            }
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        return "configoption";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            if (!this.loadResponseData()) {
                this.m_singleAccount.setSelected(true);
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        JRadioButton focus = null;
        focus = this.m_singleAccount.isSelected() ? this.m_singleAccount : this.m_multipleAccounts;
        return focus;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        if (Globals.g_quietMode && Globals.g_recordMode) {
            return null;
        }
        String[] data = new String[]{"#ACCOUNT_TYPE=single/multiple", " ACCOUNT_TYPE=single"};
        if (this.m_panelLoaded && this.m_multipleAccounts.isSelected()) {
            data[1] = " ACCOUNT_TYPE=multiple";
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_singleAccount, this.m_multipleAccounts};
        JTextArea[] infos = new JTextArea[]{this.m_singleInfo, this.m_multipleInfo};
        return ConsoleMode.promptRadioButtons(options, infos);
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("ACCOUNT_TYPE", null);
        if (response != null) {
            if (response.equalsIgnoreCase("single")) {
                valid = true;
                this.m_singleAccount.setSelected(true);
            } else if (response.equalsIgnoreCase("multiple")) {
                valid = true;
                this.m_multipleAccounts.setSelected(true);
            } else if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "ACCOUNT_TYPE", response, null);
            }
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), "ACCOUNT_TYPE");
        }
        return valid;
    }

    private void initialize() {
        this.m_infoText = new JTextArea(this.bundle.getString("PanelAccountType.Info.txt"));
        this.m_infoText.setEditable(false);
        this.m_infoText.setFocusable(false);
        this.m_infoText.setLineWrap(true);
        this.m_infoText.setWrapStyleWord(true);
        this.m_infoText.setOpaque(false);
        String mtxt = this.bundle.getString("PanelAccountType.SingleAccount.txt");
        this.m_singleAccount = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_singleAccount.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_singleAccount.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_singleAccount.getFont();
        this.m_singleAccount.setFont(optionFont.deriveFont(1));
        this.m_singleInfo = new JTextArea(this.bundle.getString("PanelAccountType.SingleInfo.txt"));
        this.m_singleInfo.setEditable(false);
        this.m_singleInfo.setFocusable(false);
        this.m_singleInfo.setLineWrap(true);
        this.m_singleInfo.setWrapStyleWord(true);
        this.m_singleInfo.setOpaque(false);
        mtxt = this.bundle.getString("PanelAccountType.MultipleAccounts.txt");
        this.m_multipleAccounts = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_multipleAccounts.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_multipleAccounts.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_multipleAccounts.getFont();
        this.m_multipleAccounts.setFont(optionFont.deriveFont(1));
        this.m_multipleInfo = new JTextArea(this.bundle.getString("PanelAccountType.MultipleInfo.txt"));
        this.m_multipleInfo.setEditable(false);
        this.m_multipleInfo.setFocusable(false);
        this.m_multipleInfo.setLineWrap(true);
        this.m_multipleInfo.setWrapStyleWord(true);
        this.m_multipleInfo.setOpaque(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_singleAccount);
        group.add(this.m_multipleAccounts);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_infoText, c);
        c.gridy = 1;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_singleAccount, c);
        c.gridy = 2;
        c.insets = new Insets(5, 20, 5, 0);
        this.m_panel.add((Component)this.m_singleInfo, c);
        c.gridy = 3;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_multipleAccounts, c);
        c.gridy = 4;
        c.insets = new Insets(5, 20, 0, 0);
        this.m_panel.add((Component)this.m_multipleInfo, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

