/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.OsLevelCheck;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class OsLevelConfirm {
    private static SSNResource bundle = new SSNResource(OsLevelConfirm.class);
    private static long osMajorVersion = 0L;
    private static long osMinorVersion = 0L;
    private static long ServicePackMajor = 0L;
    private static long ServicePackMinor = 0L;
    private static long SuiteMask = 0L;
    private static long ProductType = 0L;
    private static long ProcessorArchitecture = 0L;
    private static long ProductInfo = 0L;
    private static final long VER_NT_WORKSTATION = 1L;
    public static boolean skiposlevelcheck = false;
    private static String minOSDescription = "";
    private static String currentOsDescription = "";
    private static String errmsg = null;

    public static boolean checkOsVersion() {
        if (skiposlevelcheck) {
            return true;
        }
        if (Utils.getOS(true) == 9 || Utils.getOS(true) == 8) {
            return true;
        }
        boolean result = true;
        if (Utils.getOS(true) == 1) {
            if (OsLevelCheck.getOsVersionAndSplit()) {
                osMajorVersion = OsLevelCheck.getMajorReleaseVersion();
                osMinorVersion = OsLevelCheck.getMinorReleaseVersion();
                ServicePackMajor = OsLevelCheck.getServicePackMajor();
                ServicePackMinor = OsLevelCheck.getServicePackMinor();
                SuiteMask = OsLevelCheck.getSuiteMask();
                ProductType = OsLevelCheck.getProductType();
                ProcessorArchitecture = OsLevelCheck.getProcessorArchitecture();
                ProductInfo = OsLevelCheck.getProductInfo();
                OrderTypes orderType = OsLevelConfirm.orderType();
                if (orderType == OrderTypes.SAS) {
                    result = OsLevelConfirm.checkAgainstSAS();
                }
            }
        } else {
            OrderTypes orderType = OsLevelConfirm.orderType();
            if (orderType == OrderTypes.SAS) {
                result = OsLevelConfirm.checkAgainstSASUnx();
            }
        }
        if (!result) {
            Logging.log.warning("This OS is not supported: " + currentOsDescription);
            if (minOSDescription != null && !minOSDescription.isEmpty()) {
                Logging.log.warning("The minimun OS requirement is: " + minOSDescription);
                errmsg = bundle.messageString("OsLevelConfirm.current.txt", currentOsDescription);
                errmsg = errmsg + bundle.messageString("OsLevelConfirm.needed.txt", minOSDescription);
                errmsg = errmsg + bundle.getString("OsLevelConfirm.OSVersionNotCorrect.txt");
            } else {
                errmsg = bundle.messageString("OsLevelConfirm.current.txt", currentOsDescription);
                errmsg = errmsg + bundle.getString("OsLevelConfirm.OSVersionNotCorrect.txt");
            }
        } else {
            errmsg = null;
            Logging.log.info("This OS is supported: " + currentOsDescription);
        }
        return result;
    }

    private static boolean checkAgainstSASUnx() {
        boolean result = true;
        String script = Utils.joinPath(Globals.g_setupLocation, "unx", Utils.getOS_Suffix() + "check.sh");
        File oslevCheckFile = new File(script);
        if (!oslevCheckFile.exists() || !oslevCheckFile.canExecute()) {
            Logging.log.info("OS Level check file, " + script + " does not exist or executable.");
            return result;
        }
        String[] command = new String[]{"/bin/sh", "-c", script};
        Utils.ProcessData p = Utils.runProcess(command);
        int rc = p.exitValue;
        if (p.getStdOutput() != null && p.getStdOutput().length != 0) {
            currentOsDescription = p.getStdOutput()[0];
            if (p.getStdOutput().length > 1) {
                minOSDescription = p.getStdOutput()[1];
            }
        }
        if (p.getStdErr() != null) {
            Logging.log.info("script=" + script);
            String err = System.getProperty("line.separator");
            for (int i = 0; i < p.getStdErr().length; ++i) {
                err = err + p.getStdErr()[i] + System.getProperty("line.separator");
            }
            Logging.log.info("standarderroroutput=" + err);
        }
        if (rc == 0) {
            Logging.log.fine("OS version=" + currentOsDescription);
            result = true;
        } else {
            Logging.log.warning("Required OS version=" + minOSDescription);
            result = false;
        }
        return result;
    }

    private static boolean checkAgainstSAS() {
        boolean result = true;
        boolean is32bit = OsLevelCheck.getProcessorArchitecture() == 0L;
        boolean is64bit = OsLevelCheck.getProcessorArchitecture() == 9L;
        currentOsDescription = OsLevelCheck.getOsVersionDescription();
        if (!is32bit && !is64bit) {
            Logging.log.info("Not a supported 32 or 64 bit chip");
            result = false;
        } else if (OsLevelCheck.getMajorReleaseVersion() < 6L) {
            result = false;
            minOSDescription = "";
        } else if (OsLevelCheck.getMajorReleaseVersion() == 6L) {
            if (OsLevelCheck.getMinorReleaseVersion() <= 1L) {
                result = false;
                minOSDescription = "";
            } else if (OsLevelCheck.getMinorReleaseVersion() >= 2L) {
                result = false;
                minOSDescription = ProductType == 1L ? "Windows 10" : "Windows Server 2016";
            }
        }
        return result;
    }

    static String getErrorMessage() {
        return errmsg;
    }

    private static OrderTypes orderType() {
        OrderTypes result = OrderTypes.SAS;
        String[] setNumIds = Globals.g_deploymentData.getOrder(Globals.g_order).getSetnumids();
        for (int i = 0; i < setNumIds.length; ++i) {
            String installType = Globals.g_deploymentData.getOrder(Globals.g_order).getSidType(setNumIds[i]);
            if ("JMP".equalsIgnoreCase(installType)) {
                result = OrderTypes.JMP;
                continue;
            }
            if ("DataFlux".equalsIgnoreCase(installType)) {
                result = OrderTypes.DataFlux;
                continue;
            }
            if (!"SAS".equalsIgnoreCase(installType)) continue;
            result = OrderTypes.SAS;
            break;
        }
        return result;
    }

    private static enum OrderTypes {
        SAS,
        JMP,
        DataFlux,
        SPDS;

    }

    public static enum wProductInfo {
        PRODUCT_BUSINESS(6L),
        PRODUCT_BUSINESS_N(16L),
        PRODUCT_CLUSTER_SERVER(18L),
        PRODUCT_DATACENTER_SERVER(8L),
        PRODUCT_DATACENTER_SERVER_CORE(12L),
        PRODUCT_DATACENTER_SERVER_CORE_V(39L),
        PRODUCT_DATACENTER_SERVER_V(37L),
        PRODUCT_ENTERPRISE(4L),
        PRODUCT_ENTERPRISE_E(70L),
        PRODUCT_ENTERPRISE_N(27L),
        PRODUCT_ENTERPRISE_SERVER(10L),
        PRODUCT_ENTERPRISE_SERVER_CORE(14L),
        PRODUCT_ENTERPRISE_SERVER_CORE_V(41L),
        PRODUCT_ENTERPRISE_SERVER_IA64(15L),
        PRODUCT_ENTERPRISE_SERVER_V(38L),
        PRODUCT_HOME_BASIC(2L),
        PRODUCT_HOME_BASIC_E(67L),
        PRODUCT_HOME_BASIC_N(5L),
        PRODUCT_HOME_PREMIUM(3L),
        PRODUCT_HOME_PREMIUM_E(68L),
        PRODUCT_HOME_PREMIUM_N(26L),
        PRODUCT_HYPERV(42L),
        PRODUCT_MEDIUMBUSINESS_SERVER_MANAGEMENT(30L),
        PRODUCT_MEDIUMBUSINESS_SERVER_MESSAGING(32L),
        PRODUCT_MEDIUMBUSINESS_SERVER_SECURITY(31L),
        PRODUCT_PROFESSIONAL(48L),
        PRODUCT_PROFESSIONAL_E(69L),
        PRODUCT_PROFESSIONAL_N(49L),
        PRODUCT_SERVER_FOR_SMALLBUSINESS(24L),
        PRODUCT_SERVER_FOR_SMALLBUSINESS_V(35L),
        PRODUCT_SERVER_FOUNDATION(33L),
        PRODUCT_SMALLBUSINESS_SERVER(9L),
        PRODUCT_SOLUTION_EMBEDDEDSERVER(56L),
        PRODUCT_STANDARD_SERVER(7L),
        PRODUCT_STANDARD_SERVER_CORE(13L),
        PRODUCT_STANDARD_SERVER_CORE_V(40L),
        PRODUCT_STANDARD_SERVER_V(36L),
        PRODUCT_STARTER(11L),
        PRODUCT_STARTER_E(66L),
        PRODUCT_STARTER_N(47L),
        PRODUCT_STORAGE_ENTERPRISE_SERVER(23L),
        PRODUCT_STORAGE_EXPRESS_SERVER(20L),
        PRODUCT_STORAGE_STANDARD_SERVER(21L),
        PRODUCT_STORAGE_WORKGROUP_SERVER(22L),
        PRODUCT_UNDEFINED(0L),
        PRODUCT_ULTIMATE(1L),
        PRODUCT_ULTIMATE_E(71L),
        PRODUCT_ULTIMATE_N(28L),
        PRODUCT_WEB_SERVER(17L),
        PRODUCT_WEB_SERVER_CORE(29L);

        private static final Map<wProductInfo, Long> lookup;
        private Long member;

        private wProductInfo(Long member) {
            this.member = member;
        }

        public Long getMember() {
            return this.member;
        }

        public static Long get(wProductInfo member) {
            return lookup.get((Object)member);
        }

        public static boolean and(wProductInfo member, long bitvalue) {
            return (wProductInfo.get(member) & bitvalue) != 0L;
        }

        public static boolean equals(wProductInfo member, long bitvalue) {
            return wProductInfo.get(member) == bitvalue;
        }

        static {
            lookup = new HashMap<wProductInfo, Long>();
            for (wProductInfo s : EnumSet.allOf(wProductInfo.class)) {
                lookup.put(s, s.getMember());
            }
        }
    }

    public static enum wProductType {
        VER_NT_DOMAIN_CONTROLLER(2L),
        VER_NT_SERVER(3L),
        VER_NT_WORKSTATION(1L);

        private static final Map<wProductType, Long> lookup;
        private Long member;

        private wProductType(Long member) {
            this.member = member;
        }

        public Long getMember() {
            return this.member;
        }

        public static Long get(wProductType member) {
            return lookup.get((Object)member);
        }

        public static boolean and(wProductType member, long bitvalue) {
            return (wProductType.get(member) & bitvalue) != 0L;
        }

        public static boolean equals(wProductType member, long bitvalue) {
            return wProductType.get(member) == bitvalue;
        }

        static {
            lookup = new HashMap<wProductType, Long>();
            for (wProductType s : EnumSet.allOf(wProductType.class)) {
                lookup.put(s, s.getMember());
            }
        }
    }

    public static enum wSuiteMask {
        VER_SUITE_BACKOFFICE(4L),
        VER_SUITE_BLADE(1024L),
        VER_SUITE_COMPUTE_SERVER(16384L),
        VER_SUITE_DATACENTER(128L),
        VER_SUITE_ENTERPRISE(2L),
        VER_SUITE_EMBEDDEDNT(64L),
        VER_SUITE_PERSONAL(512L),
        VER_SUITE_SINGLEUSERTS(256L),
        VER_SUITE_SMALLBUSINESS(1L),
        VER_SUITE_SMALLBUSINESS_RESTRICTED(32L),
        VER_SUITE_STORAGE_SERVER(8192L),
        VER_SUITE_TERMINAL(16L),
        VER_SUITE_WH_SERVER(32768L);

        private static final Map<wSuiteMask, Long> lookup;
        private Long member;

        private wSuiteMask(Long member) {
            this.member = member;
        }

        public Long getMember() {
            return this.member;
        }

        public static Long get(wSuiteMask member) {
            return lookup.get((Object)member);
        }

        public static boolean and(wSuiteMask member, long bitvalue) {
            return (wSuiteMask.get(member) & bitvalue) != 0L;
        }

        public static boolean equals(wSuiteMask member, long bitvalue) {
            return wSuiteMask.get(member) == bitvalue;
        }

        static {
            lookup = new HashMap<wSuiteMask, Long>();
            for (wSuiteMask s : EnumSet.allOf(wSuiteMask.class)) {
                lookup.put(s, s.getMember());
            }
        }
    }
}

