/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Logging;
import com.sas.ssn.OsLevelConfirm;
import com.sas.ssn.Utils;
import com.sas.tools.deployjni.saswin.SASWinAPI;
import com.sas.tools.deployjni.winregistry.WinRegAPI;

public class OsLevelCheck {
    private static long osMajorVersion = 0L;
    private static long osMinorVersion = 0L;
    private static long ServicePackMajor = 0L;
    private static long ServicePackMinor = 0L;
    private static long SuiteMask = 0L;
    private static long ProductType = 0L;
    private static long ProductInfo = 0L;
    private static long ProcessorArchitecture = 0L;
    private static long BuildNumber = 0L;
    private static final long VER_NT_WORKSTATION = 1L;
    private static final long VER_SUITE_DATACENTER = 128L;
    private static final long VER_SUITE_ENTERPRISE = 2L;
    private static final long VER_SUITE_BLADE = 1024L;
    private static final String WINDOWS_KEY = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion";
    private static boolean dataIsSet = false;

    public static String getOsInfo() {
        String osInfo = null;
        try {
            if (Utils.getOS() == 1) {
                osInfo = SASWinAPI.GetWinVerStr();
                Logging.log.info("osInfo from windows api = " + osInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Logging.logStackTrace(e);
        }
        return osInfo;
    }

    static boolean getOsVersionAndSplit() {
        if (dataIsSet) {
            return true;
        }
        boolean result = false;
        String osLevel = OsLevelCheck.getOsInfo();
        if (osLevel != null) {
            String[] items = osLevel.split("\\.");
            if (items.length == 8) {
                osMajorVersion = Long.parseLong(items[0]);
                osMinorVersion = Long.parseLong(items[1]);
                ServicePackMajor = Long.parseLong(items[2]);
                ServicePackMinor = Long.parseLong(items[3]);
                SuiteMask = Long.parseLong(items[4]);
                ProductType = Long.parseLong(items[5]);
                ProcessorArchitecture = Long.parseLong(items[6]);
                ProductInfo = Long.parseLong(items[7]);
                try {
                    BuildNumber = Integer.parseInt(WinRegAPI.getWindowsRegistryValue(8, WINDOWS_KEY, "CurrentBuildNumber"));
                    Logging.log.info("buildNumber = " + BuildNumber);
                    if (osMajorVersion == 10L && BuildNumber >= 20348L) {
                        osMajorVersion = 11L;
                    }
                }
                catch (NumberFormatException e) {
                    Logging.log.severe("WinRegAPI failed to get CurrentBuildNumber.");
                }
                result = true;
                dataIsSet = true;
            } else {
                Logging.log.severe("JNI call for system info returned unexpected results: " + osLevel);
            }
        } else {
            Logging.log.severe("JNI call to get system information failed.");
        }
        Logging.log.info("osMajorVersion = " + osMajorVersion + " osMinor = " + osMinorVersion);
        return result;
    }

    static boolean isWin7() {
        boolean returnValue = OsLevelCheck.getOsVersionAndSplit();
        if (returnValue) {
            return osMajorVersion == 6L && osMinorVersion == 1L && ProductType == 1L;
        }
        return false;
    }

    static boolean isWin2008Sev() {
        boolean returnValue = OsLevelCheck.getOsVersionAndSplit();
        if (returnValue) {
            return osMajorVersion == 6L && osMinorVersion == 0L && ProductType != 1L;
        }
        return false;
    }

    static boolean isWorkstation() {
        boolean returnValue = OsLevelCheck.getOsVersionAndSplit();
        return returnValue && ProductType == 1L;
    }

    static boolean isWin2008SevR2() {
        boolean returnValue = OsLevelCheck.getOsVersionAndSplit();
        if (returnValue) {
            return osMajorVersion == 6L && osMinorVersion == 1L && ProductType != 1L;
        }
        return false;
    }

    static boolean isWin8() {
        boolean returnValue = OsLevelCheck.getOsVersionAndSplit();
        if (returnValue) {
            return osMajorVersion == 6L && osMinorVersion == 2L && ProductType == 1L;
        }
        return false;
    }

    static boolean isWin2012Sev() {
        boolean returnValue = OsLevelCheck.getOsVersionAndSplit();
        if (returnValue) {
            return osMajorVersion == 6L && osMinorVersion >= 2L && ProductType != 1L;
        }
        return false;
    }

    static long getMajorReleaseVersion() {
        boolean returnValue = OsLevelCheck.getOsVersionAndSplit();
        if (returnValue) {
            return osMajorVersion;
        }
        return 0L;
    }

    static long getMinorReleaseVersion() {
        boolean returnValue = OsLevelCheck.getOsVersionAndSplit();
        if (returnValue) {
            return osMinorVersion;
        }
        return 0L;
    }

    static String getOsVersionDescription() {
        boolean returnValue = OsLevelCheck.getOsVersionAndSplit();
        if (!returnValue) {
            return null;
        }
        String description = OsLevelCheck.getOsVersionDescription(osMajorVersion, osMinorVersion, ProductType, SuiteMask, ProductInfo, ProcessorArchitecture, ServicePackMajor, ServicePackMinor, BuildNumber);
        return description;
    }

    static String getOsVersionDescription(long osMajor, long osMinor, long prodType, long steMask, long prodInfo, long architecture, long SPMajor, long SPMinor, long buildNumber) {
        String description = null;
        if (osMajor == 6L) {
            if (osMinor == 3L) {
                description = prodType == 1L ? "Windows 8.1" : "Windows Server 2012 R2";
            } else if (osMinor == 2L) {
                description = prodType == 1L ? "Windows 8" : "Windows Server 2012";
            } else if (osMinor == 1L) {
                description = prodType == 1L ? "Windows 7" : "Windows Server 2008 R2";
            } else if (osMinor == 0L) {
                description = prodType == 1L ? "Windows Vista" : "Windows Server 2008";
            }
            if (steMask == 128L) {
                description = description + " Datacenter Edition";
            } else if (steMask == 2L) {
                description = description + " Enterprise Edition";
            } else if (steMask == 1024L) {
                description = description + " Web Edition";
            }
            if (osMinor < 3L) {
                if (OsLevelConfirm.wProductInfo.equals(OsLevelConfirm.wProductInfo.PRODUCT_ENTERPRISE, prodInfo)) {
                    description = description + " Enterprise";
                }
                if (OsLevelConfirm.wProductInfo.equals(OsLevelConfirm.wProductInfo.PRODUCT_PROFESSIONAL, prodInfo)) {
                    description = description + " Professional";
                }
                if (OsLevelConfirm.wProductInfo.equals(OsLevelConfirm.wProductInfo.PRODUCT_ULTIMATE, prodInfo)) {
                    description = description + " Ultimate";
                }
            }
            if (architecture == 0L) {
                description = description + " 32-bit";
            } else if (architecture == 9L) {
                description = description + " 64-bit";
            }
        } else if (osMajor == 5L) {
            if (osMinor == 2L) {
                description = "Microsoft Windows Server 2003";
                description = steMask == 128L ? description + " Datacenter Edition" : (steMask == 2L ? description + " Enterprise Edition" : (steMask == 1024L ? description + " Web Edition" : (ProductType == 1L ? "Windows XP 64-Bit Edition" : description + " Standard Edition")));
            } else if (osMinorVersion == 1L) {
                description = "Microsoft Windows XP";
            }
        } else if (osMajor == 10L) {
            if (osMinor == 0L) {
                if (prodType == 1L) {
                    description = "Windows 10";
                } else {
                    try {
                        description = buildNumber < 17763L ? "Windows Server 2016" : "Windows Server 2019";
                    }
                    catch (NumberFormatException ex) {
                        return "Microsoft Windows";
                    }
                }
            }
            if (steMask == 128L) {
                description = description + " Datacenter Edition";
            } else if (steMask == 2L) {
                description = description + " Enterprise Edition";
            } else if (steMask == 1024L) {
                description = description + " Web Edition";
            }
            if (osMinor < 3L) {
                if (OsLevelConfirm.wProductInfo.equals(OsLevelConfirm.wProductInfo.PRODUCT_ENTERPRISE, prodInfo)) {
                    description = description + " Enterprise";
                }
                if (OsLevelConfirm.wProductInfo.equals(OsLevelConfirm.wProductInfo.PRODUCT_PROFESSIONAL, prodInfo)) {
                    description = description + " Professional";
                }
                if (OsLevelConfirm.wProductInfo.equals(OsLevelConfirm.wProductInfo.PRODUCT_ULTIMATE, prodInfo)) {
                    description = description + " Ultimate";
                }
            }
            if (architecture == 0L) {
                description = description + " 32-bit";
            } else if (architecture == 9L) {
                description = description + " 64-bit";
            }
        } else if (osMajor == 11L) {
            if (osMinor == 0L) {
                if (prodType == 1L) {
                    description = "Windows 11 64-bit";
                }
                description = buildNumber >= 26100L ? "Windows Server 2025 64-bit" : "Windows Server 2022 64-bit";
            }
        } else {
            description = "Microsoft Windows";
        }
        if (SPMajor != 0L) {
            description = description + " Service Pack " + SPMajor;
            if (SPMinor != 0L) {
                description = description + "." + SPMinor;
            }
        }
        return description;
    }

    static boolean isAppCompatFlagsSet(String sasDMExeLocation) {
        String appCompatFlagsKey = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\AppCompatFlags\\Layers";
        String flagValue = null;
        if (Utils.getOS_Suffix().equals("wx6")) {
            if (WinRegAPI.isWindowsRegistryKey64(8, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\AppCompatFlags\\Layers")) {
                flagValue = WinRegAPI.getWindowsRegistryValue(8, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\AppCompatFlags\\Layers", sasDMExeLocation);
            }
        } else if (WinRegAPI.isWindowsRegistryKey32(8, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\AppCompatFlags\\Layers")) {
            flagValue = WinRegAPI.getWindowsRegistryValue(8, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\AppCompatFlags\\Layers", sasDMExeLocation);
        }
        if (flagValue == null || flagValue.equals("")) {
            return false;
        }
        Logging.log.info("OS Version:       " + OsLevelCheck.getOsVersionDescription());
        Logging.log.info(sasDMExeLocation + " is set as compatibility mode (" + flagValue + ")");
        return true;
    }

    public static long getServicePackMajor() {
        return ServicePackMajor;
    }

    public static long getServicePackMinor() {
        return ServicePackMinor;
    }

    public static long getSuiteMask() {
        return SuiteMask;
    }

    public static long getProductType() {
        return ProductType;
    }

    public static long getProcessorArchitecture() {
        return ProcessorArchitecture;
    }

    public static long getProductInfo() {
        return ProductInfo;
    }
}

