/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.CdId;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DestPanel;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class NextDiskDialog
extends JDialog {
    public static final int CANCEL = 0;
    public static final int OK = 1;
    private GridBagConstraints c = new GridBagConstraints();
    private DestPanel filePanel;
    private int buttonClicked;
    protected static SSNResource bundle = new SSNResource(NextDiskDialog.class);

    public NextDiskDialog(final Frame owner, String diskLabel, String defaultPath, final String cdId) {
        super(owner, true);
        this.setTitle(bundle.getString("NextDiskDialog.InsertDiskTitle.txt"));
        JTextPane description = new JTextPane();
        description.setBackground(this.getBackground());
        description.setContentType("text/html");
        description.setText(bundle.messageString("NextDiskDialog.NonCDTier.NonVMS.InsertDisk.txt", diskLabel));
        description.setEditable(false);
        description.setFocusable(false);
        this.filePanel = new DestPanel(null, defaultPath, 0, 1);
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.getRootPane().setDefaultButton(okButton);
        okButton.setText(Util.getLabelWithoutMnemonic(bundle.getString("Common.OK2.txt")));
        cancelButton.setText(bundle.getString("Common.Cancel.txt"));
        this.setSize(400, 200);
        this.setLocationRelativeTo(owner);
        this.getContentPane().setLayout(new GridBagLayout());
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.insets = new Insets(10, 10, 0, 10);
        this.c.anchor = 11;
        this.getContentPane().add((Component)description, this.c);
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.anchor = 10;
        this.c.insets = new Insets(0, 10, 0, 10);
        this.getContentPane().add((Component)this.filePanel, this.c);
        this.c.fill = 0;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.anchor = 14;
        this.c.insets = new Insets(0, 10, 10, 10);
        this.getContentPane().add((Component)new navButtons(okButton, cancelButton), this.c);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NextDiskDialog.checkDisk(NextDiskDialog.this.getPath(), cdId)) {
                    NextDiskDialog.this.buttonClicked = 1;
                    NextDiskDialog.this.setVisible(false);
                    NextDiskDialog.this.dispose();
                } else {
                    CustMsgBox.showMessageDialog((Component)owner, bundle.getString("NextDiskDialog.WrongDiskMsg.txt"), bundle.getString("Common.Warning.txt"), 2);
                }
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NextDiskDialog.this.buttonClicked = 0;
                NextDiskDialog.this.setVisible(false);
                NextDiskDialog.this.dispose();
            }
        });
        this.addKeyListeners(this, new cKeyHandler());
        this.setResizable(false);
        this.show();
    }

    public static boolean checkDisk(String searchPath, String volser) {
        boolean retVal = false;
        try {
            CdId id = new CdId(searchPath + File.separator + "cd.id");
            retVal = id.contains(volser);
        }
        catch (IOException e) {
            Logging.logStackTrace(e);
        }
        return retVal;
    }

    public int buttonClicked() {
        return this.buttonClicked;
    }

    public String getPath() {
        return this.filePanel.getPath();
    }

    protected void addKeyListeners(Container container, cKeyHandler keyHandler) {
        Component[] aComps = container.getComponents();
        int nComps = aComps.length;
        for (int iComp = 0; iComp < nComps; ++iComp) {
            aComps[iComp].addKeyListener(keyHandler);
            if (!(aComps[iComp] instanceof Container)) continue;
            this.addKeyListeners((Container)aComps[iComp], keyHandler);
        }
    }

    private class navButtons
    extends JPanel {
        public navButtons(JButton okButton, JButton cancelButton) {
            GridBagConstraints c = new GridBagConstraints();
            JPanel okPanel = new JPanel();
            JPanel cancelPanel = new JPanel();
            okPanel.setLayout(new GridBagLayout());
            cancelPanel.setLayout(new GridBagLayout());
            c.fill = 2;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 0, 0, 4);
            c.anchor = 10;
            okPanel.add((Component)okButton, c);
            c.fill = 2;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 4, 0, 0);
            c.anchor = 10;
            cancelPanel.add((Component)cancelButton, c);
            this.setLayout(new GridLayout(1, 2));
            this.add(okPanel);
            this.add(cancelPanel);
        }
    }

    protected class cKeyHandler
    extends KeyAdapter {
        protected cKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int eKeyCode = e.getKeyCode();
            switch (eKeyCode) {
                case 27: {
                    NextDiskDialog.this.dispose();
                }
            }
        }
    }
}

