/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.Utils;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MsiInstallData {
    private String version = "";
    private String productCode = "";
    private String installingHost = "";
    private String osBitness = "";
    public static int LESS_THAN = -1;
    public static int EQUAL = 0;
    public static int GREATER_THAN = 1;
    private boolean isAutoUpdate = false;
    private List<String> existingDeplRegVersions = new ArrayList<String>();
    private boolean is32bWowKey = false;

    public MsiInstallData(ProductData prodData, String[] versions) {
        this.initialize(prodData, versions);
    }

    private String[] findSubKeys(String regKeyToQuery) {
        if (this.osBitness.equals("win")) {
            return WinRegAPI.childrenForKey32(8, regKeyToQuery);
        }
        if (this.is32bWowKey) {
            return WinRegAPI.childrenForKey32(8, regKeyToQuery);
        }
        return WinRegAPI.childrenForKey64(8, regKeyToQuery);
    }

    private int[] splitVersion(String prodVersion) {
        if (prodVersion == null || prodVersion == "") {
            return null;
        }
        String[] versionSplit = prodVersion.split("[.]");
        int[] split = new int[versionSplit.length];
        for (int i = 0; i < versionSplit.length; ++i) {
            split[i] = Integer.parseInt(versionSplit[i]);
        }
        return split;
    }

    private String getWindowsRegKeyToQuery(String installingProdCode) {
        String REGISTRY_KEY_AMO = "SOFTWARE\\SAS Institute Inc.\\AddIn for Microsoft Office\\";
        String REGISTRY_KEY_AMO32ON64 = "SOFTWARE\\Wow6432Node\\SAS Institute Inc.\\AddIn for Microsoft Office\\";
        String REGISTRY_KEY_EGA = "SOFTWARE\\SAS Institute Inc.\\Enterprise Guide\\";
        String REGISTRY_KEY_EGA32ON64 = "SOFTWARE\\Wow6432Node\\SAS Institute Inc.\\Enterprise Guide\\";
        if (this.osBitness.equals("wx6")) {
            if (installingProdCode.equalsIgnoreCase("msofficeint")) {
                return this.is32bWowKey ? "SOFTWARE\\Wow6432Node\\SAS Institute Inc.\\AddIn for Microsoft Office\\" : "SOFTWARE\\SAS Institute Inc.\\AddIn for Microsoft Office\\";
            }
            if (installingProdCode.equalsIgnoreCase("eguide")) {
                return this.is32bWowKey ? "SOFTWARE\\Wow6432Node\\SAS Institute Inc.\\Enterprise Guide\\" : "SOFTWARE\\SAS Institute Inc.\\Enterprise Guide\\";
            }
        }
        if (this.osBitness.equals("win")) {
            if (installingProdCode.equalsIgnoreCase("msofficeint")) {
                return "SOFTWARE\\SAS Institute Inc.\\AddIn for Microsoft Office\\";
            }
            if (installingProdCode.equalsIgnoreCase("eguide")) {
                return "SOFTWARE\\SAS Institute Inc.\\Enterprise Guide\\";
            }
        }
        return "";
    }

    private List<String> getWinRegExistingVersions(String regKeyToQuery) {
        List<String> versions = new ArrayList<String>();
        String[] keyVersions = this.findSubKeys(regKeyToQuery);
        if (keyVersions != null && keyVersions.length >= 1) {
            versions = Arrays.asList(keyVersions);
        }
        return versions;
    }

    private boolean hasMajorVersionInDeplReg() {
        int[] installingVer = this.splitVersion(this.version);
        for (String version : this.existingDeplRegVersions) {
            int[] ver = this.splitVersion(version);
            if (ver[0] != installingVer[0]) continue;
            return true;
        }
        return false;
    }

    private boolean hasMajorVersionInWinReg() {
        int[] installingVer = this.splitVersion(this.version);
        String regKeyToQuery = this.getWindowsRegKeyToQuery(this.productCode);
        Logging.log.info("Querying registry key: " + regKeyToQuery);
        List<String> winRegVersions = this.getWinRegExistingVersions(regKeyToQuery);
        Logging.log.info("Registry subkeys: " + winRegVersions);
        for (String version : winRegVersions) {
            int[] ver = this.splitVersion(version);
            if (ver[0] != installingVer[0]) continue;
            return true;
        }
        return false;
    }

    private void initialize(ProductData prodData, String[] versions) {
        this.version = prodData.getProdVersion();
        this.productCode = prodData.getProdCode();
        this.installingHost = prodData.getPlatform();
        this.osBitness = Utils.getOS_Suffix();
        if (this.osBitness.equals("wx6") && this.installingHost.equals("win")) {
            this.is32bWowKey = true;
        }
        if (versions != null) {
            for (String ver : versions) {
                this.existingDeplRegVersions.add(ver);
            }
        }
        this.setAutoUpdate();
    }

    private void setAutoUpdate() {
        if (this.hasMajorVersionInWinReg() && !this.hasMajorVersionInDeplReg()) {
            this.isAutoUpdate = true;
        }
    }

    public boolean isAutoUpdate() {
        return this.isAutoUpdate;
    }
}

