/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.UnicodeInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MigrationMatrixReport {
    private final String PRODUCT_NAME = "product";
    private final String COMPLETE_REPORT_FILE = "AnalysisReport" + File.separator + "matrix-report.xml";
    private HashMap<String, MatrixReportProduct> m_productMap = new HashMap();

    public MigrationMatrixReport(String smuPackagePath, String[] smuTierFolders) {
        this(new File(smuPackagePath), smuTierFolders);
    }

    public MigrationMatrixReport(File smuPackage, String[] smuTierFolders) {
        for (int i = 0; i < smuTierFolders.length; ++i) {
            File folder = new File(smuPackage, smuTierFolders[i]);
            if (!folder.exists()) continue;
            File completeReport = new File(folder, this.COMPLETE_REPORT_FILE);
            if (completeReport.exists()) {
                this.loadReportData(completeReport);
                continue;
            }
            Logging.log.info("MigrationMatrixReport:  Migration matrix report file, " + completeReport.getPath() + ", missing.  No incompatibilities found.");
        }
    }

    public MigrationMatrixReport(ArrayList products) {
        for (int i = 0; i < products.size(); ++i) {
            MatrixReportProduct prod = (MatrixReportProduct)products.get(i);
            this.m_productMap.put(prod.getCode(), prod);
        }
    }

    private void loadReportData(File file) {
        Document m_doc = null;
        Element m_root = null;
        if (file.exists()) {
            try {
                m_doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(file));
                m_root = m_doc.getDocumentElement();
                NodeList products = m_root.getElementsByTagName("product");
                for (int i = 0; i < products.getLength(); ++i) {
                    MatrixReportProduct prod = new MatrixReportProduct((Element)products.item(i));
                    this.m_productMap.put(prod.getCode(), prod);
                    Logging.log.info("MigrationMatrixReport: loading matrix data for 12byte=" + prod.getCode() + ", version=" + prod.getVersion());
                }
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
    }

    public ArrayList<MatrixReportProduct> checkIncompatibilities(ProductData[] configData) {
        ArrayList<MatrixReportProduct> incompatibilities = new ArrayList<MatrixReportProduct>();
        for (Map.Entry<String, MatrixReportProduct> pairs : this.m_productMap.entrySet()) {
            MatrixReportProduct prod = pairs.getValue();
            System.out.println("Checking " + prod.getCode() + ", " + prod.getIncompatibilities());
            SpsSkuData data = Globals.g_deploymentData.getNewestSpsSku(prod.getCode(), null, true);
            if (!this.checkConfigData(prod, data)) continue;
            Logging.log.info("MigrationMatrixReport: found incompatibility 12byte=" + data.getProdCode() + ", version=" + prod.getVersion() + ", incompatibile with version " + data.getCustomerVer("en") + ".");
            incompatibilities.add(prod);
        }
        return incompatibilities;
    }

    private boolean checkConfigData(MatrixReportProduct product, SpsSkuData data) {
        if (data != null) {
            String version = data.getCustomerVer("en");
            String versionTransform = version.replace("_", "");
            if (product.incompatibleWith(data.getProdCode(), version) || product.incompatibleWith(data.getProdCode(), versionTransform)) {
                return true;
            }
        }
        return false;
    }

    public ArrayList<MatrixReportProduct> getProducts() {
        ArrayList<MatrixReportProduct> m_products = new ArrayList<MatrixReportProduct>();
        for (Map.Entry<String, MatrixReportProduct> pairs : this.m_productMap.entrySet()) {
            MatrixReportProduct prod = pairs.getValue();
            m_products.add(prod);
        }
        return m_products;
    }

    public class MatrixReportProduct {
        String m_code = null;
        String m_name = null;
        String m_version = null;
        List<String> m_incompatibilities = null;
        ArrayList deploymentsList = new ArrayList();

        public MatrixReportProduct(Element element) {
            this.m_code = element.getAttribute("code");
            this.m_name = element.getAttribute("name");
            this.m_version = element.getAttribute("version");
            String incompatibleWith = element.getAttribute("incompatibleWith");
            this.m_incompatibilities = Arrays.asList(incompatibleWith.split("\\s*,\\s*"));
        }

        public MatrixReportProduct(String code, String name, String version, String incompatibleWith) {
            this.m_code = code;
            this.m_name = name;
            this.m_version = version;
            this.m_incompatibilities = Arrays.asList(incompatibleWith.split("\\s*,\\s*"));
        }

        public String getIncompatibilities() {
            String incompatibilities = this.m_incompatibilities.get(0);
            for (int i = 1; i < this.m_incompatibilities.size(); ++i) {
                incompatibilities = incompatibilities + ", " + this.m_incompatibilities.get(i);
            }
            return incompatibilities;
        }

        public String getName() {
            return this.m_name;
        }

        public String getCode() {
            return this.m_code;
        }

        public String getVersion() {
            return this.m_version;
        }

        public boolean incompatibleWith(String code, String version) {
            if (this.m_code.equalsIgnoreCase(code)) {
                for (int i = 0; i < this.m_incompatibilities.size(); ++i) {
                    if (!version.equalsIgnoreCase(this.m_incompatibilities.get(i).trim())) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

