/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class Logging {
    private static String TIMESTAMP_FORMAT = "yyyy-MM-dd-HH.mm.ss";
    private static String timeStamp = new SimpleDateFormat(TIMESTAMP_FORMAT).format(new Date());
    private static final String SDW_LOG_FILE_NAME = "SDW_" + timeStamp + ".log";
    private static final String SDM_LOG_FILE_NAME = "SDM_" + timeStamp + ".log";
    private static final String SDW_ALT_LOG_FILE_NAME = "SDW_%u.log";
    private static final String SDM_ALT_LOG_FILE_NAME = "SDM_%u.log";
    public static Logger log;

    public static void createLog() {
        log = Logger.getLogger("com.sas.ssn");
        log.setUseParentHandlers(false);
        String rootLogPath = Utils.getSDWDataPath(true);
        Handler fh = null;
        try {
            fh = Globals.g_mode == 2 || Globals.g_mode == 5 || Globals.g_mode == 4 ? new FileHandler(Utils.joinPath(rootLogPath, SDM_LOG_FILE_NAME), true) : new FileHandler(Utils.joinPath(rootLogPath, Logging.getSdwLogFileName()), true);
        }
        catch (IOException e) {
            System.err.print("Can't create log file: " + Utils.joinPath(rootLogPath, Logging.getSdwLogFileName()));
            e.printStackTrace();
            try {
                if (Globals.g_mode == 2 || Globals.g_mode == 5) {
                    fh = new FileHandler(Utils.joinPath(rootLogPath, SDM_ALT_LOG_FILE_NAME), true);
                }
                fh = new FileHandler(Utils.joinPath(rootLogPath, SDW_ALT_LOG_FILE_NAME), true);
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        fh.setFormatter(new SimpleFormatter());
        log.addHandler(fh);
        log.fine("Initialized Logging Class");
    }

    public static void closeLog() {
        for (Handler tmpHan : Arrays.asList(log.getHandlers())) {
            tmpHan.close();
        }
    }

    public static void logStackTrace(Throwable e) {
        log.severe(Logging.getFormattedLogMsg(e));
    }

    public static String getFormattedLogMsg(Throwable e) {
        String logMsg = e.toString();
        StackTraceElement[] stackTrace = e.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            logMsg = logMsg + "\n" + stackTrace[i].toString();
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            logMsg = logMsg + "\n\nCaused by:\n";
            logMsg = logMsg + sw.toString();
        }
        return logMsg;
    }

    public static String getTimeStamp() {
        return timeStamp;
    }

    public static String getSdwLogFileName() {
        return SDW_LOG_FILE_NAME;
    }
}

