/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Logging;
import com.sas.ssn.SID;
import com.sas.ssn.Utils;
import java.io.File;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LicenseServer {
    private File sasHome;
    private File sidRepository;
    private Hashtable<String, Vector<SID>> storedSetnumidHash = new Hashtable();
    private Vector<String> storedFilenames = new Vector();
    private Vector<SID> queuedSids = new Vector();

    public LicenseServer(String sashome) {
        this(new File(sashome));
    }

    public LicenseServer(File sashome) {
        this.sasHome = sashome;
        this.sidRepository = new File(this.sasHome, "licenses");
        this.loadFromDisk(this.sidRepository);
    }

    public boolean add(SID sid) {
        return this.queuedSids.add(sid);
    }

    public boolean remove(SID sid) {
        return this.queuedSids.remove(sid);
    }

    public boolean store() {
        boolean success = true;
        int maxCount = 999;
        Pattern pattern = Pattern.compile("^(.+)(\\..+)$");
        if (this.queuedSids.size() > 0) {
            if (!this.sidRepository.isDirectory() && !this.sidRepository.mkdirs()) {
                success = false;
                Logging.log.severe("Error creating license repository");
            }
            for (SID sid : this.queuedSids) {
                Vector<SID> storedSids;
                if (success && (storedSids = this.getSidsForSetnumid(sid.getSetnumid(), sid.getVersion(), sid.getRevision(), true)).size() == 1 && !this.queuedSids.contains(storedSids.firstElement()) && !this.removeStored(storedSids.firstElement())) {
                    success = false;
                    Logging.log.severe("Error removing old license for setnumid " + sid.getSetnumid());
                }
                if (!success) continue;
                if (!this.storedFilenames.contains(this.getFileKey(sid.getSIDFile().getName()))) {
                    sid.setSIDFile(new File(this.sidRepository, sid.getSIDFile().getName()));
                } else {
                    String filename = sid.getSIDFile().getName();
                    Matcher matcher = pattern.matcher(filename);
                    for (int i = 1; i <= maxCount; ++i) {
                        filename = matcher.find() ? matcher.group(1) + "-" + i + matcher.group(2) : filename + "-" + i;
                        if (!this.storedFilenames.contains(this.getFileKey(filename))) {
                            sid.setSIDFile(new File(this.sidRepository, filename));
                            i = maxCount + 1;
                            continue;
                        }
                        if (i != maxCount) continue;
                        success = false;
                        Logging.log.severe("Maximum file count exceeded for storing license");
                    }
                }
                if (!success || this.addStored(sid)) continue;
                success = false;
                Logging.log.severe("Error adding license to the repository");
            }
            this.queuedSids.clear();
        }
        return success;
    }

    private String getFileKey(String filename) {
        String key = Utils.getOS() == 1 ? filename.toLowerCase(Locale.ENGLISH) : filename;
        return key;
    }

    private Vector<SID> getSidsForSetnumid(String setnumid, String version, String revision, boolean create) {
        String key = setnumid + ":" + version + ":" + revision;
        Vector<SID> sids = this.storedSetnumidHash.get(key);
        if (sids == null && create) {
            sids = new Vector();
            this.storedSetnumidHash.put(key, sids);
        }
        return sids;
    }

    private void loadFromDisk(File repository) {
        SID sid = null;
        File[] files = repository.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    sid = new SID(files[i]);
                    Vector<SID> sids = this.getSidsForSetnumid(sid.getSetnumid(), sid.getVersion(), sid.getRevision(), true);
                    sids.add(sid);
                }
                catch (Exception e) {
                    Logging.log.info("Error encountered parsing " + files[i].getName());
                    Logging.log.info(e.getMessage());
                }
                this.storedFilenames.add(this.getFileKey(files[i].getName()));
            }
        }
    }

    private boolean addStored(SID sid) {
        boolean success = false;
        Vector<SID> sids = this.getSidsForSetnumid(sid.getSetnumid(), sid.getVersion(), sid.getRevision(), true);
        sids.add(sid);
        this.storedFilenames.add(this.getFileKey(sid.getSIDFile().getName()));
        success = sid.writeFormattedSIDFile(this.sidRepository);
        return success;
    }

    private boolean removeStored(SID sid) {
        boolean success = false;
        Vector<SID> sids = this.getSidsForSetnumid(sid.getSetnumid(), sid.getVersion(), sid.getRevision(), false);
        if (sids != null && sid.getSIDFile().delete()) {
            sids.removeElement(sid);
            this.storedFilenames.remove(this.getFileKey(sid.getSIDFile().getName()));
            success = true;
        }
        return success;
    }
}

