/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class LangSelectDlgFrame {
    private static final long serialVersionUID = -1289794545608236568L;
    public static final int CANCEL = 0;
    public static final int OK = 1;
    protected static SSNResource bundle = new SSNResource(LangSelectDlgFrame.class);
    private JFrame frame;
    private JDialog dialog;
    private JComboBox langList;
    private GridBagConstraints c = new GridBagConstraints();
    private int m_buttonClicked;
    private String[] m_langCodes;
    private String[] m_langNames;

    public LangSelectDlgFrame(String[] codes, String[] names, String selected) {
        try {
            this.frame = new JFrame();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_langCodes = codes;
        this.m_langNames = names;
        this.sortLanguages(this.m_langNames, this.m_langCodes);
        this.dialog = new JDialog(this.getFrame(), bundle.getString("LangSelectDlgFrame.Title.txt"), true);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Logging.closeLog();
                System.exit(-1);
            }
        });
        this.getFrame().setTitle(bundle.getString("LangSelectDlgFrame.Title.txt"));
        JTextArea description = new JTextArea(){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if (size.width < size.height) {
                    size.width = (int)((double)size.height * 1.8);
                }
                if (size.width < 280) {
                    size.width = 280;
                } else if (size.width > 700) {
                    size.width = 700;
                }
                if (size.height < 30) {
                    size.height = 30;
                } else if (size.height > 700) {
                    size.height = 700;
                }
                return size;
            }
        };
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        description.setBackground(this.getFrame().getBackground());
        if (Globals.g_mode == 5) {
            description.setText(bundle.messageString("LangSelectDlgFrame.Description.txt", bundle.getString("Common.SDATitle.txt")));
        } else if (Globals.g_mode == 1) {
            description.setText(bundle.messageString("LangSelectDlgFrame.Description.txt", bundle.getString("Common.ESDTitle.txt")));
        } else if (Globals.g_mode == 2) {
            description.setText(bundle.messageString("LangSelectDlgFrame.Description.txt", bundle.getString("Common.CMTTitle.txt")));
        } else if (Globals.g_mode == 6) {
            description.setText(bundle.messageString("LangSelectDlgFrame.Description.txt", bundle.getString("Common.DCUTitle.txt")));
        } else {
            description.setText(bundle.messageString("LangSelectDlgFrame.Description.txt", bundle.getString("Common.Title.txt")));
        }
        description.setEnabled(true);
        description.setEditable(false);
        description.getPreferredSize();
        description.setFocusable(false);
        this.langList = new JComboBox<String>(this.m_langNames);
        this.setDefaultLang(this.langList, selected);
        this.langList.setFocusable(true);
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.getFrame().setBounds(-1000, -1000, 0, 0);
        ImageIcon myIcon = bundle.getImageIcon("Common.icon.image");
        this.getFrame().setIconImage(myIcon.getImage());
        this.dialog.getContentPane().setLayout(new GridBagLayout());
        String mtxt = bundle.getString("Common.OK2.txt");
        String txt = Util.getLabelWithoutMnemonic(mtxt);
        okButton.setText(txt);
        cancelButton.setText(bundle.getString("Common.Cancel.txt"));
        this.c.fill = 1;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.ipady = 10;
        this.c.anchor = 11;
        this.c.insets = new Insets(10, 10, 0, 10);
        this.dialog.getContentPane().add((Component)description, this.c);
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.ipady = 0;
        this.c.anchor = 11;
        this.c.insets = new Insets(0, 10, 0, 10);
        this.dialog.getContentPane().add((Component)this.langList, this.c);
        this.c.fill = 0;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.ipady = 10;
        this.c.anchor = 15;
        this.c.insets = new Insets(10, 10, 10, 10);
        this.dialog.getContentPane().add((Component)new navButtons(okButton, cancelButton), this.c);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LangSelectDlgFrame.this.m_buttonClicked = 1;
                LangSelectDlgFrame.this.dialog.dispose();
                LangSelectDlgFrame.this.getFrame().dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LangSelectDlgFrame.this.m_buttonClicked = 0;
                LangSelectDlgFrame.this.dialog.dispose();
                LangSelectDlgFrame.this.getFrame().dispose();
                Logging.closeLog();
                System.exit(-1);
            }
        });
        this.dialog.getRootPane().setDefaultButton(okButton);
        this.getFrame().show();
        this.dialog.pack();
        this.dialog.setSize(this.dialog.getPreferredSize());
        Dimension screenSize = this.dialog.getToolkit().getScreenSize();
        Dimension dialogSize = this.dialog.getSize();
        this.dialog.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        this.addKeyListeners(this.dialog, new cKeyHandler());
        this.dialog.show();
        this.dialog.toFront();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    private void sortLanguages(String[] langNames, String[] langCodes) {
        int length = langNames.length;
        if (langNames.length == langCodes.length && length > 1) {
            for (int i = length - 1; i > 0; --i) {
                for (int j = 0; j < i; ++j) {
                    if (langNames[j].compareTo(langNames[j + 1]) <= 0) continue;
                    String temp = langNames[j];
                    langNames[j] = langNames[j + 1];
                    langNames[j + 1] = temp;
                    temp = langCodes[j];
                    langCodes[j] = langCodes[j + 1];
                    langCodes[j + 1] = temp;
                }
            }
        }
    }

    private void setDefaultLang(JComboBox langList, String language) {
        boolean done = false;
        for (int i = 0; !done && i < this.m_langCodes.length; ++i) {
            if (language.compareTo(this.m_langCodes[i]) != 0) continue;
            langList.setSelectedIndex(i);
            done = true;
        }
    }

    public int buttonClicked() {
        return this.m_buttonClicked;
    }

    public String getSelected() {
        return this.m_langCodes[this.langList.getSelectedIndex()];
    }

    protected void addKeyListeners(Container container, cKeyHandler keyHandler) {
        Component[] aComps = container.getComponents();
        int nComps = aComps.length;
        for (int iComp = 0; iComp < nComps; ++iComp) {
            aComps[iComp].addKeyListener(keyHandler);
            if (!(aComps[iComp] instanceof Container)) continue;
            this.addKeyListeners((Container)aComps[iComp], keyHandler);
        }
    }

    private class navButtons
    extends JPanel {
        public navButtons(JButton okButton, JButton cancelButton) {
            GridBagConstraints c = new GridBagConstraints();
            JPanel okPanel = new JPanel();
            JPanel cancelPanel = new JPanel();
            okPanel.setLayout(new GridBagLayout());
            cancelPanel.setLayout(new GridBagLayout());
            c.fill = 2;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 0, 0, 4);
            c.anchor = 10;
            okPanel.add((Component)okButton, c);
            c.fill = 2;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 4, 0, 0);
            c.anchor = 10;
            cancelPanel.add((Component)cancelButton, c);
            this.setLayout(new GridLayout(1, 2));
            this.add(okPanel);
            this.add(cancelPanel);
        }
    }

    protected class cKeyHandler
    extends KeyAdapter {
        protected cKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int eKeyCode = e.getKeyCode();
            switch (eKeyCode) {
                case 27: {
                    LangSelectDlgFrame.this.dialog.dispose();
                    Logging.closeLog();
                    System.exit(-1);
                    break;
                }
                case 38: {
                    LangSelectDlgFrame.this.langList.showPopup();
                    break;
                }
                case 48: {
                    this.setLogging(0);
                    break;
                }
                case 49: {
                    this.setLogging(1);
                    break;
                }
                case 50: {
                    this.setLogging(2);
                    break;
                }
                case 51: {
                    Globals.g_mode = 6;
                    Logging.log.info("Forcing depotchecker mode");
                    break;
                }
                case 52: {
                    Globals.g_httponly = true;
                    Logging.log.info("Forcing http mode");
                    break;
                }
                case 53: {
                    System.setProperty("javax.net.debug", "ssl");
                    Logging.log.info("Forcing SSL debug mode");
                    break;
                }
                case 56: {
                    Globals.g_kerberosproxy = true;
                    Globals.g_forceProxy = true;
                    Logging.log.info("Setting for a kerberos enabled proxy");
                    break;
                }
                case 57: {
                    Globals.g_forceProxy = true;
                    Logging.log.info("Forcing proxy window to appear");
                }
            }
        }

        private void setLogging(int keyEvent) {
            switch (keyEvent) {
                case 0: {
                    Logging.log.setLevel(Level.INFO);
                    Logging.log.info("Logging set for INFO");
                    break;
                }
                case 1: {
                    Logging.log.setLevel(Level.FINE);
                    Logging.log.info("Logging set for FINE");
                    break;
                }
                case 2: {
                    Utils.loggingToFiner();
                }
            }
        }
    }
}

