/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.KitUnixOEM;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;

public class KitVMSOEM {
    protected static SSNResource bundle = new SSNResource(KitUnixOEM.class);
    private int m_status = 0;
    private static String dterm = "create/terminal/wait";

    public KitVMSOEM(String cmdpath, String cmdArgs) {
        FilenameFilter pathFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("X") || name.equals("bin");
            }
        };
        String fiScriptName = Globals.g_tempLocation + File.separator + "foundationInstall.com";
        String fiScriptStatus = Globals.g_tempLocation + File.separator + "foundationIntall.out";
        File fiRcFile = new File(fiScriptStatus);
        File fiScriptFile = new File(fiScriptName);
        String fiScriptSpec = Utils.unixToVMSPath(fiScriptName);
        int rc = -1;
        String command = null;
        Runtime myruntime = Runtime.getRuntime();
        try {
            String cmdprefix;
            PrintStream out = new PrintStream(new FileOutputStream(fiScriptFile));
            out.println("$ set nover");
            out.println("$ set noon");
            out.println("$ set proc/parse=extend");
            out.println("$ rcfile = \"" + Utils.unixToVMSPath(fiRcFile.getAbsolutePath()) + "\"");
            out.println("$ if f$search(rcfile) .nes. \"\" then delete/nolog 'rcfile';*");
            if (cmdpath.indexOf(".com") == -1) {
                cmdprefix = "$ ";
                out.println("$ sascmd :== $" + Utils.unixToVMSPath(cmdpath));
            } else {
                cmdprefix = "$@ ";
                out.println("$ sascmd :== @" + Utils.unixToVMSPath(cmdpath));
            }
            if (cmdArgs != null && cmdArgs.length() > 0) {
                out.println(cmdprefix + "sascmd " + cmdArgs);
            } else {
                out.println(cmdprefix + "sascmd");
            }
            out.println("$ if (.not. $status) ");
            out.println("$ then");
            out.println("$    rc = 1");
            out.println("$ else");
            out.println("$    rc = 0");
            out.println("$ endif");
            out.println("$ open/write fp 'rcfile");
            out.println("$ write fp \"''rc'\"");
            out.println("$ close fp");
            String promptStr = bundle.messageString("Common.OEM.quitPrompt.txt", bundle.getString("Common.Title.txt"));
            promptStr = promptStr.substring(0, promptStr.length() - 1);
            out.println("$ inquire dummy \"" + promptStr + "\"");
            out.close();
            command = bundle.getString("Common.OEM.requiresXterm").charAt(0) == 'y' ? this.createDCLScript(dterm + " @" + fiScriptSpec) : fiScriptSpec;
            Logging.log.info("VMS OEM decterm invocation script: " + fiScriptSpec);
            Logging.log.info("Execute command: " + command);
            Process p = Runtime.getRuntime().exec(command);
            p.waitFor();
            rc = p.exitValue();
            p = null;
        }
        catch (IOException e1) {
            rc = -2;
        }
        catch (InterruptedException e2) {
            rc = -3;
        }
        try {
            if (fiScriptFile.exists() && !Globals.g_debug) {
                fiScriptFile.delete();
            }
        }
        catch (Exception e) {
            Logging.log.info("Unexpected exception executing " + fiScriptFile.getName());
            Logging.log.info(e.getMessage());
        }
        if (rc == 1) {
            try {
                if (fiRcFile.exists()) {
                    BufferedReader in = new BufferedReader(new FileReader(fiRcFile));
                    rc = Integer.parseInt(in.readLine());
                    in.close();
                    in = null;
                    fiRcFile.delete();
                } else {
                    rc = -4;
                }
                fiRcFile = null;
            }
            catch (IOException e1) {
                rc = -4;
            }
        }
        this.m_status = rc;
        Logging.log.info("OEM script return value: " + rc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createDCLScript(String cmd) {
        String dclScriptName = Globals.g_tempLocation + File.separator + "exec_cmd.com";
        File dclScriptFile = new File(dclScriptName);
        try (PrintStream out = null;){
            out = new PrintStream(new FileOutputStream(dclScriptFile));
            out.println("$ set nover");
            out.println("$ " + cmd);
            out.println("$ exit 1");
            out.close();
        }
        return Utils.unixToVMSPath(dclScriptName);
    }

    public int getStatus() {
        return this.m_status;
    }
}

