/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;

public class KitUnixOEM {
    protected static SSNResource bundle = new SSNResource(KitUnixOEM.class);
    private int m_status = 0;

    public KitUnixOEM(String cmdpath, String cmdArgs) {
        FilenameFilter pathFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("X") || name.equals("bin");
            }
        };
        String logFileName = Globals.g_tempLocation + "/.unixkit_rc.log";
        String script = Globals.g_tempLocation + "/.unixkit_cmd.sh";
        Integer rc = new Integer(0);
        File rcFile = null;
        File scriptFile = new File(script);
        Runtime myruntime = Runtime.getRuntime();
        try {
            FileOutputStream strOut = new FileOutputStream(scriptFile);
            PrintStream str = new PrintStream(strOut);
            str.println("#!/bin/sh");
            str.println("clean_up_and_exit () {");
            str.println("  exit_status=$1");
            str.println("  if [ -f " + logFileName + " ] ; then");
            str.println("    rm -f " + logFileName);
            str.println("  fi");
            str.println("  $echo $exit_status >" + logFileName);
            str.println("  $echo");
            str.println("  $echo");
            str.println("  $echo");
            str.println("  $echo " + bundle.messageString("Common.OEM.quitPrompt.txt", bundle.getString("Common.Title.txt")));
            str.println("  read dummy");
            str.println("  exit");
            str.println("}");
            str.println("handle_interrupt () {");
            str.println("   clean_up_and_exit -5");
            str.println("}");
            str.println("trap 'handle_interrupt' 1 2 15");
            str.println("if [ -x /usr/bin/echo ]; then");
            str.println("  echo=/usr/bin/echo");
            str.println("elif [ -x /bin/echo ] ; then");
            str.println("  echo=/bin/echo");
            str.println("else");
            str.println("  echo=echo");
            str.println("fi");
            String cmd = cmdpath.toString();
            if (cmdArgs != null && cmdArgs.length() > 0) {
                cmd = cmd + " " + cmdArgs;
            }
            str.println(cmd);
            Logging.log.info("Unix OEM invocation command: " + cmd);
            str.println("myrc=$?");
            str.println("clean_up_and_exit $myrc");
            str.close();
            String[] mycommand = new String[]{"chmod", "755", script};
            Process scriptProc = myruntime.exec(mycommand);
            scriptProc.waitFor();
            scriptProc = null;
            String[] command = new String[]{""};
            command = bundle.getString("Common.OEM.requiresXterm").charAt(0) == 'y' ? new String[]{KitUnixOEM.unixSearch("xterm", pathFilter), "-cu", "-aw", "-sb", "+si", "-sk", "-sl", "500", "-wf", "+ls", "-geometry", "80x24+0+0", "-e", script} : new String[]{script};
            Logging.log.info("Unix OEM xterm invocation script: " + command);
            Process runProc = myruntime.exec(command);
            runProc.waitFor();
            rc = new Integer(runProc.exitValue());
            runProc = null;
        }
        catch (IOException e1) {
            rc = new Integer(-2);
        }
        catch (InterruptedException e2) {
            rc = new Integer(-3);
        }
        try {
            if (scriptFile.exists()) {
                scriptFile.delete();
            }
        }
        catch (Exception e) {
            Logging.log.info("denied access to file, " + scriptFile.getName());
        }
        if (rc == 0) {
            try {
                rcFile = new File(logFileName);
                if (rcFile.exists()) {
                    BufferedReader in = new BufferedReader(new FileReader(rcFile));
                    rc = new Integer(in.readLine());
                    in.close();
                    in = null;
                    rcFile.delete();
                } else {
                    rc = new Integer(-4);
                }
                rcFile = null;
            }
            catch (IOException e1) {
                rc = new Integer(-4);
            }
        }
        this.m_status = rc;
        Logging.log.info("OEM script return value: " + rc.toString());
    }

    private static String unixSearch(String program, FilenameFilter filter) {
        String found = null;
        File test = new File(Utils.joinPath("/usr/bin", program));
        if (!(test.exists() || (test = new File(Utils.joinPath("/usr/local/bin", program))).exists() || (test = new File(Utils.joinPath("/usr/bin/X11", program))).exists() || (test = new File(Utils.joinPath("/usr/openwin/bin", program))).exists() || (test = new File(Utils.joinPath("/usr/X11/bin", program))).exists() || (test = new File(Utils.joinPath("/usr/X11R6/bin", program))).exists())) {
            found = KitUnixOEM.unixPathSearch(program, "/usr/local", filter);
            test = found == null ? ((found = KitUnixOEM.unixPathSearch(program, "/usr", filter)) == null ? ((found = KitUnixOEM.unixPathSearch(program, "/usr/bin", filter)) == null ? new File(program) : new File(found)) : new File(found)) : new File(found);
        }
        return test.toString();
    }

    private static String unixPathSearch(String program, String dirname, FilenameFilter filter) {
        String path = null;
        File test = new File(dirname + "/" + program);
        if (test.exists()) {
            path = test.toString();
        } else {
            try {
                File dir = new File(dirname);
                String[] longlist = dir.list(filter);
                if (longlist != null) {
                    for (int i = 0; path == null && i < longlist.length; ++i) {
                        path = KitUnixOEM.unixPathSearch(program, dirname + "/" + longlist[i], filter);
                    }
                }
            }
            catch (Exception e) {
                path = null;
            }
        }
        return path;
    }

    public int getStatus() {
        return this.m_status;
    }
}

