/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.KitTextFieldPopup;
import com.sas.ssn.Language;
import com.sas.ssn.Logging;
import com.sas.visuals.util.XMLCommandEvent;
import com.sas.visuals.util.XMLCommandListener;
import com.sas.visuals.util.XMLHelpEvent;
import com.sas.visuals.util.XMLHelpListener;
import com.sas.visuals.util.XMLMenuButton;
import com.sas.visuals.util.XMLMenuItem;
import com.sas.visuals.util.XMLPopupMenu;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JTextField;

public class KitTextField
extends JTextField
implements XMLCommandListener,
XMLHelpListener,
MouseListener {
    private XMLPopupMenu popup = null;
    private Clipboard clipBoard = null;
    private XMLMenuItem copyItem = null;
    private XMLMenuItem pasteItem = null;

    public KitTextField(int columns) {
        super(columns);
        this.init();
    }

    public KitTextField() {
        this.init();
    }

    public KitTextField(String text) {
        super(text);
        this.init();
    }

    public KitTextField(String text, int columns) {
        super(text, columns);
        this.init();
    }

    @Override
    public void processCommand(XMLCommandEvent e) {
        if (e.getCommand().equals("_copy_")) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchKeyEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, 65485, '\uffff'));
        } else if (e.getCommand().equals("_paste_")) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchKeyEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, 65487, '\uffff'));
        }
    }

    @Override
    public String getText() {
        String s = super.getText();
        return s.trim();
    }

    private void init() {
        try {
            this.clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.popup = new KitTextFieldPopup(Language.gs_SelectedLanguage);
        }
        catch (Exception e) {
            try {
                this.popup = new KitTextFieldPopup("en");
            }
            catch (Exception ee) {
                Logging.log.info(ee.getMessage());
                Logging.logStackTrace(ee);
            }
        }
        if (this.popup != null) {
            this.popup.addCommandListener(this);
            this.popup.addHelpListener(this);
            this.addMouseListener(this);
            ArrayList copyArray = this.popup.getMenuItemsById("copy");
            ArrayList pasteArray = this.popup.getMenuItemsById("paste");
            if (copyArray.size() > 0) {
                this.copyItem = (XMLMenuButton)copyArray.get(0);
            }
            if (pasteArray.size() > 0) {
                this.pasteItem = (XMLMenuButton)pasteArray.get(0);
            }
        }
    }

    @Override
    public void displayHelp(XMLHelpEvent e) {
    }

    @Override
    public void unDisplayHelp(XMLHelpEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.displayMenu(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.displayMenu(e);
        }
    }

    public void displayMenu(MouseEvent e) {
        String selText = ((JTextField)e.getComponent()).getSelectedText();
        Transferable cbtext = null;
        if (this.clipBoard != null) {
            cbtext = this.clipBoard.getContents(this);
        }
        if (selText == null || selText.equals("")) {
            this.copyItem.setEnabled(false);
        } else {
            this.copyItem.setEnabled(true);
        }
        if (cbtext == null || cbtext.equals("")) {
            this.pasteItem.setEnabled(false);
        } else if (this.isEnabled()) {
            this.pasteItem.setEnabled(true);
        } else {
            this.pasteItem.setEnabled(false);
        }
        this.popup.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

