/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.KitNodeInfo;
import com.sas.ssn.KitWebPanel;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class KitOEMDialog
extends JDialog {
    private KitWebPanel webPanel;
    protected static SSNResource bundle = new SSNResource(KitOEMDialog.class);
    private JButton printButton;
    private JButton closeButton;
    private boolean installed = false;

    public KitOEMDialog(String productCode, String page) {
        super((Frame)null, true);
        String mtxt = null;
        Logging.log.info("Install HTML: " + page);
        mtxt = bundle.getString("Common.Print.txt");
        this.printButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.printButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.printButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        mtxt = bundle.getString("Common.close.txt");
        this.closeButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.closeButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.closeButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        try {
            this.webPanel = new KitWebPanel(productCode);
            this.webPanel.setKitNodeInfo(new KitNodeInfo("", "", new URL(page)));
        }
        catch (Exception e) {
            Logging.log.info(e.getMessage());
            System.err.println(e);
        }
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KitOEMDialog.this.webPanel.print();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KitOEMDialog.this.validateButtonClick();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                KitOEMDialog.this.validateButtonClick();
            }
        });
        this.setDefaultCloseOperation(0);
        if (Globals.g_wizard.getFrame() != null) {
            this.setSize(Globals.g_wizard.getFrame().getSize());
        }
        GridBagConstraints c = new GridBagConstraints();
        this.getContentPane().setLayout(new GridBagLayout());
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 10;
        this.getContentPane().add((Component)this.webPanel, c);
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 5, 0);
        c.anchor = 10;
        this.getContentPane().add((Component)new navButtons(), c);
    }

    @Override
    public void show() {
        this.setLocationRelativeTo(Globals.g_wizard.getFrame());
        super.show();
    }

    @Override
    public void dispose() {
        super.dispose();
        Logging.log.info("Install Successful: " + (this.installed ? "YES" : "NO"));
    }

    public boolean isInstalled() {
        return this.installed;
    }

    private void validateButtonClick() {
        switch (CustMsgBox.showConfirmDialog((Component)this, bundle.getString("KitOEMDialog.SuccessMessage.txt"))) {
            case 0: {
                this.installed = true;
                this.setVisible(false);
                this.dispose();
                break;
            }
            case 1: {
                this.installed = false;
                this.setVisible(false);
                this.dispose();
                break;
            }
            default: {
                this.installed = false;
            }
        }
    }

    private class navButtons
    extends JPanel {
        public navButtons() {
            GridBagConstraints c = new GridBagConstraints();
            JPanel printPanel = new JPanel();
            JPanel closePanel = new JPanel();
            printPanel.setLayout(new GridBagLayout());
            closePanel.setLayout(new GridBagLayout());
            c.fill = 2;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 0, 0, 4);
            c.anchor = 10;
            printPanel.add((Component)KitOEMDialog.this.printButton, c);
            c.fill = 2;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 4, 0, 0);
            c.anchor = 10;
            closePanel.add((Component)KitOEMDialog.this.closeButton, c);
            this.setLayout(new GridLayout(1, 2));
            this.add(printPanel);
            this.add(closePanel);
        }
    }
}

