/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.KitNodeInfo;
import com.sas.ssn.KitWebPanel;
import com.sas.ssn.SSNResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JPanel;

class KitNavPanel
extends JPanel {
    protected static SSNResource bundle = new SSNResource(KitNavPanel.class);
    private GridBagConstraints c = new GridBagConstraints();
    private JButton homeButton;
    private JButton backButton;
    private JButton nextButton;
    private KitWebPanel kwp;
    private KitNodeInfo kni;

    public KitNavPanel(KitWebPanel parent, URL startPage) {
        this.kwp = parent;
        this.homeButton = new JButton(bundle.getImageIcon("Common.ArrowLeftEnd.image"));
        this.backButton = new JButton(bundle.getImageIcon("Common.ArrowLeft.image"));
        this.nextButton = new JButton(bundle.getImageIcon("Common.ArrowRight.image"));
        if (startPage != null) {
            this.add(startPage);
        }
        this.homeButton.setEnabled(false);
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.setLayout(new GridBagLayout());
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.fill = 2;
        this.c.gridwidth = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(0, 5, 0, 0);
        this.c.anchor = 10;
        this.add((Component)this.homeButton, this.c);
        this.c.gridx = 1;
        this.c.gridy = 0;
        this.c.fill = 2;
        this.c.gridwidth = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(0, 5, 0, 0);
        this.c.anchor = 10;
        this.add((Component)this.backButton, this.c);
        this.c.gridx = 2;
        this.c.gridy = 0;
        this.c.fill = 2;
        this.c.gridwidth = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(0, 5, 0, 0);
        this.c.anchor = 10;
        this.add((Component)this.nextButton, this.c);
        this.homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KitNavPanel.this.goHome();
            }
        });
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KitNavPanel.this.pageBack();
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KitNavPanel.this.pageForward();
            }
        });
    }

    public void add(URL url) {
        if (this.kni != null) {
            this.kni.setCurrentIndex(this.kni.getCurrentIndex() + 1);
            this.kni.getHistory()[this.kni.getCurrentIndex()] = url;
            this.kni.setMaxIndex(this.kni.getCurrentIndex());
            this.setButtons();
        }
    }

    private void setButtons() {
        if (this.kni != null) {
            this.nextButton.setEnabled(this.kni.getCurrentIndex() < this.kni.getMaxIndex());
            this.backButton.setEnabled(this.kni.getCurrentIndex() > 0);
            this.homeButton.setEnabled(this.kni.getCurrentIndex() > 0);
        }
    }

    public JButton getBackButton() {
        return this.backButton;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public JButton getHomeButton() {
        return this.homeButton;
    }

    @Override
    public boolean isFocusable() {
        return this.nextButton.isEnabled() || this.backButton.isEnabled() || this.homeButton.isEnabled();
    }

    public void setKitNodeInfo(KitNodeInfo info) {
        this.kni = info;
        this.kwp.loadPage(this.kni.getHistory()[this.kni.getCurrentIndex()]);
        this.setButtons();
    }

    public void pageBack() {
        if (this.kni != null && this.backButton.isEnabled()) {
            this.kni.setCurrentIndex(this.kni.getCurrentIndex() - 1);
            this.kwp.loadPage(this.kni.getHistory()[this.kni.getCurrentIndex()]);
            this.setButtons();
        }
    }

    public void pageForward() {
        if (this.kni != null && this.nextButton.isEnabled()) {
            this.kni.setCurrentIndex(this.kni.getCurrentIndex() + 1);
            this.kwp.loadPage(this.kni.getHistory()[this.kni.getCurrentIndex()]);
            this.setButtons();
        }
    }

    public void goHome() {
        if (this.kni != null && this.homeButton.isEnabled()) {
            this.kni.setCurrentIndex(0);
            this.kwp.loadPage(this.kni.getHistory()[this.kni.getCurrentIndex()]);
            this.setButtons();
        }
    }
}

